# 3A-calcstats_sgl.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from statistics calculated from available data
use strict;
use warnings;

use Test::More tests => 13;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $dat) = ('love');

my %dat_ref = (
    SSZ => 18,
    CCT => 181,
    ONC => 6,
    ONC2 => 5,
);

# Get stats by method name:
$dat = $usf->setsize($word1, calc => 1);
ok( is_equal($dat, $dat_ref{'SSZ'}), "ssz calculated = $dat, should be $dat_ref{'SSZ'}" );

$dat = $usf->cue_count($word1);
ok( is_equal($dat, $dat_ref{'CCT'}), "cct calculated = $dat, should be $dat_ref{'CCT'}" );

$dat = $usf->orthon_count($word1, cues_only => 0);
ok( is_equal($dat, $dat_ref{'ONC'}), "onc (all words) calculated = $dat, should be $dat_ref{'ONC'}" );

$dat = $usf->orthon_count($word1, cues_only => 1);
ok( is_equal($dat, $dat_ref{'ONC2'}), "onc (cues only) with calculated = $dat, should be $dat_ref{'ONC2'}" );

# Get stats directly from word_stat();
foreach my $s(qw/SSZ CCT ONC/) {
    $dat = $usf->word_stat($word1, $s, {calc => 1, cues_only => 0});
    ok( is_equal($dat, $dat_ref{$s}), "$s calculated = $dat, should be $dat_ref{$s}" );
}

# A bit more complicated: a canned and a calc'd stat in one:
my $frq = $usf->word_stat($word1, 'FRQ', {ref => 0, cues_only => 0});
my $sum_want = $dat_ref{'ONC'} + $frq;
# - firstly as an aref:
my $aref = $usf->word_stat($word1, [qw/FRQ ONC/], {ref => 1, data => 0, cues_only => 0});
my $sum_got = sum(@{$aref});
ok( is_equal($sum_got, $sum_want), "FRQ and ONC sum got = $sum_got of $aref->[0] and $aref->[1], should be $sum_want of $frq and $dat_ref{'ONC'}" );
# now as an open array
my @ari = $usf->word_stat($word1, [qw/FRQ ONC/], {ref => 0, data => 0, cues_only => 0});
$sum_got = sum(@ari);
ok( is_equal($sum_got, $sum_want), "FRQ and ONC sum got = $sum_got of $ari[0] and $ari[1], should be $sum_want of $frq and $dat_ref{'ONC'}" );

# now with cues_only => 1
$sum_want = $dat_ref{'ONC2'} + $frq;
@ari = $usf->word_stat($word1, [qw/FRQ ONC/], {ref => 0, data => 0, cues_only => 1});
$sum_got = sum(@ari);
ok( is_equal($sum_got, $sum_want), "FRQ and ONC sum got = $sum_got of $ari[0] and $ari[1], should be $sum_want of $frq and $dat_ref{'ONC2'}" );

# Check is_word():
$dat = $usf->is_word('PIN');
ok( is_equal($dat, 1), "is_word check: got $dat, should be 1");
$dat = $usf->is_word('NIP'); # not listed in DB
ok( is_equal($dat, 0), "is_word check: got $dat, should be 0");

sub sum {
    my $d = 0;
    $d += $_ foreach @_;
    return $d;
}

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
