#!/usr/bin/env raku
#t/09-cmp.t 
#TESTALL$ prove6 ./t      [from root]
use lib '../lib';
use Test;
plan 14; 

use Physics::Measure;

my $a ♎️ '4.3 m';
my $c = $a;
is $a cmp $c, Order::Same,                                                      '$a cmp $c';

my $b ♎️ '-2.3 m';
is $a cmp $b, Order::More,                                                      '$a cmp $b';

$b ♎️ 23;
is $a cmp $b, Order::Less,                                                      '$a cmp $b';

my $t2 ♎️ '2 mins';
my $t3 ♎️ '43 hours';
is $t2 cmp $t3, Less,                                                            '$t cmp $t3';

my $d ♎️ '44 feet';
is $a cmp $d, Less,                                                             '$a cmp $d';

my $e = $a.in: 'feet';
is $a cmp $e, Same,                                                             '$a cmp $e';

is $a eq $b, Bool::False,                                                       '$a eq $b';
is $a ne $b, Bool::True,                                                        '$a ne $b';
is $a eq $e, Bool::False,                                                       '$a eq $e';
is $a ne $e, Bool::True,                                                        '$a ne $e';

is $a == $b, Bool::False,                                                       '$a == $b';
is $a != $b, Bool::True,                                                        '$a != $b';
is $a == $e, Bool::True,                                                        '$a == $e';
is $a != $e, Bool::False,                                                       '$a != $e';


#done-testing;

