use v6;
use Test;

plan 2;

use Email::Valid;

my $public = Email::Valid.new( :allow-ip );

my @ipv6_valid     = Q:w/
    ab@[IPv6:2001:1620:0028:0001:0b6f:8bca:0093:a116] 
    ab@[IPv6:2001:1620:0000:0000:000:00:0000:006] 
    ab@[ipv6:2001:1620:28:1:b6f:8bca:93:a116] 
    cc@[IpV6:2001:1620:0028::0116]
    cc@[iPv6:2001:1620:0028::116]
    cc@[iPv6:2001:0:0028::116]
    cc@[iPv6:2001:0028::116]
    cc@[iPv6:2001::116]
    cc@[iPv6:2001::1]
/;

my @ipv6_invalid   = Q:w/
    ab@[ipv6:02001:0000:1234:0000:0000:C1C0:ABCD:0876]
    ab@[ipv6:FF02:0000:0000:0000:0000:0000:0000:0000:0001]
    ab@[ipv6:::1111:2222:3333:4444:5555:6666::]
    ab@[2001:1620:0028:0001:0b6f:8bca:0093:a116]
    ab@[2001:1620:0028:0001::8bca:0093:a116]
    ab@[ip:2001:1620:0028:0001::8bca:0093:a116]
    ab@[ipv6:2001:1620:0028:0001:8bca:0093:a116]
    ab@[ipv6:2001:1620:0028:0001:8bca:0093]
    ab@[ipv6:2001:1620:0028:0001:8bca]
    ab@[ipv6:2001:1620:0028:0001]
    ab@[ipv6:2001:1620:0028]
    ab@[ipv6:2001:1620]
    ab@[ipv6:2001:]
    ab@[ipv6:2001]
    ab@[IPv6:2001:1620:0028:0001:0b6f:8bca:0093] 
    ab@[ipv6:2001:1620:0028:0001::8bca:0093::]
    ab@[ipv6:2001:1620:0028:0001::8bca:0093:]
    cc@[IpV6:2001::1620::0028::0116]
    cc@[IpV6:20011::1601:0028:0000]
    cc@[IpV6:2001:1620::0028::0116]
    cc@[IpV6:2001:1620:0028::01161]
    cc@[IpV6:2001:1620:00281::0161]
    cc@[IpV6:2001:16201:0028::0161]
    cc@[IpV6:20011:1601:0028::0161]
    cc@[IpV6:20011:1601:0028::0161]
    cc@[IpV6:20011:1601:0028::0000]
    cc@[IpV6:20011:1601:0028:0000]
    cc@[IpV6:3ffe:b00::1::a]
    cc@[iPv6:2001::0028::116]
    cc@[iPv6:2001::::116]
    cc@[iPv6:2001:::116]
    cc@[IpV6:3fge:b00:1:a]
    cc@[IpV6:3fje:b00:1:a]
    cc@[IPv6:2001:Ae00:1]
    cc@[IpV6:256.0.0.0]
    cc@[IpV6:256:0:0:0]
    cc@[IpV6:2001::0]
    cc@[IpV6:2001:0]
    cc@[IpV6:2001::]
    cc@[IpV6:2001:]
    cc@[IpV6:0:0]
    cc@[IpV6:::0]
/;


is [ @ipv6_valid.map({ $public.validate( $_ ) }) ],  [ True xx @ipv6_valid.elems ],    'Valid IPv6';
is [ @ipv6_invalid.map({ $public.validate( $_ ) }) ],[ False xx @ipv6_invalid.elems ], 'Invalid IPv6';


