# Generated file, do not edit
# $Id: ParserTable.pm,v 1.7 2009/01/04 20:15:20 Paulo Custodio Exp $
package CPU::Z80::Assembler::ParserTable;

our $VERSION = '<VERSION>';

use HOP::Stream qw(append list_to_stream);

#------------------------------------------------------------------------------
# LOOKUP-TABLES
#	Lookup table of all assembly instructions recognized by the assembler
#	Sequence is indexed by a sequence of token labels, followed by "" as the 
#	last key. The value is a fucntion with the signature:
#		($parsed, $input) = f($input, $start, @expr)
#	$input is the current stream position after the recognized tokens
#	$start is the stream position at the start of the instruction
#	@expr are all the expressions parsed, as streams.
#	Functions die with error message on parse failure, error will be caught
#	to explain where the error occured.

sub _parser_table {
my $table;
$table->{"adc"}{"a"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x8E], $_[0])};
$table->{"adc"}{"a"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8E, ["sb", $_[2]]], $_[0])};
$table->{"adc"}{"a"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8E, ["sb", $_[2]]], $_[0])};
$table->{"adc"}{"a"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xCE, ["ub", $_[2]]], $_[0])};
$table->{"adc"}{"a"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x8E], $_[0])};
$table->{"adc"}{"a"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8E, ["sb", $_[2]]], $_[0])};
$table->{"adc"}{"a"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8E, ["sb", $_[2]]], $_[0])};
$table->{"adc"}{"a"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x8F], $_[0])};
$table->{"adc"}{"a"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x88], $_[0])};
$table->{"adc"}{"a"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x89], $_[0])};
$table->{"adc"}{"a"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x8A], $_[0])};
$table->{"adc"}{"a"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x8B], $_[0])};
$table->{"adc"}{"a"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x8C], $_[0])};
$table->{"adc"}{"a"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8C], $_[0])};
$table->{"adc"}{"a"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8C], $_[0])};
$table->{"adc"}{"a"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8C], $_[0])};
$table->{"adc"}{"a"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8D], $_[0])};
$table->{"adc"}{"a"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8C], $_[0])};
$table->{"adc"}{"a"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8D], $_[0])};
$table->{"adc"}{"a"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x8D], $_[0])};
$table->{"adc"}{"a"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8D], $_[0])};
$table->{"adc"}{"a"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8D], $_[0])};
$table->{"adc"}{"a"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8C], $_[0])};
$table->{"adc"}{"a"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x8D], $_[0])};
$table->{"adc"}{"a"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8C], $_[0])};
$table->{"adc"}{"a"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x8D], $_[0])};
$table->{"adc"}{"hl"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x4A], $_[0])};
$table->{"adc"}{"hl"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x5A], $_[0])};
$table->{"adc"}{"hl"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x6A], $_[0])};
$table->{"adc"}{"hl"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x7A], $_[0])};
$table->{"add"}{"a"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x86], $_[0])};
$table->{"add"}{"a"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x86, ["sb", $_[2]]], $_[0])};
$table->{"add"}{"a"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x86, ["sb", $_[2]]], $_[0])};
$table->{"add"}{"a"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xC6, ["ub", $_[2]]], $_[0])};
$table->{"add"}{"a"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x86], $_[0])};
$table->{"add"}{"a"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x86, ["sb", $_[2]]], $_[0])};
$table->{"add"}{"a"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x86, ["sb", $_[2]]], $_[0])};
$table->{"add"}{"a"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x87], $_[0])};
$table->{"add"}{"a"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x80], $_[0])};
$table->{"add"}{"a"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x81], $_[0])};
$table->{"add"}{"a"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x82], $_[0])};
$table->{"add"}{"a"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x83], $_[0])};
$table->{"add"}{"a"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x84], $_[0])};
$table->{"add"}{"a"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x84], $_[0])};
$table->{"add"}{"a"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x84], $_[0])};
$table->{"add"}{"a"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x84], $_[0])};
$table->{"add"}{"a"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x85], $_[0])};
$table->{"add"}{"a"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x84], $_[0])};
$table->{"add"}{"a"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x85], $_[0])};
$table->{"add"}{"a"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x85], $_[0])};
$table->{"add"}{"a"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x85], $_[0])};
$table->{"add"}{"a"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x85], $_[0])};
$table->{"add"}{"a"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x84], $_[0])};
$table->{"add"}{"a"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x85], $_[0])};
$table->{"add"}{"a"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x84], $_[0])};
$table->{"add"}{"a"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x85], $_[0])};
$table->{"add"}{"hl"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x09], $_[0])};
$table->{"add"}{"hl"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x19], $_[0])};
$table->{"add"}{"hl"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x29], $_[0])};
$table->{"add"}{"hl"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0x39], $_[0])};
$table->{"add"}{"ix"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x09], $_[0])};
$table->{"add"}{"ix"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x19], $_[0])};
$table->{"add"}{"ix"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x29], $_[0])};
$table->{"add"}{"ix"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x39], $_[0])};
$table->{"add"}{"iy"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x09], $_[0])};
$table->{"add"}{"iy"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x19], $_[0])};
$table->{"add"}{"iy"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x29], $_[0])};
$table->{"add"}{"iy"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x39], $_[0])};
$table->{"and"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xA6], $_[0])};
$table->{"and"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA6, ["sb", $_[2]]], $_[0])};
$table->{"and"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA6, ["sb", $_[2]]], $_[0])};
$table->{"and"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xE6, ["ub", $_[2]]], $_[0])};
$table->{"and"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xA6], $_[0])};
$table->{"and"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA6, ["sb", $_[2]]], $_[0])};
$table->{"and"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA6, ["sb", $_[2]]], $_[0])};
$table->{"and"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xA7], $_[0])};
$table->{"and"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xA0], $_[0])};
$table->{"and"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xA1], $_[0])};
$table->{"and"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xA2], $_[0])};
$table->{"and"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xA3], $_[0])};
$table->{"and"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xA4], $_[0])};
$table->{"and"}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA4], $_[0])};
$table->{"and"}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA4], $_[0])};
$table->{"and"}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA4], $_[0])};
$table->{"and"}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA5], $_[0])};
$table->{"and"}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA4], $_[0])};
$table->{"and"}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA5], $_[0])};
$table->{"and"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xA5], $_[0])};
$table->{"and"}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA5], $_[0])};
$table->{"and"}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA5], $_[0])};
$table->{"and"}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA4], $_[0])};
$table->{"and"}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xA5], $_[0])};
$table->{"and"}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA4], $_[0])};
$table->{"and"}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xA5], $_[0])};
$table->{"bit"}{"CEXPR"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x46], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x4E], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x56], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x5E], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x66], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x6E], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x76], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x7E], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x46], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x4E], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x56], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x5E], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x66], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x6E], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x76], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x7E], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x46], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x4E], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x56], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x5E], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x66], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x6E], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x76], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x7E], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x46], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x4E], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x56], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x5E], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x66], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x6E], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x76], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x7E], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x46], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x4E], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x56], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x5E], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x66], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x6E], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x76], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x7E], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x46], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x4E], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x56], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x5E], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x66], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x6E], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x76], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x7E], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x47], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x4F], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x57], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x5F], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x67], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x6F], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x77], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x7F], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x40], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x48], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x50], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x58], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x60], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x68], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x70], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x78], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x41], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x49], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x51], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x59], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x61], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x69], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x71], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x79], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x42], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x4A], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x52], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x5A], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x62], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x6A], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x72], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x7A], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x43], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x4B], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x53], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x5B], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x63], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x6B], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x73], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x7B], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x44], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x4C], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x54], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x5C], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x64], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x6C], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x74], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x7C], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"bit"}{"CEXPR"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x45], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x4D], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x55], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x5D], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0x65], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0x6D], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0x75], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0x7D], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"call"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xCD, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"c"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDC, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"m"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFC, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"nc"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xD4, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"nz"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xC4, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"p"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xF4, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"pe"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xEC, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"po"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xE4, ["w", $_[2]], []], $_[0])};
$table->{"call"}{"z"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xCC, ["w", $_[2]], []], $_[0])};
$table->{"ccf"}{"END"}{""}	= sub {(["OPCODE", 0x3F], $_[0])};
$table->{"cp"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xBE], $_[0])};
$table->{"cp"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBE, ["sb", $_[2]]], $_[0])};
$table->{"cp"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBE, ["sb", $_[2]]], $_[0])};
$table->{"cp"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFE, ["ub", $_[2]]], $_[0])};
$table->{"cp"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xBE], $_[0])};
$table->{"cp"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBE, ["sb", $_[2]]], $_[0])};
$table->{"cp"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBE, ["sb", $_[2]]], $_[0])};
$table->{"cp"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xBF], $_[0])};
$table->{"cp"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xB8], $_[0])};
$table->{"cp"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xB9], $_[0])};
$table->{"cp"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xBA], $_[0])};
$table->{"cp"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xBB], $_[0])};
$table->{"cp"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xBC], $_[0])};
$table->{"cp"}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBC], $_[0])};
$table->{"cp"}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBC], $_[0])};
$table->{"cp"}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBC], $_[0])};
$table->{"cp"}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBD], $_[0])};
$table->{"cp"}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBC], $_[0])};
$table->{"cp"}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBD], $_[0])};
$table->{"cp"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xBD], $_[0])};
$table->{"cp"}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBD], $_[0])};
$table->{"cp"}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBD], $_[0])};
$table->{"cp"}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBC], $_[0])};
$table->{"cp"}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xBD], $_[0])};
$table->{"cp"}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBC], $_[0])};
$table->{"cp"}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xBD], $_[0])};
$table->{"cpd"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xA9], $_[0])};
$table->{"cpdr"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xB9], $_[0])};
$table->{"cpi"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xA1], $_[0])};
$table->{"cpir"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xB1], $_[0])};
$table->{"cpl"}{"END"}{""}	= sub {(["OPCODE", 0x2F], $_[0])};
$table->{"daa"}{"END"}{""}	= sub {(["OPCODE", 0x27], $_[0])};
$table->{"dec"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x35], $_[0])};
$table->{"dec"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x35, ["sb", $_[2]]], $_[0])};
$table->{"dec"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x35, ["sb", $_[2]]], $_[0])};
$table->{"dec"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x35], $_[0])};
$table->{"dec"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x35, ["sb", $_[2]]], $_[0])};
$table->{"dec"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x35, ["sb", $_[2]]], $_[0])};
$table->{"dec"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x3D], $_[0])};
$table->{"dec"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x05], $_[0])};
$table->{"dec"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x0B], $_[0])};
$table->{"dec"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x0D], $_[0])};
$table->{"dec"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x15], $_[0])};
$table->{"dec"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x1B], $_[0])};
$table->{"dec"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x1D], $_[0])};
$table->{"dec"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x25], $_[0])};
$table->{"dec"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x2B], $_[0])};
$table->{"dec"}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x25], $_[0])};
$table->{"dec"}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x25], $_[0])};
$table->{"dec"}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2B], $_[0])};
$table->{"dec"}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x25], $_[0])};
$table->{"dec"}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2D], $_[0])};
$table->{"dec"}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2B], $_[0])};
$table->{"dec"}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x25], $_[0])};
$table->{"dec"}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2D], $_[0])};
$table->{"dec"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x2D], $_[0])};
$table->{"dec"}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2D], $_[0])};
$table->{"dec"}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2D], $_[0])};
$table->{"dec"}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0x3B], $_[0])};
$table->{"dec"}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x25], $_[0])};
$table->{"dec"}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2D], $_[0])};
$table->{"dec"}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x25], $_[0])};
$table->{"dec"}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2D], $_[0])};
$table->{"di"}{"END"}{""}	= sub {(["OPCODE", 0xF3], $_[0])};
$table->{"djnz"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x10, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"], ["-","-"], ["NAME","\$"], ["-","-"], ["NUMBER",2]))]], $_[0])};
$table->{"ei"}{"END"}{""}	= sub {(["OPCODE", 0xFB], $_[0])};
$table->{"ex"}{"("}{"sp"}{")"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xE3], $_[0])};
$table->{"ex"}{"("}{"sp"}{")"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE3], $_[0])};
$table->{"ex"}{"("}{"sp"}{")"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE3], $_[0])};
$table->{"ex"}{"["}{"sp"}{"]"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xE3], $_[0])};
$table->{"ex"}{"["}{"sp"}{"]"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE3], $_[0])};
$table->{"ex"}{"["}{"sp"}{"]"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE3], $_[0])};
$table->{"ex"}{"af"}{","}{"af"}{"END"}{""}	= sub {(["OPCODE", 0x08], $_[0])};
$table->{"ex"}{"af"}{","}{"af'"}{"END"}{""}	= sub {(["OPCODE", 0x08], $_[0])};
$table->{"ex"}{"af"}{"END"}{""}	= sub {(["OPCODE", 0x08], $_[0])};
$table->{"ex"}{"de"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xEB], $_[0])};
$table->{"exa"}{"END"}{""}	= sub {(["OPCODE", 0x08], $_[0])};
$table->{"exx"}{"END"}{""}	= sub {(["OPCODE", 0xD9], $_[0])};
$table->{"halt"}{"END"}{""}	= sub {(["OPCODE", 0x76], $_[0])};
$table->{"im"}{"CEXPR"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xED, 0x46], $_[0])}, 
1 => sub {(["OPCODE", 0xED, 0x56], $_[0])}, 
2 => sub {(["OPCODE", 0xED, 0x5E], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"in"}{"a"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDB, ["ub", $_[2]]], $_[0])};
$table->{"in"}{"a"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x78], $_[0])};
$table->{"in"}{"a"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDB, ["ub", $_[2]]], $_[0])};
$table->{"in"}{"a"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x78], $_[0])};
$table->{"in"}{"b"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x40], $_[0])};
$table->{"in"}{"b"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x40], $_[0])};
$table->{"in"}{"c"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x48], $_[0])};
$table->{"in"}{"c"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x48], $_[0])};
$table->{"in"}{"d"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x50], $_[0])};
$table->{"in"}{"d"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x50], $_[0])};
$table->{"in"}{"e"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x58], $_[0])};
$table->{"in"}{"e"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x58], $_[0])};
$table->{"in"}{"f"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x70], $_[0])};
$table->{"in"}{"f"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x70], $_[0])};
$table->{"in"}{"h"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x60], $_[0])};
$table->{"in"}{"h"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x60], $_[0])};
$table->{"in"}{"l"}{","}{"("}{"c"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x68], $_[0])};
$table->{"in"}{"l"}{","}{"["}{"c"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x68], $_[0])};
$table->{"inc"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x34], $_[0])};
$table->{"inc"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x34, ["sb", $_[2]]], $_[0])};
$table->{"inc"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x34, ["sb", $_[2]]], $_[0])};
$table->{"inc"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x34], $_[0])};
$table->{"inc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x34, ["sb", $_[2]]], $_[0])};
$table->{"inc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x34, ["sb", $_[2]]], $_[0])};
$table->{"inc"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x3C], $_[0])};
$table->{"inc"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x04], $_[0])};
$table->{"inc"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x03], $_[0])};
$table->{"inc"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x0C], $_[0])};
$table->{"inc"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x14], $_[0])};
$table->{"inc"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x13], $_[0])};
$table->{"inc"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x1C], $_[0])};
$table->{"inc"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x24], $_[0])};
$table->{"inc"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x23], $_[0])};
$table->{"inc"}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x24], $_[0])};
$table->{"inc"}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x24], $_[0])};
$table->{"inc"}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x23], $_[0])};
$table->{"inc"}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x24], $_[0])};
$table->{"inc"}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2C], $_[0])};
$table->{"inc"}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x23], $_[0])};
$table->{"inc"}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x24], $_[0])};
$table->{"inc"}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2C], $_[0])};
$table->{"inc"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x2C], $_[0])};
$table->{"inc"}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2C], $_[0])};
$table->{"inc"}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2C], $_[0])};
$table->{"inc"}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0x33], $_[0])};
$table->{"inc"}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x24], $_[0])};
$table->{"inc"}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2C], $_[0])};
$table->{"inc"}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x24], $_[0])};
$table->{"inc"}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2C], $_[0])};
$table->{"ind"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xAA], $_[0])};
$table->{"indr"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xBA], $_[0])};
$table->{"ini"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xA2], $_[0])};
$table->{"inir"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xB2], $_[0])};
$table->{"jp"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xE9], $_[0])};
$table->{"jp"}{"("}{"ix"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE9], $_[0])};
$table->{"jp"}{"("}{"iy"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE9], $_[0])};
$table->{"jp"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xC3, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xE9], $_[0])};
$table->{"jp"}{"["}{"ix"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE9], $_[0])};
$table->{"jp"}{"["}{"iy"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE9], $_[0])};
$table->{"jp"}{"c"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDA, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xE9], $_[0])};
$table->{"jp"}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE9], $_[0])};
$table->{"jp"}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE9], $_[0])};
$table->{"jp"}{"m"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFA, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"nc"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xD2, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"nz"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xC2, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"p"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xF2, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"pe"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xEA, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"po"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xE2, ["w", $_[2]], []], $_[0])};
$table->{"jp"}{"z"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xCA, ["w", $_[2]], []], $_[0])};
$table->{"jr"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x18, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"], ["-","-"], ["NAME","\$"], ["-","-"], ["NUMBER",2]))]], $_[0])};
$table->{"jr"}{"c"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x38, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"], ["-","-"], ["NAME","\$"], ["-","-"], ["NUMBER",2]))]], $_[0])};
$table->{"jr"}{"nc"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x30, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"], ["-","-"], ["NAME","\$"], ["-","-"], ["NUMBER",2]))]], $_[0])};
$table->{"jr"}{"nz"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x20, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"], ["-","-"], ["NAME","\$"], ["-","-"], ["NUMBER",2]))]], $_[0])};
$table->{"jr"}{"z"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x28, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"], ["-","-"], ["NAME","\$"], ["-","-"], ["NUMBER",2]))]], $_[0])};
$table->{"ld"}{"("}{"EXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x32, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"("}{"EXPR"}{")"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x43, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"("}{"EXPR"}{")"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x53, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"("}{"EXPR"}{")"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x22, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"("}{"EXPR"}{")"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x22, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"("}{"EXPR"}{")"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x22, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"("}{"EXPR"}{")"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x73, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"("}{"bc"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x02], $_[0])};
$table->{"ld"}{"("}{"de"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x12], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x36, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x77], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x70], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x23, 0x70, 0x2B], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x71], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x72], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x23, 0x72, 0x2B], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x73], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x74], $_[0])};
$table->{"ld"}{"("}{"hl"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x75], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x36, ["sb", $_[2]], ["ub", $_[3]]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x77, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x70, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x70, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x72, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x72, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x74, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x74, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x36, ["sb", $_[2]], ["ub", $_[3]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x77, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x70, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x70, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x72, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x72, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x74, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x74, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"EXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x32, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"["}{"EXPR"}{"]"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x43, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"["}{"EXPR"}{"]"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x53, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"["}{"EXPR"}{"]"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x22, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"["}{"EXPR"}{"]"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x22, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"["}{"EXPR"}{"]"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x22, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"["}{"EXPR"}{"]"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x73, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"["}{"bc"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x02], $_[0])};
$table->{"ld"}{"["}{"de"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x12], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x36, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x77], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x70], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x23, 0x70, 0x2B], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x71], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x72], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x23, 0x72, 0x2B], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x73], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x74], $_[0])};
$table->{"ld"}{"["}{"hl"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x75], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x36, ["sb", $_[2]], ["ub", $_[3]]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x77, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x70, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x70, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x72, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x72, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x74, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x74, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x36, ["sb", $_[2]], ["ub", $_[3]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x77, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x70, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x70, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x72, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x72, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x74, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x74, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"a"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x3A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"a"}{","}{"("}{"bc"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x0A], $_[0])};
$table->{"ld"}{"a"}{","}{"("}{"de"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x1A], $_[0])};
$table->{"ld"}{"a"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x7E], $_[0])};
$table->{"ld"}{"a"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"a"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"a"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x3E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"a"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x3A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"a"}{","}{"["}{"bc"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x0A], $_[0])};
$table->{"ld"}{"a"}{","}{"["}{"de"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x1A], $_[0])};
$table->{"ld"}{"a"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x7E], $_[0])};
$table->{"ld"}{"a"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"a"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"a"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x7F], $_[0])};
$table->{"ld"}{"a"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x78], $_[0])};
$table->{"ld"}{"a"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x79], $_[0])};
$table->{"ld"}{"a"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x7A], $_[0])};
$table->{"ld"}{"a"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x7B], $_[0])};
$table->{"ld"}{"a"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x7C], $_[0])};
$table->{"ld"}{"a"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7C], $_[0])};
$table->{"ld"}{"a"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7C], $_[0])};
$table->{"ld"}{"a"}{","}{"i"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x57], $_[0])};
$table->{"ld"}{"a"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7C], $_[0])};
$table->{"ld"}{"a"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7D], $_[0])};
$table->{"ld"}{"a"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7C], $_[0])};
$table->{"ld"}{"a"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7D], $_[0])};
$table->{"ld"}{"a"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x7D], $_[0])};
$table->{"ld"}{"a"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7D], $_[0])};
$table->{"ld"}{"a"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7D], $_[0])};
$table->{"ld"}{"a"}{","}{"r"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x5F], $_[0])};
$table->{"ld"}{"a"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7C], $_[0])};
$table->{"ld"}{"a"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7D], $_[0])};
$table->{"ld"}{"a"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7C], $_[0])};
$table->{"ld"}{"a"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7D], $_[0])};
$table->{"ld"}{"b"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x46], $_[0])};
$table->{"ld"}{"b"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x46, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"b"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x46, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"b"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x06, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"b"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x46], $_[0])};
$table->{"ld"}{"b"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x46, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"b"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x46, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"b"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x47], $_[0])};
$table->{"ld"}{"b"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x40], $_[0])};
$table->{"ld"}{"b"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x41], $_[0])};
$table->{"ld"}{"b"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x42], $_[0])};
$table->{"ld"}{"b"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x43], $_[0])};
$table->{"ld"}{"b"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x44], $_[0])};
$table->{"ld"}{"b"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x44], $_[0])};
$table->{"ld"}{"b"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x44], $_[0])};
$table->{"ld"}{"b"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x44], $_[0])};
$table->{"ld"}{"b"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x45], $_[0])};
$table->{"ld"}{"b"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x44], $_[0])};
$table->{"ld"}{"b"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x45], $_[0])};
$table->{"ld"}{"b"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x45], $_[0])};
$table->{"ld"}{"b"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x45], $_[0])};
$table->{"ld"}{"b"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x45], $_[0])};
$table->{"ld"}{"b"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x44], $_[0])};
$table->{"ld"}{"b"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x45], $_[0])};
$table->{"ld"}{"b"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x44], $_[0])};
$table->{"ld"}{"b"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x45], $_[0])};
$table->{"ld"}{"bc"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x4B, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"bc"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x23, 0x46, 0x2B], $_[0])};
$table->{"ld"}{"bc"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x46, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"bc"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x46, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"bc"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x01, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"bc"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x4B, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"bc"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x23, 0x46, 0x2B], $_[0])};
$table->{"ld"}{"bc"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x46, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"bc"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x46, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"bc"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x40, 0x49], $_[0])};
$table->{"ld"}{"bc"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x42, 0x4B], $_[0])};
$table->{"ld"}{"bc"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x44, 0x4D], $_[0])};
$table->{"ld"}{"bc"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x44, 0xDD, 0x4D], $_[0])};
$table->{"ld"}{"bc"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x44, 0xFD, 0x4D], $_[0])};
$table->{"ld"}{"c"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x4E], $_[0])};
$table->{"ld"}{"c"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"c"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"c"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x0E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"c"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x4E], $_[0])};
$table->{"ld"}{"c"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"c"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"c"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x4F], $_[0])};
$table->{"ld"}{"c"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x48], $_[0])};
$table->{"ld"}{"c"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x49], $_[0])};
$table->{"ld"}{"c"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x4A], $_[0])};
$table->{"ld"}{"c"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x4B], $_[0])};
$table->{"ld"}{"c"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x4C], $_[0])};
$table->{"ld"}{"c"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4C], $_[0])};
$table->{"ld"}{"c"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4C], $_[0])};
$table->{"ld"}{"c"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4C], $_[0])};
$table->{"ld"}{"c"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4D], $_[0])};
$table->{"ld"}{"c"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4C], $_[0])};
$table->{"ld"}{"c"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4D], $_[0])};
$table->{"ld"}{"c"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x4D], $_[0])};
$table->{"ld"}{"c"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4D], $_[0])};
$table->{"ld"}{"c"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4D], $_[0])};
$table->{"ld"}{"c"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4C], $_[0])};
$table->{"ld"}{"c"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4D], $_[0])};
$table->{"ld"}{"c"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4C], $_[0])};
$table->{"ld"}{"c"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4D], $_[0])};
$table->{"ld"}{"d"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x56], $_[0])};
$table->{"ld"}{"d"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x56, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"d"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x56, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"d"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x16, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"d"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x56], $_[0])};
$table->{"ld"}{"d"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x56, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"d"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x56, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"d"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x57], $_[0])};
$table->{"ld"}{"d"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x50], $_[0])};
$table->{"ld"}{"d"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x51], $_[0])};
$table->{"ld"}{"d"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x52], $_[0])};
$table->{"ld"}{"d"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x53], $_[0])};
$table->{"ld"}{"d"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x54], $_[0])};
$table->{"ld"}{"d"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x54], $_[0])};
$table->{"ld"}{"d"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x54], $_[0])};
$table->{"ld"}{"d"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x54], $_[0])};
$table->{"ld"}{"d"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x55], $_[0])};
$table->{"ld"}{"d"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x54], $_[0])};
$table->{"ld"}{"d"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x55], $_[0])};
$table->{"ld"}{"d"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x55], $_[0])};
$table->{"ld"}{"d"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x55], $_[0])};
$table->{"ld"}{"d"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x55], $_[0])};
$table->{"ld"}{"d"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x54], $_[0])};
$table->{"ld"}{"d"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x55], $_[0])};
$table->{"ld"}{"d"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x54], $_[0])};
$table->{"ld"}{"d"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x55], $_[0])};
$table->{"ld"}{"de"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x5B, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"de"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x23, 0x56, 0x2B], $_[0])};
$table->{"ld"}{"de"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x56, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"de"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x56, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"de"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x11, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"de"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x5B, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"de"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x23, 0x56, 0x2B], $_[0])};
$table->{"ld"}{"de"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x56, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"de"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x56, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"de"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x50, 0x59], $_[0])};
$table->{"ld"}{"de"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x52, 0x5B], $_[0])};
$table->{"ld"}{"de"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x54, 0x5D], $_[0])};
$table->{"ld"}{"de"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x54, 0xDD, 0x5D], $_[0])};
$table->{"ld"}{"de"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x54, 0xFD, 0x5D], $_[0])};
$table->{"ld"}{"e"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x5E], $_[0])};
$table->{"ld"}{"e"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"e"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"e"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x1E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"e"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x5E], $_[0])};
$table->{"ld"}{"e"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"e"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"e"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x5F], $_[0])};
$table->{"ld"}{"e"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x58], $_[0])};
$table->{"ld"}{"e"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x59], $_[0])};
$table->{"ld"}{"e"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x5A], $_[0])};
$table->{"ld"}{"e"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x5B], $_[0])};
$table->{"ld"}{"e"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x5C], $_[0])};
$table->{"ld"}{"e"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5C], $_[0])};
$table->{"ld"}{"e"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5C], $_[0])};
$table->{"ld"}{"e"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5C], $_[0])};
$table->{"ld"}{"e"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5D], $_[0])};
$table->{"ld"}{"e"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5C], $_[0])};
$table->{"ld"}{"e"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5D], $_[0])};
$table->{"ld"}{"e"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x5D], $_[0])};
$table->{"ld"}{"e"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5D], $_[0])};
$table->{"ld"}{"e"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5D], $_[0])};
$table->{"ld"}{"e"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5C], $_[0])};
$table->{"ld"}{"e"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5D], $_[0])};
$table->{"ld"}{"e"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5C], $_[0])};
$table->{"ld"}{"e"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5D], $_[0])};
$table->{"ld"}{"h"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x66], $_[0])};
$table->{"ld"}{"h"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x66, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"h"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x66, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"h"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x26, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"h"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x66], $_[0])};
$table->{"ld"}{"h"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x66, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"h"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x66, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"h"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x67], $_[0])};
$table->{"ld"}{"h"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x60], $_[0])};
$table->{"ld"}{"h"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x61], $_[0])};
$table->{"ld"}{"h"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x62], $_[0])};
$table->{"ld"}{"h"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x63], $_[0])};
$table->{"ld"}{"h"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x64], $_[0])};
$table->{"ld"}{"h"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x65], $_[0])};
$table->{"ld"}{"hl"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x2A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"hl"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x66, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"hl"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x66, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"hl"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x21, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"hl"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x2A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"hl"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x66, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"hl"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x66, ["sb", append(list_to_stream(["(","("]), $_[2], list_to_stream([")",")"]), list_to_stream(["+","+"]), list_to_stream(["NUMBER",1]))]], $_[0])};
$table->{"ld"}{"hl"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x60, 0x69], $_[0])};
$table->{"ld"}{"hl"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x62, 0x6B], $_[0])};
$table->{"ld"}{"hl"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x64, 0x6D], $_[0])};
$table->{"ld"}{"hl"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE5, 0xE1], $_[0])};
$table->{"ld"}{"hl"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE5, 0xE1], $_[0])};
$table->{"ld"}{"hx"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x26, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"hx"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x67], $_[0])};
$table->{"ld"}{"hx"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x60], $_[0])};
$table->{"ld"}{"hx"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x61], $_[0])};
$table->{"ld"}{"hx"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x62], $_[0])};
$table->{"ld"}{"hx"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x63], $_[0])};
$table->{"ld"}{"hx"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x64], $_[0])};
$table->{"ld"}{"hx"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x65], $_[0])};
$table->{"ld"}{"hy"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x26, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"hy"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x67], $_[0])};
$table->{"ld"}{"hy"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x60], $_[0])};
$table->{"ld"}{"hy"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x61], $_[0])};
$table->{"ld"}{"hy"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x62], $_[0])};
$table->{"ld"}{"hy"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x63], $_[0])};
$table->{"ld"}{"hy"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x64], $_[0])};
$table->{"ld"}{"hy"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x65], $_[0])};
$table->{"ld"}{"i"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x47], $_[0])};
$table->{"ld"}{"ix"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"ix"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x21, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"ix"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"ix"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x69, 0xDD, 0x60], $_[0])};
$table->{"ld"}{"ix"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6B, 0xDD, 0x62], $_[0])};
$table->{"ld"}{"ix"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xE5, 0xDD, 0xE1], $_[0])};
$table->{"ld"}{"ix"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6D, 0xDD, 0x64], $_[0])};
$table->{"ld"}{"ix"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE5, 0xDD, 0xE1], $_[0])};
$table->{"ld"}{"ixh"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x26, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"ixh"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x67], $_[0])};
$table->{"ld"}{"ixh"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x60], $_[0])};
$table->{"ld"}{"ixh"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x61], $_[0])};
$table->{"ld"}{"ixh"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x62], $_[0])};
$table->{"ld"}{"ixh"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x63], $_[0])};
$table->{"ld"}{"ixh"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x64], $_[0])};
$table->{"ld"}{"ixh"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x65], $_[0])};
$table->{"ld"}{"ixl"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"ixl"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6F], $_[0])};
$table->{"ld"}{"ixl"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x68], $_[0])};
$table->{"ld"}{"ixl"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x69], $_[0])};
$table->{"ld"}{"ixl"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6A], $_[0])};
$table->{"ld"}{"ixl"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6B], $_[0])};
$table->{"ld"}{"ixl"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6C], $_[0])};
$table->{"ld"}{"ixl"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6D], $_[0])};
$table->{"ld"}{"iy"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"iy"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x21, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"iy"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2A, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"iy"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x69, 0xFD, 0x60], $_[0])};
$table->{"ld"}{"iy"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6B, 0xFD, 0x62], $_[0])};
$table->{"ld"}{"iy"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xE5, 0xFD, 0xE1], $_[0])};
$table->{"ld"}{"iy"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE5, 0xFD, 0xE1], $_[0])};
$table->{"ld"}{"iy"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6D, 0xFD, 0x64], $_[0])};
$table->{"ld"}{"iyh"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x26, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"iyh"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x67], $_[0])};
$table->{"ld"}{"iyh"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x60], $_[0])};
$table->{"ld"}{"iyh"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x61], $_[0])};
$table->{"ld"}{"iyh"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x62], $_[0])};
$table->{"ld"}{"iyh"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x63], $_[0])};
$table->{"ld"}{"iyh"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x64], $_[0])};
$table->{"ld"}{"iyh"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x65], $_[0])};
$table->{"ld"}{"iyl"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"iyl"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6F], $_[0])};
$table->{"ld"}{"iyl"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x68], $_[0])};
$table->{"ld"}{"iyl"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x69], $_[0])};
$table->{"ld"}{"iyl"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6A], $_[0])};
$table->{"ld"}{"iyl"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6B], $_[0])};
$table->{"ld"}{"iyl"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6C], $_[0])};
$table->{"ld"}{"iyl"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6D], $_[0])};
$table->{"ld"}{"l"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x6E], $_[0])};
$table->{"ld"}{"l"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"l"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"l"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x2E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"l"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x6E], $_[0])};
$table->{"ld"}{"l"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"l"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]]], $_[0])};
$table->{"ld"}{"l"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x6F], $_[0])};
$table->{"ld"}{"l"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x68], $_[0])};
$table->{"ld"}{"l"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x69], $_[0])};
$table->{"ld"}{"l"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x6A], $_[0])};
$table->{"ld"}{"l"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x6B], $_[0])};
$table->{"ld"}{"l"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x6C], $_[0])};
$table->{"ld"}{"l"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x6D], $_[0])};
$table->{"ld"}{"lx"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"lx"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6F], $_[0])};
$table->{"ld"}{"lx"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x68], $_[0])};
$table->{"ld"}{"lx"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x69], $_[0])};
$table->{"ld"}{"lx"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6A], $_[0])};
$table->{"ld"}{"lx"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6B], $_[0])};
$table->{"ld"}{"lx"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6C], $_[0])};
$table->{"ld"}{"lx"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6D], $_[0])};
$table->{"ld"}{"ly"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"ly"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6F], $_[0])};
$table->{"ld"}{"ly"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x68], $_[0])};
$table->{"ld"}{"ly"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x69], $_[0])};
$table->{"ld"}{"ly"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6A], $_[0])};
$table->{"ld"}{"ly"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6B], $_[0])};
$table->{"ld"}{"ly"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6C], $_[0])};
$table->{"ld"}{"ly"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6D], $_[0])};
$table->{"ld"}{"r"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x4F], $_[0])};
$table->{"ld"}{"sp"}{","}{"("}{"EXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x7B, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"sp"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x31, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"sp"}{","}{"["}{"EXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x7B, ["w", $_[2]], []], $_[0])};
$table->{"ld"}{"sp"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xF9], $_[0])};
$table->{"ld"}{"sp"}{","}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xF9], $_[0])};
$table->{"ld"}{"sp"}{","}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xF9], $_[0])};
$table->{"ld"}{"xh"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x26, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"xh"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x67], $_[0])};
$table->{"ld"}{"xh"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x60], $_[0])};
$table->{"ld"}{"xh"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x61], $_[0])};
$table->{"ld"}{"xh"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x62], $_[0])};
$table->{"ld"}{"xh"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x63], $_[0])};
$table->{"ld"}{"xh"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x64], $_[0])};
$table->{"ld"}{"xh"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x65], $_[0])};
$table->{"ld"}{"xl"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x2E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"xl"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6F], $_[0])};
$table->{"ld"}{"xl"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x68], $_[0])};
$table->{"ld"}{"xl"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x69], $_[0])};
$table->{"ld"}{"xl"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6A], $_[0])};
$table->{"ld"}{"xl"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6B], $_[0])};
$table->{"ld"}{"xl"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6C], $_[0])};
$table->{"ld"}{"xl"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6D], $_[0])};
$table->{"ld"}{"yh"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x26, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"yh"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x67], $_[0])};
$table->{"ld"}{"yh"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x60], $_[0])};
$table->{"ld"}{"yh"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x61], $_[0])};
$table->{"ld"}{"yh"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x62], $_[0])};
$table->{"ld"}{"yh"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x63], $_[0])};
$table->{"ld"}{"yh"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x64], $_[0])};
$table->{"ld"}{"yh"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x65], $_[0])};
$table->{"ld"}{"yl"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x2E, ["ub", $_[2]]], $_[0])};
$table->{"ld"}{"yl"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6F], $_[0])};
$table->{"ld"}{"yl"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x68], $_[0])};
$table->{"ld"}{"yl"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x69], $_[0])};
$table->{"ld"}{"yl"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6A], $_[0])};
$table->{"ld"}{"yl"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6B], $_[0])};
$table->{"ld"}{"yl"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6C], $_[0])};
$table->{"ld"}{"yl"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6D], $_[0])};
$table->{"ldd"}{"("}{"bc"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x02, 0x0B], $_[0])};
$table->{"ldd"}{"("}{"de"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x12, 0x1B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x36, ["ub", $_[2]], 0x2B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x77, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x70, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x72, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x74, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"hl"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x75, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x77, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x70, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x72, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x74, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x77, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x70, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x72, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x74, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xA8], $_[0])};
$table->{"ldd"}{"["}{"bc"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x02, 0x0B], $_[0])};
$table->{"ldd"}{"["}{"de"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x12, 0x1B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x36, ["ub", $_[2]], 0x2B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x77, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x70, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x72, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x74, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"hl"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x75, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x77, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x70, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x72, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x74, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x77, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x70, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x72, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x74, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"a"}{","}{"("}{"bc"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x0A, 0x0B], $_[0])};
$table->{"ldd"}{"a"}{","}{"("}{"de"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x1A, 0x1B], $_[0])};
$table->{"ldd"}{"a"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x7E, 0x2B], $_[0])};
$table->{"ldd"}{"a"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"a"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"a"}{","}{"["}{"bc"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x0A, 0x0B], $_[0])};
$table->{"ldd"}{"a"}{","}{"["}{"de"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x1A, 0x1B], $_[0])};
$table->{"ldd"}{"a"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x7E, 0x2B], $_[0])};
$table->{"ldd"}{"a"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"a"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"b"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x46, 0x2B], $_[0])};
$table->{"ldd"}{"b"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x46, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"b"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x46, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"b"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x46, 0x2B], $_[0])};
$table->{"ldd"}{"b"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x46, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"b"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x46, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"c"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x2B], $_[0])};
$table->{"ldd"}{"c"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"c"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"c"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x2B], $_[0])};
$table->{"ldd"}{"c"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"c"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"d"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x56, 0x2B], $_[0])};
$table->{"ldd"}{"d"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x56, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"d"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x56, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"d"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x56, 0x2B], $_[0])};
$table->{"ldd"}{"d"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x56, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"d"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x56, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"e"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x2B], $_[0])};
$table->{"ldd"}{"e"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"e"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"e"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x2B], $_[0])};
$table->{"ldd"}{"e"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"e"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"h"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x66, 0x2B], $_[0])};
$table->{"ldd"}{"h"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x66, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"h"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x66, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"h"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x66, 0x2B], $_[0])};
$table->{"ldd"}{"h"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x66, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"h"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x66, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"l"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x6E, 0x2B], $_[0])};
$table->{"ldd"}{"l"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"l"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"ldd"}{"l"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x6E, 0x2B], $_[0])};
$table->{"ldd"}{"l"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x2B], $_[0])};
$table->{"ldd"}{"l"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x2B], $_[0])};
$table->{"lddr"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xB8], $_[0])};
$table->{"ldi"}{"("}{"bc"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x02, 0x03], $_[0])};
$table->{"ldi"}{"("}{"de"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x12, 0x13], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x36, ["ub", $_[2]], 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x77, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x70, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x23, 0x70, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x72, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x23, 0x72, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x74, 0x23], $_[0])};
$table->{"ldi"}{"("}{"hl"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x75, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x77, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x70, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x70, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x72, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x72, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x74, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x74, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x77, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x70, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x70, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x72, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x72, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x74, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x74, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xA0], $_[0])};
$table->{"ldi"}{"["}{"bc"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x02, 0x03], $_[0])};
$table->{"ldi"}{"["}{"de"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x12, 0x13], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0x36, ["ub", $_[2]], 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x77, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x70, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x23, 0x70, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x71, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x72, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x23, 0x72, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x73, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x74, 0x23], $_[0])};
$table->{"ldi"}{"["}{"hl"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x75, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x77, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x70, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x70, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x71, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x72, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x72, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x73, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x74, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x74, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x75, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x36, ["sb", $_[2]], ["ub", $_[3]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x77, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x70, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x70, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x71, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x72, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x72, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x73, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x74, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x74, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x75, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"a"}{","}{"("}{"bc"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x0A, 0x03], $_[0])};
$table->{"ldi"}{"a"}{","}{"("}{"de"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x1A, 0x13], $_[0])};
$table->{"ldi"}{"a"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x7E, 0x23], $_[0])};
$table->{"ldi"}{"a"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"a"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"a"}{","}{"["}{"bc"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x0A, 0x03], $_[0])};
$table->{"ldi"}{"a"}{","}{"["}{"de"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x1A, 0x13], $_[0])};
$table->{"ldi"}{"a"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x7E, 0x23], $_[0])};
$table->{"ldi"}{"a"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x7E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"a"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x7E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"b"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x46, 0x23], $_[0])};
$table->{"ldi"}{"b"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x46, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"b"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x46, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"b"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x46, 0x23], $_[0])};
$table->{"ldi"}{"b"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x46, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"b"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x46, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"bc"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x23, 0x46, 0x23], $_[0])};
$table->{"ldi"}{"bc"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x46, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"bc"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x46, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"bc"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x23, 0x46, 0x23], $_[0])};
$table->{"ldi"}{"bc"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x46, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"bc"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x46, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"c"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x23], $_[0])};
$table->{"ldi"}{"c"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"c"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"c"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x4E, 0x23], $_[0])};
$table->{"ldi"}{"c"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x4E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"c"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x4E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"d"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x56, 0x23], $_[0])};
$table->{"ldi"}{"d"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x56, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"d"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x56, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"d"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x56, 0x23], $_[0])};
$table->{"ldi"}{"d"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x56, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"d"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x56, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"de"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x23, 0x56, 0x23], $_[0])};
$table->{"ldi"}{"de"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x56, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"de"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x56, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"de"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x23, 0x56, 0x23], $_[0])};
$table->{"ldi"}{"de"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x56, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"de"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x56, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"e"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x23], $_[0])};
$table->{"ldi"}{"e"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"e"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"e"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x5E, 0x23], $_[0])};
$table->{"ldi"}{"e"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x5E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"e"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x5E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"h"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x66, 0x23], $_[0])};
$table->{"ldi"}{"h"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x66, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"h"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x66, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"h"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x66, 0x23], $_[0])};
$table->{"ldi"}{"h"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x66, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"h"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x66, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"hl"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x66, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"hl"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x66, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"hl"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x23, 0xDD, 0x66, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"hl"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x23, 0xFD, 0x66, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"l"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x6E, 0x23], $_[0])};
$table->{"ldi"}{"l"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"l"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldi"}{"l"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x6E, 0x23], $_[0])};
$table->{"ldi"}{"l"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x6E, ["sb", $_[2]], 0xDD, 0x23], $_[0])};
$table->{"ldi"}{"l"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x6E, ["sb", $_[2]], 0xFD, 0x23], $_[0])};
$table->{"ldir"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xB0], $_[0])};
$table->{"neg"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x44], $_[0])};
$table->{"nop"}{"END"}{""}	= sub {(["OPCODE", 0x00], $_[0])};
$table->{"or"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xB6], $_[0])};
$table->{"or"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB6, ["sb", $_[2]]], $_[0])};
$table->{"or"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB6, ["sb", $_[2]]], $_[0])};
$table->{"or"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xF6, ["ub", $_[2]]], $_[0])};
$table->{"or"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xB6], $_[0])};
$table->{"or"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB6, ["sb", $_[2]]], $_[0])};
$table->{"or"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB6, ["sb", $_[2]]], $_[0])};
$table->{"or"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xB7], $_[0])};
$table->{"or"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xB0], $_[0])};
$table->{"or"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xB1], $_[0])};
$table->{"or"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xB2], $_[0])};
$table->{"or"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xB3], $_[0])};
$table->{"or"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xB4], $_[0])};
$table->{"or"}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB4], $_[0])};
$table->{"or"}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB4], $_[0])};
$table->{"or"}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB4], $_[0])};
$table->{"or"}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB5], $_[0])};
$table->{"or"}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB4], $_[0])};
$table->{"or"}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB5], $_[0])};
$table->{"or"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xB5], $_[0])};
$table->{"or"}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB5], $_[0])};
$table->{"or"}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB5], $_[0])};
$table->{"or"}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB4], $_[0])};
$table->{"or"}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xB5], $_[0])};
$table->{"or"}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB4], $_[0])};
$table->{"or"}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xB5], $_[0])};
$table->{"otdr"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xBB], $_[0])};
$table->{"otir"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xB3], $_[0])};
$table->{"out"}{"("}{"EXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xD3, ["ub", $_[2]]], $_[0])};
$table->{"out"}{"("}{"c"}{")"}{","}{"CEXPR"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xED, 0x71], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"out"}{"("}{"c"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x79], $_[0])};
$table->{"out"}{"("}{"c"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x41], $_[0])};
$table->{"out"}{"("}{"c"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x49], $_[0])};
$table->{"out"}{"("}{"c"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x51], $_[0])};
$table->{"out"}{"("}{"c"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x59], $_[0])};
$table->{"out"}{"("}{"c"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x61], $_[0])};
$table->{"out"}{"("}{"c"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x69], $_[0])};
$table->{"out"}{"["}{"EXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xD3, ["ub", $_[2]]], $_[0])};
$table->{"out"}{"["}{"c"}{"]"}{","}{"CEXPR"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xED, 0x71], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"out"}{"["}{"c"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x79], $_[0])};
$table->{"out"}{"["}{"c"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x41], $_[0])};
$table->{"out"}{"["}{"c"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x49], $_[0])};
$table->{"out"}{"["}{"c"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x51], $_[0])};
$table->{"out"}{"["}{"c"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x59], $_[0])};
$table->{"out"}{"["}{"c"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x61], $_[0])};
$table->{"out"}{"["}{"c"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x69], $_[0])};
$table->{"outd"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xAB], $_[0])};
$table->{"outi"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0xA3], $_[0])};
$table->{"pop"}{"af"}{"END"}{""}	= sub {(["OPCODE", 0xF1], $_[0])};
$table->{"pop"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xC1], $_[0])};
$table->{"pop"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xD1], $_[0])};
$table->{"pop"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xE1], $_[0])};
$table->{"pop"}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE1], $_[0])};
$table->{"pop"}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE1], $_[0])};
$table->{"push"}{"af"}{"END"}{""}	= sub {(["OPCODE", 0xF5], $_[0])};
$table->{"push"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xC5], $_[0])};
$table->{"push"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xD5], $_[0])};
$table->{"push"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xE5], $_[0])};
$table->{"push"}{"ix"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xE5], $_[0])};
$table->{"push"}{"iy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xE5], $_[0])};
$table->{"res"}{"CEXPR"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x86], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x8E], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x96], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x9E], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA6], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xAE], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB6], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xBE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x87], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8F], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x97], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9F], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA7], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAF], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB7], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x80], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x88], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x90], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x98], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA0], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA8], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB0], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x81], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x89], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x91], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x99], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA1], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA9], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB1], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x82], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8A], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x92], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9A], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA2], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAA], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB2], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x83], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8B], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x93], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9B], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA3], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAB], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB3], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x84], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8C], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x94], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9C], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA4], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAC], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB4], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x85], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8D], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x95], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9D], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA5], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAD], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB5], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x86], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8E], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x96], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9E], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA6], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAE], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB6], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x87], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8F], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x97], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9F], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA7], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAF], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB7], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x80], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x88], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x90], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x98], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA0], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA8], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB0], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x81], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x89], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x91], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x99], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA1], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA9], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB1], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x82], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8A], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x92], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9A], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA2], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAA], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB2], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x83], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8B], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x93], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9B], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA3], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAB], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB3], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x84], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8C], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x94], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9C], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA4], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAC], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB4], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x85], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8D], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x95], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9D], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA5], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAD], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB5], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x86], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8E], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x96], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9E], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA6], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAE], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB6], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x86], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x8E], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x96], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x9E], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA6], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xAE], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB6], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xBE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x87], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8F], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x97], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9F], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA7], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAF], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB7], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x80], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x88], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x90], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x98], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA0], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA8], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB0], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x81], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x89], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x91], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x99], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA1], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA9], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB1], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x82], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8A], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x92], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9A], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA2], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAA], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB2], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x83], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8B], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x93], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9B], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA3], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAB], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB3], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x84], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8C], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x94], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9C], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA4], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAC], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB4], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x85], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8D], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x95], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9D], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA5], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAD], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB5], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x86], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x8E], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x96], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0x9E], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xA6], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xAE], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xB6], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xBE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x87], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8F], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x97], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9F], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA7], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAF], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB7], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x80], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x88], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x90], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x98], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA0], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA8], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB0], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x81], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x89], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x91], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x99], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA1], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA9], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB1], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x82], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8A], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x92], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9A], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA2], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAA], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB2], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x83], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8B], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x93], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9B], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA3], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAB], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB3], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x84], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8C], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x94], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9C], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA4], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAC], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB4], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x85], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8D], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x95], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9D], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA5], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAD], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB5], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x86], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x8E], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x96], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0x9E], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xA6], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xAE], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xB6], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xBE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x87], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x8F], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x97], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x9F], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA7], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xAF], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB7], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xBF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x80], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x88], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x90], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x98], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA0], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xA8], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB0], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xB8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x81], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x89], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x91], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x99], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA1], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xA9], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB1], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xB9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x82], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x8A], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x92], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x9A], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA2], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xAA], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB2], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xBA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x83], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x8B], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x93], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x9B], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA3], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xAB], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB3], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xBB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x84], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x8C], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x94], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x9C], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA4], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xAC], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB4], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xBC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"res"}{"CEXPR"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0x85], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0x8D], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0x95], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0x9D], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xA5], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xAD], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xB5], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xBD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"ret"}{"END"}{""}	= sub {(["OPCODE", 0xC9], $_[0])};
$table->{"ret"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xD8], $_[0])};
$table->{"ret"}{"m"}{"END"}{""}	= sub {(["OPCODE", 0xF8], $_[0])};
$table->{"ret"}{"nc"}{"END"}{""}	= sub {(["OPCODE", 0xD0], $_[0])};
$table->{"ret"}{"nz"}{"END"}{""}	= sub {(["OPCODE", 0xC0], $_[0])};
$table->{"ret"}{"p"}{"END"}{""}	= sub {(["OPCODE", 0xF0], $_[0])};
$table->{"ret"}{"pe"}{"END"}{""}	= sub {(["OPCODE", 0xE8], $_[0])};
$table->{"ret"}{"po"}{"END"}{""}	= sub {(["OPCODE", 0xE0], $_[0])};
$table->{"ret"}{"z"}{"END"}{""}	= sub {(["OPCODE", 0xC8], $_[0])};
$table->{"reti"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x4D], $_[0])};
$table->{"retn"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x45], $_[0])};
$table->{"rl"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x16], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x17], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x10], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x11], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x12], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x13], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x14], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x15], $_[0])};
$table->{"rl"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x16], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x17], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x10], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x11], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x12], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x13], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x14], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x15], $_[0])};
$table->{"rl"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x16], $_[0])};
$table->{"rl"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x16], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x17], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x10], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x11], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x12], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x13], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x14], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x15], $_[0])};
$table->{"rl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x16], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x17], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x10], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x11], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x12], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x13], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x14], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x15], $_[0])};
$table->{"rl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x16], $_[0])};
$table->{"rl"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x17], $_[0])};
$table->{"rl"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x10], $_[0])};
$table->{"rl"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x11, 0xCB, 0x10], $_[0])};
$table->{"rl"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x11], $_[0])};
$table->{"rl"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x12], $_[0])};
$table->{"rl"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x13, 0xCB, 0x12], $_[0])};
$table->{"rl"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x13], $_[0])};
$table->{"rl"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x14], $_[0])};
$table->{"rl"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x15, 0xCB, 0x14], $_[0])};
$table->{"rl"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x15], $_[0])};
$table->{"rla"}{"END"}{""}	= sub {(["OPCODE", 0x17], $_[0])};
$table->{"rlc"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x06], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x07], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x00], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x01], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x02], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x03], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x04], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x05], $_[0])};
$table->{"rlc"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x06], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x07], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x00], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x01], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x02], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x03], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x04], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x05], $_[0])};
$table->{"rlc"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x06], $_[0])};
$table->{"rlc"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x06], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x07], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x00], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x01], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x02], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x03], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x04], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x05], $_[0])};
$table->{"rlc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x06], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x07], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x00], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x01], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x02], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x03], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x04], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x05], $_[0])};
$table->{"rlc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x06], $_[0])};
$table->{"rlc"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x07], $_[0])};
$table->{"rlc"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x00], $_[0])};
$table->{"rlc"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x01], $_[0])};
$table->{"rlc"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x02], $_[0])};
$table->{"rlc"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x03], $_[0])};
$table->{"rlc"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x04], $_[0])};
$table->{"rlc"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x05], $_[0])};
$table->{"rlca"}{"END"}{""}	= sub {(["OPCODE", 0x07], $_[0])};
$table->{"rld"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x6F], $_[0])};
$table->{"rr"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1E], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1F], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x18], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x19], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1A], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1B], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1C], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1D], $_[0])};
$table->{"rr"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1E], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1F], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x18], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x19], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1A], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1B], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1C], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1D], $_[0])};
$table->{"rr"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1E], $_[0])};
$table->{"rr"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1E], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1F], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x18], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x19], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1A], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1B], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1C], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1D], $_[0])};
$table->{"rr"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x1E], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1F], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x18], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x19], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1A], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1B], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1C], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1D], $_[0])};
$table->{"rr"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x1E], $_[0])};
$table->{"rr"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1F], $_[0])};
$table->{"rr"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x18], $_[0])};
$table->{"rr"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x18, 0xCB, 0x19], $_[0])};
$table->{"rr"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x19], $_[0])};
$table->{"rr"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1A], $_[0])};
$table->{"rr"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1A, 0xCB, 0x1B], $_[0])};
$table->{"rr"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1B], $_[0])};
$table->{"rr"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1C], $_[0])};
$table->{"rr"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1C, 0xCB, 0x1D], $_[0])};
$table->{"rr"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x1D], $_[0])};
$table->{"rra"}{"END"}{""}	= sub {(["OPCODE", 0x1F], $_[0])};
$table->{"rrc"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x0E], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0F], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x08], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x09], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0A], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0B], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0C], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0D], $_[0])};
$table->{"rrc"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0E], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0F], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x08], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x09], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0A], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0B], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0C], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0D], $_[0])};
$table->{"rrc"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0E], $_[0])};
$table->{"rrc"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x0E], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0F], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x08], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x09], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0A], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0B], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0C], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0D], $_[0])};
$table->{"rrc"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x0E], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0F], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x08], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x09], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0A], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0B], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0C], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0D], $_[0])};
$table->{"rrc"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x0E], $_[0])};
$table->{"rrc"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x0F], $_[0])};
$table->{"rrc"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x08], $_[0])};
$table->{"rrc"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x09], $_[0])};
$table->{"rrc"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x0A], $_[0])};
$table->{"rrc"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x0B], $_[0])};
$table->{"rrc"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x0C], $_[0])};
$table->{"rrc"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x0D], $_[0])};
$table->{"rrca"}{"END"}{""}	= sub {(["OPCODE", 0x0F], $_[0])};
$table->{"rrd"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x67], $_[0])};
$table->{"rst"}{"CEXPR"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xC7], $_[0])}, 
1 => sub {(["OPCODE", 0xCF], $_[0])}, 
16 => sub {(["OPCODE", 0xD7], $_[0])}, 
2 => sub {(["OPCODE", 0xD7], $_[0])}, 
24 => sub {(["OPCODE", 0xDF], $_[0])}, 
3 => sub {(["OPCODE", 0xDF], $_[0])}, 
32 => sub {(["OPCODE", 0xE7], $_[0])}, 
4 => sub {(["OPCODE", 0xE7], $_[0])}, 
40 => sub {(["OPCODE", 0xEF], $_[0])}, 
48 => sub {(["OPCODE", 0xF7], $_[0])}, 
5 => sub {(["OPCODE", 0xEF], $_[0])}, 
56 => sub {(["OPCODE", 0xFF], $_[0])}, 
6 => sub {(["OPCODE", 0xF7], $_[0])}, 
7 => sub {(["OPCODE", 0xFF], $_[0])}, 
8 => sub {(["OPCODE", 0xCF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"sbc"}{"a"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x9E], $_[0])};
$table->{"sbc"}{"a"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9E, ["sb", $_[2]]], $_[0])};
$table->{"sbc"}{"a"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9E, ["sb", $_[2]]], $_[0])};
$table->{"sbc"}{"a"}{","}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xDE, ["ub", $_[2]]], $_[0])};
$table->{"sbc"}{"a"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x9E], $_[0])};
$table->{"sbc"}{"a"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9E, ["sb", $_[2]]], $_[0])};
$table->{"sbc"}{"a"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9E, ["sb", $_[2]]], $_[0])};
$table->{"sbc"}{"a"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x9F], $_[0])};
$table->{"sbc"}{"a"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x98], $_[0])};
$table->{"sbc"}{"a"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x99], $_[0])};
$table->{"sbc"}{"a"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x9A], $_[0])};
$table->{"sbc"}{"a"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x9B], $_[0])};
$table->{"sbc"}{"a"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x9C], $_[0])};
$table->{"sbc"}{"a"}{","}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9C], $_[0])};
$table->{"sbc"}{"a"}{","}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9C], $_[0])};
$table->{"sbc"}{"a"}{","}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9C], $_[0])};
$table->{"sbc"}{"a"}{","}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9D], $_[0])};
$table->{"sbc"}{"a"}{","}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9C], $_[0])};
$table->{"sbc"}{"a"}{","}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9D], $_[0])};
$table->{"sbc"}{"a"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x9D], $_[0])};
$table->{"sbc"}{"a"}{","}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9D], $_[0])};
$table->{"sbc"}{"a"}{","}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9D], $_[0])};
$table->{"sbc"}{"a"}{","}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9C], $_[0])};
$table->{"sbc"}{"a"}{","}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x9D], $_[0])};
$table->{"sbc"}{"a"}{","}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9C], $_[0])};
$table->{"sbc"}{"a"}{","}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x9D], $_[0])};
$table->{"sbc"}{"hl"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x42], $_[0])};
$table->{"sbc"}{"hl"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x52], $_[0])};
$table->{"sbc"}{"hl"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x62], $_[0])};
$table->{"sbc"}{"hl"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0xED, 0x72], $_[0])};
$table->{"scf"}{"END"}{""}	= sub {(["OPCODE", 0x37], $_[0])};
$table->{"set"}{"CEXPR"}{","}{"("}{"hl"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC6], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xCE], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD6], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xDE], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE6], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xEE], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF6], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xFE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC7], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCF], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD7], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDF], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE7], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEF], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF7], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC0], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC8], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD0], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD8], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE0], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE8], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF0], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC1], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC9], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD1], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD9], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE1], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE9], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF1], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC2], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCA], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD2], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDA], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE2], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEA], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF2], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC3], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCB], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD3], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDB], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE3], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEB], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF3], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC4], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCC], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD4], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDC], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE4], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEC], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF4], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC5], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCD], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD5], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDD], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE5], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xED], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF5], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC6], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCE], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD6], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDE], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE6], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEE], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF6], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC7], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCF], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD7], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDF], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE7], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEF], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF7], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC0], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC8], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD0], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD8], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE0], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE8], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF0], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC1], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC9], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD1], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD9], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE1], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE9], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF1], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC2], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCA], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD2], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDA], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE2], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEA], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF2], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC3], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCB], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD3], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDB], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE3], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEB], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF3], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC4], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCC], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD4], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDC], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE4], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEC], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF4], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC5], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCD], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD5], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDD], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE5], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xED], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF5], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC6], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCE], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD6], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDE], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE6], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEE], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF6], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"hl"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC6], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xCE], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD6], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xDE], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE6], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xEE], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF6], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xFE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC7], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCF], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD7], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDF], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE7], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEF], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF7], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC0], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC8], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD0], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD8], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE0], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE8], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF0], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC1], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC9], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD1], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD9], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE1], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE9], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF1], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC2], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCA], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD2], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDA], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE2], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEA], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF2], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC3], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCB], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD3], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDB], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE3], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEB], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF3], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC4], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCC], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD4], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDC], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE4], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEC], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF4], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC5], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCD], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD5], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDD], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE5], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xED], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF5], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xC6], $_[0])}, 
1 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xCE], $_[0])}, 
2 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xD6], $_[0])}, 
3 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xDE], $_[0])}, 
4 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xE6], $_[0])}, 
5 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xEE], $_[0])}, 
6 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xF6], $_[0])}, 
7 => sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[3]], 0xFE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC7], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCF], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD7], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDF], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE7], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEF], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF7], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC0], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC8], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD0], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD8], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE0], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE8], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF0], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC1], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC9], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD1], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD9], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE1], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE9], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF1], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC2], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCA], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD2], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDA], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE2], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEA], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF2], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC3], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCB], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD3], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDB], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE3], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEB], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF3], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC4], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCC], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD4], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDC], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE4], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEC], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF4], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC5], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCD], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD5], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDD], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE5], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xED], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF5], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xC6], $_[0])}, 
1 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xCE], $_[0])}, 
2 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xD6], $_[0])}, 
3 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xDE], $_[0])}, 
4 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xE6], $_[0])}, 
5 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xEE], $_[0])}, 
6 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xF6], $_[0])}, 
7 => sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[3]], 0xFE], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"a"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC7], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xCF], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD7], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xDF], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE7], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xEF], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF7], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xFF], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"b"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC0], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xC8], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD0], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xD8], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE0], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xE8], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF0], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xF8], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"c"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC1], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xC9], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD1], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xD9], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE1], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xE9], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF1], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xF9], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"d"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC2], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xCA], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD2], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xDA], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE2], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xEA], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF2], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xFA], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"e"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC3], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xCB], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD3], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xDB], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE3], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xEB], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF3], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xFB], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"h"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC4], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xCC], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD4], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xDC], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE4], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xEC], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF4], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xFC], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"set"}{"CEXPR"}{","}{"l"}{"END"}{""}	= sub { my $lu = {
0 => sub {(["OPCODE", 0xCB, 0xC5], $_[0])}, 
1 => sub {(["OPCODE", 0xCB, 0xCD], $_[0])}, 
2 => sub {(["OPCODE", 0xCB, 0xD5], $_[0])}, 
3 => sub {(["OPCODE", 0xCB, 0xDD], $_[0])}, 
4 => sub {(["OPCODE", 0xCB, 0xE5], $_[0])}, 
5 => sub {(["OPCODE", 0xCB, 0xED], $_[0])}, 
6 => sub {(["OPCODE", 0xCB, 0xF5], $_[0])}, 
7 => sub {(["OPCODE", 0xCB, 0xFD], $_[0])}, 
}; defined($lu->{$_[2]}) ? $lu->{$_[2]}->(@_) : die("Value $_[2] is not allowed\n");};
$table->{"sla"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x26], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x27], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x20], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x21], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x22], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x23], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x24], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x25], $_[0])};
$table->{"sla"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x26], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x27], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x20], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x21], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x22], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x23], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x24], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x25], $_[0])};
$table->{"sla"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x26], $_[0])};
$table->{"sla"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x26], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x27], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x20], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x21], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x22], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x23], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x24], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x25], $_[0])};
$table->{"sla"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x26], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x27], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x20], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x21], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x22], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x23], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x24], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x25], $_[0])};
$table->{"sla"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x26], $_[0])};
$table->{"sla"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x27], $_[0])};
$table->{"sla"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x20], $_[0])};
$table->{"sla"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x21, 0xCB, 0x10], $_[0])};
$table->{"sla"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x21], $_[0])};
$table->{"sla"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x22], $_[0])};
$table->{"sla"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x23, 0xCB, 0x12], $_[0])};
$table->{"sla"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x23], $_[0])};
$table->{"sla"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x24], $_[0])};
$table->{"sla"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0x29], $_[0])};
$table->{"sla"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x25], $_[0])};
$table->{"sli"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x36], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sli"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sli"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sli"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x36], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sli"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sli"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sli"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x37], $_[0])};
$table->{"sli"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x30], $_[0])};
$table->{"sli"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x31, 0xCB, 0x10], $_[0])};
$table->{"sli"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x31], $_[0])};
$table->{"sli"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x32], $_[0])};
$table->{"sli"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x33, 0xCB, 0x12], $_[0])};
$table->{"sli"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x33], $_[0])};
$table->{"sli"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x34], $_[0])};
$table->{"sli"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x35, 0xCB, 0x14], $_[0])};
$table->{"sli"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x35], $_[0])};
$table->{"sll"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x36], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sll"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sll"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sll"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x36], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sll"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x37], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x30], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x31], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x32], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x33], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x34], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x35], $_[0])};
$table->{"sll"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x36], $_[0])};
$table->{"sll"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x37], $_[0])};
$table->{"sll"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x30], $_[0])};
$table->{"sll"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x31, 0xCB, 0x10], $_[0])};
$table->{"sll"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x31], $_[0])};
$table->{"sll"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x32], $_[0])};
$table->{"sll"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x33, 0xCB, 0x12], $_[0])};
$table->{"sll"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x33], $_[0])};
$table->{"sll"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x34], $_[0])};
$table->{"sll"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x35, 0xCB, 0x14], $_[0])};
$table->{"sll"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x35], $_[0])};
$table->{"sra"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2E], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2F], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x28], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x29], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2A], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2B], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2C], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2D], $_[0])};
$table->{"sra"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2E], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2F], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x28], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x29], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2A], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2B], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2C], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2D], $_[0])};
$table->{"sra"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2E], $_[0])};
$table->{"sra"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2E], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2F], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x28], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x29], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2A], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2B], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2C], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2D], $_[0])};
$table->{"sra"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x2E], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2F], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x28], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x29], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2A], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2B], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2C], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2D], $_[0])};
$table->{"sra"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x2E], $_[0])};
$table->{"sra"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2F], $_[0])};
$table->{"sra"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x28], $_[0])};
$table->{"sra"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x28, 0xCB, 0x19], $_[0])};
$table->{"sra"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x29], $_[0])};
$table->{"sra"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2A], $_[0])};
$table->{"sra"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2A, 0xCB, 0x1B], $_[0])};
$table->{"sra"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2B], $_[0])};
$table->{"sra"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2C], $_[0])};
$table->{"sra"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2C, 0xCB, 0x1D], $_[0])};
$table->{"sra"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x2D], $_[0])};
$table->{"srl"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3E], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3F], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x38], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x39], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3A], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3B], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3C], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3D], $_[0])};
$table->{"srl"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3E], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3F], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x38], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x39], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3A], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3B], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3C], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3D], $_[0])};
$table->{"srl"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3E], $_[0])};
$table->{"srl"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3E], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3F], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x38], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x39], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3A], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3B], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3C], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3D], $_[0])};
$table->{"srl"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xCB, ["sb", $_[2]], 0x3E], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3F], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x38], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x39], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3A], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3B], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3C], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{","}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3D], $_[0])};
$table->{"srl"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xCB, ["sb", $_[2]], 0x3E], $_[0])};
$table->{"srl"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3F], $_[0])};
$table->{"srl"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x38], $_[0])};
$table->{"srl"}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x38, 0xCB, 0x19], $_[0])};
$table->{"srl"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x39], $_[0])};
$table->{"srl"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3A], $_[0])};
$table->{"srl"}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3A, 0xCB, 0x1B], $_[0])};
$table->{"srl"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3B], $_[0])};
$table->{"srl"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3C], $_[0])};
$table->{"srl"}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3C, 0xCB, 0x1D], $_[0])};
$table->{"srl"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xCB, 0x3D], $_[0])};
$table->{"stop"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xDD, 0x00], $_[0])};
$table->{"sub"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0x96], $_[0])};
$table->{"sub"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x96, ["sb", $_[2]]], $_[0])};
$table->{"sub"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x96, ["sb", $_[2]]], $_[0])};
$table->{"sub"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xD6, ["ub", $_[2]]], $_[0])};
$table->{"sub"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0x96], $_[0])};
$table->{"sub"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x96, ["sb", $_[2]]], $_[0])};
$table->{"sub"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x96, ["sb", $_[2]]], $_[0])};
$table->{"sub"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0x97], $_[0])};
$table->{"sub"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0x90], $_[0])};
$table->{"sub"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0x91], $_[0])};
$table->{"sub"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0x92], $_[0])};
$table->{"sub"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0x93], $_[0])};
$table->{"sub"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0x94], $_[0])};
$table->{"sub"}{"hl"}{","}{"bc"}{"END"}{""}	= sub {(["OPCODE", 0xB7, 0xED, 0x42], $_[0])};
$table->{"sub"}{"hl"}{","}{"de"}{"END"}{""}	= sub {(["OPCODE", 0xB7, 0xED, 0x52], $_[0])};
$table->{"sub"}{"hl"}{","}{"hl"}{"END"}{""}	= sub {(["OPCODE", 0xB7, 0xED, 0x62], $_[0])};
$table->{"sub"}{"hl"}{","}{"sp"}{"END"}{""}	= sub {(["OPCODE", 0xB7, 0xED, 0x72], $_[0])};
$table->{"sub"}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x94], $_[0])};
$table->{"sub"}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x94], $_[0])};
$table->{"sub"}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x94], $_[0])};
$table->{"sub"}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x95], $_[0])};
$table->{"sub"}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x94], $_[0])};
$table->{"sub"}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x95], $_[0])};
$table->{"sub"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0x95], $_[0])};
$table->{"sub"}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x95], $_[0])};
$table->{"sub"}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x95], $_[0])};
$table->{"sub"}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x94], $_[0])};
$table->{"sub"}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0x95], $_[0])};
$table->{"sub"}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x94], $_[0])};
$table->{"sub"}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0x95], $_[0])};
$table->{"xor"}{"("}{"hl"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xAE], $_[0])};
$table->{"xor"}{"("}{"ix"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAE, ["sb", $_[2]]], $_[0])};
$table->{"xor"}{"("}{"iy"}{"OPTEXPR"}{")"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAE, ["sb", $_[2]]], $_[0])};
$table->{"xor"}{"EXPR"}{"END"}{""}	= sub {(["OPCODE", 0xEE, ["ub", $_[2]]], $_[0])};
$table->{"xor"}{"["}{"hl"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xAE], $_[0])};
$table->{"xor"}{"["}{"ix"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAE, ["sb", $_[2]]], $_[0])};
$table->{"xor"}{"["}{"iy"}{"OPTEXPR"}{"]"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAE, ["sb", $_[2]]], $_[0])};
$table->{"xor"}{"a"}{"END"}{""}	= sub {(["OPCODE", 0xAF], $_[0])};
$table->{"xor"}{"b"}{"END"}{""}	= sub {(["OPCODE", 0xA8], $_[0])};
$table->{"xor"}{"c"}{"END"}{""}	= sub {(["OPCODE", 0xA9], $_[0])};
$table->{"xor"}{"d"}{"END"}{""}	= sub {(["OPCODE", 0xAA], $_[0])};
$table->{"xor"}{"e"}{"END"}{""}	= sub {(["OPCODE", 0xAB], $_[0])};
$table->{"xor"}{"h"}{"END"}{""}	= sub {(["OPCODE", 0xAC], $_[0])};
$table->{"xor"}{"hx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAC], $_[0])};
$table->{"xor"}{"hy"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAC], $_[0])};
$table->{"xor"}{"ixh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAC], $_[0])};
$table->{"xor"}{"ixl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAD], $_[0])};
$table->{"xor"}{"iyh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAC], $_[0])};
$table->{"xor"}{"iyl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAD], $_[0])};
$table->{"xor"}{"l"}{"END"}{""}	= sub {(["OPCODE", 0xAD], $_[0])};
$table->{"xor"}{"lx"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAD], $_[0])};
$table->{"xor"}{"ly"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAD], $_[0])};
$table->{"xor"}{"xh"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAC], $_[0])};
$table->{"xor"}{"xl"}{"END"}{""}	= sub {(["OPCODE", 0xDD, 0xAD], $_[0])};
$table->{"xor"}{"yh"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAC], $_[0])};
$table->{"xor"}{"yl"}{"END"}{""}	= sub {(["OPCODE", 0xFD, 0xAD], $_[0])};
$table;
}
1;
