/* string_funcs.h
 *  Copyright (C) 2001-2003, The Perl Foundation.
 *  SVN Info
 *     $Id: string_primitives.h 25665 2008-02-12 12:38:33Z fperrad $
 *  Overview:
 *     This is the api header for the string subsystem
 *  Data Structure and Algorithms:
 *  History:
 *  Notes:
 *  References:
 */

#ifndef PARROT_STRING_PRIMITIVES_H_GUARD
#define PARROT_STRING_PRIMITIVES_H_GUARD

#ifdef PARROT_IN_CORE

/* HEADERIZER BEGIN: src/string_primitives.c */

PARROT_API
PARROT_CONST_FUNCTION
UINTVAL Parrot_char_digit_value(SHIM_INTERP, UINTVAL character);

PARROT_API
PARROT_MALLOC
PARROT_CANNOT_RETURN_NULL
char * str_dup(ARGIN(const char *old))
        __attribute__nonnull__(1);

PARROT_API
void string_set_data_directory(PARROT_INTERP, ARGIN(const char *dir))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2);

PARROT_API
Parrot_UInt4 string_unescape_one(PARROT_INTERP,
    ARGMOD(UINTVAL *offset),
    ARGMOD(STRING *string))
        __attribute__nonnull__(1)
        __attribute__nonnull__(2)
        __attribute__nonnull__(3)
        FUNC_MODIFIES(*offset)
        FUNC_MODIFIES(*string);

/* HEADERIZER END: src/string_primitives.c */

#endif /* PARROT_IN_CORE */
#endif /* PARROT_STRING_PRIMITIVES_H_GUARD */

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
