use strict; use warnings;
BEGIN {
  use FFI::CheckLib qw( check_lib_or_exit );
  check_lib_or_exit(
    lib => 'uuid',
    symbol => [ map { "uuid_$_" } qw(
      generate_random
      generate_time
      unparse
      copy
      clear
      type
      variant
      is_null
      compare
    ) ],
  );
  unless(eval q{ use 5.006; 1}) {
    print "Perl 5.006 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.22.
use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Universally Unique Identifiers FFI style",
  "AUTHOR" => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "FFI::CheckLib" => "0.05"
  },
  "DISTNAME" => "UUID-FFI",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.006",
  "NAME" => "UUID::FFI",
  "PM" => {
    "lib/UUID/FFI.pm" => "\$(INST_LIB)/UUID/FFI.pm"
  },
  "PREREQ_PM" => {
    "FFI::CheckLib" => "0.06",
    "FFI::Platypus" => "0.12"
  },
  "TEST_REQUIRES" => {
    "Test2::V0" => "0.000060"
  },
  "VERSION" => "0.06",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "FFI::CheckLib" => "0.06",
  "FFI::Platypus" => "0.12",
  "Test2::V0" => "0.000060"
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
