package FFI::Platypus::Lang::ASM;

use strict;
use warnings;

# ABSTRACT: Documentation and tools for using Platypus with the Assembly
our $VERSION = '0.19'; # VERSION


sub native_type_map
{
  {}
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

FFI::Platypus::Lang::ASM - Documentation and tools for using Platypus with the Assembly

=head1 VERSION

version 0.19

=head1 SYNOPSIS

 use FFI::Platypus;
 my $ffi = FFI::Platypus->new;
 $ffi->lang('ASM');

=head1 DESCRIPTION

Setting your lang to C<ASM> removes all non ffi types.  

This document will one day include information on bundling Assembly
with your Perl / FFI / Platypus distribution.  Pull requests welcome!

=head1 METHODS

=head2 native_type_map

 my $hashref = FFI::Platypus::Lang::C->native_type_map;

This returns a hash reference containing the native aliases for the
C programming languages.  That is the keys are native C types and the
values are libffi native types.

=head1 SEE ALSO

=over 4

=item L<FFI::Platypus>

The Core Platypus documentation.

=back

=cut

=head1 AUTHOR

Author: Graham Ollis E<lt>plicease@cpan.orgE<gt>

Contributors:

Bakkiaraj Murugesan (bakkiaraj)

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
