package Alien::Install::Example::Libfoo::Installer;

use strict;
use warnings;
use Role::Tiny::With;
use Alien::Install::Util;

# ABSTRACT: Example installer for libfoo
our $VERSION = '0.08_05'; # VERSION

config
  name             => 'foo',
  versions_url     => 'http://dist.wdlabs.com/',
  versions_process => qr{libfoo-([0-9]+\.[0-9]{2})\.tar\.gz},
  fetch_url        => sub {
    my(undef, $version) = @_;
    "http://dist.wdlabs.com/libfoo-$version.tar.gz";
  },
  test_compile_run_program => join("\n",
    "#include <foo.h>",
    "#include <stdio.h>",
    "int",
    "main(int argc, char *argv[])",
    "{",
    "  printf(\"version = '%s'\\n\", foo_version_string());",
    "  return 0;",
    "}",
  ),
  test_ffi_signature => ['foo_version_string', 'str'],
  test_ffi_version   => sub {
    my(undef, $function) = @_;
    $function->();
  },
;

with qw(
  Alien::Install::Role::Installer
  Alien::Install::Role::HTTP
  Alien::Install::Role::Tar 
  Alien::Install::Role::Autoconf
  Alien::Install::Role::TestCompileRun
  Alien::Install::Role::TestFFI
);

sub system_install
{
  die 'todo';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Alien::Install::Example::Libfoo::Installer - Example installer for libfoo

=head1 VERSION

version 0.08_05

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
