package Tree::Object;

our $DATE = '2016-03-24'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

use Role::Tiny::With;

with 'Role::TinyCommons::Tree::NodeMethods';

sub new {
    my $class = shift;
    my %attrs = @_;
    $attrs{parent} //= undef;
    $attrs{children} //= [];
    bless \%attrs, $class;
}

sub parent {
    my $self = shift;
    if (@_) {
        $self->{parent} = $_[0];
    }
    $self->{parent};
}

sub children {
    my $self = shift;

    if (@_) {
        if (@_ == 1 && ref($_[0]) eq 'ARRAY') {
            $self->{children} = $_[0];
        } else {
            $self->{children} = \@_;
        }
    }
    return @{ $self->{children} };
}

1;
# ABSTRACT: A tree object

__END__

=pod

=encoding UTF-8

=head1 NAME

Tree::Object - A tree object

=head1 VERSION

This document describes version 0.02 of Tree::Object (from Perl distribution Tree-Object), released on 2016-03-24.

=head1 SYNOPSIS

 use Tree::Object;

 my $tree = Tree::Object->new(foo => 1, bar => 2, ...);

 my $child1 = Tree::Object->new( ... );
 my $child2 = Tree::Object->new( ... );

 # connect children to parent
 $child1->parent($tree);
 $child2->parent($tree);

 # connect parent to children
 $tree->children($child1, $child2);

=head1 DESCRIPTION

This is a pretty generic tree object you can use directly or as a base class.

It gets its methods from L<Role::TinyCommons::Tree::Node> and
L<Role::TinyCommons::Tree::NodeMethods> roles.

=head1 METHODS

See L<Role::TinyCommons::Tree::Node>, L<Role::TinyCommons::Tree::NodeMethods>
for the complete list of methods.

=head2 CLASS->new(%attrs) => obj

Constructor.

=head2 $obj->parent( [ $obj ] ) => obj

Get or set parent.

=head2 $obj->children( [ $child, ... ] ) => list

Get or set children.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Tree-Object>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Tree-Object>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Tree-Object>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Role::TinyCommons::Tree::Node>

L<Role::TinyCommons::Tree::NodeMethods>

Some other generic tree modules on CPAN: L<Data::Tree>, L<Tree::Simple>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
