/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.OrderRelation;
import java.math.BigDecimal;
import org.relaxng.datatype.ValidationContext;

class DecimalDatatype
extends DatatypeBase
implements OrderRelation {
    DecimalDatatype() {
    }

    boolean lexicallyAllows(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        switch (string.charAt(n2)) {
            case '+': 
            case '-': {
                if (++n2 != n) break;
                return false;
            }
        }
        boolean bl = false;
        if (string.charAt(n2) == '.') {
            bl = true;
            if (++n2 == n) {
                return false;
            }
        }
        do {
            switch (string.charAt(n2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (++n2 < n);
        return true;
    }

    String getLexicalSpaceKey() {
        return "decimal";
    }

    Object getValue(String string, ValidationContext validationContext) {
        if (string.charAt(0) == '+') {
            string = string.substring(1);
        }
        return new BigDecimal(string);
    }

    OrderRelation getOrderRelation() {
        return this;
    }

    public boolean isLessThan(Object object, Object object2) {
        return ((BigDecimal)object).compareTo((BigDecimal)object2) < 0;
    }

    public boolean sameValue(Object object, Object object2) {
        return ((BigDecimal)object).compareTo((BigDecimal)object2) == 0;
    }

    public int valueHashCode(Object object) {
        return ((BigDecimal)object).toBigInteger().hashCode();
    }
}

