use 5.008001;
use strict;
use warnings;

package BSON::MaxKey;
# ABSTRACT: MaxKey data for BSON

our $VERSION = '0.13'; # TRIAL

sub new {
    bless {}, $_[0];
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

BSON::MaxKey - MaxKey data for BSON

=head1 VERSION

version 0.13

=head1 SYNOPSIS

    use BSON;

    my $key = BSON::MaxKey->new;

=head1 DESCRIPTION

This module is needed for L<BSON> and it manages BSON's MaxKey element.

=head1 METHODS

=head2 new

Object constructor, takes no parameters.

=head1 SEE ALSO

L<BSON>

=head1 AUTHORS

=over 4

=item *

minimalist <minimalist@lavabit.com>

=item *

David Golden <david@mongodb.com>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by minimalist and MongoDB, Inc..

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
