use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::MockTime;
use Test::More;
use Time::Piece;

# This ensures that the work buffer entry for the self identity isn't
# in the middle of one of the time periods in the tests below.
# Otherwise failures occur if the tests are run between the hours of
# 1:00 and 2:00, 2:00 and 3:00, etc.
my $now = localtime;
Test::MockTime::set_absolute_time( $now->ymd . 'T12:00:01' );

run_in_tempdir {

    isa_ok exception { bif(qw/work/) }, 'Bif::Error::UserRepoNotFound';
    bif(qw/init/);

    isa_ok bif(qw/work/), 'Bif::OK::NoWork';
    isa_ok exception { bif(qw/work 999/) }, 'Bif::Error::TopicNotFound';
    isa_ok bif(qw/work 1 --at 01:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work/),              'Bif::OK::Working';
    isa_ok exception { bif(qw/work 1/) }, 'Bif::Error::WorkOther';
    isa_ok bif(qw/work 1 --force --at 01:30/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - --at 01:59/),         'Bif::OK::StopWork';
    isa_ok bif(qw/work/),                      'Bif::OK::NoWork';

    isa_ok bif(qw/work 1 start_comment --at 02:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - stop_comment --at 02:59/),  'Bif::OK::StopWork';

    isa_ok bif(qw/work 1 --at 03:00:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - --at 04:00:00/), 'Bif::OK::StopWork';

    ok exception {
        bif(qw/work 1 --at 03:30:00/);
    }, 'Cannot overlap start of work';

    # Using "yesterday"
    isa_ok bif( qw/work 1 --at /, 'yesterday 04:00' ),    'Bif::OK::StartWork';
    isa_ok bif( qw/work - --at /, 'yesterday 04:00:01' ), 'Bif::OK::StopWork';

    # Make sure new-project wbuffer doesn't conflict with init wbuffer
    Test::MockTime::set_absolute_time( $now->ymd . 'T12:00:10' );
    my $p1 = bif(qw/ new project todo --message m1 title /);
    isa_ok bif(qw/work todo --at 05:00/), 'Bif::OK::StartWork';
    isa_ok bif(qw/work - --at 05:01/),    'Bif::OK::StopWork';

    bif(qw/work 1 --at 04:30:00/);
    ok exception {
        bif(qw/work 1 - --at 05:00:30/);
    }, 'Cannot overlap end of work';

};

done_testing();
