CREATE TABLE func_import_new_work(
    node_uuid VARCHAR(40) NOT NULL,
    offset INTEGER NOT NULL,
    start INTEGER NOT NULL,
    stop INTEGER NOT NULL,
    comment TEXT,
    bill BOOL NOT NULL
);


CREATE TRIGGER
    func_import_new_work_bi_1
BEFORE INSERT ON
    func_import_new_work
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.node_uuid,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.comment,
        NEW.bill
    );

    INSERT INTO
        func_new_work(
            change_id,
            node_id,
            offset,
            start,
            stop,
            comment,
            bill
        )
    SELECT
        currval('changes'),
        n.id,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.comment,
        NEW.bill
    FROM
        nodes n
    WHERE
        n.uuid = NEW.node_uuid
    ;

    SELECT RAISE(IGNORE);
END;
