package App::bif::pull::identity;
use strict;
use warnings;
use AnyEvent;
use Bif::Sync::Client;
use Bif::Mo;
use Coro;
use DBIx::ThinSQL qw/qv/;
use Log::Any '$log';

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $cv   = AE::cv;
    my $dbw  = $self->dbw;

    $opts->{message} ||= "Importing identity from $opts->{location}";

    $|++;

    my $error;
    my $client = Bif::Sync::Client->new(
        name          => $opts->{location},
        db            => $dbw,
        location      => $opts->{location},
        debug         => $opts->{debug},
        debug_bifsync => $opts->{debug_bifsync},
        on_update     => sub {
            my $client = shift;
            $self->lprint( $client->name . ': ' . $_[0] );
        },
        on_error => sub {
            $error = shift;
            $cv->send;
        },
    );

    my $fh   = select;
    my $coro = async {
        select $fh;

        eval {
            $dbw->txn(
                sub {
                    $|++;
                    my $status = $client->bootstrap_identity;

                    unless ( $status eq 'IdentityImported' ) {
                        $dbw->rollback;
                        $error =
"unexpected IdentityImported status received: $status";
                        return;
                    }

                    my ( $iid, $uuid, $name, $sn ) = $dbw->xlist(
                        select => [
                            'bifkv.identity_id',
                            '"u" || substr(n.uuid,1,8) AS uuid',
                            'e.name', 'i.shortname',
                        ],
                        from       => 'bifkv',
                        inner_join => 'nodes n',
                        on         => 'n.id = bifkv.identity_id',
                        inner_join => 'identities i',
                        on         => 'i.id = n.id',
                        inner_join => 'entities e',
                        on         => 'e.id = i.id',
                        where      => { key => 'self' },
                    );

                    print "\n";
                }
            );
        };

        if ($@) {
            $error = $@;
            print "\n";
        }

        return $cv->send;
    };

    $cv->recv;
    $client->disconnect;
    return $self->err( 'Unknown', $error ) if $error;
    return $self->ok('PullIdentity');
}

1;
__END__

=head1 NAME

=for bif-doc #sync

bif-pull-identity - import an identity from a repository

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif pull identity LOCATION [OPTIONS...]

=head1 DESCRIPTION

The B<bif-pull-identity> command imports an identity from a repository.

=head1 ARGUMENTS & OPTIONS

=over

=item LOCATION

The location of the identity repository.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

