CREATE TABLE func_import_update_issue(
    uuid VARCHAR(40),
    issue_status_uuid VARCHAR(40),
    title VARCHAR(1024)
);


CREATE TRIGGER
    func_import_update_issue_bi_1
BEFORE INSERT ON
    func_import_update_issue
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.issue_status_uuid,
        NEW.title
    );

    INSERT INTO
        func_update_issue(
            change_id,
            id,
            issue_status_id,
            title
        )
    SELECT
        currval('changes'),
        i.id,
        s.id,
        NEW.title
    FROM
        nodes i
    LEFT JOIN
        nodes s
    ON
        s.uuid = NEW.issue_status_uuid
    WHERE
        i.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
