package App::bif::log::identity;
use strict;
use warnings;
use locale;
use Bif::Mo;

our $VERSION = '0.1.5_5';
extends 'App::bif::log';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;
    my $info = $self->get_node( $opts->{id}, 'identity' );
    my $now  = $self->now;

    DBIx::ThinSQL->import(qw/concat case func qv/);

    my $sth = $db->xprepare(
        select => [
            'id.id AS id',
            concat( qv('.'),  'c.id' )->as('change_id'),
            concat( qv('.u'), 'c.uuid' )->as('change_uuid'),
            'c.mtime AS mtime',
            'c.mtimetz AS mtimetz',
            'c.mtimetzhm AS mtimetzhm',
            "$now - c.mtime AS mtime_age",
            'c.action AS action',
            'COALESCE(c.author,i.name) AS author',
            "COALESCE(c.author_contact_method || ': ' || c.author_contact,"
              . "ecm.method || ': ' || ecm.mvalue) AS contact",
            'c.message AS message',
            'c.ucount AS ucount',
            qv(undef)->as('name'),
            qv(undef)->as('method'),
            qv(undef)->as('mvalue'),
            'c.path AS path',
            'ct.depth AS depth',
            'd.action AS delta',
            case (
                when => 'd.action = "new_identity"',
                then => func(
                    'printf', ',',
                    qv(
                        "new_identity:\n" . "  name: %s\n" . "  shortname: %s"
                    ),
                    'ed.name',
                    'id.shortname'
                ),
                when => 'd.action = "new_identity_contact_method"',
                then => func(
                    'printf', ',',
                    qv(
                            "new_identity_contact_method:\n"
                          . "  method: %s\n"
                          . "  mvalue: %s"
                    ),
                    'ecmd.method',
                    'ecmd.mvalue'
                ),
                when => 'd.action = "update_identity"',
                then => func(
                    'printf', ',',
                    qv(
                            "update_identity:\n"
                          . "  default_contact_method: %s\n"
                          . "  name: %s\n"
                          . "  shortname: %s"
                    ),
                    'ecm2.mvalue',
                    'ed.name',
                    'id.shortname'
                ),
                else => qv('*unknown*'),
            )->as('delta_value'),
        ],
        from       => 'nodes n',
        inner_join => 'changes_tree ct',
        on         => 'ct.parent = n.first_change_id',
        inner_join => 'changes c',
        on         => 'c.id = ct.child',
        inner_join => 'entities i',
        on         => 'i.id = c.identity_id',
        inner_join => 'entity_contact_methods ecm',
        on         => 'ecm.id = i.default_contact_method_id',
        left_join  => 'deltas d',
        on         => 'd.change_id = c.id',
        left_join  => 'entity_deltas ed',
        on         => 'ed.id = d.id',
        left_join  => 'identity_deltas id',
        on         => 'id.id = d.id',
        left_join  => 'entity_contact_method_deltas ecmd',
        on         => 'ecmd.id = d.id',
        left_join  => 'entity_contact_methods ecm2',
        on         => 'ecm2.id = ed.default_contact_method_id',
        where      => { 'n.id' => $info->{id} },
        order_by   => 'c.path,d.id',
    );

    $sth->execute;

    $self->start_pager;

    $self->log_start;
    $self->log_next($_) for $sth->hashrefs;
    $self->log_next;    # finalize output

    return $self->ok('LogIdentity');
}

1;
__END__

=head1 NAME

=for bif-doc #history

bif-log-identity - review the history of a identity

=head1 VERSION

0.1.5_5 (2015-08-13)

=head1 SYNOPSIS

    bif log identity ID [OPTIONS...]

=head1 DESCRIPTION

The B<bif-log-identity> command displays the history of an identity.

=head1 ARGUMENTS & OPTIONS

=over

=item ID

The ID of a identity. Required.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2014-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

