CREATE TABLE hub_entities(
    hub_id INTEGER NOT NULL,
    entity_id INTEGER NOT NULL,
    PRIMARY KEY(hub_id,entity_id) ON CONFLICT IGNORE,
    FOREIGN KEY(hub_id) REFERENCES hubs(id) ON DELETE CASCADE,
    FOREIGN KEY(entity_id) REFERENCES entities(id) ON DELETE CASCADE
) WITHOUT ROWID;


CREATE TRIGGER
    hub_entities_ai_1
AFTER INSERT ON
    hub_entities
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.hub_id,
        NEW.entity_id
    );


    INSERT INTO -- OR IGNORE INTO
        hub_changes(
            hub_id,
            prefix,
            change_id
        )
    SELECT DISTINCT
        NEW.hub_id,
        SUBSTR(c.uuid, 1, 1),
        c.id
    FROM
        topics_tree tt
    INNER JOIN
        topics t
    ON
        t.id = tt.child
    INNER JOIN
        changes_tree ct
    ON
        ct.parent = t.first_change_id
    INNER JOIN
        changes c
    ON
        c.id = ct.child
    WHERE
        tt.parent = NEW.entity_id
    ;

END;


CREATE TRIGGER
    hub_entities_ad_1
AFTER DELETE ON
    hub_entities
FOR EACH ROW
BEGIN

    SELECT debug(
        OLD.hub_id,
        OLD.entity_id
    );


    DELETE FROM
        hub_changes
    WHERE
        hub_id = OLD.hub_id AND change_id IN (
            SELECT DISTINCT
                ct.child
            FROM
                topics_tree tt
            INNER JOIN
                topics t
            ON
                t.id = tt.child
            INNER JOIN
                changes_tree ct
            ON
                ct.parent = t.first_change_id
            WHERE
                tt.parent = OLD.entity_id
        )
    ;

END;
