CREATE TABLE hub_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    hub_id INTEGER NOT NULL,
    new INTEGER,
    location VARCHAR,
    FOREIGN KEY(id) REFERENCES deltas(id) ON DELETE CASCADE,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(hub_id) REFERENCES hubs(id) ON DELETE CASCADE
);

CREATE TRIGGER
    hub_deltas_ai_1
AFTER INSERT ON
    hub_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.hub_id,
        NEW.new,
        NEW.location
    );

    UPDATE
        changes
    SET
        ucount = ucount + 1
    WHERE
        id = NEW.change_id
    ;


    INSERT OR IGNORE INTO
        hubs_tomerge(hub_id)
    VALUES
        (NEW.hub_id)
    ;

    UPDATE
        hubs_tomerge
    SET
        location = location + (NEW.location IS NOT NULL)
    WHERE
        hub_id = NEW.hub_id
    ;



    UPDATE
        change_topics
    SET
        hub_change = hub_change + 1
    WHERE
        change_id = NEW.change_id AND topic_id = NEW.hub_id
    ;

END;


CREATE TRIGGER
    hub_deltas_ad_1
AFTER DELETE ON
    hub_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        OLD.change_id,
        OLD.hub_id,
        OLD.location
    );

    INSERT OR IGNORE INTO
        hubs_tomerge(hub_id)
    VALUES
        (OLD.hub_id)
    ;

    UPDATE
        hubs_tomerge
    SET
        location = location + (OLD.location IS NOT NULL)
    WHERE
        hub_id = OLD.hub_id
    ;

END;

