CREATE TABLE func_update_hub(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    name VARCHAR,
    title VARCHAR
);

CREATE TRIGGER
    func_update_hub_bi_1
BEFORE INSERT ON
    func_update_hub
FOR EACH ROW BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.name,
        NEW.title
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: update_hub' || x'0A'
                || '  name: ' || COALESCE(NEW.name,'~') || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
                || '  uuid: ' || h.uuid || x'0A'
            FROM
                topics h
            WHERE
                h.id = NEW.id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'update_hub'
    );

    INSERT INTO
        topic_deltas(
            id,
            change_id,
            topic_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.name
    );

    INSERT INTO
        project_deltas(
            id,
            change_id,
            project_id,
            title
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.title
    );

    SELECT RAISE(IGNORE);

END;
