CREATE TABLE func_new_project(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    parent_id INTEGER,
    name VARCHAR(40),
    title VARCHAR(1024) NOT NULL DEFAULT '',
    uuid VARCHAR(40),
    local INTEGER DEFAULT 0
);

CREATE TRIGGER
    func_new_project_bi_1
BEFORE INSERT ON
    func_new_project
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.parent_id,
        NEW.name,
        NEW.title,
        NEW.local,
        NEW.uuid
    );


    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_project' || x'0A'
                || CASE WHEN
                    instr(NEW.name, ' ')
                THEN
                    '  name: ''' || NEW.name || '''' || x'0A'
                ELSE
                    '  name: ' || NEW.name || x'0A'
                END
                || '  parent_uuid: ' || COALESCE(p.uuid, '~') || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
            FROM
                (SELECT 1)
            LEFT JOIN
                topics p
            ON
                p.id = NEW.parent_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO func_new_topic(
        id,
        parent_id,
        change_id,
        name,
        kind,
        uuid
    )
    VALUES(
        NEW.id,
        NULL, -- To maintain uniqueness until the merge
        NEW.change_id,
        'project-' || NEW.id, -- To maintain uniqueness until the merge
        'project',
        NEW.uuid
    );

    INSERT INTO
        projects(
            id,
            parent_id,
            title,
            local
        )
    VALUES(
        NEW.id,
        NEW.parent_id,
        NEW.title,
        NEW.local
    );


    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_project'
    );

    INSERT INTO
        topic_deltas(
            id,
            change_id,
            topic_id,
            parent_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.parent_id,
        NEW.name
    );

    INSERT INTO
        project_deltas(
            id,
            change_id,
            project_id,
            new,
            title
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        1,
        NEW.title
    );

    SELECT RAISE(IGNORE);
END;
