CREATE TABLE func_new_project_status(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL DEFAULT (nextval('topics')),
    project_id INTEGER,
    status VARCHAR(40) NOT NULL,
    rank INTEGER NOT NULL,
    uuid VARCHAR(40)
);

CREATE TRIGGER
    func_new_project_status_bi_1
BEFORE INSERT ON
    func_new_project_status
FOR EACH ROW BEGIN

    SELECT debug(
        NEW.id,
        NEW.project_id,
        NEW.status,
        NEW.rank,
        NEW.uuid
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_project_status' || x'0A'
                || '  project_uuid: ' || p.uuid || x'0A'
                || '  rank: ' || NEW.rank || x'0A'
                || '  status: ' || NEW.status || x'0A'
            FROM
                topics p
            WHERE
                p.id = NEW.project_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO func_new_topic(
        id,
        parent_id,
        change_id,
        name,
        kind,
        uuid
    )
    VALUES(
        NEW.id,
        NEW.project_id,
        NEW.change_id,
        NEW.id,
        'project_status',
        NEW.uuid
    );


    INSERT INTO
        project_status(
            id,
            project_id,
            status,
            rank
        )
    VALUES(
        NEW.id,
        NEW.project_id,
        NEW.status,
        NEW.rank
    );

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_project_status'
    );

    INSERT INTO
        topic_deltas(
            id,
            change_id,
            topic_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.id
    );

    INSERT INTO
        project_status_deltas(
            id,
            change_id,
            project_status_id,
            new,
            status,
            rank
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        1,
        NEW.status,
        NEW.rank
    );

    SELECT RAISE(IGNORE);
END;
