CREATE TABLE func_import_hub(
    uuid VARCHAR NOT NULL
);

CREATE TRIGGER
    func_import_hub_bi_1
BEFORE INSERT ON
    func_import_hub
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid
    );

    INSERT INTO
        func_new_hub(
            change_id,
            id
        )
    SELECT
        currval('changes'),
        h.id
    FROM
        topics h
    WHERE
        h.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
