CREATE TABLE hubs (
    id INTEGER NOT NULL PRIMARY KEY,
    default_repo_id INTEGER,
    hash VARCHAR,
    num_changes INTEGER,
    FOREIGN KEY (id) REFERENCES projects(id) ON DELETE CASCADE,
    FOREIGN KEY (id,default_repo_id) REFERENCES hub_repos(hub_id,id)
);


CREATE TRIGGER
    hubs_ad_1
AFTER DELETE ON
    hubs
FOR EACH ROW
BEGIN
    SELECT debug( 
        OLD.id
    );

    DELETE FROM
        projects
    WHERE
        id = OLD.id
    ;

    /*
        The following is necessary, because although FK relationships
        do result in the remove of rows from hubs_tomerge, the deletion
        of rows from hub_deltas just inserts more rows.
    */

    DELETE FROM
        hubs_tomerge
    WHERE
        hub_id = OLD.id
    ;

END;

