CREATE TABLE func_import_task_delta(
    uuid VARCHAR(40),
    task_status_uuid VARCHAR(40),
    title VARCHAR(1024)
);


CREATE TRIGGER
    func_import_task_delta_bi_1
BEFORE INSERT ON
    func_import_task_delta
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.task_status_uuid,
        NEW.title
    );

    INSERT INTO
        func_update_task(
            change_id,
            id,
            task_status_id,
            title
        )
    SELECT
        currval('changes'),
        t.id,
        s.id,
        NEW.title
    FROM
        topics t
    LEFT JOIN
        topics s
    ON
        s.uuid = NEW.task_status_uuid
    WHERE
        t.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
