use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $check0 = 0;
my $check1 = 0;
my $now = time;
my $then = (stat('./Makefile.old'))[9];
# set number of seconds to view
my $view = $then +86400 < $now ? 5:0;

unless (grep { m/-noxs/ } @ARGV) {
  print q{
This build requires a C compiler by default except on Windows
where the Pure Perl version is mandatory. The Pure Perl
version does not require compilation of XS code can be used 
by invoking this as:

  perl Makefile.PL -noxs

};
  sleep $view if $view;
}

unless (grep { m/with-threads/ } @ARGV) {
  print q{
This version of NetAddr::IP incorporates ALPHA support for THREADS 
on the underlying platform (not perl threads).  If  perl was built 
with <pthreads.h> or <threads.h> then this module can be linked to 
those libraries if desired. Documentation about perl suggests this 
might be a good idea maybe??? The additional thread code is designed 
to make the XS library thread safe via serialization with mutex locks.
However, there is no assurance that the present NetAddr::IP threads 
code works as expected or improves anything at all. I confess I 
don't know that much about threads.

Use at your own risk as follows:

  perl Makefile.PL --with-threads

};
  sleep $view if $view;
}

eval q{ use Test::Pod;
	$check0 = 1; };

unless ($check0)
{
    print <<EOF;

Looks like this host does not have Test::Pod installed. Without this module,
the Pod documentation cannot be tested. This is not a big deal really, but
you might want to install Test::Pod by issuing the following command:

    perl -MCPAN -e "install('Test::Pod')"

at a nearby shell. This is nice because it allows easy tests of your own
documentation.

EOF
    ;
}

eval q{ use Pod::Coverage;
	$check1 = 1; };

unless ($check1)
{
    print <<EOF;

You might want to install Pod::Coverage, so that coverage of the
documentation can be properly tested. You can do so by typing the
following:

    perl -MCPAN -e "install('Pod::Coverage')"

EOF
    ;
}

sleep $view if $view && ($check0 || $check1);

print <<EOF;

======================================================================
W A R N I N G - Please do read below if you have legacy code
======================================================================

Versions 3.21 and above of NetAddr::IP, include hooks for the Storable
class that are incompatible with the old (automatic) method of storing
data. To regain backwards compatibility, the module must be use()d as

    use NetAddr::IP ':old_storable';

Which will disable the new hooks and revert back to the old ways.

If you do  not use Storable along NetAddr::IP or  just don't know what
this all means, most likely you're safe to go along.

Versions before 3.25 recognized by default IP addresses as returned by
inet_aton. This is no longer the default. To enable this behaviour
again, the module must be use()d as

    use NetAddr::IP ':aton';

Versions before 4.08 recognized the above syntax. This behavior is
fundamentally broken, is DEPRECATED and WILL BE REMOVED in version 5.0
Use this method to create new objects from 'aton's

    \$ip = new_from_aton NetAddr::IP(inet_aton('1.2.3.4'))

EOF
    ;
sleep $view if $view;

my %makeparms = (
#	      (MM->can('signature_target') ? (SIGN => 1) : ()),    
	      'NAME'		=> 'NetAddr::IP',
	      'VERSION_FROM'	=> 'IP.pm', # finds $VERSION
	      'PREREQ_PM'		=> {
		  Test::More => 0,
		}, # e.g., Module::Name => 1.1
	      ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
	       (ABSTRACT_FROM	=> 'IP.pm',
		AUTHOR     	=> 'Luis E. Muñoz <luismunoz@cpan.org>') : ()),
		clean		=> { FILES    => "*~ tmp*"},
);

WriteMakefile(%makeparms);
