package PONAPI::CLI::Command::demo;

use PONAPI::CLI -command;

use strict;
use warnings;

use File::Temp qw( tempfile tempdir );
use Plack::Runner;

sub abstract    { "Run a DEMO PONAPI::Server" }
sub description { "This tool will run a demo server with a mock DB" }

sub opt_spec {
    return (
        [ "port=i", "specify a port for the server (default=5000)" ],
    );
}

sub validate_args {
    my ( $self, $opt, $args ) = @_;
}

sub execute {
    my ( $self, $opt, $args ) = @_;

    my $dir     = tempdir( CLEANUP => 1 );
    my $fh_conf = tempfile( DIR => $dir );
    print $fh_conf <<"DEFAULT_CONF";
server:
  spec_version: "1.0"
  sort_allowed: "false"
  send_version_header: "true"
  send_document_self_link: "true"
  links_type: "relative"
  respond_to_updates_with_200: "false"

repository:
  class:  "Test::PONAPI::Repository::MockDB"
  args:   []
DEFAULT_CONF

    my ( $fh_psgi, $psgi ) = tempfile( DIR => $dir );
    print $fh_psgi <<"DEFAULT_PSGI";
use strict;
use warnings;
use Plack::Middleware::MethodOverride;
use PONAPI::Server;

Plack::Middleware::MethodOverride->wrap(
    PONAPI::Server->new(
       'repository.class' => 'Test::PONAPI::Repository::MockDB'
    )->to_app()
);
DEFAULT_PSGI

    my @options = ();
    $opt->{port} and push @options => ( '-port', $opt->{port} );

    my $runner = Plack::Runner->new;
    $runner->parse_options(@options)
    $runner->run($psgi);
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

PONAPI::CLI::Command::demo

=head1 VERSION

version 0.002008

=head1 AUTHORS

=over 4

=item *

Mickey Nasriachi <mickey@cpan.org>

=item *

Stevan Little <stevan@cpan.org>

=item *

Brian Fraser <hugmeir@cpan.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Mickey Nasriachi, Stevan Little, Brian Fraser.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
