#!/bin/bash

tooldir=`dirname "$0"`
if [[ "$HOSTNAME" == 'stain' ]]; then
  PDT20_DATA=/home/pajas/projects/pdt
  VALLEX_DATA=/home/pajas/projects/pdt/vallex_pml
else
  PDT20_DATA=/net/projects/pdt/pdt20/data
  VALLEX_DATA=/net/work/people/pajas/vallex
fi

if [ ! -d "$PDT20_DATA/" ] || [ ! -d "$VALLEX_DATA/" ]; then
    (    echo "One of the following directories was not found, aborting!"
	echo "PDT20_DATA=$PDT20_DATA"
	echo "VALLEX_DATA=$VALLEX_DATA"
    ) >&2
    exit 1
fi

resource_dir="$tooldir/resources/pdt2base:$PDT20_DATA/schemas:$tooldir/../resources:"
tdata_fl="$PDT20_DATA"/filelists/1-t-all-train-pml.fl
adata_fl="$PDT20_DATA"/filelists/2-a-all-train-pml.fl
pdt_data_dir="$PDT20_DATA"

vallex_pml="$VALLEX_DATA"/vallex_*.pml
start=''

    
# if [[ "$HOSTNAME" == 'lrc.ufal.hide.ms.mff.cuni.cz' ]] ; then
qcmd=/home/pajas/bin/qcmd
if [ -n "$SGE_CLUSTER_NAME" ] && [ -f "$qcmd" ]; then
  start="$qcmd -v PML_COMPILE=1 --"
else
  start='env PML_COMPILE=1'
fi

if [[ "$1" != -* ]]; then
  which="$1"
  shift
fi
if [ -z "$which" ]; then
    which='vat'
fi

if [[ "$which" = *a* ]]; then
$start btred -qI "$tooldir/pml2base.btred" \
   --resource-dir "$resource_dir": \
 -o "$@" \
  --data-dir "$pdt_data_dir" \
-- -l "$adata_fl" & 
fi 

if [[ "$which" = *t* ]]; then
$start btred -qI "$tooldir/pml2base.btred" \
   --no-secondary-files \
   --resource-dir "$resource_dir": \
 -o "$@" \
  --data-dir "$pdt_data_dir" \
  -R adata_schema.xml \
  -R "$VALLEX_DATA/vallex_schema.xml" \
  -r t-a/aux.rf=adata:a-node \
  -r t-a/lex.rf=adata:a-node \
  -r t-root/atree.rf=adata:a-root \
  -r t-node/coref_text.rf=t-node \
  -r t-node/coref_gram.rf=t-node \
  -r t-node/compl.rf=t-node \
  -r t-node/val_frame.rf=valency_lexicon:v-frame \
-- -l "$tdata_fl"
fi

if [[ "$which" = *v* ]]; then
$start btred -qI "$tooldir/pml2base.btred" \
   --resource-dir "$resource_dir": \
 -o "$@" \
  --data-dir "$VALLEX_DATA" \
  -r problem/author=user \
  -r local_event/author=user \
  -r valency_lexicon/owner=user \
-- $vallex_pml
fi
