#!/usr/bin/perl -w
#-*-perl-*-
# Autogenerated by fd2pl from fdesign file ProcCntl.fd
#

use Xforms;

fl_initialize('ProcCntl');
fl_set_defaults(FL_PDBorderWidth, -2);
$ProcCntl = undef;
@Processes = undef;
$SelectedProcs = undef;
$Browser = undef;
$Menu = undef;
$autoupdate = 1;
$stat_time = time() + 10;
create_form_ProcCntl();
PopulateBrowser();
fl_show_form($ProcCntl, FL_PLACE_FREE, FL_FULLBORDER, "Processes");
fl_set_idle_callback("AutoUpdate", 0);
fl_do_forms();
exit 0;

sub PopulateBrowser {

	@Processes = ();
	@SelectedProcs = ();
	fl_freeze_form($ProcCntl); 
	fl_clear_browser($Browser);
	open (PROCS, 'ps -xafw |');
	while ($procline = <PROCS>) {
		if ($procline =~ /\s*(\d\d*).*:\d\d (.*)/) {
			$procnum = $1;
			$proctext = $2;
			push (@Processes,$procnum);
			fl_add_browser_line($Browser,$proctext);
		}
	}
	fl_set_menu_item_mode($Menu, 2, FL_PUP_GRAY);
	fl_unfreeze_form($ProcCntl);
	$stat_time = time() + 10;
	close PROCS;
}
			
sub SelectBrows {
	$selline = fl_get_browser($Browser);

	if ($selline > 0) {
		push (@SelectedProcs, $Processes[$selline-1]);
	} else {
		for ($i = 0; $SelectedProcs[$i] != $Processes[(-$selline)-1]; $i++) {}
		splice (@SelectedProcs, $i, 1);
	}
	if (@SelectedProcs) {
		fl_set_menu_item_mode($Menu, 2, FL_PUP_NONE);
		$autoupdate = 0;
	} else { 		
		fl_set_menu_item_mode($Menu, 2, FL_PUP_GRAY);
		$autoupdate = 1;
	}

}

sub AutoUpdate {
	PopulateBrowser() if ($autoupdate && time() >= $stat_time);
}

sub ProcMenu {

	$menuitem = fl_get_menu($Menu);
	if ($menuitem == 4) {
		fl_finish();
		exit;
	} elsif ($menuitem == 3) {
		PopulateBrowser();
		$autoupdate = 1;
	} elsif ($menuitem == 2 && @SelectedProcs) {
		kill (9, @SelectedProcs);  
		PopulateBrowser();
		$autoupdate = 1;
	}

}

sub create_form_ProcCntl {
  $obj = undef;
  $ProcCntl = fl_bgn_form(FL_NO_BOX, 545, 260);
  $obj = fl_add_box(FL_FLAT_BOX, 0, 0, 545, 260, "");
  $obj = $Browser = fl_add_browser(FL_MULTI_BROWSER, 10, 35, 525, 220, "");
  fl_set_object_gravity($obj, FL_NorthWest, FL_SouthEast);
  fl_set_object_lstyle($obj, FL_BOLD_STYLE);
  fl_set_object_callback($obj, "SelectBrows", 0);
  fl_set_browser_fontsize($obj, FL_MEDIUM_SIZE);
  $obj = fl_add_box(FL_UP_BOX, 0, 0, 545, 25, "");
  fl_set_object_resize($obj, FL_RESIZE_X);
  $obj = $Menu = fl_add_menu(FL_PULLDOWN_MENU, 5, 5, 65, 15, "Process");
  fl_set_object_resize($obj,FL_RESIZE_NONE);
  fl_set_object_gravity($obj, FL_NorthWest, FL_NorthWest);
  fl_set_object_shortcut($obj, "P", 1);
  fl_set_object_boxtype($obj, FL_FLAT_BOX);
  fl_set_object_lsize($obj, FL_NORMAL_SIZE);
  fl_set_object_lstyle($obj, FL_BOLD_STYLE);
  fl_setpup_fontstyle(FL_BOLD_STYLE);
  fl_set_menu($obj, "Details|Kill%l|Refresh%l|Exit");
  fl_set_menu_item_mode($obj, 1, FL_PUP_GRAY);
  fl_set_menu_item_mode($obj, 2, FL_PUP_GRAY);
  fl_set_object_callback($obj, "ProcMenu", 0);

  fl_end_form();
}

sub create_the_forms {
  create_form_ProcCntl();
}
1;
