use v6;
use Test;

use OWL::IRI;


#-------------------------------------------------------------------------------
subtest {
  is OWL::IRI.get-prefix('rdf'), 'http://www.w3.org/1999/02/22-rdf-syntax-ns#', 'rdf prefix';

  OWL::IRI.prefix(local-name => 'file://Perl6/Projects/OWL#');
  is OWL::IRI.get-prefix(), 'file://Perl6/Projects/OWL#', 'default prefix';
}, 'Prefixes';

#-------------------------------------------------------------------------------
subtest {
  my OWL::IRI $i1 .= check-iri('abc');
  isa-ok $i1, 'IRI', 'i1 is IRI';
  is "$i1", 'file://Perl6/Projects/OWL#abc', "IRI i1 = $i1";

  my OWL::IRI $i2 .= new(:iri('abc'));
  isa-ok $i2, 'IRI', 'i2 is IRI';
  is "$i2", 'abc', "IRI i2 = $i2";

  my OWL::IRI $i3 .= check-iri('file://Perl6/Projects/OWL#abc');
  isa-ok $i3, 'IRI', 'i3 is IRI';
  is "$i3", 'file://Perl6/Projects/OWL#abc', "IRI i3 = $i3";

  my OWL::IRI $i4 .= check-iri('def:abc');
  nok $i4, "IRI i4 = undefined";

}, 'Set and test iri';

#-------------------------------------------------------------------------------
# Cleanup
#
done();
exit(0);
