use v6;
use OWL::IRI;
use OWL::Axiom;
use OWL::Entity;
use OWL::Class;
use OWL::ObjectProperty;
use OWL::DataProperty;
use OWL::AnnotationProperty;
use OWL::DataType;
use OWL::NamedIndividual;

package OWL {

  class Declaration is OWL::Axiom {

    constant @entity-types = < class data-type object-property data-property
                               annotation-property named-individual
#                               anonymous-individual
                             >;

    has OWL::Entity $.entity;


    #---------------------------------------------------------------------------
    #
    method check-entity-type ( $entity-type --> Bool ) {

      return $entity-type !~~ any(@entity-types);
    }

    #---------------------------------------------------------------------------
    #
    method set ( Str $type, OWL::IRI $iri ) {

      given $type {

        when 'class' {
          $!entity = OWL::Class.new(:$iri);
        }

        when 'object-property' {
          $!entity = OWL::ObjectProperty.new(:$iri);
        }

        when 'data-property' {
          $!entity = OWL::DataProperty.new(:$iri);
        }

        when 'annotation-property' {
          $!entity = OWL::AnnotationProperty.new(:$iri);
        }

        when 'data-type' {
          $!entity = OWL::DataType.new(:$iri);
        }

        when 'named-individual' {
          $!entity = OWL::NamedIndividual.new(:$iri);
        }

        default {
          die "Unknown type";
        }
      }

      self.set-type($type);
    }

    #---------------------------------------------------------------------------
    #
    method get-entity ( ) { return $!entity; }
  }
}
