package Egg::Plugin::SessionKit;
#
# Masatoshi Mizuno E<lt>lusheE<64>cpan.orgE<gt>
#
# $Id: SessionKit.pm 214 2007-11-06 13:51:19Z lushe $
#
use strict;
use warnings;
use base qw/ Egg::Plugin::IxHash /;

our $VERSION = '2.10';

=head1 NAME

Egg::Plugin::SessionKit - Plugin that manages session.

=head1 SYNOPSIS

  use Egg qw/ SessionKit /;
  
  __PACKAGE__->mk_eggstartup(
    .......
    ...
    plugin_session => {
      key_name           => 'ss',
      verifi_agent       => 1,
      ipaddr_check_level => 1,
      component=> [qw/ Base::DBI Bind::Cookie Store::Base64 /],
      },
    );

  # ZbVf[^lB
  my $session = $e->session;
  
  $session->{hoge}= 'in data';
  
  # ݂̃ZbVhcQƁB
  $session->session_id;

=head1 DESCRIPTION

ZbVǗsׂ̃vOCłB

* ȑÕo[WƂ͎dl኱ςĂ܂B

* ̃vOC Egg::Plugin::IxHash pĂ܂̂ŁAEgg::Plugin::IxHash
  ʂɃ[hKv͂܂B

=head1 CONFIGRATION

'plugin_session' ɂ̃W[̐ݒsĉB

=head2 key_name

NbL[ȂǂɎgpZbVhc擾p̃p[^̖OB

  plugin_session=> {
    key_name=> 'session_id',
    ...
    },

ftHg ss łB

=head2 verifi_agent

ȑOƓZbVvĂAHTTP_USER_AGENT vȂΕʃZbVƂĈ܂B

  plugin_session=> {
    verifi_agent=> 1,
    ...
    },

ftHg͖`łB

=head2 ipaddr_check_level

ȑOƓZbVvꂽ̂hoAhXƌ݂̂hoAhẌv`FbN܂B
vΕʃZbVƂĈ܂B

1  C ݒ肷 CNX ̃`FbNA1  C ȊO̕ݒ肷ƊSvŃ`FbN܂B
0  ` ȂSēZbVƂĈ܂B

  plugin_session=> {
    ipaddr_check_level=> 1,
    ...
    },

ftHg͖`łB

=head2 component

̃ZbVW[ǂݍފeR|[lgEW[w肵܂B

ftHg͂܂̂ŁAǂݍރR|[lg͑SĐݒ肷Kv܂B

ݒ͕K ARRAY t@XōsAŏ̒l BasenR|[lgݒ肷鎖B

Base nR|[lgȍ~͓ɏԂɍS܂񂪁AStoren  Bindn ̃R|[lg
ݒ肪KKvɂȂ܂B Issuen R|[lg͏ȗł܂B

  plugin_session=> {
    ...
    component=> [qw/ Base::FileCache Bind::Cookie Store::Base64 /],
    },

܂elɃIvVݒ肷ꍇ͎̂悤ȊɂȂ܂B

  plugin_session=> {
    ...
    component=> [
      [ 'Base::FileCache' => {
        namespace  => 'sessions',
        cache_root => '/path/to/cache',
        ...
        } ],
      qw/ Bind::Cookie Store::Base64 /,
      ],
    },

  plugin_session=> {
    ...
    component=> [
      [ 'Base::FileCache' => {
        namespace  => 'sessions',
        cache_root => '/path/to/cache',
        ...
        } ],
      [ 'Bind::Cookie' => {
        cookie_name   => 'sid',
        cookie_path   => '/',
        ...
        } ],
      'Store::Base64',
      ],
    },

=head2 ticket

  plugin_session=> {
    ...
    ticket => {
      param_name => 'my_ticket',
      },
    },

ꎞ`PbgtH[󂯎ׂ̖̂ param_name Őݒ肵܂B

ftHg ticket łB

=head1 METHODS

=head2 session

ZbVEIuWFNgԂ܂B

  my $session= $e->session;

lZbgꍇ͕ʂɑΗǂłB

  $session->{data}= 'foo';

=head2 ticket_id

1 ^ƈꎞ`Pbghc𐶐ĕԂ܂B

  my $ticket_id= $e->ticket_id(1);

͎̂悤ȃR[hƓłB

  my $ticket_id= $e->session->{session_ticket}= $e->session->create_id;

0 ^ƈꎞ`Pbghc𖳌ɂ܂B

  $e->ticket_id(0);

=head2 ticket_check

ꎞ`PbghcZbVɕۑĂhcƈv true Ԃ܂B

  if ($e->ticket_check($e->req->param('ticket'))) {
     Ticket ID is corresponding.
  } else {
     Ticket ID is a disagreement.
  }

ȗ param_name ɐݒ肵NG[̒lrΏƂɂ܂B

  if ($e->ticket_check) {
     Ticket ID is corresponding.
  } else {
     Ticket ID is a disagreement.
  }

=head2 session_close

ZbV𖾎IɃN[Y܂B

* ͒ʏ _finalize ŌĂ΂ׁAAvP[VŃR[Kv͂܂B

=head1 HANDLER_METHODS

=head2 new

ZbVnh[IuWFNgԂ܂B

  my $session= $e->session;

=head2 session_id

݃ZbgĂZbVhcԂ܂B

  my $session_id= $e->session->session_id;

=head2 session_ticket

݃ZbgĂꎞ`PbghcԂ܂B

  my $ticket_id= $e->session->session_ticket || undef;

=head2 access_time_now

ZbVI[v time lԂ܂B

=head2 access_time_old

OZbVI[v access_time_now ̒lԂ܂B

=head2 context

ZbV TieHash IuWFNgԂ܂B

=head2 session

ZbV TieHash gԂ܂B

=head2 e

vWFNgEIuWFNgԂ܂B

=head2 conf

ZbṼRtBO[VԂ܂B

=head2 attr

ZbV֘Åe푮Ԃ܂B(HASHt@X)

=head2 is_handler

ZbV TieHash ɎgĂnh[Ԃ܂B

=head2 is_update

ZbVɉlčXVKv true Ԃ܂B

=head2 is_newentry

݂̃ZbVVKZbVhcɂ̂Ȃ true Ԃ܂B

=head2 create_id ([ID_LENGTH])

SHA1 ɂ胆j[NȂhc𐶐܂B

̃\bh Issuen R|[lgɂăI[o[Ch鎖܂B

  my $id= $session->create_id(32);

* ID_LENGTH ̃ftHg 32 łASHA1 g͒ʏ40Ԃ܂̂ 40 ȏw肵Ă
  ӖłB

=head2 change

VhcŕʃZbVɕύX܂Bf[^͑SĈȑÔ̂p܂B

=head2 clear

VhcŕʃZbVŏ܂Bf[^͑SăNA܂B

=head2 delete ([KEY_NAME])

w肵L[̃f[^폜܂B

  $session->delete('fooo');

͎̃R[hƓłB

  delete($session->{fooo});

=head1 TIEHASH_HANDLER

̃\bh̓AvP[V璼ڌĂяo鎖z肵Ă܂B

=head2 e

vWFNgIuWFNgԂ܂B

=head2 conf, mod_conf, config

RtBO[VԂ܂B

=head2 attr

ZbV֘Åe푮Ԃ܂B(HASHt@X)

=head2 session_id

ZbVhcԂ܂B

=head2 new_entry

݂̃ZbVVKZbVhcɂ̂Ȃ true Ԃ܂B

=head2 agent_key_name

HTTP_USER_AGENT ۑĂZbṼL[Ԃ܂B

=head2 addr_key_name

REMOTE_ADDR ۑĂZbṼL[Ԃ܂B

=head2 initialize

ZbVf[^܂B

=head2 normalize

ZbVɕۑ鏉f[^ZbgAbv܂B

=head2 create_session_id

VZbVhc𔭍s܂B

=head2 issue_id

ZbVhc𔭍s܂B
̃\bh Issuen R|[lgăI[o[Ch܂B

=head2 issue_check_id

󂯎hc̏`FbN܂B

=head2 commit_ok

gUNVׂ̈̃_~[\bh

=head2 insert

VZbVۑׂ̃\bh

=head2 update

ZbVXṼׂ\bh

=head2 restore

ZbVǂݍވׂ̃\bh

=head2 set_bind_data

ZbVhc Cookie ɃZbgׂ̃\bh

=head2 get_bind_data

ZbVhc Cookie 瓾ׂ̃\bh

=head2 startup

ZbgAbvp̃\bh

=cut

{
	my($handler, $config, $ticket_param_name);
	sub _setup {
		my($e)= @_;
		$config= $e->config->{plugin_session} ||= {};
		my $ticket= $config->{ticket} ||= {};
		$ticket_param_name= $ticket->{param_name} || 'ticket';
		$handler= $e->{session_handler} ||= 'Egg::Plugin::SessionKit::handler';
		$handler->_startup($e, $config, $handler);
		$e->next::method;
	}
	sub _prepare {
		my($e)= @_;
		$handler->_prepare($e, $config);
		$e->next::method;
	}
	sub _finalize {
		my($e)= @_;
		$e->next::method;
		if ($e->{sessionkit}) {
			$handler->_finalize($e, $config);
			$e->session_close;
		}
		$e;
	}
	sub _finalize_error {
		my($e)= @_;
		$e->next::method;
		if (my $ss= $e->{sessionkit}) {
			$ss->attr->{rollback}= 1;
			$handler->_finalize($e, $config);
			$e->session_close;
		}
		$e;
	}
	sub session {
		$_[0]->{sessionkit} ||= $handler->new(shift, $config, @_);
	}
	sub ticket_check {
		my $e= shift;
		my $ticket= shift
		  || $e->request->param($ticket_param_name)
		  || return do { $e->debug_out("# - ticket is undefined."); 0 };
		return do { $e->debug_out("# - session_ticket is undefined."); 0 }
		  unless my $id= $e->session->session_ticket;
		return 1 if $id eq $ticket;
		$e->debug_out("# - ticket is unmatched. ($ticket = $id)");
		return 0;
	}
  };

sub ticket_id {
	my $e= shift;
	return $e->session->session_ticket || 0 unless @_;
	$e->session->session_ticket
	   ( $_[0] ? $e->session->create_id($_[0] > 1 ? $_[0]: 0): 0 );
}
sub session_close {
	my($e)= @_;
	return $e unless $e->{sessionkit};
	untie %{$e->{sessionkit}};
	undef $e->{sessionkit};
	$e;
}

package Egg::Plugin::SessionKit::handler;
use strict;
use warnings;
use UNIVERSAL::require;
use Digest::SHA1 qw/sha1_hex/;
use base qw/Class::Accessor::Fast/;

__PACKAGE__->mk_accessors
   (qw/ session_id session_ticket access_time_now access_time_old /);

my $tie_handler;

sub _prepare  {}
sub _finalize {}

sub _startup {
	my($class, $e, $cf, $handler)= @_;
	my $compo= $cf->{component}
	   || [qw/ Base::FileCache Bind::Cookie Store::Plain /];
	$cf->{key_name} ||= 'ss';
	my $conf= $cf->{config}= $e->ixhash;
	   $tie_handler= "${handler}::TieHash";
	my $pkg_name   = 'Egg::Plugin::SessionKit';
	my $base_name  = "${pkg_name}::base";
	no strict 'refs';  ## no critic.
	my $isa= \@{"${tie_handler}::ISA"};
	my @pkg;
	for (1..$#{$compo}) {
		my $name= __sessionkit_config($conf, $compo->[$_]);
		push @$isa, "${pkg_name}::${name}";
		push @pkg,  "${pkg_name}::${name}";
	}
	my $base= __sessionkit_config($conf, $compo->[0]);
	$base=~m{^Base\:+} || die q{ A 'Base' component is not specified. };
	push @$isa, "${pkg_name}::${base}";
	push @$isa, $base_name;
	$_->require or die $@ for (@pkg, "${pkg_name}::${base}");

	no strict 'refs';  ## no critic.
	no warnings 'redefine';

	*{"${base_name}::agent_check"}= $cf->{verifi_agent} ? do {
		$e->debug_out("# + session verifi_agent: ON.");
		sub {
			my($self, $data)= @_;
			my $agent= $data->{$self->agent_key_name} || return 1;
			$self->e->request->agent eq $agent ? 1: 0;
		};
	  }: do {
		$e->debug_out("# + session verifi_agent: OFF.");
		sub { 1 };
	  };

	*{"${base_name}::ipaddr_check"}= $cf->{ipaddr_check_level} ? do {
		$cf->{ipaddr_check_level}=~m{^(?:1|C)}i ? do {
			$e->debug_out("# + session ipaddr check: C class.");
			sub {
				my($self, $data)= @_;
				my $addr= $data->{$self->addr_key_name} || return 1;
				my($level)= $addr=~/^(\d+\.\d+\.\d+)/;
				$self->e->request->address=~/^${level}\.\d+$/ ? 1: 0;
			  };
		  }: do {
			$e->debug_out("# + session ipaddr check: Absolute.");
			sub {
				my($self, $data)= @_;
				my $addr= $data->{$self->addr_key_name} || return 1;
				$self->e->request->address eq $addr ? 1: 0;
			  };
		  };
	  }: do {
		$e->debug_out("# + session ipaddr check: None.");
		sub { 1 };
	  };

	$tie_handler->startup($e, $conf);
	$class;
}
sub new {
	my $class= shift;
	my %session;
	tie %session, $tie_handler, @_;
	my $self= bless \%session, $class;
	tied(%session)->initialize($self);
	$self;
}
sub context { tied(%{$_[0]}) }
sub session { $_[0]->context->[0] }
sub e       { $_[0]->context->[1] }
sub conf    { $_[0]->context->[2] }
sub attr    { $_[0]->context->[3] }

sub is_handler  { $tie_handler }
sub is_update   { $_[0]->attr->{update}   }
sub is_newentry { $_[0]->attr->{newentry} }

sub create_id {
	my $self= shift;
	my $leng= shift || 32;  ## rand(1000);
	substr( sha1_hex(time. {}. rand(1000). $$), 0, $leng );
}
sub change {
	my($self)= @_;
	$self->context->normalize
	   ($self->context->create_session_id, $self->session);
	$self;
}
sub clear {
	my($self)= @_;
	$self->context->normalize
	   ($self->context->create_session_id, {});
	$self;
}
sub delete {
	my $self= shift;
	$self->context->delete(@_);
}
sub __sessionkit_config {
	my $conf= shift;
	my $data= shift || die q{ I want sessionkit setup. };
	ref($data) eq 'HASH' ? do {
		my $cname= $data->{name}
		   || die q{ I want sessionkit setup 'component name' };
		$conf->{ __sessionkit_name_conv($cname) }= $data->{conf} || {};
		return $cname;
	  }:
	ref($data) eq 'ARRAY' ? do {
		my $cname= $data->[0]
		   || die q{ I want sessionkit setup 'component name' };
		$conf->{ __sessionkit_name_conv($cname) }= $data->[1] || {};
		return $cname;
	  }: do {
		$conf->{ __sessionkit_name_conv($data) }= {};
		return $data;
	  };
}
sub __sessionkit_name_conv {
	my($name)= @_;
	$name=~s{\:\:} [_]g;
	lc($name);
}

package Egg::Plugin::SessionKit::handler::TieHash;
use strict;
use warnings;

package Egg::Plugin::SessionKit::base;
use strict;
use warnings;
use Tie::Hash;
use Class::C3;

our @ISA = 'Tie::ExtraHash';

__PACKAGE__->mk_ro_accessors
  (qw/ parent is_update is_newentry is_rollback is_output_id is_session_id /);

sub e    { $_[0][1] }
sub conf { $_[0][2] }
sub attr { $_[0][3] }
sub mod_conf { $_[0]->conf->{config} }

sub mk_ro_accessors {
	my $proto= shift;
	my $class= ref($proto) || $proto;
	no strict 'refs';  ## no critic.
	no warnings 'redefine';
	for (@_) {
		my $key= $_; $key=~s{^is_} [];
		*{"${class}::$_"}= sub { $_[0][3]{$key} };
	}
}
*config     = \&conf;
*new_entry  = \&is_newentry;
*session_id = \&is_session_id;

sub agent_key_name { 'session_user_agent' }
sub addr_key_name  { 'session_remote_addr' }

sub TIEHASH {
	my($class, $e, $conf, $id)= @_;
	bless [{}, $e, $conf, {
	  update    => 0,
	  newentry  => 0,
	  rollback  => 0,
	  output_id => 0,
	  session_id=> ($id || ""),
	  }], $class;
}
sub STORE {
	my $self= shift;
	$self->attr->{update}= 1;
	$self->[0]{$_[0]}= $_[1];
}
sub DELETE {
	my $self= shift;
	$self->attr->{update}= 1;
	delete($self->[0]{$_[0]});
}
sub initialize {
	my $self= shift;
	$self->attr->{parent}= shift;
	my($session_id, $session_data);
	if ($session_id= $self->get_bind_data($self->conf->{key_name})) {
		$session_id= 0 unless $self->issue_check_id($session_id);
	}
	if ($session_id) {
		$self->e->debug_out("# + session restore: ${session_id}");
		$session_data= $self->restore($session_id)
		   || do { $session_id= $self->create_session_id; {} };
	} else {
		$session_id= $self->create_session_id;
		$session_data= {};
	}
	$self->normalize($session_id, $session_data);
}
sub normalize {
	my $self= shift;
	my $id  = shift || $self->is_session_id;
	my $data= shift || $self->[0];
	$data= {} unless $self->agent_check($data);
	$data= {} unless $self->ipaddr_check($data);
	$data->{session_id}= $self->attr->{session_id}= $id;
	$data->{session_create_time} ||= time;
	$data->{$self->agent_key_name}= $self->e->request->agent;
	$data->{$self->addr_key_name }= $self->e->request->address;
	$data->{access_time_old}= $data->{access_time_now} || 0;
	$data->{access_time_now}= time;
	$self->[0]= $data;
	$self;
}
sub create_session_id {
	my($self)= @_;
	my $id= $self->issue_id
	     || die q{ 'Issue_id' method doesn't return the value. };
	$self->attr->{newentry}= $self->attr->{output_id}= 1;
	$self->e->debug_out("# + session newentry : $id");
	$id;
}
sub output_session_id {
	my $self= shift;
	my $id  = shift || $self->is_session_id;
	$self->set_bind_data($self->conf->{key_name}, $id, @_);
}
sub issue_id {
	$_[0]->parent->create_id(32);
}
sub issue_check_id {
	my $self= shift;
	my $id  = shift || return 0;
	$id=~/^[A-Fa-f0-9]{32}$/ ? $id: 0;
}
sub commit_ok { }
sub insert  { die q{ There is no 'insert' method. } }
sub update  { die q{ There is no 'update' method. } }
sub restore { die q{ There is no 'restore' method. } }
sub set_bind_data { die q{ There is no 'set_bind_data' method. } }
sub get_bind_data { die q{ There is no 'get_bind_data' method. } }
sub startup { @_ }

sub DESTROY {
	my($self)= @_;
	return 1 unless $self->[0];
	if ($self->is_update and ! $self->is_rollback) {
		my $method= $self->is_newentry ? 'insert': 'update';
		$self->e->debug_out("# + session ${method}: ". $self->is_session_id);
		$self->$method;
		$self->commit_ok(1);
	}
	$self->output_session_id if $self->is_output_id;
}

1;

__END__

=head1 SEE ALSO

L<Class::C3>,
L<Digest::SHA1>,
L<Class::Accessor::Fast>,
L<Tie::Hash>,
L<Egg::Plugin::IxHash>,
L<Egg::Release>,

=head1 AUTHOR

Masatoshi Mizuno E<lt>lusheE<64>cpan.orgE<gt>

=head1 COPYRIGHT

Copyright (C) 2007 by Bee Flag, Corp. E<lt>http://egg.bomcity.com/E<gt>, All Rights Reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut

