/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.testgenerator;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XlateHtmlSeleneseToJava {
    static Set generatedJavaClassNames = new HashSet();
    private static Map funcTypes = null;
    static final String BEGIN_SELENESE = ">>>>>";
    static final String END_SELENESE = "<<<<<";
    static final String SELENESE_TOKEN_DIVIDER = "//////";
    static HashMap declaredVariables = new HashMap();
    private static int varNameSeed = 1;
    private static String EOL = "\n\t\t";
    private static int timeOut = 30000;
    private static String domain;
    private static boolean silentMode;
    private static boolean dontThrowOnTranslationDifficulties;

    public static void main(String[] args) throws IOException {
        boolean generateSuite = false;
        if (args.length < 2) {
            XlateHtmlSeleneseToJava.Usage("too few args");
            return;
        }
        HashMap<String, Boolean> skipList = new HashMap<String, Boolean>();
        String javaSeleneseFileDirectoryName = args[0];
        for (int j = 1; j < args.length; ++j) {
            if (args[j].equals("-silent")) {
                silentMode = true;
                continue;
            }
            if (args[j].equals("-skip")) {
                skipList.put(args[++j], Boolean.TRUE);
                continue;
            }
            if (args[j].equals("-dontThrowOnTranslationDifficulties")) {
                dontThrowOnTranslationDifficulties = true;
                continue;
            }
            if (args[j].equals("-suite")) {
                generateSuite = true;
                continue;
            }
            if (args[j].equals("-dir")) {
                String dirName;
                File dir;
                if (!(dir = new File(dirName = args[++j])).isDirectory()) {
                    XlateHtmlSeleneseToJava.Usage("-dir is not a directory: " + dirName);
                }
                String[] children = dir.list();
                for (int k = 0; k < children.length; ++k) {
                    String fileName = children[k];
                    if (skipList.containsKey(fileName) || fileName.indexOf(".htm") == -1 || fileName.indexOf("Suite") != -1) continue;
                    XlateHtmlSeleneseToJava.generateJavaClassFromSeleneseHtml(dirName + "/" + fileName, javaSeleneseFileDirectoryName);
                }
                continue;
            }
            String htmlSeleneseFileName = args[j];
            XlateHtmlSeleneseToJava.generateJavaClassFromSeleneseHtml(htmlSeleneseFileName, javaSeleneseFileDirectoryName);
        }
        if (generateSuite) {
            XlateHtmlSeleneseToJava.generateSuite(javaSeleneseFileDirectoryName);
        }
    }

    private static void initializeFuncTypes() {
        if (funcTypes != null) {
            return;
        }
        funcTypes = new HashMap();
        InputStream stream = XlateHtmlSeleneseToJava.class.getResourceAsStream("/core/iedoc.xml");
        if (stream == null) {
            throw new RuntimeException("could not find /core/iedoc.xml on the class path");
        }
        try {
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            NodeList functions = d.getElementsByTagName("function");
            for (int i = 0; i < functions.getLength(); ++i) {
                Element function = (Element)functions.item(i);
                String funcName = function.getAttribute("name");
                NodeList returnElements = function.getElementsByTagName("return");
                if (returnElements.getLength() == 0) {
                    funcTypes.put(funcName, Void.TYPE);
                    continue;
                }
                Element ret = (Element)returnElements.item(0);
                String retType = ret.getAttribute("type");
                if ("boolean".equals(retType)) {
                    funcTypes.put(funcName, Boolean.TYPE);
                    continue;
                }
                if (!"string".equals(retType)) continue;
                funcTypes.put(funcName, class$java$lang$String == null ? XlateHtmlSeleneseToJava.class$("java.lang.String") : class$java$lang$String);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isBoolean(String op) {
        return Boolean.TYPE.equals(XlateHtmlSeleneseToJava.getOpType(op));
    }

    private static Class getOpType(String op) {
        XlateHtmlSeleneseToJava.initializeFuncTypes();
        if (funcTypes.get(op) != null) {
            return (Class)funcTypes.get(op);
        }
        String swappedOp = op.replaceFirst("store", "get");
        if (funcTypes.get(swappedOp) != null) {
            return (Class)funcTypes.get(swappedOp);
        }
        swappedOp = op.replaceFirst("store", "is");
        if (funcTypes.get(swappedOp) != null) {
            return (Class)funcTypes.get(swappedOp);
        }
        if (op.matches(".*(Present|Visible|Editable)$")) {
            return Boolean.TYPE;
        }
        return String.class;
    }

    private static void generateSuite(String javaSeleneseFileDirectoryName) throws IOException {
        if (generatedJavaClassNames.size() == 1) {
            return;
        }
        String beginning = "package com.thoughtworks.selenium.corebased;\n\nimport junit.framework.Test;\nimport junit.framework.TestSuite;\n\npublic class SeleneseSuite {\n    static public Test suite() {\n        TestSuite suite =  new TestSuite();\n";
        String ending = "        return suite;\n    }\n}\n";
        StringBuffer middle = new StringBuffer();
        Iterator i = generatedJavaClassNames.iterator();
        while (i.hasNext()) {
            String generatedJavaClassName = (String)i.next();
            if (generatedJavaClassName.equals("TestJavascriptParameters")) continue;
            middle.append("         suite.addTestSuite(").append(generatedJavaClassName).append(".class);\n");
        }
        XlateHtmlSeleneseToJava.WriteFileContents(beginning + middle + ending, XlateHtmlSeleneseToJava.openFile(javaSeleneseFileDirectoryName + "/SeleneseSuite.java"));
    }

    private static void generateJavaClassFromSeleneseHtml(String htmlSeleneseFileName, String javaSeleneseFileDirectoryName) throws IOException {
        String base = htmlSeleneseFileName;
        base = base.replaceAll(".*/", "");
        base = base.replaceAll("\\.html?$", "");
        String javaSeleneseFileName = javaSeleneseFileDirectoryName + "/" + base + ".java";
        generatedJavaClassNames.add(base);
        System.out.println("Generating test class " + base + " from\t" + htmlSeleneseFileName + "...");
        File htmlSeleneseFile = XlateHtmlSeleneseToJava.openFile(htmlSeleneseFileName);
        File javaSeleneseFile = XlateHtmlSeleneseToJava.openFile(javaSeleneseFileName);
        try {
            javaSeleneseFile.createNewFile();
        }
        catch (IOException e) {
            XlateHtmlSeleneseToJava.Usage(e.toString());
        }
        if (!htmlSeleneseFile.canRead()) {
            XlateHtmlSeleneseToJava.Usage("can't read " + htmlSeleneseFileName);
        }
        if (!javaSeleneseFile.canWrite()) {
            XlateHtmlSeleneseToJava.Usage("can't write " + javaSeleneseFileName);
        }
        String htmlSelenese = XlateHtmlSeleneseToJava.ReadFileContents(htmlSeleneseFile);
        String javaSelenese = XlateHtmlSeleneseToJava.XlateString(base, htmlSeleneseFileName, htmlSelenese);
        XlateHtmlSeleneseToJava.WriteFileContents(javaSelenese, javaSeleneseFile);
    }

    private static void WriteFileContents(String s, File f) throws IOException {
        FileWriter output = new FileWriter(f);
        if (!silentMode) {
            System.out.println(">>>>" + s + "<<<<");
        }
        output.write(s);
        output.close();
    }

    protected static String possiblyDeclare(boolean isBoolean, String variableName) {
        if (!declaredVariables.containsKey(variableName)) {
            declaredVariables.put(variableName, variableName);
            return (isBoolean ? "boolean" : "String") + " " + variableName;
        }
        return variableName;
    }

    private static String XlateString(String base, String htmlSeleneseFileName, String htmlSelenese) {
        String possibleSetup;
        declaredVariables.clear();
        domain = null;
        String preamble = "package com.thoughtworks.selenium.corebased;\nimport com.thoughtworks.selenium.*;\n/**\n * @author XlateHtmlSeleneseToJava\n * Generated from " + htmlSeleneseFileName + ".\n" + " */\n" + "public class " + base + " extends SeleneseTestCase\n" + "{\n" + "   public void " + XlateHtmlSeleneseToJava.makeTestName(base) + "() throws Throwable {\n\t\t";
        StringBuffer java = new StringBuffer();
        String body = htmlSelenese.replaceAll("[\n]", "");
        body = body.replaceAll("\\s*<", "<");
        body = body.replaceAll("</?em/?>", "");
        body = body.replaceAll("\r", "");
        body = body.replaceAll("</?[bi]/?>", "");
        body = body.replaceFirst(".*<title>([^<]+)</title>.*?<table.*?>", "selenium.setContext(\"$1\", \"info\");\n");
        body = body.replaceAll("<br>", "");
        body = body.replaceAll("\\\\", "\\\\\\\\");
        body = body.replaceAll(">\\s*<", "><");
        body = body.replaceAll("</?tbody>", "");
        body = body.replaceAll("<tr><t[dh]\\s+(rowspan=\"1\"\\s+)?colspan=\"3\">([^<]+)</t[dh]></tr>", "\n/* $2 */\n");
        if (!silentMode) {
            System.out.println("-------------------------------------------------------------\n" + body);
        }
        body = body.replaceAll("&nbsp;?", "");
        body = body.replaceAll("</table>.*?<table.*?>", "");
        body = body.replaceAll("</table>.*", "");
        body = body.replaceAll("</?tbody>", "");
        if (!silentMode) {
            System.out.println("-------------------------------------------------------------\n" + body);
        }
        body = body.replaceAll("(<tr>)(<!--.*?-->)", "$2$1");
        body = body.replaceAll("<!--\\s*", EOL + "/* ");
        body = body.replaceAll("\\s*-->", " */\n");
        body = body.replaceAll("<tr>\\s*(<td>)?", BEGIN_SELENESE);
        body = body.replaceAll("</tr>", "<<<<<\n");
        body = body.replaceAll("</td><td>", SELENESE_TOKEN_DIVIDER);
        body = body.replaceAll("</?td>", "");
        body = body.replaceAll("\\s*\\)", ")");
        body = body.replaceAll("<td/>", "");
        if (!silentMode) {
            System.out.println("-------------------------------------------------------------\n" + body);
        }
        String[] lines = body.split("\n");
        int j = 0;
        while (j < lines.length) {
            String line = lines[j];
            if (!line.startsWith(BEGIN_SELENESE)) {
                java.append(line);
                ++j;
            } else {
                j = XlateHtmlSeleneseToJava.XlateSeleneseStatement(java, lines, j);
            }
            java.append("\n");
        }
        String string = possibleSetup = domain == null ? "" : "\tpublic void setUp() throws Exception {\n\t\tsuper.setUp(\"" + domain + "\");\n" + "\t}\n";
        if (!silentMode) {
            System.out.println("-------------------------------------------------------------\n" + java);
        }
        String ending = "\n\t\tcheckForVerificationErrors();\n\t}\n" + possibleSetup + "}\n";
        return preamble + java.toString() + ending;
    }

    private static String makeTestName(String base) {
        if (base.startsWith("test")) {
            return base;
        }
        if (base.startsWith("Test")) {
            return base.replaceFirst("Test", "test");
        }
        return "test" + base;
    }

    private static int XlateSeleneseStatement(StringBuffer java, String[] lines, int j) {
        return XlateHtmlSeleneseToJava.XlateSeleneseStatement(java, lines, j, true);
    }

    private static int XlateSeleneseStatement(StringBuffer java, String[] lines, int j, boolean tryCatchAllowed) {
        String line = lines[j];
        String[] splitTokens = line.replaceFirst(BEGIN_SELENESE, "").replaceFirst(END_SELENESE, "").split(SELENESE_TOKEN_DIVIDER);
        String[] tokens = XlateHtmlSeleneseToJava.getValuesOrBlankStrings(splitTokens);
        String op = tokens[0];
        if (op.equals("typeRepeated")) {
            lines[j] = lines[j].replaceFirst("typeRepeated", "type");
            tokens[0] = "type";
            op = "type";
            tokens[2] = tokens[2] + tokens[2];
        }
        if (op.startsWith("waitFor") && !op.equals("waitForCondition") && !op.equals("waitForPopUp") && !op.equals("waitForPageToLoad")) {
            String conditionCkVarName = "sawCondition" + j;
            java.append("\t\tboolean " + conditionCkVarName + " = false;" + EOL).append("for (int second = 0; second < 60; second++) {" + EOL).append("\ttry {" + EOL).append("\t\tif (");
            lines[j] = lines[j].replaceFirst("waitFor", "assert");
            StringBuffer testStatementSB = new StringBuffer();
            XlateHtmlSeleneseToJava.XlateSeleneseStatement(testStatementSB, lines, j, false);
            String testStatement = testStatementSB.toString();
            if (testStatement.matches("^/\\*.*\\*/$")) {
                testStatement = testStatement + " false";
            }
            testStatement = testStatement.replaceAll("\t//.*", "");
            if ((testStatement = testStatement.replaceFirst("^\\s*", "")).startsWith("assertTrue")) {
                testStatement = testStatement.replaceFirst("assertTrue", "");
            } else if (testStatement.startsWith("assertEquals")) {
                testStatement = testStatement.replaceFirst("assertEquals", "seleniumEquals");
            } else if (testStatement.startsWith("assertNotEquals")) {
                testStatement = testStatement.replaceFirst("assertNotEquals", "!seleniumEquals");
            }
            testStatement = testStatement.replaceFirst(";$", "");
            java.append(testStatement).append(") {" + EOL).append("\t\t\t" + conditionCkVarName + " = true;" + EOL).append("\t\t\tbreak;" + EOL).append("\t\t}" + EOL).append("\t}" + EOL).append("\tcatch (Exception ignore) {" + EOL).append("\t}" + EOL).append("\tpause(1000);" + EOL).append("}" + EOL).append("assertTrue(" + conditionCkVarName + ");" + EOL);
        } else if (op.matches("setTimeout")) {
            timeOut = Integer.parseInt(tokens[1]);
        } else if (op.matches(".*(Error|Failure)OnNext") || op.matches("verify(Element)?(Not)?(Editable|Visible|Present|Selected)")) {
            boolean throwExpected;
            String throwCkVarName = "sawThrow" + j;
            if (tryCatchAllowed) {
                java.append(EOL + "boolean " + throwCkVarName + " = false;" + EOL + "try {" + EOL + "\t");
            }
            if (op.indexOf("ErrorOnNext") != -1 || op.indexOf("FailureOnNext") != -1) {
                throwExpected = true;
                ++j;
            } else {
                java.append("// originally " + tokens[0] + "|" + tokens[1] + "|" + tokens[2] + EOL);
                throwExpected = false;
            }
            String wrapper = lines[j].startsWith(">>>>>verify") ? "verify" : "assert";
            lines[j] = lines[j].replaceFirst("verify", "assert");
            StringBuffer testStatement = new StringBuffer();
            XlateHtmlSeleneseToJava.XlateSeleneseStatement(testStatement, lines, j, false);
            java.append(testStatement.toString().replaceFirst("\tverify", "\tassert"));
            if (tryCatchAllowed) {
                java.append(EOL + "}" + EOL + "catch (Throwable e) {" + EOL + "\t" + "" + throwCkVarName + " = true;" + EOL + "}" + EOL + wrapper + (throwExpected ? "True" : "False") + "(" + throwCkVarName + ");" + EOL);
            }
        } else {
            java.append(XlateHtmlSeleneseToJava.XlateSeleneseStatementTokens(op, tokens, line));
        }
        return j + 1;
    }

    private static String XlateSeleneseStatementTokens(String op, String[] tokens, String oldLine) {
        boolean isBoolean = XlateHtmlSeleneseToJava.isBoolean(op);
        String beginning = "\t\t// " + oldLine.replaceFirst(BEGIN_SELENESE, "").replaceFirst(END_SELENESE, "").replaceAll(SELENESE_TOKEN_DIVIDER, "|") + EOL;
        String ending = ";";
        if (op.equals("echo")) {
            return beginning.replaceFirst("\n", "") + ": op not meaningful from rc client";
        }
        if (op.endsWith("AndWait")) {
            if (!op.startsWith("click")) {
                ending = ending + EOL + "selenium.waitForPageToLoad(\"" + timeOut + "\");";
            }
            op = op.replaceFirst("AndWait", "");
            tokens[0] = tokens[0].replaceFirst("AndWait", "");
        }
        if (op.equals("storeText")) {
            return beginning + "String " + tokens[2] + " = selenium.getText(" + XlateHtmlSeleneseToJava.quote(tokens[1]) + ");";
        }
        if (op.equals("storeTextLength")) {
            return beginning + "Integer " + tokens[2] + " = new Integer(selenium.getText(" + XlateHtmlSeleneseToJava.quote(tokens[1]) + ").length());";
        }
        if (op.equals("store")) {
            return beginning + XlateHtmlSeleneseToJava.possiblyDeclare(isBoolean, tokens[2]) + " = " + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ";";
        }
        if (op.equals("storeAttribute")) {
            return beginning + XlateHtmlSeleneseToJava.possiblyDeclare(false, tokens[2]) + " = selenium.getAttribute(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ");";
        }
        if (op.equals("storeBodyText")) {
            return beginning + XlateHtmlSeleneseToJava.possiblyDeclare(false, tokens[1]) + " = this.getText();";
        }
        if (op.equals("storeValue")) {
            if (tokens[2].equals("")) {
                return beginning + XlateHtmlSeleneseToJava.possiblyDeclare(false, tokens[1]) + " = this.getText();";
            }
            return beginning + XlateHtmlSeleneseToJava.possiblyDeclare(false, tokens[2]) + " = selenium.getValue(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ");";
        }
        if (op.startsWith("store")) {
            return beginning + XlateHtmlSeleneseToJava.possiblyDeclare(isBoolean, tokens[1]) + " = " + (op.endsWith("NotPresent") ? "!" : "") + "selenium." + (isBoolean ? "is" : "get") + op.replaceFirst("store", "") + "();";
        }
        if (op.startsWith("verify") || op.startsWith("assert")) {
            String middle;
            beginning = op.startsWith("verify") ? beginning + "verifyEquals(" : beginning + "assertEquals(";
            ending = ")" + ending;
            if ((op = op.replaceFirst("assert|verify", "")).equals("ElementPresent") || op.equals("ElementNotPresent") || op.equals("TextPresent") || op.equals("TextNotPresent") || op.equals("Editable") || op.equals("NotEditable") || op.equals("Visible") || op.equals("NotVisible")) {
                String possibleInversion = "";
                if (op.indexOf("Not") != -1) {
                    possibleInversion = "!";
                    op = op.replaceFirst("Not", "");
                }
                return "\t\tassertTrue(" + possibleInversion + "selenium.is" + op + "(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + "));";
            }
            if (op.equals("Selected") || op.equals("NotSelected")) {
                return "\t\tassertTrue(selenium.is" + op + "(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ", " + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[2]) + "));";
            }
            if (op.startsWith("Not")) {
                beginning = XlateHtmlSeleneseToJava.invertAssertion(beginning);
                op = op.replaceFirst("Not", "");
            }
            if (op.equals("TextLength")) {
                middle = XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[2]) + ", \"\" + selenium.getText(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ").length()";
            } else {
                if (op.equals("Location")) {
                    return "\t\tassertTrue(selenium.isLocation(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + "));";
                }
                if (op.equals("Confirmation") || op.equals("AbsoluteLocation") || op.equals("Title")) {
                    middle = XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ", selenium.get" + op + "()";
                } else if (op.equals("Value") || op.equals("Checked") || op.equals("CursorPosition") || op.equals("Attribute") || op.equals("Text")) {
                    middle = XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[2]) + ", selenium.get" + op + "(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ")";
                } else if (op.equals("Alert") || op.equals("Prompt")) {
                    middle = XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ", selenium.get" + op + "()";
                } else if (op.equals("Expression")) {
                    middle = XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ", " + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[2]);
                } else {
                    if (op.equals("ErrorOnNext") || op.equals("FailureOnNext")) {
                        String t = "these line-spanning ops should be handled by the caller: " + oldLine;
                        if (dontThrowOnTranslationDifficulties) {
                            return "// " + t;
                        }
                        throw new RuntimeException(t);
                    }
                    if (op.equals("Selected") || op.equals("ValueRepeated") || op.equals("modalDialogTest")) {
                        return "// skipped undocumented " + oldLine;
                    }
                    if (op.equals("SelectOptions") || op.equals("SelectedOptions")) {
                        String tmpArrayVarName = XlateHtmlSeleneseToJava.newTmpName();
                        beginning = "\t\t" + XlateHtmlSeleneseToJava.declareAndInitArray(tmpArrayVarName, tokens[2]) + "\n" + beginning;
                        middle = tmpArrayVarName + ", selenium.get" + op + "(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ")";
                    } else if (op.equals("Table")) {
                        middle = XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[2]) + ", selenium.get" + op + "(" + XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[1]) + ")";
                    } else {
                        String possibleInversion = "";
                        if (op.indexOf("Not") != -1) {
                            possibleInversion = "!";
                            op = op.replaceFirst("Not", "");
                        }
                        return "\t\tassertTrue(" + possibleInversion + "selenium.is" + op + "());";
                    }
                }
            }
            return beginning + middle + ending;
        }
        if (op.equals("pause")) {
            return beginning + op + "(" + tokens[1] + ")" + ending;
        }
        if (op.equals("modalDialogTest") || op.equals("ValueRepeated")) {
            return "// skipped undocumented, unsupported op in " + oldLine;
        }
        if (op.equals("open")) {
            XlateHtmlSeleneseToJava.recordFirstDomain(tokens[1]);
        }
        int expectedArgCount = 2;
        if (op.equals("open") || op.equals("answerOnNextPrompt") || op.equals("click") || op.equals("check") || op.equals("selectWindow") || op.equals("submit") || op.equals("uncheck") || op.equals("answerOnNextPrompt")) {
            expectedArgCount = 1;
        } else if (op.equals("chooseCancelOnNextConfirmation") || op.equals("close") || op.equals("refresh") || op.equals("goBack")) {
            expectedArgCount = 0;
        }
        return beginning + XlateHtmlSeleneseToJava.XlateSeleneseStatementDefault(expectedArgCount, "selenium", tokens) + ending;
    }

    private static void recordFirstDomain(String urlToOpen) {
        if (domain != null) {
            return;
        }
        if (urlToOpen.indexOf("//") == -1) {
            return;
        }
        domain = urlToOpen.replaceFirst("://", ":::").replaceFirst("/.*", "").replaceFirst("\\?.*", "").replaceFirst(":::", "://");
    }

    private static String declareAndInitArray(String name, String commaSeparatedValue) {
        String DIVIDER = ">>>>>>>><<<<<>>>>>>";
        commaSeparatedValue = commaSeparatedValue.replaceAll("([^\\\\]),", "$1" + DIVIDER);
        boolean trailingEmptyValue = false;
        String BOGUS_EXTRA_VALUE_SO_SPLIT_WILL_ALLOCATE_FINAL_ENTRY = "dummy";
        if (commaSeparatedValue.lastIndexOf(DIVIDER) == commaSeparatedValue.length() - DIVIDER.length()) {
            trailingEmptyValue = true;
            commaSeparatedValue = commaSeparatedValue + BOGUS_EXTRA_VALUE_SO_SPLIT_WILL_ALLOCATE_FINAL_ENTRY;
        }
        String[] vals = commaSeparatedValue.split(DIVIDER);
        if (trailingEmptyValue) {
            vals[vals.length - 1] = "";
        }
        String declaration = "String[] " + name + " = {";
        for (int j = 0; j < vals.length; ++j) {
            if (j > 0) {
                declaration = declaration + ", ";
            }
            declaration = declaration + "\"" + vals[j] + "\"";
        }
        declaration = declaration + "};";
        return declaration;
    }

    private static String newTmpName() {
        return "tmp" + varNameSeed++;
    }

    private static String invertAssertion(String s) {
        if (s.indexOf("Equals") != -1) {
            return s.replaceFirst("Equals", "NotEquals");
        }
        return s.replaceFirst("True", "False");
    }

    private static String[] getValuesOrBlankStrings(String[] splitTokens) {
        String[] valuesOrBlankStrings = new String[]{"", "", ""};
        valuesOrBlankStrings[0] = splitTokens[0];
        valuesOrBlankStrings[1] = splitTokens.length > 1 ? splitTokens[1] : "";
        valuesOrBlankStrings[2] = splitTokens.length > 2 ? splitTokens[2] : "";
        return valuesOrBlankStrings;
    }

    protected static String quote(String value) {
        return "\"" + value.replaceAll("\"", "\\\"") + "\"";
    }

    private static String XlateSeleneseStatementDefault(int expectedArgCount, String objName, String[] tokens) {
        StringBuffer sb = new StringBuffer(objName);
        sb.append(".").append(tokens[0]).append("(").append(XlateHtmlSeleneseToJava.XlateSeleneseArguments(expectedArgCount, tokens)).append(")");
        return sb.toString();
    }

    private static String XlateSeleneseArguments(int expectedArgCount, String[] tokens) {
        StringBuffer sb = new StringBuffer();
        for (int j = 1; j < tokens.length && j <= expectedArgCount; ++j) {
            if (j > 1) {
                sb.append(", ");
            }
            sb.append(XlateHtmlSeleneseToJava.XlateSeleneseArgument(tokens[j]));
        }
        return sb.toString();
    }

    private static String XlateSeleneseArgument(String oldArg) {
        String arg = oldArg.replaceAll("\"", "\\\\\"");
        arg = arg.replaceFirst("^", "\"");
        if ((arg = arg.replaceFirst("$", "\"")).startsWith("\"javascript{")) {
            arg = arg.replaceFirst("^\"javascript\\{(.*)\\}\"$", "$1");
            arg = arg.replaceAll("storedVars\\['(.*?)'\\]", "\" + $1 + \"");
            arg = "selenium.getEval(\"" + arg + "\")";
        }
        arg = arg.replaceAll("\\$\\{(.*?)}", "\" + $1 + \"");
        arg = arg.replaceAll(" \\+ \"\"", "");
        arg = arg.replaceAll("\"\" \\+ ", "");
        return arg;
    }

    private static String ReadFileContents(File f) throws IOException {
        int c;
        FileReader input = new FileReader(f);
        StringBuffer sb = new StringBuffer();
        while ((c = input.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private static File openFile(String fileName) {
        File f = new File(fileName);
        return f;
    }

    private static void Usage(String errorMessage) {
        System.err.println(errorMessage + "\nUsage: XlateHtmlSeleneseToJava [-suite] [-silent] [seleneseJavaFileNameDirectory] [-dir seleneseHtmlDirName] [seleneseHtmlFileName1 seleneseHtmlFileName2 ...] \n" + "e.g., XlateHtmlSeleneseToJava a/b/c x/y/z/seleneseTestCase.html" + "will take x/y/z/seleneseTestCase.html as its input and produce as its output an equivalent Java" + "class at a/b/c/seleneseTestCase.java.");
        System.exit(-1);
    }

    static {
        silentMode = false;
        dontThrowOnTranslationDifficulties = false;
    }
}

