/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class InternetExplorerCustomProxyLauncher
implements BrowserLauncher {
    private static final String REG_KEY_SELENIUM_FOLDER = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\";
    private static final String REG_KEY_BACKUP_READY = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\BackupReady";
    private static final String REG_KEY_BACKUP_AUTOCONFIG_URL = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\AutoConfigURL";
    private static final String REG_KEY_BACKUP_AUTOPROXY_RESULT_CACHE = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\EnableAutoproxyResultCache";
    private static final String REG_KEY_BACKUP_POPUP_MGR = "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\PopupMgr";
    private static final String REG_KEY_POPUP_MGR = "HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\New Windows\\PopupMgr";
    private static final String REG_KEY_AUTOCONFIG_URL = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\AutoConfigURL";
    private static final String REG_KEY_AUTOPROXY_RESULT_CACHE = "HKEY_CURRENT_USER\\Software\\Policies\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\EnableAutoproxyResultCache";
    private static final RegKeyBackup[] keys = new RegKeyBackup[]{new RegKeyBackup("HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\New Windows\\PopupMgr", "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\PopupMgr", String.class), new RegKeyBackup("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\AutoConfigURL", "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\AutoConfigURL", String.class), new RegKeyBackup("HKEY_CURRENT_USER\\Software\\Policies\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\EnableAutoproxyResultCache", "HKEY_CURRENT_USER\\Software\\Selenium\\RemoteControl\\EnableAutoproxyResultCache", Boolean.TYPE)};
    private int port = 8180;
    private String sessionId;
    private File customProxyPACDir;
    private String[] cmdarray;
    private String commandPath;
    private Process process;

    public InternetExplorerCustomProxyLauncher() {
        this.commandPath = InternetExplorerCustomProxyLauncher.findBrowserLaunchLocation();
    }

    public InternetExplorerCustomProxyLauncher(int port, String sessionId) {
        this.commandPath = InternetExplorerCustomProxyLauncher.findBrowserLaunchLocation();
        this.port = port;
        this.sessionId = sessionId;
    }

    public InternetExplorerCustomProxyLauncher(int port, String sessionId, String browserLaunchLocation) {
        this.commandPath = browserLaunchLocation;
        this.port = port;
        this.sessionId = sessionId;
    }

    private static String findBrowserLaunchLocation() {
        File defaultLocation;
        String defaultPath = System.getProperty("internetExplorerDefaultPath");
        if (defaultPath == null) {
            defaultPath = WindowsUtils.getProgramFilesPath() + "\\Internet Explorer\\iexplore.exe";
        }
        if ((defaultLocation = new File(defaultPath)).exists()) {
            return defaultLocation.getAbsolutePath();
        }
        File iexploreEXE = AsyncExecute.whichExec("iexplore.exe");
        if (iexploreEXE != null) {
            return iexploreEXE.getAbsolutePath();
        }
        throw new RuntimeException("Internet Explorer couldn't be found in the path!\nPlease add the directory containing iexplore.exe to your PATH environment\nvariable, or explicitly specify a path to IE like this:\n*iexplore c:\\blah\\iexplore.exe");
    }

    public void launch(String url) {
        try {
            this.changeRegistrySettings();
            this.cmdarray = new String[]{this.commandPath, "-new", url};
            System.out.println("Launching Internet Explorer...");
            AsyncExecute exe = new AsyncExecute();
            exe.setCommandline(this.cmdarray);
            this.process = exe.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void changeRegistrySettings() throws IOException {
        this.customProxyPACDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        if (this.customProxyPACDir.exists()) {
            LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
        }
        this.customProxyPACDir.mkdir();
        File proxyPAC = new File(this.customProxyPACDir, "proxy.pac");
        PrintStream out = new PrintStream(new FileOutputStream(proxyPAC));
        out.println("function FindProxyForURL(url, host) {");
        out.println("   if(shExpMatch(url, '*/selenium-server/*')) {");
        out.println("       return 'PROXY localhost:" + Integer.toString(this.port) + "; DIRECT'");
        out.println("   }");
        out.println("}");
        out.close();
        this.backupRegistrySettings();
        System.out.println("Modifying registry settings...");
        String newURL = "file://" + proxyPAC.getAbsolutePath().replace('\\', '/');
        WindowsUtils.writeStringRegistryValue(REG_KEY_AUTOCONFIG_URL, newURL);
        WindowsUtils.writeBooleanRegistryValue(REG_KEY_AUTOPROXY_RESULT_CACHE, false);
        WindowsUtils.writeStringRegistryValue(REG_KEY_POPUP_MGR, "no");
    }

    public void backupRegistrySettings() {
        if (this.backupIsReady()) {
            return;
        }
        System.out.println("Backing up registry settings...");
        for (int i = 0; i < keys.length; ++i) {
            InternetExplorerCustomProxyLauncher.keys[i].backup();
        }
        this.backupReady(true);
    }

    public void restoreRegistrySettings() {
        if (!this.backupIsReady()) {
            return;
        }
        System.out.println("Restoring registry settings (won't affect running browsers)...");
        for (int i = 0; i < keys.length; ++i) {
            InternetExplorerCustomProxyLauncher.keys[i].restore();
        }
        this.backupReady(false);
    }

    private boolean backupIsReady() {
        if (!WindowsUtils.doesRegistryValueExist(REG_KEY_BACKUP_READY)) {
            return false;
        }
        return WindowsUtils.readBooleanRegistryValue(REG_KEY_BACKUP_READY);
    }

    private void backupReady(boolean backupReady) {
        WindowsUtils.writeBooleanRegistryValue(REG_KEY_BACKUP_READY, backupReady);
    }

    public void close() {
        Throwable taskKillException = null;
        this.restoreRegistrySettings();
        this.process.destroy();
        try {
            LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
        }
        catch (RuntimeException e) {
            if (taskKillException != null) {
                e.printStackTrace();
                System.err.print("Perhaps caused by: ");
                taskKillException.printStackTrace();
                throw new RuntimeException("Couldn't delete custom IE proxy directory, presumably because task kill failed; see stderr!", e);
            }
            throw e;
        }
    }

    public static void main(String[] args) {
        InternetExplorerCustomProxyLauncher l = new InternetExplorerCustomProxyLauncher(4444, "CUSTIE");
        l.launch("http://www.google.com/");
        int seconds = 5;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight(seconds * 1000);
        l.close();
        System.out.println("He's dead now, right?");
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl));
    }

    public void launchRemoteSession(String browserURL) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId));
    }

    private static class RegKeyBackup {
        private String keyOriginal;
        private String keyBackup;
        private Class type;

        public RegKeyBackup(String keyOriginal, String keyBackup, Class type) {
            this.keyOriginal = keyOriginal;
            this.keyBackup = keyBackup;
            this.type = type;
        }

        private boolean backupExists() {
            return WindowsUtils.doesRegistryValueExist(this.keyBackup);
        }

        private boolean originalExists() {
            return WindowsUtils.doesRegistryValueExist(this.keyOriginal);
        }

        private void backup() {
            if (this.originalExists()) {
                this.copy(this.keyOriginal, this.keyBackup);
            } else {
                this.clear(this.keyBackup);
            }
        }

        private void restore() {
            if (this.backupExists()) {
                this.copy(this.keyBackup, this.keyOriginal);
            } else {
                this.clear(this.keyOriginal);
            }
        }

        private void clear(String key) {
            if (WindowsUtils.doesRegistryValueExist(key)) {
                WindowsUtils.deleteRegistryValue(key);
            }
        }

        private void copy(String source, String dest) {
            if (this.type.equals(class$java$lang$String == null ? (class$java$lang$String = InternetExplorerCustomProxyLauncher.class$("java.lang.String")) : class$java$lang$String)) {
                this.copyString(source, dest);
                return;
            }
            if (this.type.equals(Boolean.TYPE)) {
                this.copyBoolean(source, dest);
                return;
            }
            if (this.type.equals(Integer.TYPE)) {
                this.copyInt(source, dest);
                return;
            }
            throw new RuntimeException("Bad type: " + this.type.getName());
        }

        private void copyString(String source, String dest) {
            String data = WindowsUtils.readStringRegistryValue(source);
            WindowsUtils.writeStringRegistryValue(dest, data);
        }

        private void copyBoolean(String source, String dest) {
            boolean data = WindowsUtils.readBooleanRegistryValue(source);
            WindowsUtils.writeBooleanRegistryValue(dest, data);
        }

        private void copyInt(String source, String dest) {
            int data = WindowsUtils.readIntRegistryValue(source);
            WindowsUtils.writeIntRegistryValue(dest, data);
        }
    }
}

