/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Path;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class AsyncExecute
extends Execute {
    File workingDirectory;
    Project project = new Project();
    boolean useVMLauncher = true;

    public static void sleepTight(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Process asyncSpawn() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = AsyncExecute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        if (Os.isFamily("windows")) {
            AsyncExecute.sleepTight(1000L);
        }
        OutputStream dummyOut = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        PumpStreamHandler streamHandler = new PumpStreamHandler(dummyOut);
        streamHandler.setProcessErrorStream(process.getErrorStream());
        streamHandler.setProcessOutputStream(process.getInputStream());
        streamHandler.start();
        process.getOutputStream().close();
        this.project.log("spawned process " + process.toString(), 3);
        return process;
    }

    public static boolean isAlive(Process p) {
        try {
            p.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    public static int waitForProcessDeath(Process p, long timeout) {
        InterruptedException ie;
        ProcessWaiter pw = new ProcessWaiter(p);
        Thread waiter = new Thread(pw);
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for process", e);
        }
        if (waiter.isAlive()) {
            waiter.interrupt();
        }
        if ((ie = pw.getException()) != null) {
            throw new RuntimeException("Timeout waiting for process to die", ie);
        }
        return p.exitValue();
    }

    public static File whichExec(String exec) {
        Path p = null;
        String pathStr = WindowsUtils.getPath();
        if (pathStr != null) {
            p = new Path(new Project(), pathStr);
        }
        if (p != null) {
            String[] dirs = p.list();
            for (int i = 0; i < dirs.length; ++i) {
                File executableFile = new File(dirs[i], exec);
                if (!executableFile.exists()) continue;
                return executableFile;
            }
        }
        return null;
    }

    private static class ProcessWaiter
    implements Runnable {
        private InterruptedException t;
        private Process p;

        public InterruptedException getException() {
            return this.t;
        }

        public ProcessWaiter(Process p) {
            this.p = p;
        }

        public void run() {
            try {
                this.p.waitFor();
            }
            catch (InterruptedException e) {
                this.t = e;
            }
        }
    }
}

