package Bio::Palantir::Parser::Domain;
# ABSTRACT: BiosynML DTD-derived internal class
$Bio::Palantir::Parser::Domain::VERSION = '0.201670';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);
use Data::UUID;

use aliased 'Bio::Palantir::Parser::Motif';
use aliased 'Bio::Palantir::Parser::Location';


# private attributes
has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);


has 'uui' => (
    is       => 'ro',
    isa      => 'Str',
    init_arg => undef,
    default  => sub {
        my $self = shift;
        my $ug = Data::UUID->new;
        my $uui = $ug->create_str();    
        return $uui;
    }
);

has 'rank' => (
    is      => 'ro',
    isa     => 'Num',
	default => -1,
	writer  => '_set_rank',
);

has 'monomer' => (
    is       => 'ro',
    isa      => 'Maybe[Str]',
    init_arg => undef,
    writer   => '_set_monomer',
);


# public array(s) of composed objects


has 'motifs' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::Palantir::Parser::Motif]',
    handles  => {
         count_motifs => 'count',
           all_motifs => 'elements',
           get_motif  => 'get',
          next_motif  => 'shift',        
    },
);


## no critic (ProhibitUnusedPrivateSubroutines)


## use critic



# public composed object(s)


has 'gene_locations' => (
    is       => 'ro',
    isa      => 'Bio::Palantir::Parser::Location',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_gene_locations',
	handles  => {
		              dna_begin => 'dna_begin',
		                dna_end => 'dna_end',
		               dna_size => 'dna_size',
                dna_coordinates => 'dna_coordinates',
	},
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_gene_locations {
    my $self = shift;
    return Location->new(
        _root => $self->_root->{location}->{gene}->{position}
    );
}

# use critic


has 'protein_locations' => (
    is       => 'ro',
    isa      => 'Bio::Palantir::Parser::Location',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_protein_locations',
	handles  => {
		              begin => 'dna_begin',
		                end => 'dna_end',
		               size => 'dna_size',
                coordinates => 'dna_coordinates',
	},
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_protein_locations {
    my $self = shift;
    return Location->new(
        _root => $self->_root->{location}->{protein}->{position}
    );
}

# use critic


# public deep methods


sub protein_sequence {
    return shift->_root->{'location'}->{'protein'}->{'sequence'}->{'value'}
}


sub protein_name {
    return shift->_root->{'location'}->{'protein'}->{'name'}->{'value'}
}


# public methods


sub nodeid {
    return shift->_root->{'nodeid'}->{'value'} // 'NA'
}


sub function {
    return shift->_root->{'function'}->{'value'} // 'NA'
}


sub subtype {
    return shift->_root->{'subtype'}->{'value'} // 'NA'
}


sub dstatus {
    return shift->_root->{'dstatus'}->{'value'} // 'NA'
}


sub label {
    return shift->_root->{'label'}->{'value'} // 'NA'
}


sub chemistry {
    return shift->_root->{'chemistry'}->{'value'} // 'NA'
}


sub substrate {
    return shift->_root->{'substrate'}->{'value'} // 'NA'
}

with 'Bio::Palantir::Roles::Domainable';

# public aliases


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::Palantir::Parser::Domain - BiosynML DTD-derived internal class

=head1 VERSION

version 0.201670

=head1 SYNOPSIS

    # TODO

=head1 DESCRIPTION

    # TODO

=head1 ATTRIBUTES

=head2 motifs

ArrayRef of L<Bio::Palantir::Parser::Motif>

=head2 gene_locations

L<Bio::Palantir::Parser::Location> composed object

=head2 protein_locations

L<Bio::Palantir::Parser::Location> composed object

=head1 METHODS

=head2 count_motifs

Returns the number of Motifs of the Domain.

    # $domain is a Bio::Palantir::Parser::Domain
    my $count = $domain->count_motifs;

This method does not accept any arguments.

=head2 all_motifs

Returns all the Motifs of the Domain (not an array reference).

    # $domain is a Bio::Palantir::Parser::Domain
    my @motifs = $domain->all_motifs;

This method does not accept any arguments.

=head2 get_motif

Returns one Motif of the Domain by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Motif does not exist, this method will return C<undef>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $motif = $domain->get_motif($index);
    croak "Motif $index not found!" unless defined $motif;

This method accepts just one argument (and not an array slice).

=head2 next_motif

Shifts the first Motif of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Motifs in
the array, returns C<undef>.

    # $domain is a Bio::Palantir::Parser::Domain
    while (my $motif = $domain->next_motif) {
        # process $motif
        # ...
    }

This method does not accept any arguments.

=head2 protein_sequence

Returns the value of the element C<<location}->{protein}->{sequence>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $protein_sequence = $domain->protein_sequence;

This method does not accept any arguments.

=head2 protein_name

Returns the value of the element C<<location}->{protein}->{name>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $protein_name = $domain->protein_name;

This method does not accept any arguments.

=head2 nodeid

Returns the value of the element C<<nodeid>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $nodeid = $domain->nodeid;

This method does not accept any arguments.

=head2 function

Returns the value of the element C<<function>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $function = $domain->function;

This method does not accept any arguments.

=head2 subtype

Returns the value of the element C<<subtype>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $subtype = $domain->subtype;

This method does not accept any arguments.

=head2 dstatus

Returns the value of the element C<<dstatus>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $dstatus = $domain->dstatus;

This method does not accept any arguments.

=head2 label

Returns the value of the element C<<label>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $label = $domain->label;

This method does not accept any arguments.

=head2 chemistry

Returns the value of the element C<<chemistry>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $chemistry = $domain->chemistry;

This method does not accept any arguments.

=head2 substrate

Returns the value of the element C<<substrate>>.

    # $domain is a Bio::Palantir::Parser::Domain
    my $substrate = $domain->substrate;

This method does not accept any arguments.

=head1 AUTHOR

Loic MEUNIER <lmeunier@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by University of Liege / Unit of Eukaryotic Phylogenomics / Loic MEUNIER and Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
