# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.37
#
# Don't modify this file, modify the SWIG interface instead.

package Math::GSL::Poly;
use base qw(Exporter);
use base qw(DynaLoader);
package Math::GSL::Polyc;
bootstrap Math::GSL::Poly;
package Math::GSL::Poly;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Math::GSL::Poly;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::Poly;

*gsl_log1p = *Math::GSL::Polyc::gsl_log1p;
*gsl_expm1 = *Math::GSL::Polyc::gsl_expm1;
*gsl_hypot = *Math::GSL::Polyc::gsl_hypot;
*gsl_hypot3 = *Math::GSL::Polyc::gsl_hypot3;
*gsl_acosh = *Math::GSL::Polyc::gsl_acosh;
*gsl_asinh = *Math::GSL::Polyc::gsl_asinh;
*gsl_atanh = *Math::GSL::Polyc::gsl_atanh;
*gsl_isnan = *Math::GSL::Polyc::gsl_isnan;
*gsl_isinf = *Math::GSL::Polyc::gsl_isinf;
*gsl_finite = *Math::GSL::Polyc::gsl_finite;
*gsl_nan = *Math::GSL::Polyc::gsl_nan;
*gsl_posinf = *Math::GSL::Polyc::gsl_posinf;
*gsl_neginf = *Math::GSL::Polyc::gsl_neginf;
*gsl_fdiv = *Math::GSL::Polyc::gsl_fdiv;
*gsl_coerce_double = *Math::GSL::Polyc::gsl_coerce_double;
*gsl_coerce_float = *Math::GSL::Polyc::gsl_coerce_float;
*gsl_coerce_long_double = *Math::GSL::Polyc::gsl_coerce_long_double;
*gsl_ldexp = *Math::GSL::Polyc::gsl_ldexp;
*gsl_frexp = *Math::GSL::Polyc::gsl_frexp;
*gsl_fcmp = *Math::GSL::Polyc::gsl_fcmp;
*gsl_poly_eval = *Math::GSL::Polyc::gsl_poly_eval;
*gsl_poly_complex_eval = *Math::GSL::Polyc::gsl_poly_complex_eval;
*gsl_complex_poly_complex_eval = *Math::GSL::Polyc::gsl_complex_poly_complex_eval;
*gsl_poly_dd_init = *Math::GSL::Polyc::gsl_poly_dd_init;
*gsl_poly_dd_eval = *Math::GSL::Polyc::gsl_poly_dd_eval;
*gsl_poly_dd_taylor = *Math::GSL::Polyc::gsl_poly_dd_taylor;
*gsl_poly_solve_quadratic = *Math::GSL::Polyc::gsl_poly_solve_quadratic;
*gsl_poly_complex_solve_quadratic = *Math::GSL::Polyc::gsl_poly_complex_solve_quadratic;
*gsl_poly_solve_cubic = *Math::GSL::Polyc::gsl_poly_solve_cubic;
*gsl_poly_complex_solve_cubic = *Math::GSL::Polyc::gsl_poly_complex_solve_cubic;
*gsl_poly_complex_workspace_alloc = *Math::GSL::Polyc::gsl_poly_complex_workspace_alloc;
*gsl_poly_complex_workspace_free = *Math::GSL::Polyc::gsl_poly_complex_workspace_free;
*gsl_poly_complex_solve = *Math::GSL::Polyc::gsl_poly_complex_solve;
*gsl_complex_rect = *Math::GSL::Polyc::gsl_complex_rect;
*gsl_complex_polar = *Math::GSL::Polyc::gsl_complex_polar;
*gsl_complex_arg = *Math::GSL::Polyc::gsl_complex_arg;
*gsl_complex_abs = *Math::GSL::Polyc::gsl_complex_abs;
*gsl_complex_abs2 = *Math::GSL::Polyc::gsl_complex_abs2;
*gsl_complex_logabs = *Math::GSL::Polyc::gsl_complex_logabs;
*gsl_complex_add = *Math::GSL::Polyc::gsl_complex_add;
*gsl_complex_sub = *Math::GSL::Polyc::gsl_complex_sub;
*gsl_complex_mul = *Math::GSL::Polyc::gsl_complex_mul;
*gsl_complex_div = *Math::GSL::Polyc::gsl_complex_div;
*gsl_complex_add_real = *Math::GSL::Polyc::gsl_complex_add_real;
*gsl_complex_sub_real = *Math::GSL::Polyc::gsl_complex_sub_real;
*gsl_complex_mul_real = *Math::GSL::Polyc::gsl_complex_mul_real;
*gsl_complex_div_real = *Math::GSL::Polyc::gsl_complex_div_real;
*gsl_complex_add_imag = *Math::GSL::Polyc::gsl_complex_add_imag;
*gsl_complex_sub_imag = *Math::GSL::Polyc::gsl_complex_sub_imag;
*gsl_complex_mul_imag = *Math::GSL::Polyc::gsl_complex_mul_imag;
*gsl_complex_div_imag = *Math::GSL::Polyc::gsl_complex_div_imag;
*gsl_complex_conjugate = *Math::GSL::Polyc::gsl_complex_conjugate;
*gsl_complex_inverse = *Math::GSL::Polyc::gsl_complex_inverse;
*gsl_complex_negative = *Math::GSL::Polyc::gsl_complex_negative;
*gsl_complex_sqrt = *Math::GSL::Polyc::gsl_complex_sqrt;
*gsl_complex_sqrt_real = *Math::GSL::Polyc::gsl_complex_sqrt_real;
*gsl_complex_pow = *Math::GSL::Polyc::gsl_complex_pow;
*gsl_complex_pow_real = *Math::GSL::Polyc::gsl_complex_pow_real;
*gsl_complex_exp = *Math::GSL::Polyc::gsl_complex_exp;
*gsl_complex_log = *Math::GSL::Polyc::gsl_complex_log;
*gsl_complex_log10 = *Math::GSL::Polyc::gsl_complex_log10;
*gsl_complex_log_b = *Math::GSL::Polyc::gsl_complex_log_b;
*gsl_complex_sin = *Math::GSL::Polyc::gsl_complex_sin;
*gsl_complex_cos = *Math::GSL::Polyc::gsl_complex_cos;
*gsl_complex_sec = *Math::GSL::Polyc::gsl_complex_sec;
*gsl_complex_csc = *Math::GSL::Polyc::gsl_complex_csc;
*gsl_complex_tan = *Math::GSL::Polyc::gsl_complex_tan;
*gsl_complex_cot = *Math::GSL::Polyc::gsl_complex_cot;
*gsl_complex_arcsin = *Math::GSL::Polyc::gsl_complex_arcsin;
*gsl_complex_arcsin_real = *Math::GSL::Polyc::gsl_complex_arcsin_real;
*gsl_complex_arccos = *Math::GSL::Polyc::gsl_complex_arccos;
*gsl_complex_arccos_real = *Math::GSL::Polyc::gsl_complex_arccos_real;
*gsl_complex_arcsec = *Math::GSL::Polyc::gsl_complex_arcsec;
*gsl_complex_arcsec_real = *Math::GSL::Polyc::gsl_complex_arcsec_real;
*gsl_complex_arccsc = *Math::GSL::Polyc::gsl_complex_arccsc;
*gsl_complex_arccsc_real = *Math::GSL::Polyc::gsl_complex_arccsc_real;
*gsl_complex_arctan = *Math::GSL::Polyc::gsl_complex_arctan;
*gsl_complex_arccot = *Math::GSL::Polyc::gsl_complex_arccot;
*gsl_complex_sinh = *Math::GSL::Polyc::gsl_complex_sinh;
*gsl_complex_cosh = *Math::GSL::Polyc::gsl_complex_cosh;
*gsl_complex_sech = *Math::GSL::Polyc::gsl_complex_sech;
*gsl_complex_csch = *Math::GSL::Polyc::gsl_complex_csch;
*gsl_complex_tanh = *Math::GSL::Polyc::gsl_complex_tanh;
*gsl_complex_coth = *Math::GSL::Polyc::gsl_complex_coth;
*gsl_complex_arcsinh = *Math::GSL::Polyc::gsl_complex_arcsinh;
*gsl_complex_arccosh = *Math::GSL::Polyc::gsl_complex_arccosh;
*gsl_complex_arccosh_real = *Math::GSL::Polyc::gsl_complex_arccosh_real;
*gsl_complex_arcsech = *Math::GSL::Polyc::gsl_complex_arcsech;
*gsl_complex_arccsch = *Math::GSL::Polyc::gsl_complex_arccsch;
*gsl_complex_arctanh = *Math::GSL::Polyc::gsl_complex_arctanh;
*gsl_complex_arctanh_real = *Math::GSL::Polyc::gsl_complex_arctanh_real;
*gsl_complex_arccoth = *Math::GSL::Polyc::gsl_complex_arccoth;

############# Class : Math::GSL::Poly::gsl_poly_complex_workspace ##############

package Math::GSL::Poly::gsl_poly_complex_workspace;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Poly );
%OWNER = ();
%ITERATORS = ();
*swig_nc_get = *Math::GSL::Polyc::gsl_poly_complex_workspace_nc_get;
*swig_nc_set = *Math::GSL::Polyc::gsl_poly_complex_workspace_nc_set;
*swig_matrix_get = *Math::GSL::Polyc::gsl_poly_complex_workspace_matrix_get;
*swig_matrix_set = *Math::GSL::Polyc::gsl_poly_complex_workspace_matrix_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Polyc::new_gsl_poly_complex_workspace(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Polyc::delete_gsl_poly_complex_workspace($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : Math::GSL::Poly::gsl_complex_long_double ##############

package Math::GSL::Poly::gsl_complex_long_double;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Poly );
%OWNER = ();
%ITERATORS = ();
*swig_dat_get = *Math::GSL::Polyc::gsl_complex_long_double_dat_get;
*swig_dat_set = *Math::GSL::Polyc::gsl_complex_long_double_dat_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Polyc::new_gsl_complex_long_double(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Polyc::delete_gsl_complex_long_double($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : Math::GSL::Poly::gsl_complex ##############

package Math::GSL::Poly::gsl_complex;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Poly );
%OWNER = ();
%ITERATORS = ();
*swig_dat_get = *Math::GSL::Polyc::gsl_complex_dat_get;
*swig_dat_set = *Math::GSL::Polyc::gsl_complex_dat_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Polyc::new_gsl_complex(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Polyc::delete_gsl_complex($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


############# Class : Math::GSL::Poly::gsl_complex_float ##############

package Math::GSL::Poly::gsl_complex_float;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Poly );
%OWNER = ();
%ITERATORS = ();
*swig_dat_get = *Math::GSL::Polyc::gsl_complex_float_dat_get;
*swig_dat_set = *Math::GSL::Polyc::gsl_complex_float_dat_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Polyc::new_gsl_complex_float(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Polyc::delete_gsl_complex_float($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Math::GSL::Poly;

*GSL_POSZERO = *Math::GSL::Polyc::GSL_POSZERO;
*GSL_NEGZERO = *Math::GSL::Polyc::GSL_NEGZERO;


@EXPORT_OK = qw/
                gsl_poly_eval 
                gsl_poly_complex_eval 
                gsl_complex_poly_complex_eval 
                gsl_poly_dd_init 
                gsl_poly_dd_eval 
                gsl_poly_dd_taylor 
                gsl_poly_solve_quadratic 
                gsl_poly_complex_solve_quadratic 
                gsl_poly_solve_cubic 
                gsl_poly_complex_solve_cubic 
                gsl_poly_complex_workspace_alloc 
                gsl_poly_complex_workspace_free 
                gsl_poly_complex_solve 
                $GSL_POSZERO $GSL_NEGZERO $GSL_NAN
             /;
our $GSL_NAN = gsl_nan();

%EXPORT_TAGS = ( all => \@EXPORT_OK );

__END__

=head1 NAME

Math::GSL::Poly - Functions for evaluating and solving polynomials

=head1 SYNOPSIS

use Math::GSL::Poly qw/:all/;

=head1 DESCRIPTION

Here is a list of all the functions included in this module :

=over

=item * gsl_poly_eval(@values, $length, $x) - This function evaluates a polynomial with real coefficients for the real variable $x. $length is the number of elements inside @values. The function returns a complex number. 

=item * gsl_poly_complex_eval(@values, $length, $z) - This function evaluates a polynomial with real coefficients for the complex variable $z. $length is the number of elements inside @valuesi. The function returns a complex number.    

=item * gsl_complex_poly_complex_eval(@values, $length, $z) - This function evaluates a polynomial with real coefficients for the complex variable $z. $length is the number of elements inside @values. $length is the number of elements inside @values. The function returns a complex number.

=item * gsl_poly_dd_init 

=item * gsl_poly_dd_eval 

=item * gsl_poly_dd_taylor 

=item * gsl_poly_solve_quadratic( $a, $b, $c, \$x0, \$x1) - find the real roots of the quadratic equation $a*x**2+$b*x+$c = 0, return the number of real root (either zero, one or two) and the real roots are returned by $x0, $x1 and $x2 which are deferenced.

=item * gsl_poly_complex_solve_quadratic

=item * gsl_poly_solve_cubic($a, $b, $c, \$x0, \$x1, \$x2) - find the real roots of the cubic equation x**3+$a*x**2+$b*x+$c = 0, return the number of real root (either one or three) and the real roots are returned by $x0, $x1 and $x2 which are deferenced.

=item * gsl_poly_complex_solve_cubic 

=item * gsl_poly_complex_workspace_alloc($n) - This function allocates space for a gsl_poly_complex_workspace struct and a workspace suitable for solving a polynomial with $n coefficients using the routine gsl_poly_complex_solve. 

=item * gsl_poly_complex_workspace_free($w) - This function frees all the memory associated with the workspace w. 

=item * gsl_poly_complex_solve 

=back

For more informations on the functions, we refer you to the GSL offcial documentation: 
L<http://www.gnu.org/software/gsl/manual/html_node/>

Tip : search on google: site:http://www.gnu.org/software/gsl/manual/html_node/ name_of_the_function_you_want

=head1 EXAMPLES

=over 1

=item C<use Math::GSL::Poly qw/:all/;>

=item C<my ($a,$b,$c) = (1,6,9);>

=item C<my ($x0, $x1) = (0,0);>

=item C<my $num_roots = gsl_poly_solve_quadratic( $a, $b, $c, \$x0, \$x1);>

=item C<print "${a}*x**2 + ${b}*x + $c contains $num_roots roots which are $x0 and $x1. \n";>

=back

=head1 AUTHORS

Jonathan Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 Jonathan Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
1;
