########################################################################
# module makes FindBin::Bin & ::Script available as late calls in
# in the code available.
########################################################################
########################################################################
# housekeeping
########################################################################

use v6.d;

unit module FindBin:ver<0.2.0>:auth<CPAN:lembark>;

# deal with use arguments:
#
# importing either of these tags makes the 
# corresponding Bin() option default to true when 
# Bin() is called from the importing lexical scope.

constant _FindBin_RESOLVE-DEF is export( :resolve ) = True;
constant _FindBin_VERBOSE-DEF is export( :verbose ) = True;

constant OPTION-TAGS    = |( :resolve, :verbose );

# decided once at use time, no reson to re-compute it:

constant IS-INTERACTIVE = $*PROGRAM-NAME eq '-e' | '-' | 'interactive';

################################################################
# exported (API)
################################################################

our sub Script 
(
    :$resolve is copy = CALLER::DYNAMIC::_FindBin_RESOLVE-DEF,
    :$verbose is copy = CALLER::DYNAMIC::_FindBin_VERBOSE-DEF
    --> Str
)
is export( :Script, :DEFAULT, OPTION-TAGS )
{
    if $verbose
    {
        note "# Resolve:     {?$resolve}";
        note "# Interactive: '{IS-INTERACTIVE}'";
        note "# Path:        '$*PROGRAM-NAME'";
    }

    IS-INTERACTIVE
    ?? ~$*PROGRAM-NAME
    !! $resolve
    ?? $*PROGRAM.resolve.basename
    !! $*PROGRAM.basename
}

our sub Bin
(
    :$resolve is copy = CALLER::DYNAMIC::_FindBin_RESOLVE-DEF,
    :$verbose is copy = CALLER::DYNAMIC::_FindBin_VERBOSE-DEF
    --> IO
)
is export( :Bin, :DEFAULT, OPTION-TAGS )
{
    my $bin_from
    =  IS-INTERACTIVE 
    ?? $*CWD 
    !! $*PROGRAM.IO
    ;

    my $path 
    = $resolve
    ?? $bin_from.resolve
    !! $bin_from.absolute.IO
    ;

    if $verbose
    {
        note "# Resolve:  {?$resolve}";
        note "# Bin from: '$bin_from'";
        note "# Path is:  '$path'";
    }

    $path.d
    ?? $path
    !! $path.dirname.IO
}

=finish
