package Bio::Graphics::Glyph::ex;

use strict;
use base 'Bio::Graphics::Glyph::generic';

# override draw_component to draw a crossed box rather than empty
sub draw {
  my $self = shift;
  my $gd = shift;
  my $fg = $self->fgcolor;
  my ($left,$top) = @_;
  my($x1,$y1,$x2,$y2) = $self->bounds(@_);

  #if widthless
  if($self->option('point')){
    my $arm = int($self->height/2);
    my $minx    = $x2 > $x1 ? $x1 : $x2;
    my $centerx = abs($x2 - $x1) + $minx;
    my $miny    = $y2 > $y1 ? $y1 : $y2;
    my $centery = abs($y2 - $y1) + $miny;
    $gd->line($centerx-$arm, $centery-$arm, $centerx+$arm, $centery+$arm, $fg);
    $gd->line($centerx-$arm, $centery+$arm, $centerx+$arm, $centery-$arm, $fg);
    return;
  } else {
    $gd->line($x1,$y1,$x2,$y2,$fg);
    $gd->line($x1,$y2,$x2,$y1,$fg);
  }

  $self->draw_label($gd,$x1,$y1-$self->height) if $self->option('label');
}


1;

__END__

=head1 NAME

Bio::Graphics::Glyph::crossbox - The "crossbox" glyph

=head1 SYNOPSIS

  See L<Bio::Graphics::Panel> and L<Bio::Graphics::Glyph>.

=head1 DESCRIPTION

This is a box with an 'X' inside glyph.

=head2 OPTIONS


The following options are standard among all Glyphs.  See
L<Bio::Graphics::Glyph> for a full explanation.

  Option      Description                      Default
  ------      -----------                      -------

  -fgcolor      Foreground color	       black

  -outlinecolor	Synonym for -fgcolor

  -bgcolor      Background color               turquoise

  -fillcolor    Synonym for -bgcolor

  -linewidth    Line width                     1

  -height       Height of glyph		       10

  -font         Glyph font		       gdSmallFont

  -connector    Connector type                 0 (false)

  -connector_color
                Connector color                black

  -label        Whether to draw a label	       0 (false)

  -description  Whether to draw a description  0 (false)

=head1 BUGS

Please report them.

=head1 SEE ALSO

L<Ace::Sequence>, L<Ace::Sequence::Feature>, L<Bio::Graphics::Panel>,
L<Bio::Graphics::Track>, L<Bio::Graphics::Glyph::anchored_arrow>,
L<Bio::Graphics::Glyph::arrow>,
L<Bio::Graphics::Glyph::box>,
L<Bio::Graphics::Glyph::primers>,
L<Bio::Graphics::Glyph::segments>,
L<Bio::Graphics::Glyph::toomany>,
L<Bio::Graphics::Glyph::transcript>,

=head1 AUTHOR

Allen Day <day@cshl.org>.

Copyright (c) 2001 Cold Spring Harbor Laboratory

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.  See DISCLAIMER.txt for
disclaimers of warranty.

=cut
