package Monitoring::GLPlugin::SNMP::MibsAndOids::LIEBERTGPENVIRONMENTALMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'LIEBERT-GP-ENVIRONMENTAL-MIB'} = {
  url => '',
  name => 'LIEBERT-GP-ENVIRONMENTAL-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'LIEBERT-GP-ENVIRONMENTAL-MIB'} = '1.3.6.1.4.1.476.1.42.3.4';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'LIEBERT-GP-ENVIRONMENTAL-MIB'} = {
  liebertGlobalProductsEnvironmentalModule => '1.3.6.1.4.1.476.1.42.1.5.1',
  lgpEnvTemperature => '1.3.6.1.4.1.476.1.42.3.4.1',
  lgpEnvTemperatureWellKnown => '1.3.6.1.4.1.476.1.42.3.4.1.1',
  lgpEnvControlTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.1',
  lgpEnvReturnAirTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.2',
  lgpEnvSupplyAirTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.3',
  lgpAmbientTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.4',
  lgpInverterTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.5',
  lgpBatteryTempterature => '1.3.6.1.4.1.476.1.42.3.4.1.1.6',
  lgpAcDcConverterTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.7',
  lgpPfcTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.8',
  lgpTransformerTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.9',
  lgpLocalTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.10',
  lgpLocal1Temperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.10.1',
  lgpLocal2Temperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.10.2',
  lgpLocal3Temperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.10.3',
  lgpDigitalScrollCompressorTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.11',
  lgpDigitalScrollCompressor1Temperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.11.1',
  lgpDigitalScrollCompressor2Temperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.11.2',
  lgpChillWaterTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.12',
  lgpCoolantTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.13',
  lgpEnvEnclosureTemperatureSensors => '1.3.6.1.4.1.476.1.42.3.4.1.1.14',
  lgpEnvEnclosureTemperatureSensor1 => '1.3.6.1.4.1.476.1.42.3.4.1.1.14.1',
  lgpEnvEnclosureTemperatureSensor2 => '1.3.6.1.4.1.476.1.42.3.4.1.1.14.2',
  lgpEnvEnclosureTemperatureSensor3 => '1.3.6.1.4.1.476.1.42.3.4.1.1.14.3',
  lgpEnvEnclosureTemperatureSensor4 => '1.3.6.1.4.1.476.1.42.3.4.1.1.14.4',
  lgpEnvValueAmbientRoomTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.15',
  lgpEnvDewPointTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.16',
  lgpEnvEnclosureTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.17',
  lgpEnvAdjustedTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.18',
  lgpEnvExternalSensors => '1.3.6.1.4.1.476.1.42.3.4.1.1.19',
  lgpEnvExternalAirSensorA => '1.3.6.1.4.1.476.1.42.3.4.1.1.19.1',
  lgpEnvExternalAirSensorADewPoint => '1.3.6.1.4.1.476.1.42.3.4.1.1.19.2',
  lgpEnvExternalAirSensorB => '1.3.6.1.4.1.476.1.42.3.4.1.1.19.3',
  lgpEnvExternalAirSensorBDewPoint => '1.3.6.1.4.1.476.1.42.3.4.1.1.19.4',
  lgpEnvSupplyFluidTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.20',
  lgpEnvSupplyRefrigerantTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.21',
  lgpEnvMinDesiredRoomAirTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.22',
  lgpEnvDewPointTemperatures => '1.3.6.1.4.1.476.1.42.3.4.1.1.23',
  lgpEnvInletDewPointTemperature => '1.3.6.1.4.1.476.1.42.3.4.1.1.23.1',
  lgpEnvTemperatureFahrenheit => '1.3.6.1.4.1.476.1.42.3.4.1.2',
  lgpEnvTemperatureSettingDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.1',
  lgpEnvTemperatureToleranceDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.2',
  lgpEnvTemperatureTableDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3',
  lgpEnvTemperatureEntryDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1',
  lgpEnvTemperatureDegFTable => '1.3.6.1.4.1.476.1.42.3.4.1.2.3',
  lgpEnvTemperatureDegFEntry => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1',
  lgpEnvTemperatureIdDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.1',
  lgpEnvTemperatureDescrDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.2',
  lgpEnvTemperatureMeasurementDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.3',
  lgpEnvTemperatureHighThresholdDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.4',
  lgpEnvTemperatureLowThresholdDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.5',
  lgpEnvTemperatureSetPointDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.6',
  lgpEnvTemperatureDailyHighDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.7',
  lgpEnvTemperatureDailyLowDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.8',
  lgpEnvTempDailyHighTimeHourDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.9',
  lgpEnvTempDailyHighTimeMinuteDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.10',
  lgpEnvTempDailyHighTimeSecondDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.11',
  lgpEnvTempDailyLowTimeHourDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.12',
  lgpEnvTempDailyLowTimeMinuteDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.13',
  lgpEnvTempDailyLowTimeSecondDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.14',
  lgpEnvTemperatureMeasurementTenthsDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.50',
  lgpEnvTemperatureHighThresholdTenthsDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.51',
  lgpEnvTemperatureLowThresholdTenthsDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.52',
  lgpEnvTemperatureSetPointTenthsDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.53',
  lgpEnvTemperatureDeadBandTenthsDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.60',
  lgpEnvTempHeatingPropBandTenthsDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.61',
  lgpEnvTempCoolingPropBandTenthsDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.3.1.62',
  lgpEnvTemperatureDeadbandRangeDegF => '1.3.6.1.4.1.476.1.42.3.4.1.2.4',
  lgpEnvTemperatureCelsius => '1.3.6.1.4.1.476.1.42.3.4.1.3',
  lgpEnvTemperatureSettingDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.1',
  lgpEnvTemperatureToleranceDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.2',
  lgpEnvTemperatureTableDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3',
  lgpEnvTemperatureEntryDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1',
  lgpEnvTemperatureDegCTable => '1.3.6.1.4.1.476.1.42.3.4.1.3.3',
  lgpEnvTemperatureDegCEntry => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1',
  lgpEnvTemperatureIdDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.1',
  lgpEnvTemperatureDescrDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.2',
  lgpEnvTemperatureMeasurementDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.3',
  lgpEnvTemperatureHighThresholdDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.4',
  lgpEnvTemperatureLowThresholdDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.5',
  lgpEnvTemperatureSetPointDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.6',
  lgpEnvTemperatureDailyHighDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.7',
  lgpEnvTemperatureDailyLowDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.8',
  lgpEnvTempDailyHighTimeHourDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.9',
  lgpEnvTempDailyHighTimeMinuteDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.10',
  lgpEnvTempDailyHighTimeSecondDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.11',
  lgpEnvTempDailyLowTimeHourDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.12',
  lgpEnvTempDailyLowTimeMinuteDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.13',
  lgpEnvTempDailyLowTimeSecondDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.14',
  lgpEnvTemperatureMeasurementTenthsDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.50',
  lgpEnvTemperatureHighThresholdTenthsDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.51',
  lgpEnvTemperatureLowThresholdTenthsDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.52',
  lgpEnvTemperatureSetPointTenthsDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.53',
  lgpEnvTemperatureDeadBandTenthsDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.60',
  lgpEnvTempHeatingPropBandTenthsDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.61',
  lgpEnvTempCoolingPropBandTenthsDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.3.1.62',
  lgpEnvTemperatureDeadbandRangeDegC => '1.3.6.1.4.1.476.1.42.3.4.1.3.4',
  lgpEnvTemperatureControlMode => '1.3.6.1.4.1.476.1.42.3.4.1.4',
  lgpEnvHumidity => '1.3.6.1.4.1.476.1.42.3.4.2',
  lgpEnvHumidityWellKnown => '1.3.6.1.4.1.476.1.42.3.4.2.1',
  lgpEnvControlHumidity => '1.3.6.1.4.1.476.1.42.3.4.2.1.1',
  lgpEnvReturnAirHumidity => '1.3.6.1.4.1.476.1.42.3.4.2.1.2',
  lgpEnvSupplyAirHumidity => '1.3.6.1.4.1.476.1.42.3.4.2.1.3',
  lgpEnvValueAmbientHumidity => '1.3.6.1.4.1.476.1.42.3.4.2.1.4',
  lgpEnvHumidityRelative => '1.3.6.1.4.1.476.1.42.3.4.2.2',
  lgpEnvHumiditySettingRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.1',
  lgpEnvHumidityToleranceRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.2',
  lgpEnvHumidityTableRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.3',
  lgpEnvHumidityEntryRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1',
  lgpEnvHumidityRelTable => '1.3.6.1.4.1.476.1.42.3.4.2.2.3',
  lgpEnvHumidityRelEntry => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1',
  lgpEnvHumidityIdRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.1',
  lgpEnvHumidityDescrRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.2',
  lgpEnvHumidityMeasurementRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.3',
  lgpEnvHumidityHighThresholdRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.4',
  lgpEnvHumidityLowThresholdRel => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.5',
  lgpEnvHumiditySetPoint => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.6',
  lgpEnvHumidityDailyHigh => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.7',
  lgpEnvHumidityDailyLow => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.8',
  lgpEnvHumidityDailyHighTimeHour => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.9',
  lgpEnvHumidityDailyHighTimeMinute => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.10',
  lgpEnvHumidityDailyHighTimeSecond => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.11',
  lgpEnvHumidityDailyLowTimeHour => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.12',
  lgpEnvHumidityDailyLowTimeMinute => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.13',
  lgpEnvHumidityDailyLowTimeSecond => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.14',
  lgpEnvHumidityDeadBand => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.15',
  lgpEnvHumidifyPropBand => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.16',
  lgpEnvDehumidifyPropBand => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.17',
  lgpEnvHumidityMeasurementRelTenths => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.50',
  lgpEnvHumidityHighThresholdRelTenths => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.51',
  lgpEnvHumidityLowThresholdRelTenths => '1.3.6.1.4.1.476.1.42.3.4.2.2.3.1.52',
  lgpEnvHumidityDeadbandRange => '1.3.6.1.4.1.476.1.42.3.4.2.2.4',
  lgpEnvState => '1.3.6.1.4.1.476.1.42.3.4.3',
  lgpEnvStateSystem => '1.3.6.1.4.1.476.1.42.3.4.3.1',
  lgpEnvStateSystemDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateSystem',
  lgpEnvStateCooling => '1.3.6.1.4.1.476.1.42.3.4.3.2',
  lgpEnvStateCoolingDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateCooling',
  lgpEnvStateHeating => '1.3.6.1.4.1.476.1.42.3.4.3.3',
  lgpEnvStateHeatingDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateHeating',
  lgpEnvStateHumidifying => '1.3.6.1.4.1.476.1.42.3.4.3.4',
  lgpEnvStateHumidifyingDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateHumidifying',
  lgpEnvStateDehumidifying => '1.3.6.1.4.1.476.1.42.3.4.3.5',
  lgpEnvStateDehumidifyingDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateDehumidifying',
  lgpEnvStateEconoCycle => '1.3.6.1.4.1.476.1.42.3.4.3.6',
  lgpEnvStateEconoCycleDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateEconoCycle',
  lgpEnvStateFan => '1.3.6.1.4.1.476.1.42.3.4.3.7',
  lgpEnvStateFanDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateFan',
  lgpEnvStateGeneralAlarmOutput => '1.3.6.1.4.1.476.1.42.3.4.3.8',
  lgpEnvStateGeneralAlarmOutputDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateGeneralAlarmOutput',
  lgpEnvStateCoolingCapacity => '1.3.6.1.4.1.476.1.42.3.4.3.9',
  lgpEnvStateHeatingCapacity => '1.3.6.1.4.1.476.1.42.3.4.3.10',
  lgpEnvStateAudibleAlarm => '1.3.6.1.4.1.476.1.42.3.4.3.11',
  lgpEnvStateAudibleAlarmDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateAudibleAlarm',
  lgpEnvStateCoolingUnits => '1.3.6.1.4.1.476.1.42.3.4.3.12',
  lgpEnvStateCoolingUnit1 => '1.3.6.1.4.1.476.1.42.3.4.3.12.2',
  lgpEnvStateCoolingUnit1Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateCoolingUnit1',
  lgpEnvStateCoolingUnit2 => '1.3.6.1.4.1.476.1.42.3.4.3.12.3',
  lgpEnvStateCoolingUnit2Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateCoolingUnit2',
  lgpEnvStateCoolingUnit3 => '1.3.6.1.4.1.476.1.42.3.4.3.12.4',
  lgpEnvStateCoolingUnit3Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateCoolingUnit3',
  lgpEnvStateCoolingUnit4 => '1.3.6.1.4.1.476.1.42.3.4.3.12.5',
  lgpEnvStateCoolingUnit4Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateCoolingUnit4',
  lgpEnvStateHeatingUnits => '1.3.6.1.4.1.476.1.42.3.4.3.13',
  lgpEnvStateHeatingUnit1 => '1.3.6.1.4.1.476.1.42.3.4.3.13.2',
  lgpEnvStateHeatingUnit1Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateHeatingUnit1',
  lgpEnvStateHeatingUnit2 => '1.3.6.1.4.1.476.1.42.3.4.3.13.3',
  lgpEnvStateHeatingUnit2Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateHeatingUnit2',
  lgpEnvStateHeatingUnit3 => '1.3.6.1.4.1.476.1.42.3.4.3.13.4',
  lgpEnvStateHeatingUnit3Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateHeatingUnit3',
  lgpEnvStateHeatingUnit4 => '1.3.6.1.4.1.476.1.42.3.4.3.13.5',
  lgpEnvStateHeatingUnit4Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateHeatingUnit4',
  lgpEnvStateOperatingReason => '1.3.6.1.4.1.476.1.42.3.4.3.14',
  lgpEnvStateOperatingReasonDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateOperatingReason',
  lgpEnvStateOperatingMode => '1.3.6.1.4.1.476.1.42.3.4.3.15',
  lgpEnvStateOperatingModeDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateOperatingMode',
  lgpEnvStateFanCapacity => '1.3.6.1.4.1.476.1.42.3.4.3.16',
  lgpEnvStateFreeCoolingCapacity => '1.3.6.1.4.1.476.1.42.3.4.3.17',
  lgpEnvStateDehumidifyingCapacity => '1.3.6.1.4.1.476.1.42.3.4.3.18',
  lgpEnvStateHumidifyingCapacity => '1.3.6.1.4.1.476.1.42.3.4.3.19',
  lgpEnvStateFreeCooling => '1.3.6.1.4.1.476.1.42.3.4.3.20',
  lgpEnvStateFreeCoolingDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateFreeCooling',
  lgpEnvStateElectricHeater => '1.3.6.1.4.1.476.1.42.3.4.3.21',
  lgpEnvStateElectricHeaterDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateElectricHeater',
  lgpEnvStateHotWater => '1.3.6.1.4.1.476.1.42.3.4.3.22',
  lgpEnvStateHotWaterDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvStateHotWater',
  lgpEnvStateOperatingEfficiency => '1.3.6.1.4.1.476.1.42.3.4.3.23',
  lgpEnvComponentStateTable => '1.3.6.1.4.1.476.1.42.3.4.3.50',
  lgpEnvComponentStateEntry => '1.3.6.1.4.1.476.1.42.3.4.3.50.1',
  lgpEnvComponentStateIndex => '1.3.6.1.4.1.476.1.42.3.4.3.50.1.1',
  lgpEnvComponentStateDescr => '1.3.6.1.4.1.476.1.42.3.4.3.50.1.2',
  lgpEnvComponentState => '1.3.6.1.4.1.476.1.42.3.4.3.50.1.3',
  lgpEnvComponentStateDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvComponentState',
  lgpEnvValveTable => '1.3.6.1.4.1.476.1.42.3.4.3.70',
  lgpEnvValveEntry => '1.3.6.1.4.1.476.1.42.3.4.3.70.1',
  lgpEnvValveIndex => '1.3.6.1.4.1.476.1.42.3.4.3.70.1.1',
  lgpEnvValveDescr => '1.3.6.1.4.1.476.1.42.3.4.3.70.1.2',
  lgpEnvValveState => '1.3.6.1.4.1.476.1.42.3.4.3.70.1.3',
  lgpEnvValveStateDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvValveState',
  lgpEnvValvePositionTenths => '1.3.6.1.4.1.476.1.42.3.4.3.70.1.20',
  lgpEnvConfig => '1.3.6.1.4.1.476.1.42.3.4.4',
  lgpEnvConfigReheatLockout => '1.3.6.1.4.1.476.1.42.3.4.4.1',
  lgpEnvConfigReheatLockoutDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigReheatLockout',
  lgpEnvConfigHumLockout => '1.3.6.1.4.1.476.1.42.3.4.4.2',
  lgpEnvConfigHumLockoutDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigHumLockout',
  lgpEnvConfigRestartDelay => '1.3.6.1.4.1.476.1.42.3.4.4.4',
  lgpEnvConfigRemoteShutdown => '1.3.6.1.4.1.476.1.42.3.4.4.7',
  lgpEnvConfigRemoteShutdownDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigRemoteShutdown',
  lgpEnvConfigCoolingServiceInterval => '1.3.6.1.4.1.476.1.42.3.4.4.8',
  lgpEnvConfigHumidifierServiceInterval => '1.3.6.1.4.1.476.1.42.3.4.4.9',
  lgpEnvConfigFilterServiceInterval => '1.3.6.1.4.1.476.1.42.3.4.4.10',
  lgpEnvConfigSleepModeDeadbandRangeDegC => '1.3.6.1.4.1.476.1.42.3.4.4.11',
  lgpEnvConfigSleepModeDeadbandRangeDegF => '1.3.6.1.4.1.476.1.42.3.4.4.12',
  lgpEnvConfigSupplyTempLowLimitDegF => '1.3.6.1.4.1.476.1.42.3.4.4.13',
  lgpEnvConfigSupplyTempLowLimitDegC => '1.3.6.1.4.1.476.1.42.3.4.4.14',
  lgpEnvConfigTemperatureIntegTime => '1.3.6.1.4.1.476.1.42.3.4.4.15',
  lgpEnvConfigLocalTemperatureUnit => '1.3.6.1.4.1.476.1.42.3.4.4.16',
  lgpEnvConfigLocalTemperatureUnitDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigLocalTemperatureUnit',
  lgpEnvConfigSleepMode => '1.3.6.1.4.1.476.1.42.3.4.4.17',
  lgpEnvConfigSleepModeDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigSleepMode',
  lgpEnvConfigHumidityIntegTime => '1.3.6.1.4.1.476.1.42.3.4.4.18',
  lgpEnvConfigFreecoolingDeltaDegF => '1.3.6.1.4.1.476.1.42.3.4.4.19',
  lgpEnvConfigFreecoolingDeltaDegC => '1.3.6.1.4.1.476.1.42.3.4.4.20',
  lgpEnvConfigSupplyTempLowLimit => '1.3.6.1.4.1.476.1.42.3.4.4.21',
  lgpEnvConfigSupplyTempLowLimitDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigSupplyTempLowLimit',
  lgpEnvConfigSensorEventsStandard => '1.3.6.1.4.1.476.1.42.3.4.4.22',
  lgpEnvConfigSensorEventsStandardDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigSensorEventsStandard',
  lgpEnvConfigSensorEvents1 => '1.3.6.1.4.1.476.1.42.3.4.4.23',
  lgpEnvConfigSensorEvents1Definition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigSensorEvents1',
  lgpEnvConfigSleepModeDeadbandRange => '1.3.6.1.4.1.476.1.42.3.4.4.24',
  lgpEnvConfigSleepModeDeadbandRangeDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigSleepModeDeadbandRange',
  lgpEnvConfigAutoConfiguration => '1.3.6.1.4.1.476.1.42.3.4.4.25',
  lgpEnvConfigAutoConfigurationDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigAutoConfiguration',
  lgpEnvConfigDeltaGlycolType => '1.3.6.1.4.1.476.1.42.3.4.4.26',
  lgpEnvConfigDeltaGlycolTypeDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigDeltaGlycolType',
  lgpEnvConfigChillWaterControl => '1.3.6.1.4.1.476.1.42.3.4.4.27',
  lgpEnvConfigChillWaterControlDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigChillWaterControl',
  lgpEnvConfigInfaredFlushRate => '1.3.6.1.4.1.476.1.42.3.4.4.28',
  lgpEnvConfigHumidityControl => '1.3.6.1.4.1.476.1.42.3.4.4.29',
  lgpEnvConfigHumidityControlDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigHumidityControl',
  lgpEnvConfigCompressorLockout => '1.3.6.1.4.1.476.1.42.3.4.4.30',
  lgpEnvConfigCompressorLockoutDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigCompressorLockout',
  lgpEnvConfigReheatAndHumidifierLockout => '1.3.6.1.4.1.476.1.42.3.4.4.31',
  lgpEnvConfigReheatAndHumidifierLockoutDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigReheatAndHumidifierLockout',
  lgpEnvOperationalTimeTable => '1.3.6.1.4.1.476.1.42.3.4.4.32',
  lgpEnvOperationalTimeEntry => '1.3.6.1.4.1.476.1.42.3.4.4.32.1',
  lgpEnvOperationTimeIndex => '1.3.6.1.4.1.476.1.42.3.4.4.32.1.1',
  lgpEnvOperationTimePoint => '1.3.6.1.4.1.476.1.42.3.4.4.32.1.2',
  lgpEnvOperationTimeSubID => '1.3.6.1.4.1.476.1.42.3.4.4.32.1.3',
  lgpEnvOperationTimeUnit => '1.3.6.1.4.1.476.1.42.3.4.4.32.1.4',
  lgpEnvOperationTimeValue => '1.3.6.1.4.1.476.1.42.3.4.4.32.1.5',
  lgpEnvOperationTimeHighWarning => '1.3.6.1.4.1.476.1.42.3.4.4.32.1.6',
  lgpEnvConfigTempControlAlgorithm => '1.3.6.1.4.1.476.1.42.3.4.4.33',
  lgpEnvConfigTempControlAlgorithmDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigTempControlAlgorithm',
  lgpEnvConfigFanSpeedMode => '1.3.6.1.4.1.476.1.42.3.4.4.34',
  lgpEnvConfigFanSpeedModeDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigFanSpeedMode',
  lgpEnvConfigFanSpeedCapacity => '1.3.6.1.4.1.476.1.42.3.4.4.35',
  lgpEnvConfigBmsResetTimer => '1.3.6.1.4.1.476.1.42.3.4.4.36',
  lgpEnvConfigDisableSensorOffsetDegC => '1.3.6.1.4.1.476.1.42.3.4.4.37',
  lgpEnvConfigDisableSensorOffsetDegF => '1.3.6.1.4.1.476.1.42.3.4.4.38',
  lgpEnvConfigCabinetSensorAlarms => '1.3.6.1.4.1.476.1.42.3.4.4.39',
  lgpEnvConfigCabinetSensorAlarmsDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigCabinetSensorAlarms',
  lgpEnvConfigAirTemperatureControlSensor => '1.3.6.1.4.1.476.1.42.3.4.4.42',
  lgpEnvConfigAirTemperatureControlSensorDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigAirTemperatureControlSensor',
  lgpEnvConfigFanSpeedControlSensor => '1.3.6.1.4.1.476.1.42.3.4.4.43',
  lgpEnvConfigFanSpeedControlSensorDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvConfigFanSpeedControlSensor',
  lgpEnvConfigMinFanSpeed => '1.3.6.1.4.1.476.1.42.3.4.4.44',
  lgpEnvConfigMaxFanSpeed => '1.3.6.1.4.1.476.1.42.3.4.4.45',
  lgpEnvConfigFanSpeedPropBandDegC => '1.3.6.1.4.1.476.1.42.3.4.4.46',
  lgpEnvConfigFanSpeedPropBandDegF => '1.3.6.1.4.1.476.1.42.3.4.4.47',
  lgpEnvControl => '1.3.6.1.4.1.476.1.42.3.4.5',
  lgpEnvControlShutdownAfterDelay => '1.3.6.1.4.1.476.1.42.3.4.5.1',
  lgpEnvControlStartupAfterDelay => '1.3.6.1.4.1.476.1.42.3.4.5.2',
  lgpEnvSleepIntervalTimeTable => '1.3.6.1.4.1.476.1.42.3.4.5.3',
  lgpEnvSleepIntervalTimeEntry => '1.3.6.1.4.1.476.1.42.3.4.5.3.1',
  lgpEnvSleepTimeIndex => '1.3.6.1.4.1.476.1.42.3.4.5.3.1.1',
  lgpEnvSleepTimeSubID => '1.3.6.1.4.1.476.1.42.3.4.5.3.1.2',
  lgpEnvSleepTimeStartHour => '1.3.6.1.4.1.476.1.42.3.4.5.3.1.3',
  lgpEnvSleepTimeStartMinute => '1.3.6.1.4.1.476.1.42.3.4.5.3.1.4',
  lgpEnvSleepTimeStopHour => '1.3.6.1.4.1.476.1.42.3.4.5.3.1.5',
  lgpEnvSleepTimeStopMinute => '1.3.6.1.4.1.476.1.42.3.4.5.3.1.6',
  lgpEnvSleepDayTable => '1.3.6.1.4.1.476.1.42.3.4.5.4',
  lgpEnvSleepDayEntry => '1.3.6.1.4.1.476.1.42.3.4.5.4.1',
  lgpEnvSleepDayIndex => '1.3.6.1.4.1.476.1.42.3.4.5.4.1.1',
  lgpEnvSleepDay => '1.3.6.1.4.1.476.1.42.3.4.5.4.1.2',
  lgpEnvSleepDayDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvSleepDay',
  lgpEnvSleepAllDayEnabled => '1.3.6.1.4.1.476.1.42.3.4.5.4.1.3',
  lgpEnvSleepAllDayEnabledDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvSleepAllDayEnabled',
  lgpEnvStatistics => '1.3.6.1.4.1.476.1.42.3.4.6',
  lgpEnvStatisticsComp1RunHr => '1.3.6.1.4.1.476.1.42.3.4.6.1',
  lgpEnvStatisticsComp2RunHr => '1.3.6.1.4.1.476.1.42.3.4.6.2',
  lgpEnvStatisticsFanRunHr => '1.3.6.1.4.1.476.1.42.3.4.6.3',
  lgpEnvStatisticsHumRunHr => '1.3.6.1.4.1.476.1.42.3.4.6.4',
  lgpEnvStatisticsReheat1RunHr => '1.3.6.1.4.1.476.1.42.3.4.6.7',
  lgpEnvStatisticsReheat2RunHr => '1.3.6.1.4.1.476.1.42.3.4.6.8',
  lgpEnvStatisticsReheat3RunHr => '1.3.6.1.4.1.476.1.42.3.4.6.9',
  lgpEnvStatisticsCoolingModeHrs => '1.3.6.1.4.1.476.1.42.3.4.6.10',
  lgpEnvStatisticsHeatingModeHrs => '1.3.6.1.4.1.476.1.42.3.4.6.11',
  lgpEnvStatisticsHumidifyModeHrs => '1.3.6.1.4.1.476.1.42.3.4.6.12',
  lgpEnvStatisticsDehumidifyModeHrs => '1.3.6.1.4.1.476.1.42.3.4.6.13',
  lgpEnvStatisticsHotGasRunHr => '1.3.6.1.4.1.476.1.42.3.4.6.14',
  lgpEnvStatisticsHotWaterRunHr => '1.3.6.1.4.1.476.1.42.3.4.6.15',
  lgpEnvStatisticsFreeCoolRunHr => '1.3.6.1.4.1.476.1.42.3.4.6.16',
  lgpEnvStatisticsComp3RunHr => '1.3.6.1.4.1.476.1.42.3.4.6.17',
  lgpEnvStatisticsComp4RunHr => '1.3.6.1.4.1.476.1.42.3.4.6.18',
  lgpEnvPoints => '1.3.6.1.4.1.476.1.42.3.4.7',
  lgpEnvWellKnownPoints => '1.3.6.1.4.1.476.1.42.3.4.7.1',
  lgpEnvFanPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.1',
  lgpEnvCompressorPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.2',
  lgpEnvElectricHeaterPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.3',
  lgpEnvChilledWaterPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.4',
  lgpEnvHumidifierPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.5',
  lgpEnvDehumidifierPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.6',
  lgpEnvFreeCoolingPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.7',
  lgpEnvHotWaterPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.8',
  lgpEnvHotGasPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.9',
  lgpEnvBatteryCabinetPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.10',
  lgpEnvPumpPoints => '1.3.6.1.4.1.476.1.42.3.4.7.1.11',
  lgpEnvPump1Point => '1.3.6.1.4.1.476.1.42.3.4.7.1.11.1',
  lgpEnvPump2Point => '1.3.6.1.4.1.476.1.42.3.4.7.1.11.2',
  lgpEnvCompressorPoints => '1.3.6.1.4.1.476.1.42.3.4.7.1.12',
  lgpEnvCompressor1Point => '1.3.6.1.4.1.476.1.42.3.4.7.1.12.1',
  lgpEnvCompressor1APoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.12.1.1',
  lgpEnvCompressor1BPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.12.1.2',
  lgpEnvCompressor2Point => '1.3.6.1.4.1.476.1.42.3.4.7.1.12.2',
  lgpEnvCompressor2APoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.12.2.1',
  lgpEnvCompressor2BPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.12.2.2',
  lgpEnvValvePoints => '1.3.6.1.4.1.476.1.42.3.4.7.1.13',
  lgpEnvHotGasValve1Point => '1.3.6.1.4.1.476.1.42.3.4.7.1.13.1',
  lgpEnvHotGasValve2Point => '1.3.6.1.4.1.476.1.42.3.4.7.1.13.2',
  lgpEnvRemoteSensorStatisticPoints => '1.3.6.1.4.1.476.1.42.3.4.7.1.14',
  lgpEnvRemoteSensorMinimumPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.14.1',
  lgpEnvRemoteSensorMaximumPoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.14.2',
  lgpEnvRemoteSensorAveragePoint => '1.3.6.1.4.1.476.1.42.3.4.7.1.14.3',
  lgpEnvUnits => '1.3.6.1.4.1.476.1.42.3.4.8',
  lgpEnvWellKnownUnits => '1.3.6.1.4.1.476.1.42.3.4.8.1',
  lgpEnvHours => '1.3.6.1.4.1.476.1.42.3.4.8.1.1',
  lgpEnvRemoteSensors => '1.3.6.1.4.1.476.1.42.3.4.9',
  lgpEnvRemoteSensorCalc => '1.3.6.1.4.1.476.1.42.3.4.9.1',
  lgpEnvRemoteSensorCalcDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvRemoteSensorCalc',
  lgpEnvRemoteSensorTable => '1.3.6.1.4.1.476.1.42.3.4.9.10',
  lgpEnvRemoteSensorEntry => '1.3.6.1.4.1.476.1.42.3.4.9.10.1',
  lgpEnvRemoteSensorIndex => '1.3.6.1.4.1.476.1.42.3.4.9.10.1.1',
  lgpEnvRemoteSensorId => '1.3.6.1.4.1.476.1.42.3.4.9.10.1.2',
  lgpEnvRemoteSensorMode => '1.3.6.1.4.1.476.1.42.3.4.9.10.1.3',
  lgpEnvRemoteSensorModeDefinition => 'LIEBERT-GP-ENVIRONMENTAL-MIB::lgpEnvRemoteSensorMode',
  lgpEnvRemoteSensorUsrLabel => '1.3.6.1.4.1.476.1.42.3.4.9.10.1.4',
  lgpEnvRemoteSensorTempMeasurementDegF => '1.3.6.1.4.1.476.1.42.3.4.9.10.1.5',
  lgpEnvRemoteSensorTempMeasurementDegC => '1.3.6.1.4.1.476.1.42.3.4.9.10.1.6',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'LIEBERT-GP-ENVIRONMENTAL-MIB'} = {
  lgpEnvConfigReheatAndHumidifierLockout => {
    '1' => 'lockedOut',
    '2' => 'notLockedOut',
  },
  lgpEnvConfigChillWaterControl => {
    '1' => 'disabled',
    '2' => 'enabled',
  },
  lgpEnvConfigHumLockout => {
    '1' => 'lockedOut',
    '2' => 'notLockedOut',
  },
  lgpEnvConfigAirTemperatureControlSensor => {
    '1' => 'supply',
    '2' => 'remote',
    '3' => 'return',
  },
  lgpEnvConfigSupplyTempLowLimit => {
    '1' => 'disabled',
    '2' => 'enabled',
  },
  lgpEnvStateHeating => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateAudibleAlarm => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvConfigRemoteShutdown => {
    '1' => 'disabled',
    '2' => 'enabled',
  },
  lgpEnvStateDehumidifying => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvSleepAllDayEnabled => {
    '1' => 'yes',
    '2' => 'no',
  },
  lgpEnvConfigLocalTemperatureUnit => {
    '1' => 'degC',
    '2' => 'degF',
  },
  lgpEnvStateCoolingUnit2 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvConfigSensorEventsStandard => {
    '1' => 'disabled',
    '2' => 'enabled',
  },
  lgpEnvConfigSleepModeDeadbandRange => {
    '1' => 'disabled',
    '2' => 'enabled',
  },
  lgpEnvStateFreeCooling => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'start',
    '4' => 'unavailable',
  },
  lgpEnvStateHeatingUnit3 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvValveState => {
    '0' => 'not-specified',
    '1' => 'open',
    '2' => 'closed',
  },
  lgpEnvConfigDeltaGlycolType => {
    '1' => 'disabled',
    '2' => 'contact',
    '3' => 'value',
  },
  lgpEnvStateOperatingReason => {
    '1' => 'none',
    '2' => 'localUser',
    '3' => 'alarm',
    '4' => 'schedule',
    '5' => 'remoteUser',
    '6' => 'externalDevice',
    '7' => 'localDisplay',
  },
  lgpEnvSleepDay => {
    '1' => 'sunday',
    '2' => 'monday',
    '3' => 'tuesday',
    '4' => 'wednesday',
    '5' => 'thursday',
    '6' => 'friday',
    '7' => 'saturday',
  },
  lgpEnvConfigFanSpeedMode => {
    '1' => 'manual',
    '2' => 'auto',
  },
  lgpEnvStateHeatingUnit1 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateElectricHeater => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvConfigTempControlAlgorithm => {
    '1' => 'pi',
    '2' => 'pid',
    '3' => 'intelligent',
    '4' => 'proportional',
  },
  lgpEnvStateHeatingUnit4 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvConfigHumidityControl => {
    '1' => 'relative',
    '2' => 'compensated',
    '3' => 'predictive',
  },
  lgpEnvRemoteSensorCalc => {
    '1' => 'average',
    '2' => 'maximum',
  },
  lgpEnvStateCooling => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvConfigSleepMode => {
    '1' => 'enabled',
    '2' => 'disabled',
    '3' => 'auto',
  },
  lgpEnvConfigReheatLockout => {
    '1' => 'lockedOut',
    '2' => 'notLockedOut',
  },
  lgpEnvConfigFanSpeedControlSensor => {
    '1' => 'supply',
    '2' => 'remote',
    '3' => 'return',
  },
  lgpEnvStateFan => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvConfigCompressorLockout => {
    '1' => 'lockedOut',
    '2' => 'notLockedOut',
  },
  lgpEnvStateCoolingUnit1 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateEconoCycle => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateCoolingUnit4 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvConfigCabinetSensorAlarms => {
    '0' => 'disabled',
    '1' => 'enabled',
  },
  lgpEnvConfigAutoConfiguration => {
    '1' => 'disabled',
    '2' => 'enabled',
  },
  lgpEnvRemoteSensorMode => {
    '0' => 'disable',
    '1' => 'reference',
    '2' => 'control',
  },
  lgpEnvComponentState => {
    '0' => 'not-specified',
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateHumidifying => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateHeatingUnit2 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateCoolingUnit3 => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateOperatingMode => {
    '1' => 'auto',
    '2' => 'manual',
  },
  lgpEnvStateSystem => {
    '1' => 'on',
    '2' => 'off',
    '3' => 'standby',
  },
  lgpEnvConfigSensorEvents1 => {
    '1' => 'disabled',
    '2' => 'enabled',
  },
  lgpEnvStateHotWater => {
    '1' => 'on',
    '2' => 'off',
  },
  lgpEnvStateGeneralAlarmOutput => {
    '1' => 'on',
    '2' => 'off',
  },
};
