/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2002 from the
 * contents of OpenGL.xs. Do not edit this file, edit OpenGL.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "lib/SDL/OpenGL.xs"
//
// OpenGL.xs
//
// Copyright (C) 2005 David J. Goehrig <dgoehrig@cpan.org>
//
// ------------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
//
// ------------------------------------------------------------------------------
//
// Please feel free to send questions, suggestions or improvements to:
//
//	David J. Goehrig
//	dgoehrig@cpan.org
//

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#ifndef aTHX_
#define aTHX_
#endif

#include <SDL.h>

#ifdef PERL_DARWIN
#include <gl.h>
#include <glu.h>
#else
#include <GL/gl.h>

#if defined(__WIN32__) && defined(__MINGW32__)
/* 
this is a sort of dirty hack - MS Windows supports just OpenGL 1.1 and all 1.2+
related stuff was moved from GL/gl.h to GL/glext.h; however this separation
was done not properly and even if we are OK with OpenGL 1.1 there are some
constants missing in GL/gl.h thus we need also GL/glext.h
*/
#include <GL/glext.h>
#undef GL_VERSION_1_3
#undef GL_VERSION_1_2
#endif

#include <GL/glu.h>
#endif


#ifdef USE_THREADS
#define HAVE_TLS_CONTEXT
#endif

#ifndef GL_ALL_CLIENT_ATTRIB_BITS  
#define GL_ALL_CLIENT_ATTRIB_BITS 0xFFFFFFF
#endif /* GL_ALL_CLIENT_BITS */  

#define GL_HAS_NURBS

#include "../../src/defines.h"

SV* sdl_perl_nurbs_error_hook;
void
sdl_perl_nurbs_error_callback ( GLenum errorCode )
{
	ENTER_TLS_CONTEXT
	dSP;

	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(errorCode)));
	PUTBACK;

	call_sv(sdl_perl_nurbs_error_hook,G_VOID);
	
	FREETMPS;
	LEAVE;
	LEAVE_TLS_CONTEXT	
}

void
sdl_perl_nurbs_being_callback ( GLenum type, void *cb )
{
	SV *cmd;
	ENTER_TLS_CONTEXT
	dSP;

	cmd = (SV*)cb;

	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(type)));
	PUTBACK;

	call_sv(cmd,G_VOID);
	
	FREETMPS;
	LEAVE;
	LEAVE_TLS_CONTEXT	
}

void
sdl_perl_nurbs_multi_callback ( GLfloat *vec, void *cb )
{
	SV *cmd;
	ENTER_TLS_CONTEXT
	dSP;

	cmd = (SV*)cb;

	ENTER;
	SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(PTR2IV(vec))));
	PUTBACK;

	call_sv(cmd,G_VOID);
	
	FREETMPS;
	LEAVE;
	LEAVE_TLS_CONTEXT	
}

void
sdl_perl_nurbs_end_callback ( void *cb )
{
	SV *cmd;
	ENTER_TLS_CONTEXT

	cmd = (SV*)cb;

	ENTER;
	SAVETMPS;

	call_sv(cmd,G_VOID);
	
	FREETMPS;
	LEAVE;
	LEAVE_TLS_CONTEXT	
}

void
sdl_perl_tess_end_callback ( void *cb )
{
	SV *cmd;
        ENTER_TLS_CONTEXT
	dSP;

        cmd = (SV*)cb;

        ENTER;
        SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(GLU_TESS_BEGIN)));
	PUTBACK;

        call_sv(cmd,G_VOID);

        FREETMPS;
        LEAVE;
        LEAVE_TLS_CONTEXT
}

void
sdl_perl_tess_begin_callback ( GLenum type,  void *cb )
{
        SV *cmd;
        ENTER_TLS_CONTEXT
	dSP;

        cmd = (SV*)cb;

        ENTER;
        SAVETMPS;
	PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(GLU_TESS_BEGIN)));
	XPUSHs(sv_2mortal(newSViv(type)));
	PUTBACK;

        call_sv(cmd,G_VOID);

        FREETMPS;
        LEAVE;
        LEAVE_TLS_CONTEXT
}

void
sdl_perl_tess_error_callback ( GLenum type,  void *cb )
{
        SV *cmd;
        ENTER_TLS_CONTEXT
	dSP;

        cmd = (SV*)cb;

        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
        XPUSHs(sv_2mortal(newSViv(GLU_TESS_ERROR)));
        XPUSHs(sv_2mortal(newSViv(type)));
        PUTBACK;

        call_sv(cmd,G_VOID);

        FREETMPS;
        LEAVE;
        LEAVE_TLS_CONTEXT
}

void
sdl_perl_tess_edge_flag_callback ( GLenum flag,  void *cb )
{
        SV *cmd;
        ENTER_TLS_CONTEXT
	dSP;

        cmd = (SV*)cb;

        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(GLU_TESS_EDGE_FLAG)));
        XPUSHs(sv_2mortal(newSViv(flag)));
        PUTBACK;

        call_sv(cmd,G_VOID);

        FREETMPS;
        LEAVE;
        LEAVE_TLS_CONTEXT
}

void
sdl_perl_tess_vertex_callback ( double *vd,  void *cb )
{
        SV *cmd;
        ENTER_TLS_CONTEXT
	dSP;

        cmd = (SV*)cb;

        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(GLU_TESS_VERTEX)));
        XPUSHs(sv_2mortal(newSVnv(vd[0])));
        XPUSHs(sv_2mortal(newSVnv(vd[1])));
        XPUSHs(sv_2mortal(newSVnv(vd[2])));
        XPUSHs(sv_2mortal(newSVnv(vd[3])));
        XPUSHs(sv_2mortal(newSVnv(vd[4])));
        XPUSHs(sv_2mortal(newSVnv(vd[5])));
        PUTBACK;

        call_sv(cmd,G_VOID);

        FREETMPS;
        LEAVE;
        LEAVE_TLS_CONTEXT
}

void
sdl_perl_tess_combine_callback ( GLdouble coords[3], double *vd[4], GLfloat weight[4], 
	GLdouble **out, void *cb )
{
        SV *cmd;
	double *data;
	int width;
        ENTER_TLS_CONTEXT
	dSP;

        cmd = (SV*)cb;

        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
	XPUSHs(sv_2mortal(newSViv(GLU_TESS_COMBINE)));
	XPUSHs(sv_2mortal(newSVpvn((char*)coords,sizeof(GLdouble)*3)));
	XPUSHs(sv_2mortal(newSVpvn((char*)vd,sizeof(GLdouble*)*4)));
	XPUSHs(sv_2mortal(newSVpvn((char*)weight,sizeof(GLfloat)*4)));
        PUTBACK;

        if ( 1 != call_sv(cmd,G_SCALAR) ) {
		Perl_croak(aTHX_ "sdl_perl_tess_combine_callback failed");
	}

	data = (double*)POPp;
	width = (int)POPi;
	*out = (double*)malloc(sizeof(double)*width);
	memcpy(*out,data,sizeof(double)*width);

        FREETMPS;
        LEAVE;
        LEAVE_TLS_CONTEXT
}

#line 320 "lib/SDL/OpenGL.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

#line 363 "lib/SDL/OpenGL.c"
#ifdef HAVE_GL
#define XSubPPtmpAAAA 1


XS(XS_SDL__OpenGL_glClearColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glClearColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "r, g, b, a");
    {
	double	r = (double)SvNV(ST(0));
	double	g = (double)SvNV(ST(1));
	double	b = (double)SvNV(ST(2));
	double	a = (double)SvNV(ST(3));
#line 322 "lib/SDL/OpenGL.xs"
		glClearColor((GLfloat)r,(GLfloat)g,(GLfloat)b,(GLfloat)a);
#line 385 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glClearIndex); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glClearIndex)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "index");
    {
	double	index = (double)SvNV(ST(0));
#line 328 "lib/SDL/OpenGL.xs"
		glClearIndex(index);
#line 405 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glClearDepth); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glClearDepth)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "depth");
    {
	double	depth = (double)SvNV(ST(0));
#line 334 "lib/SDL/OpenGL.xs"
		glClearDepth(depth);
#line 425 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glClearStencil); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glClearStencil)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	int	s = (int)SvIV(ST(0));
#line 340 "lib/SDL/OpenGL.xs"
		glClearStencil(s);
#line 445 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glClearAccum); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glClearAccum)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "r, g, b, a");
    {
	double	r = (double)SvNV(ST(0));
	double	g = (double)SvNV(ST(1));
	double	b = (double)SvNV(ST(2));
	double	a = (double)SvNV(ST(3));
#line 349 "lib/SDL/OpenGL.xs"
		glClearAccum((GLfloat)r,(GLfloat)g,(GLfloat)b,(GLfloat)a);
#line 468 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glClear); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glClear)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "m");
    {
	GLbitfield	m = (GLbitfield)SvIV(ST(0));
#line 355 "lib/SDL/OpenGL.xs"
		glClear(m);
#line 488 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glFlush); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glFlush)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 360 "lib/SDL/OpenGL.xs"
		glFlush();
#line 507 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glFinish); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glFinish)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 365 "lib/SDL/OpenGL.xs"
		glFinish();
#line 526 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glRect); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glRect)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "r");
    {
	SDL_Rect*	r;

	if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
		{ r = (SDL_Rect *)SvIV((SV*)SvRV( ST(0) )); }
	else if (ST(0) == 0)
	{ XSRETURN(0); }
	else{
		XSRETURN_UNDEF;
	};
#line 371 "lib/SDL/OpenGL.xs"
		glRecti(r->x,r->y,r->x+r->w,r->y+r->h);
#line 554 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glVertex); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glVertex)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "x, y, ...");
    {
	double	x = (double)SvNV(ST(0));
	double	y = (double)SvNV(ST(1));
#line 378 "lib/SDL/OpenGL.xs"
		double z,w;
		if ( items == 4 ) {
			w = SvNV(ST(3));
			z = SvNV(ST(2));
			glVertex4d(x,y,z,w);	
		} else if ( items == 3 ) {
			z = SvNV(ST(2));
			glVertex3d(x,y,z);	
		} else {
			glVertex2d(x,y);
		}
#line 585 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glBegin); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glBegin)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
#line 394 "lib/SDL/OpenGL.xs"
		glBegin(mode);
#line 605 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEnd); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEnd)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 399 "lib/SDL/OpenGL.xs"
		glEnd();
#line 624 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEnable); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEnable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cap");
    {
	GLenum	cap = (GLenum)SvIV(ST(0));
#line 405 "lib/SDL/OpenGL.xs"
		glEnable(cap);
#line 644 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDisable); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDisable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cap");
    {
	GLenum	cap = (GLenum)SvIV(ST(0));
#line 411 "lib/SDL/OpenGL.xs"
		glDisable(cap);
#line 664 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glGet); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glGet)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "param");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	GLenum	param = (GLenum)SvIV(ST(0));
#line 417 "lib/SDL/OpenGL.xs"
        switch (param) {
        case GL_EDGE_FLAG_ARRAY:
        case GL_MAP1_TEXTURE_COORD_1:
        case GL_LIGHT_MODEL_TWO_SIDE:
        case GL_INDEX_LOGIC_OP:
        case GL_PACK_ALIGNMENT:
        case GL_CLIP_PLANE4:
        case GL_TEXTURE_GEN_S:
        case GL_MAP1_VERTEX_3:
        case GL_LIGHT6:
        case GL_LIGHT0:
        case GL_NORMAL_ARRAY:
        case GL_EDGE_FLAG:
        case GL_INDEX_ARRAY:
        case GL_AUTO_NORMAL:
        case GL_POLYGON_OFFSET_FILL:
        case GL_MAP1_TEXTURE_COORD_4:
        case GL_FOG:
        case GL_LIGHT2:
        case GL_UNPACK_SWAP_BYTES:
        case GL_RGBA_MODE:
        case GL_POLYGON_OFFSET_POINT:
        case GL_POINT_SMOOTH:
        case GL_ALPHA_TEST:
        case GL_MAP2_TEXTURE_COORD_4:
        case GL_COLOR_ARRAY:
        case GL_POLYGON_OFFSET_LINE:
        case GL_MAP2_NORMAL:
        case GL_MAP1_INDEX:
        case GL_PACK_LSB_FIRST:
        case GL_MAP1_TEXTURE_COORD_2:
        case GL_MAP2_VERTEX_3:
        case GL_MAP2_TEXTURE_COORD_2:
        case GL_CULL_FACE:
        case GL_DOUBLEBUFFER:
        case GL_UNPACK_LSB_FIRST:
        case GL_TEXTURE_COORD_ARRAY:
        case GL_LIGHT1:
        case GL_TEXTURE_GEN_Q:
        case GL_MAP_STENCIL:
        case GL_TEXTURE_1D:
        case GL_LIGHT4:
        case GL_LIGHTING:
        case GL_LIGHT7:
        case GL_MAP1_NORMAL:
        case GL_CLIP_PLANE0:
        case GL_TEXTURE_GEN_R:
        case GL_PACK_SWAP_BYTES:
        case GL_DEPTH_WRITEMASK:
        case GL_COLOR_LOGIC_OP:
        case GL_CLIP_PLANE5:
        case GL_NORMALIZE:
        case GL_TEXTURE_2D:
        case GL_CLIP_PLANE3:
        case GL_COLOR_MATERIAL:
        case GL_BLEND:
        case GL_CLIP_PLANE2:
        case GL_MAP1_VERTEX_4:
        case GL_DITHER:
        case GL_CLIP_PLANE1:
        case GL_MAP2_INDEX:
        case GL_POLYGON_SMOOTH:
        case GL_STEREO:
        case GL_MAP2_COLOR_4:
        case GL_LIGHT3:
        case GL_VERTEX_ARRAY:
        case GL_MAP1_TEXTURE_COORD_3:
        case GL_STENCIL_TEST:
        case GL_MAP2_TEXTURE_COORD_3:
        case GL_TEXTURE_GEN_T:
        case GL_LIGHT_MODEL_LOCAL_VIEWER:
        case GL_LINE_SMOOTH:
        case GL_MAP1_COLOR_4:
        case GL_MAP2_TEXTURE_COORD_1:
        case GL_CURRENT_RASTER_POSITION_VALID:
        case GL_INDEX_MODE:
        case GL_SCISSOR_TEST:
        case GL_MAP_COLOR:
        case GL_POLYGON_STIPPLE:
        case GL_LIGHT5:
        case GL_DEPTH_TEST:
        case GL_LINE_STIPPLE:
        case GL_MAP2_VERTEX_4:
        {
            GLboolean ret[1];
            int i;
            glGetBooleanv(param, ret);

            for (i = 0; i < 1; i++) {
                XPUSHs(sv_2mortal(newSViv(ret[i])));
            }
            break;
        }
        case GL_COLOR_WRITEMASK:
        {
            GLboolean ret[4];
            int i;
            glGetBooleanv(param, ret);

            for (i = 0; i < 4; i++) {
                XPUSHs(sv_2mortal(newSViv(ret[i])));
            }
            break;
        }
        case GL_ZOOM_Y:
        case GL_ALPHA_TEST_REF:
        case GL_POINT_SIZE_GRANULARITY:
        case GL_CURRENT_RASTER_DISTANCE:
        case GL_ALPHA_SCALE:
        case GL_RED_BIAS:
        case GL_DEPTH_BIAS:
        case GL_FOG_DENSITY:
        case GL_GREEN_BIAS:
        case GL_DEPTH_CLEAR_VALUE:
        case GL_ALPHA_BIAS:
        case GL_FOG_END:
        case GL_GREEN_SCALE:
        case GL_BLUE_BIAS:
        case GL_DEPTH_SCALE:
        case GL_POINT_SIZE:
        case GL_POLYGON_OFFSET_FACTOR:
        case GL_ZOOM_X:
        case GL_FOG_START:
        case GL_POLYGON_OFFSET_UNITS:
        case GL_LINE_WIDTH:
        case GL_LINE_WIDTH_GRANULARITY:
        case GL_BLUE_SCALE:
        case GL_RED_SCALE:
        {
            GLdouble ret[1];
            int i;
            glGetDoublev(param, ret);

            for (i = 0; i < 1; i++) {
                XPUSHs(sv_2mortal(newSVnv(ret[i])));
            }
            break;
        }
        case GL_MODELVIEW_MATRIX:
        case GL_TEXTURE_MATRIX:
        case GL_PROJECTION_MATRIX:
        {
            GLdouble ret[16];
            int i;
            glGetDoublev(param, ret);

            for (i = 0; i < 16; i++) {
                XPUSHs(sv_2mortal(newSVnv(ret[i])));
            }
            break;
        }
        case GL_POINT_SIZE_RANGE:
        case GL_LINE_WIDTH_RANGE:
        case GL_MAP1_GRID_DOMAIN:
        case GL_DEPTH_RANGE:
        {
            GLdouble ret[2];
            int i;
            glGetDoublev(param, ret);

            for (i = 0; i < 2; i++) {
                XPUSHs(sv_2mortal(newSVnv(ret[i])));
            }
            break;
        }
        case GL_CURRENT_NORMAL:
        {
            GLdouble ret[3];
            int i;
            glGetDoublev(param, ret);

            for (i = 0; i < 3; i++) {
                XPUSHs(sv_2mortal(newSVnv(ret[i])));
            }
            break;
        }
        case GL_FOG_COLOR:
        case GL_MAP2_GRID_DOMAIN:
        case GL_CURRENT_RASTER_POSITION:
        case GL_CURRENT_COLOR:
        case GL_LIGHT_MODEL_AMBIENT:
        case GL_CURRENT_RASTER_TEXTURE_COORDS:
        case GL_TEXTURE_ENV_COLOR:
        case GL_CURRENT_RASTER_COLOR:
        case GL_CURRENT_TEXTURE_COORDS:
        case GL_COLOR_CLEAR_VALUE:
        case GL_ACCUM_CLEAR_VALUE:
        {
            GLdouble ret[4];
            int i;
            glGetDoublev(param, ret);

            for (i = 0; i < 4; i++) {
                XPUSHs(sv_2mortal(newSVnv(ret[i])));
            }
            break;
        }
        case GL_CULL_FACE_MODE:
        case GL_PIXEL_MAP_I_TO_A_SIZE:
        case GL_PIXEL_MAP_A_TO_A_SIZE:
        case GL_BLUE_BITS:
        case GL_EDGE_FLAG_ARRAY_STRIDE:
        case GL_RENDER_MODE:
        case GL_FOG_MODE:
        case GL_DEPTH_FUNC:
        case GL_READ_BUFFER:
        case GL_POINT_SMOOTH_HINT:
        case GL_PACK_SKIP_PIXELS:
        case GL_STENCIL_REF:
        case GL_STENCIL_CLEAR_VALUE:
        case GL_AUX_BUFFERS:
        case GL_COLOR_MATERIAL_PARAMETER:
        case GL_ACCUM_BLUE_BITS:
        case GL_INDEX_SHIFT:
        case GL_VERTEX_ARRAY_STRIDE:
        case GL_STENCIL_PASS_DEPTH_PASS:
        case GL_CLIENT_ATTRIB_STACK_DEPTH:
        case GL_DRAW_BUFFER:
        case GL_LINE_STIPPLE_REPEAT:
        case GL_BLEND_SRC:
        case GL_PIXEL_MAP_B_TO_B_SIZE:
        case GL_MAX_PIXEL_MAP_TABLE:
        case GL_MAX_TEXTURE_SIZE:
        case GL_PIXEL_MAP_S_TO_S_SIZE:
        case GL_LOGIC_OP_MODE:
        case GL_DEPTH_BITS:
        case GL_GREEN_BITS:
        case GL_LINE_SMOOTH_HINT:
        case GL_ALPHA_TEST_FUNC:
        case GL_MAX_LIGHTS:
        case GL_FOG_HINT:
        case GL_MAX_NAME_STACK_DEPTH:
        case GL_INDEX_ARRAY_TYPE:
        case GL_TEXTURE_COORD_ARRAY_TYPE:
        case GL_COLOR_ARRAY_TYPE:
        case GL_MAX_LIST_NESTING:
        case GL_STENCIL_WRITEMASK:
        case GL_LIST_BASE:
        case GL_ACCUM_ALPHA_BITS:
        case GL_INDEX_ARRAY_STRIDE:
        case GL_PIXEL_MAP_I_TO_B_SIZE:
        case GL_INDEX_BITS:
        case GL_STENCIL_FAIL:
        case GL_UNPACK_ALIGNMENT:
        case GL_STENCIL_PASS_DEPTH_FAIL:
        case GL_ATTRIB_STACK_DEPTH:
        case GL_PACK_SKIP_ROWS:
        case GL_TEXTURE_STACK_DEPTH:
        case GL_MATRIX_MODE:
        case GL_COLOR_ARRAY_STRIDE:
        case GL_LIST_MODE:
        case GL_UNPACK_SKIP_PIXELS:
        case GL_PIXEL_MAP_G_TO_G_SIZE:
        case GL_VERTEX_ARRAY_TYPE:
        case GL_RED_BITS:
        case GL_MAX_CLIENT_ATTRIB_STACK_DEPTH:
        case GL_INDEX_CLEAR_VALUE:
        case GL_PIXEL_MAP_I_TO_G_SIZE:
        case GL_ALPHA_BITS:
        case GL_PIXEL_MAP_I_TO_R_SIZE:
        case GL_COLOR_ARRAY_SIZE:
        case GL_TEXTURE_COORD_ARRAY_SIZE:
        case GL_MAP1_GRID_SEGMENTS:
        case GL_VERTEX_ARRAY_SIZE:
        case GL_PIXEL_MAP_R_TO_R_SIZE:
        case GL_TEXTURE_COORD_ARRAY_STRIDE:
        case GL_MODELVIEW_STACK_DEPTH:
        case GL_MAX_TEXTURE_STACK_DEPTH:
        case GL_PIXEL_MAP_I_TO_I_SIZE:
        case GL_FOG_INDEX:
        case GL_INDEX_WRITEMASK:
        case GL_PACK_ROW_LENGTH:
        case GL_CURRENT_INDEX:
        case GL_STENCIL_VALUE_MASK:
        case GL_UNPACK_SKIP_ROWS:
        case GL_MAX_PROJECTION_STACK_DEPTH:
        case GL_LIST_INDEX:
        case GL_STENCIL_FUNC:
        case GL_INDEX_OFFSET:
        case GL_UNPACK_ROW_LENGTH:
        case GL_COLOR_MATERIAL_FACE:
        case GL_NORMAL_ARRAY_TYPE:
        case GL_STENCIL_BITS:
        case GL_PROJECTION_STACK_DEPTH:
        case GL_CURRENT_RASTER_INDEX:
        case GL_SHADE_MODEL:
        case GL_TEXTURE_ENV_MODE:
        case GL_NORMAL_ARRAY_STRIDE:
        case GL_PERSPECTIVE_CORRECTION_HINT:
        case GL_MAX_CLIP_PLANES:
        case GL_MAX_MODELVIEW_STACK_DEPTH:
        case GL_SUBPIXEL_BITS:
        case GL_ACCUM_RED_BITS:
        case GL_BLEND_DST:
        case GL_FRONT_FACE:
        case GL_MAX_EVAL_ORDER:
        case GL_LINE_STIPPLE_PATTERN:
        case GL_NAME_STACK_DEPTH:
        case GL_MAX_ATTRIB_STACK_DEPTH:
        case GL_POLYGON_SMOOTH_HINT:
        case GL_ACCUM_GREEN_BITS:
        {
            GLint ret[1];
            int i;
            glGetIntegerv(param, ret);

            for (i = 0; i < 1; i++) {
                XPUSHs(sv_2mortal(newSViv(ret[i]))); 
            }
            break;
        }
        case GL_POLYGON_MODE:
        case GL_MAX_VIEWPORT_DIMS:
        case GL_MAP2_GRID_SEGMENTS:
        {
            GLint ret[2];
            int i;
            glGetIntegerv(param, ret);

            for (i = 0; i < 2; i++) {
                XPUSHs(sv_2mortal(newSViv(ret[i]))); 
            }
            break;
        }
        case GL_SCISSOR_BOX:
        case GL_VIEWPORT:
        {
            GLint ret[4];
            int i;
            glGetIntegerv(param, ret);

            for (i = 0; i < 4; i++) {
                XPUSHs(sv_2mortal(newSViv(ret[i]))); 
            }
            break;
        }
        default:
            croak("Unknown glGet parameter!");
        }
#line 1024 "lib/SDL/OpenGL.c"
	PUTBACK;
	return;
    }
}


XS(XS_SDL__OpenGL_glIsEnabled); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glIsEnabled)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "cap");
    {
	Uint32	cap = (Uint32)SvUV(ST(0));
	Uint32	RETVAL;
	dXSTARG;
#line 762 "lib/SDL/OpenGL.xs"
		RETVAL = glIsEnabled(cap);
#line 1047 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glPointSize); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPointSize)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	double	size = (double)SvNV(ST(0));
#line 770 "lib/SDL/OpenGL.xs"
		glPointSize((GLfloat)size);
#line 1068 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLineWidth); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLineWidth)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	double	size = (double)SvNV(ST(0));
#line 776 "lib/SDL/OpenGL.xs"
		glLineWidth((GLfloat)size);
#line 1088 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLineStipple); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLineStipple)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "factor, pattern");
    {
	Sint32	factor = (Sint32)SvIV(ST(0));
	Uint16	pattern = (Uint16)SvUV(ST(1));
#line 783 "lib/SDL/OpenGL.xs"
		glLineStipple(factor,pattern);
#line 1109 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPolygonMode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPolygonMode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "face, mode");
    {
	GLenum	face = (GLenum)SvIV(ST(0));
	GLenum	mode = (GLenum)SvIV(ST(1));
#line 790 "lib/SDL/OpenGL.xs"
		glPolygonMode(face,mode);
#line 1130 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glFrontFace); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glFrontFace)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
#line 796 "lib/SDL/OpenGL.xs"
		glFrontFace(mode);
#line 1150 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCullFace); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCullFace)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
#line 802 "lib/SDL/OpenGL.xs"
		glCullFace(mode);
#line 1170 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPolygonStipple); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPolygonStipple)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mask");
    {
	char *	mask = (char *)SvPV_nolen(ST(0));
#line 808 "lib/SDL/OpenGL.xs"
		glPolygonStipple(mask);
#line 1190 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEdgeFlag); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEdgeFlag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "flag");
    {
	GLenum	flag = (GLenum)SvIV(ST(0));
#line 814 "lib/SDL/OpenGL.xs"
		glEdgeFlag(flag);
#line 1210 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glNormal); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glNormal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "x, y, z");
    {
	double	x = (double)SvNV(ST(0));
	double	y = (double)SvNV(ST(1));
	double	z = (double)SvNV(ST(2));
#line 822 "lib/SDL/OpenGL.xs"
		glNormal3d(x,y,z);
#line 1232 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEnableClientState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEnableClientState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "array");
    {
	GLenum	array = (GLenum)SvIV(ST(0));
#line 828 "lib/SDL/OpenGL.xs"
		glEnableClientState(array);
#line 1252 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDisableClientState); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDisableClientState)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "array");
    {
	GLenum	array = (GLenum)SvIV(ST(0));
#line 834 "lib/SDL/OpenGL.xs"
		glDisableClientState(array);
#line 1272 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glVertexPointer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glVertexPointer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "size, type, stride, pointer");
    {
	int	size = (int)SvIV(ST(0));
	GLenum	type = (GLenum)SvIV(ST(1));
	Uint32	stride = (Uint32)SvUV(ST(2));
	char *	pointer = (char *)SvPV_nolen(ST(3));
#line 843 "lib/SDL/OpenGL.xs"
		glVertexPointer(size,type,stride,pointer);
#line 1295 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glColorPointer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glColorPointer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "size, type, stride, pointer");
    {
	Sint32	size = (Sint32)SvIV(ST(0));
	GLenum	type = (GLenum)SvIV(ST(1));
	Uint32	stride = (Uint32)SvUV(ST(2));
	char *	pointer = (char *)SvPV_nolen(ST(3));
#line 852 "lib/SDL/OpenGL.xs"
		glColorPointer(size,type,stride,pointer);
#line 1318 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glNormalPointer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glNormalPointer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "type, stride, pointer");
    {
	GLenum	type = (GLenum)SvIV(ST(0));
	Uint32	stride = (Uint32)SvUV(ST(1));
	char *	pointer = (char *)SvPV_nolen(ST(2));
#line 860 "lib/SDL/OpenGL.xs"
		glNormalPointer(type,stride,pointer);
#line 1340 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexCoordPointer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexCoordPointer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "size, type, stride, pointer");
    {
	Sint32	size = (Sint32)SvIV(ST(0));
	GLenum	type = (GLenum)SvIV(ST(1));
	Uint32	stride = (Uint32)SvUV(ST(2));
	char *	pointer = (char *)SvPV_nolen(ST(3));
#line 869 "lib/SDL/OpenGL.xs"
		glTexCoordPointer(size,type,stride,pointer);
#line 1363 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEdgeFlagPointer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEdgeFlagPointer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "stride, pointer");
    {
	Uint32	stride = (Uint32)SvUV(ST(0));
	char *	pointer = (char *)SvPV_nolen(ST(1));
#line 876 "lib/SDL/OpenGL.xs"
		glEdgeFlagPointer(stride,pointer);
#line 1384 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glArrayElement); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glArrayElement)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ith");
    {
	Uint32	ith = (Uint32)SvUV(ST(0));
#line 882 "lib/SDL/OpenGL.xs"
		glArrayElement(ith);
#line 1404 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDrawElements); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDrawElements)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "mode, count, type, indices");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
	Uint32	count = (Uint32)SvUV(ST(1));
	GLenum	type = (GLenum)SvIV(ST(2));
	char *	indices = (char *)SvPV_nolen(ST(3));
#line 891 "lib/SDL/OpenGL.xs"
		glDrawElements( mode, count, type, indices);
#line 1427 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#ifdef GL_VERSION_1_2
#define XSubPPtmpAAAB 1


XS(XS_SDL__OpenGL_glDrawRangeElements); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDrawRangeElements)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "mode, start, end, count, type, indices");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
	Uint32	start = (Uint32)SvUV(ST(1));
	Uint32	end = (Uint32)SvUV(ST(2));
	Uint32	count = (Uint32)SvUV(ST(3));
	GLenum	type = (GLenum)SvIV(ST(4));
	char *	indices = (char *)SvPV_nolen(ST(5));
#line 904 "lib/SDL/OpenGL.xs"
		glDrawRangeElements(mode,start,end,count,type,indices);
#line 1455 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif // GL_VERSION_1_2

XS(XS_SDL__OpenGL_glDrawArrays); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDrawArrays)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "mode, first, count");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
	Uint32	first = (Uint32)SvUV(ST(1));
	Uint32	count = (Uint32)SvUV(ST(2));
#line 914 "lib/SDL/OpenGL.xs"
		glDrawArrays(mode,first,count);
#line 1478 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glInterleavedArrays); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glInterleavedArrays)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "format, stride, pointer");
    {
	GLenum	format = (GLenum)SvIV(ST(0));
	Uint32	stride = (Uint32)SvUV(ST(1));
	char *	pointer = (char *)SvPV_nolen(ST(2));
#line 922 "lib/SDL/OpenGL.xs"
		glInterleavedArrays(format,stride,pointer);
#line 1500 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPushAttrib); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPushAttrib)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mask");
    {
	GLbitfield	mask = (GLbitfield)SvIV(ST(0));
#line 928 "lib/SDL/OpenGL.xs"
		glPushAttrib(mask);
#line 1520 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPopAttrib); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPopAttrib)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 933 "lib/SDL/OpenGL.xs"
		glPopAttrib();
#line 1539 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPushClientAttrib); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPushClientAttrib)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mask");
    {
	GLbitfield	mask = (GLbitfield)SvIV(ST(0));
#line 939 "lib/SDL/OpenGL.xs"
		glPushClientAttrib(mask);
#line 1559 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPopClientAttrib); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPopClientAttrib)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 944 "lib/SDL/OpenGL.xs"
		glPopClientAttrib();
#line 1578 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMatrixMode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMatrixMode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
#line 950 "lib/SDL/OpenGL.xs"
		glMatrixMode(mode);
#line 1598 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLoadIdentity); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLoadIdentity)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 955 "lib/SDL/OpenGL.xs"
		glLoadIdentity();
#line 1617 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLoadMatrix); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLoadMatrix)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 960 "lib/SDL/OpenGL.xs"
		int i;
		double mat[16];
		for ( i = 0; i < 16; i++ ) {
			mat[i] = i < items ? SvNV(ST(i)) : 0.0;
		}
		glLoadMatrixd(mat);
#line 1640 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMultMatrix); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMultMatrix)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 970 "lib/SDL/OpenGL.xs"
		int i;
		double mat[16];
		for ( i = 0; i < 16; i++ ) {
			mat[i] = i < items ? SvNV(ST(i)) : 0.0;
		}
		glMultMatrixd(mat);
#line 1663 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTranslate); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTranslate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "x, y, z");
    {
	double	x = (double)SvNV(ST(0));
	double	y = (double)SvNV(ST(1));
	double	z = (double)SvNV(ST(2));
#line 983 "lib/SDL/OpenGL.xs"
		glTranslated(x,y,z);
#line 1685 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glRotate); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glRotate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "angle, x, y, z");
    {
	double	angle = (double)SvNV(ST(0));
	double	x = (double)SvNV(ST(1));
	double	y = (double)SvNV(ST(2));
	double	z = (double)SvNV(ST(3));
#line 992 "lib/SDL/OpenGL.xs"
		glRotated(angle,x,y,z);
#line 1708 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glScale); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glScale)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "x, y, z");
    {
	double	x = (double)SvNV(ST(0));
	double	y = (double)SvNV(ST(1));
	double	z = (double)SvNV(ST(2));
#line 1000 "lib/SDL/OpenGL.xs"
		glScaled(x,y,z);
#line 1730 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glFrustum); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glFrustum)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "left, right, bottom, top, n, f");
    {
	double	left = (double)SvNV(ST(0));
	double	right = (double)SvNV(ST(1));
	double	bottom = (double)SvNV(ST(2));
	double	top = (double)SvNV(ST(3));
	double	n = (double)SvNV(ST(4));
	double	f = (double)SvNV(ST(5));
#line 1011 "lib/SDL/OpenGL.xs"
		glFrustum(left,right,bottom,top,n,f);
#line 1755 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glOrtho); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glOrtho)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "left, right, bottom, top, n, f");
    {
	double	left = (double)SvNV(ST(0));
	double	right = (double)SvNV(ST(1));
	double	bottom = (double)SvNV(ST(2));
	double	top = (double)SvNV(ST(3));
	double	n = (double)SvNV(ST(4));
	double	f = (double)SvNV(ST(5));
#line 1022 "lib/SDL/OpenGL.xs"
		glOrtho(left,right,bottom,top,n,f);
#line 1780 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glViewport); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glViewport)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "x, y, width, height");
    {
	Sint32	x = (Sint32)SvIV(ST(0));
	Sint32	y = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
#line 1031 "lib/SDL/OpenGL.xs"
		glViewport(x,y,width,height);
#line 1803 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDepthRange); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDepthRange)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "n, f");
    {
	double	n = (double)SvNV(ST(0));
	double	f = (double)SvNV(ST(1));
#line 1038 "lib/SDL/OpenGL.xs"
		glDepthRange(n,f);
#line 1824 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPushMatrix); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPushMatrix)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1043 "lib/SDL/OpenGL.xs"
		glPushMatrix();
#line 1843 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPopMatrix); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPopMatrix)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1048 "lib/SDL/OpenGL.xs"
		glPopMatrix();
#line 1862 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glClipPlane); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glClipPlane)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "plane, ...");
    {
	GLenum	plane = (GLenum)SvIV(ST(0));
#line 1054 "lib/SDL/OpenGL.xs"
		double v[4];
		int i;
		for (i = 0; i < 4; i++ ) {
			v[i] = i+1 < items ? SvNV(ST(i+1)) : 0.0;
		}
		glClipPlane(plane,v);
#line 1887 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glColor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glColor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3)
       croak_xs_usage(cv,  "r, g, b, ...");
    {
	double	r = (double)SvNV(ST(0));
	double	g = (double)SvNV(ST(1));
	double	b = (double)SvNV(ST(2));
#line 1067 "lib/SDL/OpenGL.xs"
		if ( items == 4 ) {
			double a;
			a = SvNV(ST(3));
			glColor4d(r,g,b,a);
		} else {
			glColor3d(r,g,b);	
		}
#line 1915 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glIndex); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glIndex)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "c");
    {
	Uint32	c = (Uint32)SvUV(ST(0));
#line 1079 "lib/SDL/OpenGL.xs"
		glIndexi(c);
#line 1935 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glShadeModel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glShadeModel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
#line 1085 "lib/SDL/OpenGL.xs"
		glShadeModel(mode);
#line 1955 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLight); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLight)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "light, name, ...");
    {
	GLenum	light = (GLenum)SvIV(ST(0));
	GLenum	name = (GLenum)SvIV(ST(1));
#line 1092 "lib/SDL/OpenGL.xs"
		int i;
		if ( items == 6 ) {
			float v[4];	
			for ( i = 0; i < 4; i++ ) {
				v[i] = SvNV(ST(i+2));
			}
			glLightfv(light,name,v);	
		} else if ( items == 5 ) {
			float v[3];
			for ( i = 0; i < 3; i++ ) {
				v[i] = SvNV(ST(i+2));
			}
			glLightfv(light,name,v);	
		} else if ( items == 3 ) {
			float v;
			v = SvNV(ST(2));
			glLightf(light,name,v);
		} else {
			Perl_croak(aTHX_ "SDL::OpenGL::Light invalid arguments");
		}
#line 1995 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLightModel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLightModel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "pname, ...");
    {
	GLenum	pname = (GLenum)SvIV(ST(0));
#line 1117 "lib/SDL/OpenGL.xs"
		GLfloat vec[4];
		if ( pname == GL_LIGHT_MODEL_LOCAL_VIEWER ||
			pname == GL_LIGHT_MODEL_TWO_SIDE ||
			pname == GL_LIGHT_MODEL_COLOR_CONTROL ) {
			glLightModelf(pname,SvNV(ST(1)));
		} else if ( pname == GL_LIGHT_MODEL_AMBIENT) {
			vec[0] = SvNV(ST(1));
			vec[1] = SvNV(ST(2));
			vec[2] = SvNV(ST(3));
			vec[3] = SvNV(ST(4));
			glLightModelfv(pname,vec);
		} else {
			Perl_croak(aTHX_ "SDL::OpenGL::glLightModel unknown model %d",pname);
		}
#line 2028 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMaterial); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMaterial)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "face, name, ...");
    {
	GLenum	face = (GLenum)SvIV(ST(0));
	GLenum	name = (GLenum)SvIV(ST(1));
#line 1137 "lib/SDL/OpenGL.xs"
		int i;
		if ( items == 6 ) {
			float v[4];
			for ( i = 0; i < 4; i++ ) {
				v[i] = SvNV(ST(i+2));
			}
			glMaterialfv(face,name,v);
		} else if ( items == 5 ) {
			float v[3];
			for ( i = 0; i < 3; i++ ) {
				v[i] = SvNV(ST(i+2));
			}
			glMaterialfv(face,name,v);
		} else if ( items == 3 ) {	
			float v;
			v = SvNV(ST(2));
			glMaterialf(face,name,v);
		} else {
			Perl_croak(aTHX_ "SDL::OpenGL::Material invalid arguments");
		}
#line 2068 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glColorMaterial); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glColorMaterial)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "face, mode");
    {
	GLenum	face = (GLenum)SvIV(ST(0));
	GLenum	mode = (GLenum)SvIV(ST(1));
#line 1163 "lib/SDL/OpenGL.xs"
		glColorMaterial(face,mode);
#line 2089 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glBlendFunc); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glBlendFunc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sfactor, dfactor");
    {
	GLenum	sfactor = (GLenum)SvIV(ST(0));
	GLenum	dfactor = (GLenum)SvIV(ST(1));
#line 1170 "lib/SDL/OpenGL.xs"
		glBlendFunc(sfactor,dfactor);
#line 2110 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glHint); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glHint)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "target, hint");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	GLenum	hint = (GLenum)SvIV(ST(1));
#line 1178 "lib/SDL/OpenGL.xs"
		glHint(target,hint);	
#line 2131 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glFog); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glFog)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "name, ...");
    {
	GLenum	name = (GLenum)SvIV(ST(0));
#line 1184 "lib/SDL/OpenGL.xs"
		if ( items == 5 )  {
			float v[4];
			v[0] = SvNV(ST(1));	
			v[1] = SvNV(ST(2));	
			v[2] = SvNV(ST(3));	
			v[3] = SvNV(ST(4));	
			glFogfv(name,v);
		} else if ( items == 2 ) {
			float v;
			v = SvNV(ST(1));
			glFogf(name,v);
		} else {
			Perl_croak(aTHX_ "SDL::OpenGL::Material invalid arguments");
		}
#line 2164 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPolygonOffset); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPolygonOffset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "factor, units");
    {
	double	factor = (double)SvNV(ST(0));
	double	units = (double)SvNV(ST(1));
#line 1204 "lib/SDL/OpenGL.xs"
		glPolygonOffset(factor,units);
#line 2185 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glGenLists); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glGenLists)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "range");
    {
	Uint32	range = (Uint32)SvUV(ST(0));
	Uint32	RETVAL;
	dXSTARG;
#line 1210 "lib/SDL/OpenGL.xs"
		RETVAL = glGenLists(range);
#line 2207 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glNewList); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glNewList)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "list, mode");
    {
	Uint32	list = (Uint32)SvUV(ST(0));
	GLenum	mode = (GLenum)SvIV(ST(1));
#line 1219 "lib/SDL/OpenGL.xs"
		glNewList(list,mode);
#line 2229 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEndList); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEndList)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1224 "lib/SDL/OpenGL.xs"
		glEndList();
#line 2248 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDeleteLists); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDeleteLists)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "base, count");
    {
	Uint32	base = (Uint32)SvUV(ST(0));
	Uint32	count = (Uint32)SvUV(ST(1));
#line 1231 "lib/SDL/OpenGL.xs"
                glDeleteLists(base, count);
#line 2269 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCallList); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCallList)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "list");
    {
	Uint32	list = (Uint32)SvUV(ST(0));
#line 1237 "lib/SDL/OpenGL.xs"
		glCallList(list);
#line 2289 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glIsList); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glIsList)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "list");
    {
	Uint32	list = (Uint32)SvUV(ST(0));
	Uint32	RETVAL;
	dXSTARG;
#line 1243 "lib/SDL/OpenGL.xs"
		RETVAL = glIsList(list);
#line 2311 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glListBase); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glListBase)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "base");
    {
	Uint32	base = (Uint32)SvUV(ST(0));
#line 1251 "lib/SDL/OpenGL.xs"
		glListBase(base);
#line 2332 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCallLists); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCallLists)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 1256 "lib/SDL/OpenGL.xs"
		int *i, j;	
		if ( items > 0 ) {
			i = (int*)safemalloc(sizeof(int)* (items));
			for ( j = 0; j < items; j++ ) {
				i[j] = SvIV(ST(j));
			} 
		} else {
			Perl_croak(aTHX_ "usage: SDL::OpenGL::CallLists(type,...)");
		}
		glCallLists(items, GL_INT, i);
		safefree(i);
#line 2360 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCallListsString); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCallListsString)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	SV*	string = ST(0);
#line 1272 "lib/SDL/OpenGL.xs"
		char *str;
		STRLEN len;
		str = SvPV(string,len);
		glCallLists(len,GL_BYTE,str);
#line 2383 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glRasterPos); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glRasterPos)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 3)
       croak_xs_usage(cv,  "x, y, z, ...");
    {
	double	x = (double)SvNV(ST(0));
	double	y = (double)SvNV(ST(1));
	double	z = (double)SvNV(ST(2));
#line 1283 "lib/SDL/OpenGL.xs"
		if ( items == 4 ) {
			double w = SvNV(ST(3));
			glRasterPos4d(x,y,z,w);
		} else {
			glRasterPos3d(x,y,z);
		}
#line 2410 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glBitmap); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glBitmap)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "width, height, x1, y1, x2, y2, data");
    {
	Uint32	width = (Uint32)SvUV(ST(0));
	Uint32	height = (Uint32)SvUV(ST(1));
	double	x1 = (double)SvNV(ST(2));
	double	y1 = (double)SvNV(ST(3));
	double	x2 = (double)SvNV(ST(4));
	double	y2 = (double)SvNV(ST(5));
	char *	data = (char *)SvPV_nolen(ST(6));
#line 1300 "lib/SDL/OpenGL.xs"
		glBitmap(width,height,x1,y1,x2,y2,data);
#line 2436 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDrawPixels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDrawPixels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "width, height, format, type, pixels");
    {
	Uint32	width = (Uint32)SvUV(ST(0));
	Uint32	height = (Uint32)SvUV(ST(1));
	GLenum	format = (GLenum)SvIV(ST(2));
	GLenum	type = (GLenum)SvIV(ST(3));
	char *	pixels = (char *)SvPV_nolen(ST(4));
#line 1310 "lib/SDL/OpenGL.xs"
		glDrawPixels(width,height,format,type,pixels);
#line 2460 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glReadPixels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glReadPixels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "x, y, width, height, format, type");
    {
	Uint32	x = (Uint32)SvUV(ST(0));
	Uint32	y = (Uint32)SvUV(ST(1));
	Uint32	height = (Uint32)SvUV(ST(3));
	Uint32	width = (Uint32)SvUV(ST(2));
	GLenum	format = (GLenum)SvIV(ST(4));
	GLenum	type = (GLenum)SvIV(ST(5));
	SV *	RETVAL;
#line 1322 "lib/SDL/OpenGL.xs"
                int len, size;
                char *buf;
                size = 1;       /* ALPHA, BLUE, GREEN or RED */
                if (format == GL_BGR || format == GL_RGB) 
                        size = 3;
                if (format == GL_BGRA || format == GL_RGBA) 
                        size = 4;
                len = height * width * size;            /* in bytes */
                RETVAL = newSV(len);                    /* alloc len+1 bytes */
                SvPOK_on(RETVAL);                       /* make an PV */
                buf = SvPVX(RETVAL);                    /* get ptr to buffer */
                glReadPixels(x,y,width,height,format,type,buf);
                SvCUR_set(RETVAL, len);                 /* set real length */
#line 2498 "lib/SDL/OpenGL.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glReadPixel); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glReadPixel)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	Uint32	x = (Uint32)SvUV(ST(0));
	Uint32	y = (Uint32)SvUV(ST(1));
	AV *	RETVAL;
#line 1343 "lib/SDL/OpenGL.xs"
                int rgba[4];    /* r,g,b,a */
                int i;
                glReadPixels(x,y,1,1,GL_RGBA,GL_UNSIGNED_INT,rgba);
                RETVAL = newAV();
                for ( i = 0; i < 4; i++ ) {
                        av_push(RETVAL,newSViv(rgba[i]));
                }
#line 2528 "lib/SDL/OpenGL.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glCopyPixels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyPixels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "x, y, width, height, buffer");
    {
	Sint32	x = (Sint32)SvIV(ST(0));
	Sint32	y = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
	GLenum	buffer = (GLenum)SvIV(ST(4));
#line 1361 "lib/SDL/OpenGL.xs"
		glCopyPixels(x,y,width,height,buffer);
#line 2554 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPixelStore); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPixelStore)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "name, param");
    {
	Sint32	name = (Sint32)SvIV(ST(0));
	double	param = (double)SvNV(ST(1));
#line 1368 "lib/SDL/OpenGL.xs"
		glPixelStorei(name,param);
#line 2575 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPixelTransfer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPixelTransfer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "name, ...");
    {
	GLenum	name = (GLenum)SvIV(ST(0));
#line 1374 "lib/SDL/OpenGL.xs"
		switch ( name ) {
			case GL_MAP_COLOR:
			case GL_MAP_STENCIL:
			case GL_INDEX_SHIFT:
			case GL_INDEX_OFFSET:
				glPixelTransferi(name,SvIV(ST(1)));
				break;
			default:
				glPixelTransferf(name,SvNV(ST(1)));
				break;
		}
#line 2605 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPixelMap); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPixelMap)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "type, map, mapsize, values");
    {
	GLenum	type = (GLenum)SvIV(ST(0));
	GLenum	map = (GLenum)SvIV(ST(1));
	Sint32	mapsize = (Sint32)SvIV(ST(2));
	char *	values = (char *)SvPV_nolen(ST(3));
#line 1393 "lib/SDL/OpenGL.xs"
		switch (type) {
			case GL_UNSIGNED_INT: 
				glPixelMapuiv(map,mapsize,(GLint*)values);
				break;
			case GL_UNSIGNED_SHORT:
				glPixelMapusv(map,mapsize,(GLushort*)values);
				break;
			case GL_FLOAT:
				glPixelMapfv(map,mapsize,(GLfloat*)values);
				break;
		}
#line 2638 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPixelZoom); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPixelZoom)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "zoomx, zoomy");
    {
	double	zoomx = (double)SvNV(ST(0));
	double	zoomy = (double)SvNV(ST(1));
#line 1410 "lib/SDL/OpenGL.xs"
		glPixelZoom(zoomx,zoomy);
#line 2659 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#ifdef GL_VERSION_1_3
#define XSubPPtmpAAAC 1


XS(XS_SDL__OpenGL_glColorTable); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glColorTable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, internalFormat, width, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	GLenum	internalFormat = (GLenum)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	GLenum	format = (GLenum)SvIV(ST(3));
	GLenum	type = (GLenum)SvIV(ST(4));
	char *	data = (char *)SvPV_nolen(ST(5));
#line 1423 "lib/SDL/OpenGL.xs"
		glColorTable(target,internalFormat,width,format,type,data);
#line 2687 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glColorTableParameter); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glColorTableParameter)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, name, r, g, b, a");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	GLenum	name = (GLenum)SvIV(ST(1));
	double	r = (double)SvNV(ST(2));
	double	g = (double)SvNV(ST(3));
	double	b = (double)SvNV(ST(4));
	double	a = (double)SvNV(ST(5));
#line 1434 "lib/SDL/OpenGL.xs"
		GLfloat vec[4];
		vec[0] = r;
		vec[1] = g;
		vec[2] = b;
		vec[3] = a;
		glColorTableParameterfv(target,name,vec);
#line 2717 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyColorTable); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyColorTable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "target, internalFormat, x, y, width");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	GLenum	internalFormat = (GLenum)SvIV(ST(1));
	Sint32	x = (Sint32)SvIV(ST(2));
	Sint32	y = (Sint32)SvIV(ST(3));
	Uint32	width = (Uint32)SvUV(ST(4));
#line 1449 "lib/SDL/OpenGL.xs"
		glCopyColorTable(target,internalFormat,x,y,width);
#line 2741 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glColorSubTable); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glColorSubTable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, start, count, format, type, data");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	start = (Uint32)SvUV(ST(1));
	Uint32	count = (Uint32)SvUV(ST(2));
	Uint32	format = (Uint32)SvUV(ST(3));
	Uint32	type = (Uint32)SvUV(ST(4));
	char *	data = (char *)SvPV_nolen(ST(5));
#line 1460 "lib/SDL/OpenGL.xs"
		glColorSubTable(target,start,count,format,type,data);
#line 2766 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyColorSubTable); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyColorSubTable)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "target, start, x, y, count");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	start = (Uint32)SvUV(ST(1));
	Sint32	x = (Sint32)SvIV(ST(2));
	Sint32	y = (Sint32)SvIV(ST(3));
	Uint32	count = (Uint32)SvUV(ST(4));
#line 1470 "lib/SDL/OpenGL.xs"
		glCopyColorSubTable(target,start,x,y,count);
#line 2790 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glConvolutionFilter2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glConvolutionFilter2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "target, internalFormat, width, height, format, type, image");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	internalFormat = (Uint32)SvUV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
	Uint32	format = (Uint32)SvUV(ST(4));
	Uint32	type = (Uint32)SvUV(ST(5));
	char *	image = (char *)SvPV_nolen(ST(6));
#line 1482 "lib/SDL/OpenGL.xs"
		glConvolutionFilter2D(target,internalFormat,width,height,format,type,image);
#line 2816 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyConvolutionFilter2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyConvolutionFilter2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, internalFormat, x, y, width, height");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	internalFormat = (Uint32)SvUV(ST(1));
	Sint32	x = (Sint32)SvIV(ST(2));
	Sint32	y = (Sint32)SvIV(ST(3));
	Uint32	width = (Uint32)SvUV(ST(4));
	Uint32	height = (Uint32)SvUV(ST(5));
#line 1493 "lib/SDL/OpenGL.xs"
		glCopyConvolutionFilter2D(target,internalFormat,x,y,width,height);
#line 2841 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glSeparableFilter2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glSeparableFilter2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "target, internalFormat, width, height, format, type, row, column");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	internalFormat = (Uint32)SvUV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
	Uint32	format = (Uint32)SvUV(ST(4));
	Uint32	type = (Uint32)SvUV(ST(5));
	char *	row = (char *)SvPV_nolen(ST(6));
	char *	column = (char *)SvPV_nolen(ST(7));
#line 1506 "lib/SDL/OpenGL.xs"
		glSeparableFilter2D(target,internalFormat,width,height,format,type,row,column);
#line 2868 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glConvolutionFilter1D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glConvolutionFilter1D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, internalFormat, width, format, type, image");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	internalFormat = (Uint32)SvUV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	format = (Uint32)SvUV(ST(3));
	Uint32	type = (Uint32)SvUV(ST(4));
	char *	image = (char *)SvPV_nolen(ST(5));
#line 1517 "lib/SDL/OpenGL.xs"
		glConvolutionFilter1D(target,internalFormat,width,format,type,image);
#line 2893 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyConvolutionFilter1D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyConvolutionFilter1D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "target, internalFormat, x, y, width");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	internalFormat = (Uint32)SvUV(ST(1));
	Sint32	x = (Sint32)SvIV(ST(2));
	Sint32	y = (Sint32)SvIV(ST(3));
	Uint32	width = (Uint32)SvUV(ST(4));
#line 1527 "lib/SDL/OpenGL.xs"
		glCopyConvolutionFilter1D(target,internalFormat,x,y,width);
#line 2917 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glConvolutionParameter); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glConvolutionParameter)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "target, pname, ...");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	pname = (Uint32)SvUV(ST(1));
#line 1534 "lib/SDL/OpenGL.xs"
		Uint32 pi;
		GLfloat pv[4];
		switch(pname) {	
		case GL_CONVOLUTION_BORDER_MODE:
			if ( items != 3 ) 
				Perl_croak(aTHX_ "Usage: ConvolutionParameter(target,pname,...)");
			pi = SvIV(ST(2));
			glConvolutionParameteri(target,pname,pi);
			break;
		case GL_CONVOLUTION_FILTER_SCALE:
		case GL_CONVOLUTION_FILTER_BIAS:
			if ( items != 6 ) 
				Perl_croak(aTHX_ "Usage: ConvolutionParameter(target,pname,...)");
			pv[0] = (GLfloat)SvNV(ST(2));
			pv[1] = (GLfloat)SvNV(ST(3));
			pv[2] = (GLfloat)SvNV(ST(4));
			pv[3] = (GLfloat)SvNV(ST(5));
			glConvolutionParameterfv(target,pname,pv);
			break;
		default:
			Perl_croak(aTHX_ "ConvolutionParameter invalid parameter");
			break;
		}
#line 2960 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glHistogram); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glHistogram)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "target, width, internalFormat, sink");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	width = (Uint32)SvUV(ST(1));
	Uint32	internalFormat = (Uint32)SvUV(ST(2));
	GLboolean	sink = (unsigned char)SvUV(ST(3));
#line 1565 "lib/SDL/OpenGL.xs"
		glHistogram(target,width,internalFormat,sink);
#line 2983 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glGetHistogram); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glGetHistogram)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "target, reset, format, type, values");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	GLboolean	reset = (unsigned char)SvUV(ST(1));
	Uint32	format = (Uint32)SvUV(ST(2));
	Uint32	type = (Uint32)SvUV(ST(3));
	char *	values = (char *)SvPV_nolen(ST(4));
#line 1575 "lib/SDL/OpenGL.xs"
		glGetHistogram(target,reset,format,type,values);
#line 3007 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glResetHistogram); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glResetHistogram)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "target");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
#line 1581 "lib/SDL/OpenGL.xs"
		glResetHistogram(target);
#line 3027 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMinmax); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMinmax)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "target, internalFormat, sink");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	Uint32	internalFormat = (Uint32)SvUV(ST(1));
	GLboolean	sink = (unsigned char)SvUV(ST(2));
#line 1589 "lib/SDL/OpenGL.xs"
		glMinmax(target,internalFormat,sink);
#line 3049 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glGetMinmax); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glGetMinmax)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "target, reset, format, type, values");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
	GLboolean	reset = (unsigned char)SvUV(ST(1));
	Uint32	format = (Uint32)SvUV(ST(2));
	Uint32	type = (Uint32)SvUV(ST(3));
	char *	values = (char *)SvPV_nolen(ST(4));
#line 1599 "lib/SDL/OpenGL.xs"
		glGetMinmax(target,reset,format,type,values);
#line 3073 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glResetMinmax); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glResetMinmax)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "target");
    {
	Uint32	target = (Uint32)SvUV(ST(0));
#line 1605 "lib/SDL/OpenGL.xs"
		glResetMinmax(target);
#line 3093 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glBlendEquation); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glBlendEquation)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	Uint32	mode = (Uint32)SvUV(ST(0));
#line 1611 "lib/SDL/OpenGL.xs"
		glBlendEquation(mode);
#line 3113 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif // GL_VERSION_1_3

XS(XS_SDL__OpenGL_glTexImage2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexImage2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "target, level, internalFormat, width, height, border, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	internalFormat = (Sint32)SvIV(ST(2));
	Uint32	width = (Uint32)SvUV(ST(3));
	Uint32	height = (Uint32)SvUV(ST(4));
	Sint32	border = (Sint32)SvIV(ST(5));
	GLenum	format = (GLenum)SvIV(ST(6));
	GLenum	type = (GLenum)SvIV(ST(7));
	char *	data = (char *)SvPV_nolen(ST(8));
#line 1627 "lib/SDL/OpenGL.xs"
		glTexImage2D(target,level,internalFormat,width,height,border,format,type,data);
#line 3142 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyTexImage2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyTexImage2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "target, level, internalFormat, x, y, width, height, border");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	internalFormat = (Sint32)SvIV(ST(2));
	Sint32	x = (Sint32)SvIV(ST(3));
	Sint32	y = (Sint32)SvIV(ST(4));
	Uint32	width = (Uint32)SvUV(ST(5));
	Uint32	height = (Uint32)SvUV(ST(6));
	Sint32	border = (Sint32)SvIV(ST(7));
#line 1640 "lib/SDL/OpenGL.xs"
		glCopyTexImage2D(target,level,internalFormat,x,y,width,height,border);
#line 3169 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexSubImage2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexSubImage2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "target, level, xoffset, yoffset, width, height, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	xoffset = (Sint32)SvIV(ST(2));
	Sint32	yoffset = (Sint32)SvIV(ST(3));
	Uint32	width = (Uint32)SvUV(ST(4));
	Uint32	height = (Uint32)SvUV(ST(5));
	GLenum	format = (GLenum)SvIV(ST(6));
	GLenum	type = (GLenum)SvIV(ST(7));
	char *	data = (char *)SvPV_nolen(ST(8));
#line 1654 "lib/SDL/OpenGL.xs"
		glTexSubImage2D(target,level,xoffset,yoffset,width,height,format,type,data);
#line 3197 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyTexSubImage2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyTexSubImage2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "target, level, xoffset, yoffset, x, y, width, height");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	xoffset = (Sint32)SvIV(ST(2));
	Sint32	yoffset = (Sint32)SvIV(ST(3));
	Sint32	x = (Sint32)SvIV(ST(4));
	Sint32	y = (Sint32)SvIV(ST(5));
	Uint32	width = (Uint32)SvUV(ST(6));
	Uint32	height = (Uint32)SvUV(ST(7));
#line 1667 "lib/SDL/OpenGL.xs"
		glCopyTexSubImage2D(target,level,xoffset,yoffset,x,y,width,height);
#line 3224 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexImage1D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexImage1D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "target, level, internalFormat, width, border, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	internalFormat = (Sint32)SvIV(ST(2));
	Uint32	width = (Uint32)SvUV(ST(3));
	Sint32	border = (Sint32)SvIV(ST(4));
	GLenum	format = (GLenum)SvIV(ST(5));
	GLenum	type = (GLenum)SvIV(ST(6));
	char *	data = (char *)SvPV_nolen(ST(7));
#line 1680 "lib/SDL/OpenGL.xs"
		glTexImage1D(target,level,internalFormat,width,border,format,type,data);	
#line 3251 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexSubImage1D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexSubImage1D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "target, level, xoffset, width, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	xoffset = (Sint32)SvIV(ST(2));
	Uint32	width = (Uint32)SvUV(ST(3));
	GLenum	format = (GLenum)SvIV(ST(4));
	GLenum	type = (GLenum)SvIV(ST(5));
	char *	data = (char *)SvPV_nolen(ST(6));
#line 1692 "lib/SDL/OpenGL.xs"
		glTexSubImage1D(target,level,xoffset,width,format,type,data);
#line 3277 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyTexImage1D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyTexImage1D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "target, level, internalFormat, x, y, width, border");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	internalFormat = (Sint32)SvIV(ST(2));
	Sint32	x = (Sint32)SvIV(ST(3));
	Sint32	y = (Sint32)SvIV(ST(4));
	Uint32	width = (Uint32)SvUV(ST(5));
	Sint32	border = (Sint32)SvIV(ST(6));
#line 1704 "lib/SDL/OpenGL.xs"
		glCopyTexImage1D(target,level,internalFormat,x,y,width,border);
#line 3303 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyTexSubImage1D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyTexSubImage1D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, level, xoffset, x, y, width");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	xoffset = (Sint32)SvIV(ST(2));
	Sint32	x = (Sint32)SvIV(ST(3));
	Sint32	y = (Sint32)SvIV(ST(4));
	Uint32	width = (Uint32)SvUV(ST(5));
#line 1715 "lib/SDL/OpenGL.xs"
		glCopyTexSubImage1D(target,level,xoffset,x,y,width);
#line 3328 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#ifdef GL_VERSION_1_3
#define XSubPPtmpAAAD 1


XS(XS_SDL__OpenGL_glTexImage3D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexImage3D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 10)
       croak_xs_usage(cv,  "target, level, internalFormat, width, height, depth, border, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	internalFormat = (Sint32)SvIV(ST(2));
	Uint32	width = (Uint32)SvUV(ST(3));
	Uint32	height = (Uint32)SvUV(ST(4));
	Uint32	depth = (Uint32)SvUV(ST(5));
	Sint32	border = (Sint32)SvIV(ST(6));
	GLenum	format = (GLenum)SvIV(ST(7));
	GLenum	type = (GLenum)SvIV(ST(8));
	char *	data = (char *)SvPV_nolen(ST(9));
#line 1732 "lib/SDL/OpenGL.xs"
		glTexImage3D(target,level,internalFormat,width,height,depth,border,format,type,data);
#line 3360 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexSubImage3D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexSubImage3D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 11)
       croak_xs_usage(cv,  "target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	xoffset = (Sint32)SvIV(ST(2));
	Sint32	yoffset = (Sint32)SvIV(ST(3));
	Sint32	zoffset = (Sint32)SvIV(ST(4));
	Uint32	width = (Uint32)SvUV(ST(5));
	Uint32	height = (Uint32)SvUV(ST(6));
	Uint32	depth = (Uint32)SvUV(ST(7));
	GLenum	format = (GLenum)SvIV(ST(8));
	GLenum	type = (GLenum)SvIV(ST(9));
	char *	data = (char *)SvPV_nolen(ST(10));
#line 1748 "lib/SDL/OpenGL.xs"
		glTexSubImage3D(target,level,xoffset,yoffset,zoffset,
			width,height,depth,format,type,data);
#line 3391 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glCopyTexSubImage3D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glCopyTexSubImage3D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "target, level, xoffset, yoffset, zoffset, x, y, width, height");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	level = (Sint32)SvIV(ST(1));
	Sint32	xoffset = (Sint32)SvIV(ST(2));
	Sint32	yoffset = (Sint32)SvIV(ST(3));
	Sint32	zoffset = (Sint32)SvIV(ST(4));
	Sint32	x = (Sint32)SvIV(ST(5));
	Sint32	y = (Sint32)SvIV(ST(6));
	Uint32	width = (Uint32)SvUV(ST(7));
	Uint32	height = (Uint32)SvUV(ST(8));
#line 1763 "lib/SDL/OpenGL.xs"
		glCopyTexSubImage3D(target,level,xoffset,yoffset,zoffset,x,y,width,height);
#line 3419 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif // GL_VERSION_1_3

XS(XS_SDL__OpenGL_glGenTextures); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glGenTextures)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "n");
    {
	Uint32	n = (Uint32)SvUV(ST(0));
	AV *	RETVAL;
#line 1771 "lib/SDL/OpenGL.xs"
		GLsizei i;
		GLuint* names;
		names = (GLuint*)safemalloc(sizeof(GLuint)*n);
		RETVAL = newAV();
		glGenTextures(n,names);
		for ( i = 0; i < n; i++ ) {
			av_push(RETVAL,newSViv(names[i]));
		}
		safefree(names);
#line 3449 "lib/SDL/OpenGL.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glIsTexture); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glIsTexture)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "texture");
    {
	Uint32	texture = (Uint32)SvUV(ST(0));
	GLboolean	RETVAL;
	dXSTARG;
#line 1787 "lib/SDL/OpenGL.xs"
		RETVAL = glIsTexture(texture);
#line 3473 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glBindTexture); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glBindTexture)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "target, texture");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Uint32	texture = (Uint32)SvUV(ST(1));
#line 1796 "lib/SDL/OpenGL.xs"
		glBindTexture(target,texture);
#line 3495 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDeleteTextures); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDeleteTextures)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 1801 "lib/SDL/OpenGL.xs"
		GLuint* textures;
		int i;
		textures = (GLuint*)safemalloc(sizeof(GLuint) * items);
		if ( textures ) {
	 		for ( i = 0; i < items; i++ ) {
				textures[i] = SvIV(ST(i));	
			}
		}
		glDeleteTextures(items,textures);
		safefree(textures);
#line 3522 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glAreTexturesResident); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glAreTexturesResident)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
	AV *	RETVAL;
#line 1815 "lib/SDL/OpenGL.xs"
		GLuint* textures;
		GLboolean *homes;
		int i;
		RETVAL = newAV();
		textures = (GLuint*)safemalloc(sizeof(GLuint) * items);
		homes = (GLboolean*)safemalloc(sizeof(GLboolean) * items);
		if ( textures ) {
	 		for ( i = 0; i < items; i++ ) {
				textures[i] = SvIV(ST(i));	
			}
		}
		if ( GL_FALSE != glAreTexturesResident(items,textures,homes)) {
			for (i = 0; i < items; i++ ) {
				av_push(RETVAL,newSViv(homes[i]));	
			}
		}
		safefree(homes);
		safefree(textures);
#line 3558 "lib/SDL/OpenGL.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glPrioritizeTextures); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPrioritizeTextures)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "n, names, priorities");
    {
	Uint32	n = (Uint32)SvUV(ST(0));
	char *	names = (char *)SvPV_nolen(ST(1));
	char *	priorities = (char *)SvPV_nolen(ST(2));
#line 1842 "lib/SDL/OpenGL.xs"
		glPrioritizeTextures(n,(GLuint*)names,(const GLclampf *)priorities);
#line 3582 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexEnv); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexEnv)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "target, name, ...");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	GLenum	name = (GLenum)SvIV(ST(1));
#line 1849 "lib/SDL/OpenGL.xs"
		float pv[4];
		GLint p;	
		switch(name) {
			case GL_TEXTURE_ENV_MODE:
				p = SvIV(ST(2));
				glTexEnvi(target,name,p);	
				break;
			case GL_TEXTURE_ENV_COLOR:
				pv[0] = SvNV(ST(2));
				pv[1] = SvNV(ST(3));
				pv[2] = SvNV(ST(4));
				pv[3] = SvNV(ST(5));
				glTexEnvfv(target,name,pv);
				break;
		}
#line 3617 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexCoord); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexCoord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 1868 "lib/SDL/OpenGL.xs"
		double s,t,r,q;
		if ( items < 1 || items > 4 ) 
			Perl_croak (aTHX_ "usage: SDL::OpenGL::TexCoord(s,[t,[r,[q]]])");
		s = t = r = 0.0;
		q = 1.0;
		switch(items) {
			case 4:
				q = SvNV(ST(3)); 
			case 3:
				r = SvNV(ST(2)); 
			case 2:
				t = SvNV(ST(1)); 
			case 1:
				s = SvNV(ST(0));	
		}
		glTexCoord4d(s,t,r,q);
#line 3650 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexParameter); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexParameter)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "target, name, ...");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	GLenum	name = (GLenum)SvIV(ST(1));
#line 1890 "lib/SDL/OpenGL.xs"
		GLfloat pv[4];
		GLint p;
		switch (name) {
			case GL_TEXTURE_BORDER_COLOR:
				pv[0] = SvNV(ST(2));
				pv[1] = SvNV(ST(3));
				pv[2] = SvNV(ST(4));
				pv[3] = SvNV(ST(5));
				glTexParameterfv(target,name,pv);
				break;
			case GL_TEXTURE_PRIORITY:
			case GL_TEXTURE_MIN_LOD:
			case GL_TEXTURE_MAX_LOD:
				pv[0] = SvNV(ST(2));
				glTexParameterf(target,name,pv[0]);	
				break;
			case GL_TEXTURE_BASE_LEVEL:
			case GL_TEXTURE_MAX_LEVEL:
			default:
				p = SvIV(ST(2));	
				glTexParameteri(target,name,p);
				break;
		}
#line 3693 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glTexGen); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glTexGen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2)
       croak_xs_usage(cv,  "coord, name, ...");
    {
	GLenum	coord = (GLenum)SvIV(ST(0));
	GLenum	name = (GLenum)SvIV(ST(1));
#line 1919 "lib/SDL/OpenGL.xs"
		GLdouble *pv;
		GLint p;
		int i;
		switch (name) {
			case GL_TEXTURE_GEN_MODE:
				p = SvIV(ST(2));
				glTexGeni(coord,name,p);
				break;
			default:
				if ( items == 2 ) 
					Perl_croak(aTHX_  "usage: glTexGen(coord,name,...)");
				pv = (GLdouble*)safemalloc(sizeof(GLdouble)*(items-2));
				for ( i = 0; i < items - 2; i++ ) {
					pv[i] = SvNV(ST(i+2));	
				}
				glTexGendv(coord,name,pv);	
				safefree(pv);
				break;
		}
#line 3732 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#ifdef GL_VERSION_1_3
#define XSubPPtmpAAAE 1


XS(XS_SDL__OpenGL_glActiveTextureARB); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glActiveTextureARB)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "texUnit");
    {
	GLenum	texUnit = (GLenum)SvIV(ST(0));
#line 1945 "lib/SDL/OpenGL.xs"
		glActiveTextureARB(texUnit);
#line 3755 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMultiTexCoord); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMultiTexCoord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1)
       croak_xs_usage(cv,  "texUnit, ...");
    {
	Uint32	texUnit = (Uint32)SvUV(ST(0));
#line 1951 "lib/SDL/OpenGL.xs"
		double s,t,r,q;
		if ( items < 2 || items > 5 ) 
			Perl_croak (aTHX_ "usage: SDL::OpenGL::MultiTexCoord(tex,s,[t,[r,[q]]])");
		s = t = r = 0.0;
		q = 1.0;
		switch(items) {
			case 5:
				q = SvNV(ST(3)); 
			case 4:
				r = SvNV(ST(2)); 
			case 3:
				t = SvNV(ST(1)); 
			case 2:
				s = SvNV(ST(0));	
		}
		glMultiTexCoord4dARB(texUnit,s,t,r,q);
#line 3790 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif // GL_VERSION_1_3

XS(XS_SDL__OpenGL_glDrawBuffer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDrawBuffer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
#line 1974 "lib/SDL/OpenGL.xs"
		glDrawBuffer(mode);
#line 3811 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glReadBuffer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glReadBuffer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
#line 1980 "lib/SDL/OpenGL.xs"
		glReadBuffer(mode);
#line 3831 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glIndexMask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glIndexMask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mask");
    {
	Uint32	mask = (Uint32)SvUV(ST(0));
#line 1986 "lib/SDL/OpenGL.xs"
		glIndexMask(mask);
#line 3851 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glColorMask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glColorMask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "red, green, blue, alpha");
    {
	GLboolean	red = (unsigned char)SvUV(ST(0));
	GLboolean	green = (unsigned char)SvUV(ST(1));
	GLboolean	blue = (unsigned char)SvUV(ST(2));
	GLboolean	alpha = (unsigned char)SvUV(ST(3));
#line 1995 "lib/SDL/OpenGL.xs"
		glColorMask(red,green,blue,alpha);
#line 3874 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDepthMask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDepthMask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "flag");
    {
	GLboolean	flag = (unsigned char)SvUV(ST(0));
#line 2001 "lib/SDL/OpenGL.xs"
		glDepthMask(flag);
#line 3894 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glStencilMask); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glStencilMask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mask");
    {
	Uint32	mask = (Uint32)SvUV(ST(0));
#line 2007 "lib/SDL/OpenGL.xs"
		glStencilMask(mask);
#line 3914 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glScissor); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glScissor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "x, y, width, height");
    {
	Sint32	x = (Sint32)SvIV(ST(0));
	Sint32	y = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
#line 2016 "lib/SDL/OpenGL.xs"
		glScissor(x,y,width,height);
#line 3937 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glAlphaFunc); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glAlphaFunc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "func, ref");
    {
	GLenum	func = (GLenum)SvIV(ST(0));
	double	ref = (double)SvNV(ST(1));
#line 2023 "lib/SDL/OpenGL.xs"
		glAlphaFunc(func,ref);
#line 3958 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glStencilFunc); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glStencilFunc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "func, ref, mask");
    {
	GLenum	func = (GLenum)SvIV(ST(0));
	Sint32	ref = (Sint32)SvIV(ST(1));
	Uint32	mask = (Uint32)SvUV(ST(2));
#line 2031 "lib/SDL/OpenGL.xs"
		glStencilFunc(func,ref,mask);
#line 3980 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glStencilOp); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glStencilOp)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "fail, zfail, zpass");
    {
	GLenum	fail = (GLenum)SvIV(ST(0));
	GLenum	zfail = (GLenum)SvIV(ST(1));
	GLenum	zpass = (GLenum)SvIV(ST(2));
#line 2039 "lib/SDL/OpenGL.xs"
		glStencilOp(fail,zfail,zpass);
#line 4002 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glDepthFunc); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glDepthFunc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "func");
    {
	GLenum	func = (GLenum)SvIV(ST(0));
#line 2045 "lib/SDL/OpenGL.xs"
		glDepthFunc(func);
#line 4022 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLogicOp); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLogicOp)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "opcode");
    {
	GLenum	opcode = (GLenum)SvIV(ST(0));
#line 2051 "lib/SDL/OpenGL.xs"
		glLogicOp(opcode);
#line 4042 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glAccum); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glAccum)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "op, value");
    {
	GLenum	op = (GLenum)SvIV(ST(0));
	double	value = (double)SvNV(ST(1));
#line 2058 "lib/SDL/OpenGL.xs"
		glAccum(op,value);
#line 4063 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMap1); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMap1)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, u1, u2, stride, order, points");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	double	u1 = (double)SvNV(ST(1));
	double	u2 = (double)SvNV(ST(2));
	Sint32	stride = (Sint32)SvIV(ST(3));
	Sint32	order = (Sint32)SvIV(ST(4));
	char *	points = (char *)SvPV_nolen(ST(5));
#line 2069 "lib/SDL/OpenGL.xs"
		glMap1d(target,u1,u2,stride,order,(double*)points);
#line 4088 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEvalCoord1); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEvalCoord1)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "u");
    {
	double	u = (double)SvNV(ST(0));
#line 2075 "lib/SDL/OpenGL.xs"
		glEvalCoord1d(u);	
#line 4108 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMapGrid1); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMapGrid1)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "n, u1, u2");
    {
	Sint32	n = (Sint32)SvIV(ST(0));
	double	u1 = (double)SvNV(ST(1));
	double	u2 = (double)SvNV(ST(2));
#line 2083 "lib/SDL/OpenGL.xs"
		glMapGrid1d(n,u1,u2);
#line 4130 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEvalMesh1); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEvalMesh1)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "mode, p1, p2");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
	Sint32	p1 = (Sint32)SvIV(ST(1));
	Sint32	p2 = (Sint32)SvIV(ST(2));
#line 2091 "lib/SDL/OpenGL.xs"
		glEvalMesh1(mode,p1,p2);
#line 4152 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMap2); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMap2)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 10)
       croak_xs_usage(cv,  "target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	double	u1 = (double)SvNV(ST(1));
	double	u2 = (double)SvNV(ST(2));
	Sint32	ustride = (Sint32)SvIV(ST(3));
	Sint32	uorder = (Sint32)SvIV(ST(4));
	double	v1 = (double)SvNV(ST(5));
	double	v2 = (double)SvNV(ST(6));
	Sint32	vstride = (Sint32)SvIV(ST(7));
	Sint32	vorder = (Sint32)SvIV(ST(8));
	char *	points = (char *)SvPV_nolen(ST(9));
#line 2106 "lib/SDL/OpenGL.xs"
		glMap2d(target,u1,u2,ustride,uorder,v1,v2,vstride,vorder,(double*)points);
#line 4181 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEvalCoord2); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEvalCoord2)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "u, v");
    {
	double	u = (double)SvNV(ST(0));
	double	v = (double)SvNV(ST(1));
#line 2113 "lib/SDL/OpenGL.xs"
		glEvalCoord2d(u,v);
#line 4202 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glMapGrid2); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glMapGrid2)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "nu, u1, u2, nv, v1, v2");
    {
	Sint32	nu = (Sint32)SvIV(ST(0));
	double	u1 = (double)SvNV(ST(1));
	double	u2 = (double)SvNV(ST(2));
	Sint32	nv = (Sint32)SvIV(ST(3));
	double	v1 = (double)SvNV(ST(4));
	double	v2 = (double)SvNV(ST(5));
#line 2124 "lib/SDL/OpenGL.xs"
		glMapGrid2d(nu,u1,u2,nv,v1,v2);
#line 4227 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glEvalMesh2); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glEvalMesh2)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "mode, i1, i2, j1, j2");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
	Sint32	i1 = (Sint32)SvIV(ST(1));
	Sint32	i2 = (Sint32)SvIV(ST(2));
	Sint32	j1 = (Sint32)SvIV(ST(3));
	Sint32	j2 = (Sint32)SvIV(ST(4));
#line 2134 "lib/SDL/OpenGL.xs"
		glEvalMesh2(mode,i1,i2,j1,j2);
#line 4251 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glGetError); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glGetError)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	GLenum	RETVAL;
	dXSTARG;
#line 2139 "lib/SDL/OpenGL.xs"
		RETVAL = glGetError();
#line 4272 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glRenderMode); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glRenderMode)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (GLenum)SvIV(ST(0));
	GLint	RETVAL;
	dXSTARG;
#line 2147 "lib/SDL/OpenGL.xs"
		RETVAL = glRenderMode( mode );
#line 4295 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_glInitNames); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glInitNames)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2154 "lib/SDL/OpenGL.xs"
		glInitNames();
#line 4315 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPushName); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPushName)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	GLuint	name = (GLuint)SvUV(ST(0));
#line 2160 "lib/SDL/OpenGL.xs"
		glPushName(name);
#line 4335 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPopName); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPopName)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2165 "lib/SDL/OpenGL.xs"
		glPopName();		
#line 4354 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glLoadName); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glLoadName)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	GLuint	name = (GLuint)SvUV(ST(0));
#line 2171 "lib/SDL/OpenGL.xs"
		glLoadName(name);
#line 4374 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glFeedbackBuffer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glFeedbackBuffer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "size, type, buffer");
    {
	GLuint	size = (GLuint)SvUV(ST(0));
	GLenum	type = (GLenum)SvIV(ST(1));
	float*	buffer = INT2PTR(float *,SvIV(ST(2)));
#line 2179 "lib/SDL/OpenGL.xs"
		glFeedbackBuffer(size,type,buffer);		
#line 4396 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_glPassThrough); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_glPassThrough)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "token");
    {
	GLfloat	token = (GLfloat)SvNV(ST(0));
#line 2185 "lib/SDL/OpenGL.xs"
		glPassThrough(token);
#line 4416 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif
#ifdef HAVE_GLU
#define XSubPPtmpAAAF 1


XS(XS_SDL__OpenGL_gluLookAt); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluLookAt)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz");
    {
	double	eyex = (double)SvNV(ST(0));
	double	eyey = (double)SvNV(ST(1));
	double	eyez = (double)SvNV(ST(2));
	double	centerx = (double)SvNV(ST(3));
	double	centery = (double)SvNV(ST(4));
	double	centerz = (double)SvNV(ST(5));
	double	upx = (double)SvNV(ST(6));
	double	upy = (double)SvNV(ST(7));
	double	upz = (double)SvNV(ST(8));
#line 2204 "lib/SDL/OpenGL.xs"
		gluLookAt(eyex,eyey,eyez,centerx,centery,centerz,upx,upy,upz);
#line 4448 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluPerspective); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluPerspective)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "fovy, aspect, n, f");
    {
	double	fovy = (double)SvNV(ST(0));
	double	aspect = (double)SvNV(ST(1));
	double	n = (double)SvNV(ST(2));
	double	f = (double)SvNV(ST(3));
#line 2213 "lib/SDL/OpenGL.xs"
		gluPerspective(fovy,aspect,n,f);
#line 4471 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluPickMatrix); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluPickMatrix)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "x, y, delx, dely, viewport");
    {
	double	x = (double)SvNV(ST(0));
	double	y = (double)SvNV(ST(1));
	double	delx = (double)SvNV(ST(2));
	double	dely = (double)SvNV(ST(3));
	GLint*	viewport = INT2PTR(GLint *,SvIV(ST(4)));
#line 2223 "lib/SDL/OpenGL.xs"
		gluPickMatrix(x,y,delx,dely,viewport);
#line 4495 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluOrtho2D); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluOrtho2D)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "left, right, bottom, top");
    {
	double	left = (double)SvNV(ST(0));
	double	right = (double)SvNV(ST(1));
	double	bottom = (double)SvNV(ST(2));
	double	top = (double)SvNV(ST(3));
#line 2232 "lib/SDL/OpenGL.xs"
		gluOrtho2D(left,right,bottom,top);
#line 4518 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluScaleImage); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluScaleImage)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "format, widthin, heightin, typein, datain, widthout, heightout, typeout, dataout");
    {
	GLenum	format = (GLenum)SvIV(ST(0));
	Uint32	widthin = (Uint32)SvUV(ST(1));
	Uint32	heightin = (Uint32)SvUV(ST(2));
	GLenum	typein = (GLenum)SvIV(ST(3));
	char *	datain = (char *)SvPV_nolen(ST(4));
	Uint32	widthout = (Uint32)SvUV(ST(5));
	Uint32	heightout = (Uint32)SvUV(ST(6));
	GLenum	typeout = (GLenum)SvIV(ST(7));
	char *	dataout = (char *)SvPV_nolen(ST(8));
	int	RETVAL;
	dXSTARG;
#line 2246 "lib/SDL/OpenGL.xs"
		RETVAL = gluScaleImage(format,widthin,heightin,typein,datain,
				widthout,heightout,typeout,dataout);
#line 4549 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluBuild1DMipmaps); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild1DMipmaps)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "target, internalFormat, width, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	internalFormat = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	GLenum	format = (GLenum)SvIV(ST(3));
	GLenum	type = (GLenum)SvIV(ST(4));
	char *	data = (char *)SvPV_nolen(ST(5));
	int	RETVAL;
	dXSTARG;
#line 2260 "lib/SDL/OpenGL.xs"
		RETVAL = gluBuild1DMipmaps(target,internalFormat,width,format,type,data);
#line 4577 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluBuild2DMipmaps); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild2DMipmaps)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "target, internalFormat, width, height, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	internalFormat = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
	GLenum	format = (GLenum)SvIV(ST(4));
	GLenum	type = (GLenum)SvIV(ST(5));
	char *	data = (char *)SvPV_nolen(ST(6));
	int	RETVAL;
	dXSTARG;
#line 2274 "lib/SDL/OpenGL.xs"
		RETVAL = gluBuild2DMipmaps(target,internalFormat,width,height,format,type,data);
#line 4606 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if HAVE_GLU_VERSION >= 12
#define XSubPPtmpAAAG 1


XS(XS_SDL__OpenGL_gluBuild3DMipmaps); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild3DMipmaps)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 8)
       croak_xs_usage(cv,  "target, internalFormat, width, height, depth, format, type, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	internalFormat = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
	Uint32	depth = (Uint32)SvUV(ST(4));
	GLenum	format = (GLenum)SvIV(ST(5));
	GLenum	type = (GLenum)SvIV(ST(6));
	char *	data = (char *)SvPV_nolen(ST(7));
	int	RETVAL;
	dXSTARG;
#line 2291 "lib/SDL/OpenGL.xs"
		RETVAL = gluBuild3DMipmaps(target,internalFormat,width,height,depth,
				format,type,data);
#line 4640 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAH 1


XS(XS_SDL__OpenGL_gluBuild3DMipmaps); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild3DMipmaps)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2300 "lib/SDL/OpenGL.xs"
		Perl_croak (aTHX_ "SDL::OpenGL::Build3DMipmaps requires GLU 1.2");
#line 4663 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if HAVE_GLU_VERSION >= 12
#define XSubPPtmpAAAI 1


XS(XS_SDL__OpenGL_gluBuild1DMipmapLevels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild1DMipmapLevels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "target, internalFormat, width, format, type, level, base, max, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	internalFormat = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	GLenum	format = (GLenum)SvIV(ST(3));
	GLenum	type = (GLenum)SvIV(ST(4));
	Sint32	level = (Sint32)SvIV(ST(5));
	Sint32	base = (Sint32)SvIV(ST(6));
	Sint32	max = (Sint32)SvIV(ST(7));
	char *	data = (char *)SvPV_nolen(ST(8));
	int	RETVAL;
	dXSTARG;
#line 2317 "lib/SDL/OpenGL.xs"
		RETVAL = gluBuild1DMipmapLevels(target,internalFormat,width,
				format,type,level,base,max,data);
#line 4698 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAJ 1


XS(XS_SDL__OpenGL_gluBuild1DMipmapLevels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild1DMipmapLevels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2326 "lib/SDL/OpenGL.xs"
		Perl_croak(aTHX_ "SDL::OpenGL::Build1DMipmapLevels requires GLU 1.2");		
#line 4721 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if HAVE_GLU_VERSION >= 12
#define XSubPPtmpAAAK 1


XS(XS_SDL__OpenGL_gluBuild2DMipmapLevels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild2DMipmapLevels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 10)
       croak_xs_usage(cv,  "target, internalFormat, width, height, format, type, level, base, max, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	internalFormat = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
	GLenum	format = (GLenum)SvIV(ST(4));
	GLenum	type = (GLenum)SvIV(ST(5));
	Sint32	level = (Sint32)SvIV(ST(6));
	Sint32	base = (Sint32)SvIV(ST(7));
	Sint32	max = (Sint32)SvIV(ST(8));
	char *	data = (char *)SvPV_nolen(ST(9));
	int	RETVAL;
	dXSTARG;
#line 2344 "lib/SDL/OpenGL.xs"
		RETVAL = gluBuild2DMipmapLevels(target,internalFormat,width,height,
				format,type,level,base,max,data);
#line 4757 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAL 1


XS(XS_SDL__OpenGL_gluBuild2DMipmapLevels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild2DMipmapLevels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2353 "lib/SDL/OpenGL.xs"
		Perl_croak(aTHX_ "SDL::OpenGL::Build2DMipmapLevels requires GLU 1.2");		
#line 4780 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if HAVE_GLU_VERSION >= 12
#define XSubPPtmpAAAM 1


XS(XS_SDL__OpenGL_gluBuild3DMipmapLevels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild3DMipmapLevels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 11)
       croak_xs_usage(cv,  "target, internalFormat, width, height, depth, format, type, level, base, max, data");
    {
	GLenum	target = (GLenum)SvIV(ST(0));
	Sint32	internalFormat = (Sint32)SvIV(ST(1));
	Uint32	width = (Uint32)SvUV(ST(2));
	Uint32	height = (Uint32)SvUV(ST(3));
	Uint32	depth = (Uint32)SvUV(ST(4));
	GLenum	format = (GLenum)SvIV(ST(5));
	GLenum	type = (GLenum)SvIV(ST(6));
	Sint32	level = (Sint32)SvIV(ST(7));
	Sint32	base = (Sint32)SvIV(ST(8));
	Sint32	max = (Sint32)SvIV(ST(9));
	char *	data = (char *)SvPV_nolen(ST(10));
	int	RETVAL;
	dXSTARG;
#line 2372 "lib/SDL/OpenGL.xs"
		RETVAL = gluBuild3DMipmapLevels(target,internalFormat,width,height,depth,
				format,type,level,base,max,data);
#line 4817 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#else
#define XSubPPtmpAAAN 1


XS(XS_SDL__OpenGL_gluBuild3DMipmapLevels); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBuild3DMipmapLevels)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 2381 "lib/SDL/OpenGL.xs"
		Perl_croak(aTHX_ "SDL::OpenGL::Build3DMipmapLevels requires GLU 1.2");		
#line 4840 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS(XS_SDL__OpenGL_gluErrorString); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluErrorString)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "code");
    {
	GLenum	code = (GLenum)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;
#line 2389 "lib/SDL/OpenGL.xs"
		RETVAL = (char*)gluErrorString(code);
#line 4863 "lib/SDL/OpenGL.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluNewNurbsRenderer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNewNurbsRenderer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	GLUnurbsObj *	RETVAL;
	dXSTARG;
#line 2396 "lib/SDL/OpenGL.xs"
		RETVAL = gluNewNurbsRenderer();
#line 4885 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluDeleteNurbsRenderer); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluDeleteNurbsRenderer)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "obj");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
#line 2404 "lib/SDL/OpenGL.xs"
		gluDeleteNurbsRenderer(obj);
#line 4906 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluNurbsProperty); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNurbsProperty)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "obj, property, value");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	GLenum	property = (GLenum)SvIV(ST(1));
	double	value = (double)SvNV(ST(2));
#line 2412 "lib/SDL/OpenGL.xs"
		gluNurbsProperty(obj,property,(float)value);
#line 4928 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluLoadSamplingMatrices); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluLoadSamplingMatrices)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "obj, mm, pm, vp");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	char *	mm = (char *)SvPV_nolen(ST(1));
	char *	pm = (char *)SvPV_nolen(ST(2));
	char *	vp = (char *)SvPV_nolen(ST(3));
#line 2421 "lib/SDL/OpenGL.xs"
		gluLoadSamplingMatrices(obj,(GLfloat*)mm,(GLfloat*)pm,(GLint*)vp);
#line 4951 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluGetNurbsProperty); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluGetNurbsProperty)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "obj, property");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	GLenum	property = (GLenum)SvIV(ST(1));
	double	RETVAL;
	dXSTARG;
#line 2428 "lib/SDL/OpenGL.xs"
		float f;
		gluGetNurbsProperty(obj,property,&f);
		RETVAL = (double)f;
#line 4976 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluNurbsCallback); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNurbsCallback)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "obj, which, cb");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	GLenum	which = (GLenum)SvIV(ST(1));
	SV *	cb = ST(2);
#line 2440 "lib/SDL/OpenGL.xs"
		switch(which) {
			case GLU_ERROR:
				sdl_perl_nurbs_error_hook = cb;
				gluNurbsCallback(obj,GLU_ERROR,(GLvoid*)sdl_perl_nurbs_error_callback);
				break;
#ifdef GLU_NURBS_BEGIN
#ifdef GLU_VERSION_1_3
			case GLU_NURBS_BEGIN:
			case GLU_NURBS_BEGIN_DATA:

				gluNurbsCallbackData(obj,(void*)cb);
				gluNurbsCallback(obj,GLU_NURBS_BEGIN_DATA,
					(GLvoid*)sdl_perl_nurbs_being_callback);	
				break;
			case GLU_NURBS_TEXTURE_COORD:
			case GLU_NURBS_TEXTURE_COORD_DATA:
				gluNurbsCallbackData(obj,(void*)cb);
				gluNurbsCallback(obj,GLU_NURBS_TEXTURE_COORD_DATA,
					(GLvoid*)sdl_perl_nurbs_multi_callback);	
				break;
			case GLU_NURBS_COLOR:
			case GLU_NURBS_COLOR_DATA:
				gluNurbsCallbackData(obj,(void*)cb);
				gluNurbsCallback(obj,GLU_NURBS_COLOR_DATA,
					(GLvoid*)sdl_perl_nurbs_multi_callback);	
				break;
			case GLU_NURBS_NORMAL:
			case GLU_NURBS_NORMAL_DATA:
				gluNurbsCallbackData(obj,(void*)cb);
				gluNurbsCallback(obj,GLU_NURBS_NORMAL_DATA,
					(GLvoid*)sdl_perl_nurbs_multi_callback);	
				break;
			case GLU_NURBS_VERTEX:
			case GLU_NURBS_VERTEX_DATA:
				gluNurbsCallbackData(obj,(void*)cb);
				gluNurbsCallback(obj,GLU_NURBS_VERTEX_DATA,
					(GLvoid*)sdl_perl_nurbs_multi_callback);	
				break;
			case GLU_NURBS_END:
			case GLU_NURBS_END_DATA:
				gluNurbsCallbackData(obj,(void*)cb);
				gluNurbsCallback(obj,GLU_NURBS_END_DATA,
					(GLvoid*)sdl_perl_nurbs_end_callback);	
				break;
#endif // GLU_VERSION_1_3
#endif // GLU_NURBS_BEGIN
			default:
				Perl_croak(aTHX_ "SDL::OpenGL::NurbsCallback - invalid type");
		}
#line 5047 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#ifdef GLU_VERSION_1_3
#define XSubPPtmpAAAO 1


XS(XS_SDL__OpenGL_gluNurbsCallbackData); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNurbsCallbackData)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "obj, cb");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	SV *	cb = ST(1);
#line 2497 "lib/SDL/OpenGL.xs"
		gluNurbsCallbackData(obj,(void*)cb);
#line 5071 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS(XS_SDL__OpenGL_gluBeginSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBeginSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "obj");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
#line 2505 "lib/SDL/OpenGL.xs"
		gluBeginSurface(obj);
#line 5092 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluEndSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluEndSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "obj");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
#line 2511 "lib/SDL/OpenGL.xs"
		gluEndSurface(obj);
#line 5112 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluNurbsSurface); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNurbsSurface)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 11)
       croak_xs_usage(cv,  "obj, uknot_count, uknot, vknot_count, vknot, u_stride, v_stride, ctlarray, uorder, vorder, type");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	Sint32	uknot_count = (Sint32)SvIV(ST(1));
	char *	uknot = (char *)SvPV_nolen(ST(2));
	Sint32	vknot_count = (Sint32)SvIV(ST(3));
	char *	vknot = (char *)SvPV_nolen(ST(4));
	Sint32	u_stride = (Sint32)SvIV(ST(5));
	Sint32	v_stride = (Sint32)SvIV(ST(6));
	char *	ctlarray = (char *)SvPV_nolen(ST(7));
	Sint32	uorder = (Sint32)SvIV(ST(8));
	Sint32	vorder = (Sint32)SvIV(ST(9));
	GLenum	type = (GLenum)SvIV(ST(10));
#line 2527 "lib/SDL/OpenGL.xs"
		gluNurbsSurface(obj,uknot_count,(GLfloat*)uknot,vknot_count,(GLfloat*)vknot,
			u_stride,v_stride,(GLfloat*)ctlarray,uorder,vorder,type);
#line 5143 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluBeginCurve); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBeginCurve)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "obj");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
#line 2534 "lib/SDL/OpenGL.xs"
		gluBeginCurve(obj);
#line 5163 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluEndCurve); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluEndCurve)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "obj");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
#line 2540 "lib/SDL/OpenGL.xs"
		gluEndCurve(obj);
#line 5183 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluNurbsCurve); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNurbsCurve)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "obj, uknot_count, uknot, u_stride, ctlarray, uorder, type");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	Sint32	uknot_count = (Sint32)SvIV(ST(1));
	char *	uknot = (char *)SvPV_nolen(ST(2));
	Sint32	u_stride = (Sint32)SvIV(ST(3));
	char *	ctlarray = (char *)SvPV_nolen(ST(4));
	Sint32	uorder = (Sint32)SvIV(ST(5));
	GLenum	type = (GLenum)SvIV(ST(6));
#line 2552 "lib/SDL/OpenGL.xs"
		gluNurbsCurve(obj,uknot_count,(GLfloat*)uknot,u_stride,(GLfloat*)ctlarray,
			uorder,type);
#line 5210 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluBeginTrim); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluBeginTrim)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "obj");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
#line 2559 "lib/SDL/OpenGL.xs"
		gluBeginTrim(obj);
#line 5230 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluEndTrim); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluEndTrim)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "obj");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
#line 2565 "lib/SDL/OpenGL.xs"
		gluEndTrim(obj);
#line 5250 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluPwlCurve); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluPwlCurve)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "obj, count, array, stride, type");
    {
	GLUnurbsObj *	obj = INT2PTR(GLUnurbsObj *,SvIV(ST(0)));
	Sint32	count = (Sint32)SvIV(ST(1));
	char *	array = (char *)SvPV_nolen(ST(2));
	Sint32	stride = (Sint32)SvIV(ST(3));
	GLenum	type = (GLenum)SvIV(ST(4));
#line 2575 "lib/SDL/OpenGL.xs"
		gluPwlCurve(obj,count,(GLfloat*)array,stride,type);
#line 5274 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluUnProject); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluUnProject)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "winx, winy, winz, mm, pm, vp");
    {
	double	winx = (double)SvNV(ST(0));
	double	winy = (double)SvNV(ST(1));
	double	winz = (double)SvNV(ST(2));
	char *	mm = (char *)SvPV_nolen(ST(3));
	char *	pm = (char *)SvPV_nolen(ST(4));
	char *	vp = (char *)SvPV_nolen(ST(5));
	AV *	RETVAL;
#line 2586 "lib/SDL/OpenGL.xs"
		GLdouble objx, objy, objz;
		RETVAL = newAV();
		av_push(RETVAL,newSViv(gluUnProject(winx,winy,winz,(GLdouble*)mm,
			(GLdouble*)pm,(GLint*)vp,&objx,&objy,&objz)));
		av_push(RETVAL,newSVnv((double)objx));
		av_push(RETVAL,newSVnv((double)objy));
		av_push(RETVAL,newSVnv((double)objz));
#line 5306 "lib/SDL/OpenGL.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#ifdef GL_VERSION_1_3
#define XSubPPtmpAAAP 1


XS(XS_SDL__OpenGL_gluUnProject4); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluUnProject4)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 9)
       croak_xs_usage(cv,  "winx, winy, winz, clipw, mm, pm, vp, n, f");
    {
	double	winx = (double)SvNV(ST(0));
	double	winy = (double)SvNV(ST(1));
	double	winz = (double)SvNV(ST(2));
	double	clipw = (double)SvNV(ST(3));
	char *	mm = (char *)SvPV_nolen(ST(4));
	char *	pm = (char *)SvPV_nolen(ST(5));
	char *	vp = (char *)SvPV_nolen(ST(6));
	double	n = (double)SvNV(ST(7));
	double	f = (double)SvNV(ST(8));
	AV *	RETVAL;
#line 2611 "lib/SDL/OpenGL.xs"
                GLdouble objx, objy, objz, objw;
                RETVAL = newAV();
                av_push(RETVAL,newSViv(gluUnProject4(winx,winy,winz,clipw,(GLdouble*)mm,
                        (GLdouble*)pm,(GLint*)vp,(GLclampd)n,(GLclampd)f,
			&objx,&objy,&objz,&objw)));
                av_push(RETVAL,newSVnv((double)objx));
                av_push(RETVAL,newSVnv((double)objy));
                av_push(RETVAL,newSVnv((double)objz));
                av_push(RETVAL,newSVnv((double)objw));
#line 5348 "lib/SDL/OpenGL.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif // GL_VERSION_1_3

XS(XS_SDL__OpenGL_gluProject); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluProject)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "objx, objy, objz, mm, pm, vp");
    {
	double	objx = (double)SvNV(ST(0));
	double	objy = (double)SvNV(ST(1));
	double	objz = (double)SvNV(ST(2));
	char *	mm = (char *)SvPV_nolen(ST(3));
	char *	pm = (char *)SvPV_nolen(ST(4));
	char *	vp = (char *)SvPV_nolen(ST(5));
	AV *	RETVAL;
#line 2634 "lib/SDL/OpenGL.xs"
		GLdouble winx, winy, winz;
		RETVAL = newAV();
		av_push(RETVAL,newSViv(gluUnProject(objx,objy,objz,(GLdouble*)mm,
			(GLdouble*)pm,(GLint*)vp,&winx,&winy,&winz)));
                av_push(RETVAL,newSVnv((double)winx));
                av_push(RETVAL,newSVnv((double)winy));
                av_push(RETVAL,newSVnv((double)winz));
#line 5383 "lib/SDL/OpenGL.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#ifdef GL_VERSION_1_2
#define XSubPPtmpAAAQ 1


XS(XS_SDL__OpenGL_gluNewTess); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNewTess)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	GLUtesselator *	RETVAL;
	dXSTARG;
#line 2649 "lib/SDL/OpenGL.xs"
		RETVAL = gluNewTess();
#line 5409 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluTessCallback); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessCallback)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "tess, type");
    {
	GLUtesselator *	tess = INT2PTR(GLUtesselator *,SvIV(ST(0)));
	GLenum	type = (GLenum)SvIV(ST(1));
#line 2658 "lib/SDL/OpenGL.xs"
		switch(type) {
			case GLU_TESS_BEGIN:
			case GLU_TESS_BEGIN_DATA:
				gluTessCallback(tess,GLU_TESS_BEGIN_DATA,
					(GLvoid*)sdl_perl_tess_begin_callback);	
				break;

			case GLU_TESS_EDGE_FLAG:
			case GLU_TESS_EDGE_FLAG_DATA:
				gluTessCallback(tess,GLU_TESS_EDGE_FLAG_DATA,
					(GLvoid*)sdl_perl_tess_edge_flag_callback);	
				break;

			case GLU_TESS_VERTEX:
			case GLU_TESS_VERTEX_DATA:
				gluTessCallback(tess,GLU_TESS_VERTEX_DATA,
					(GLvoid*)sdl_perl_tess_vertex_callback);	
				break;

			case GLU_TESS_END:
			case GLU_TESS_END_DATA:
				gluTessCallback(tess,GLU_TESS_END_DATA,
					(GLvoid*)sdl_perl_tess_end_callback);	
				break;

			case GLU_TESS_COMBINE:
			case GLU_TESS_COMBINE_DATA:
				gluTessCallback(tess,GLU_TESS_COMBINE_DATA,
					(GLvoid*)sdl_perl_tess_combine_callback);	
				break;

			case GLU_TESS_ERROR:
			case GLU_TESS_ERROR_DATA:
				gluTessCallback(tess,GLU_TESS_ERROR_DATA,
					(GLvoid*)sdl_perl_tess_error_callback);	
				break;
		}
#line 5467 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluTessProperty); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessProperty)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "tessobj, property, value");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
	Uint32	property = (Uint32)SvUV(ST(1));
	double	value = (double)SvNV(ST(2));
#line 2702 "lib/SDL/OpenGL.xs"
		gluTessProperty(tessobj,property,value);
#line 5489 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluGetTessProperty); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluGetTessProperty)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "tessobj, property");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
	Uint32	property = (Uint32)SvUV(ST(1));
	double	RETVAL;
	dXSTARG;
#line 2709 "lib/SDL/OpenGL.xs"
		gluGetTessProperty(tessobj,property,&RETVAL);
#line 5512 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluTessNormal); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessNormal)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "tessobj, x, y, z");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
	double	x = (double)SvNV(ST(1));
	double	y = (double)SvNV(ST(2));
	double	z = (double)SvNV(ST(3));
#line 2720 "lib/SDL/OpenGL.xs"
		gluTessNormal(tessobj,x,y,z);
#line 5536 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluTessBeginPolygon); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessBeginPolygon)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "tessobj, cb");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
	SV *	cb = ST(1);
#line 2727 "lib/SDL/OpenGL.xs"
		gluTessBeginPolygon(tessobj,cb);
#line 5557 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluTessEndPolygon); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessEndPolygon)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tessobj");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
#line 2733 "lib/SDL/OpenGL.xs"
		gluTessEndPolygon(tessobj);
#line 5577 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluTessBeginContour); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessBeginContour)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tessobj");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
#line 2739 "lib/SDL/OpenGL.xs"
		gluTessBeginContour(tessobj);
#line 5597 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluTessEndContour); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessEndContour)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tessobj");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
#line 2745 "lib/SDL/OpenGL.xs"
		gluTessEndContour(tessobj);
#line 5617 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluDeleteTess); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluDeleteTess)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "tessobj");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
#line 2751 "lib/SDL/OpenGL.xs"
		gluDeleteTess(tessobj);
#line 5637 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluTessVertex); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluTessVertex)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "tessobj, coords, vd");
    {
	GLUtesselator *	tessobj = INT2PTR(GLUtesselator *,SvIV(ST(0)));
	char *	coords = (char *)SvPV_nolen(ST(1));
	char *	vd = (char *)SvPV_nolen(ST(2));
#line 2759 "lib/SDL/OpenGL.xs"
		gluTessVertex(tessobj,(GLdouble*)coords,vd);
#line 5659 "lib/SDL/OpenGL.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS(XS_SDL__OpenGL_gluNewQuadric); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluNewQuadric)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	GLUquadric *	RETVAL;
	dXSTARG;
#line 2766 "lib/SDL/OpenGL.xs"
		RETVAL = gluNewQuadric ();
#line 5681 "lib/SDL/OpenGL.c"
	XSprePUSH; PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS(XS_SDL__OpenGL_gluDeleteQuadric); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluDeleteQuadric)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "quad");
    {
	GLUquadric *	quad = INT2PTR(GLUquadric *,SvIV(ST(0)));

	gluDeleteQuadric(quad);
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluQuadricNormals); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluQuadricNormals)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "quad, normal");
    {
	GLUquadric *	quad = INT2PTR(GLUquadric *,SvIV(ST(0)));
	GLenum	normal = (GLenum)SvIV(ST(1));

	gluQuadricNormals(quad, normal);
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluQuadricTexture); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluQuadricTexture)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "quad, texture");
    {
	GLUquadric *	quad = INT2PTR(GLUquadric *,SvIV(ST(0)));
	GLboolean	texture = (unsigned char)SvUV(ST(1));

	gluQuadricTexture(quad, texture);
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluCylinder); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluCylinder)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 6)
       croak_xs_usage(cv,  "quad, base, top, height, slices, stacks");
    {
	GLUquadric *	quad = INT2PTR(GLUquadric *,SvIV(ST(0)));
	GLdouble	base = (GLdouble)SvNV(ST(1));
	GLdouble	top = (GLdouble)SvNV(ST(2));
	GLdouble	height = (GLdouble)SvNV(ST(3));
	GLint	slices = (GLint)SvIV(ST(4));
	GLint	stacks = (GLint)SvIV(ST(5));

	gluCylinder(quad, base, top, height, slices, stacks);
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluDisk); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluDisk)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       croak_xs_usage(cv,  "quad, inner, outer, slices, loops");
    {
	GLUquadric *	quad = INT2PTR(GLUquadric *,SvIV(ST(0)));
	GLdouble	inner = (GLdouble)SvNV(ST(1));
	GLdouble	outer = (GLdouble)SvNV(ST(2));
	GLint	slices = (GLint)SvIV(ST(3));
	GLint	loops = (GLint)SvIV(ST(4));

	gluDisk(quad, inner, outer, slices, loops);
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluPartialDisk); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluPartialDisk)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 7)
       croak_xs_usage(cv,  "quad, inner, outer, slices, loops, start, sweep");
    {
	GLUquadric *	quad = INT2PTR(GLUquadric *,SvIV(ST(0)));
	GLdouble	inner = (GLdouble)SvNV(ST(1));
	GLdouble	outer = (GLdouble)SvNV(ST(2));
	GLint	slices = (GLint)SvIV(ST(3));
	GLint	loops = (GLint)SvIV(ST(4));
	GLdouble	start = (GLdouble)SvNV(ST(5));
	GLdouble	sweep = (GLdouble)SvNV(ST(6));

	gluPartialDisk(quad, inner, outer, slices, loops, start, sweep);
    }
    XSRETURN_EMPTY;
}


XS(XS_SDL__OpenGL_gluSphere); /* prototype to pass -Wmissing-prototypes */
XS(XS_SDL__OpenGL_gluSphere)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       croak_xs_usage(cv,  "quad, radius, slices, stacks");
    {
	GLUquadric *	quad = INT2PTR(GLUquadric *,SvIV(ST(0)));
	GLdouble	radius = (GLdouble)SvNV(ST(1));
	GLint	slices = (GLint)SvIV(ST(2));
	GLint	stacks = (GLint)SvIV(ST(3));

	gluSphere(quad, radius, slices, stacks);
    }
    XSRETURN_EMPTY;
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS(boot_SDL__OpenGL); /* prototype to pass -Wmissing-prototypes */
XS(boot_SDL__OpenGL)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    const char* file = __FILE__;

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    XS_VERSION_BOOTCHECK ;

#if XSubPPtmpAAAA
        newXS("SDL::OpenGL::glClearColor", XS_SDL__OpenGL_glClearColor, file);
        newXS("SDL::OpenGL::glClearIndex", XS_SDL__OpenGL_glClearIndex, file);
        newXS("SDL::OpenGL::glClearDepth", XS_SDL__OpenGL_glClearDepth, file);
        newXS("SDL::OpenGL::glClearStencil", XS_SDL__OpenGL_glClearStencil, file);
        newXS("SDL::OpenGL::glClearAccum", XS_SDL__OpenGL_glClearAccum, file);
        newXS("SDL::OpenGL::glClear", XS_SDL__OpenGL_glClear, file);
        newXS("SDL::OpenGL::glFlush", XS_SDL__OpenGL_glFlush, file);
        newXS("SDL::OpenGL::glFinish", XS_SDL__OpenGL_glFinish, file);
        newXS("SDL::OpenGL::glRect", XS_SDL__OpenGL_glRect, file);
        newXS("SDL::OpenGL::glVertex", XS_SDL__OpenGL_glVertex, file);
        newXS("SDL::OpenGL::glBegin", XS_SDL__OpenGL_glBegin, file);
        newXS("SDL::OpenGL::glEnd", XS_SDL__OpenGL_glEnd, file);
        newXS("SDL::OpenGL::glEnable", XS_SDL__OpenGL_glEnable, file);
        newXS("SDL::OpenGL::glDisable", XS_SDL__OpenGL_glDisable, file);
        newXS("SDL::OpenGL::glGet", XS_SDL__OpenGL_glGet, file);
        newXS("SDL::OpenGL::glIsEnabled", XS_SDL__OpenGL_glIsEnabled, file);
        newXS("SDL::OpenGL::glPointSize", XS_SDL__OpenGL_glPointSize, file);
        newXS("SDL::OpenGL::glLineWidth", XS_SDL__OpenGL_glLineWidth, file);
        newXS("SDL::OpenGL::glLineStipple", XS_SDL__OpenGL_glLineStipple, file);
        newXS("SDL::OpenGL::glPolygonMode", XS_SDL__OpenGL_glPolygonMode, file);
        newXS("SDL::OpenGL::glFrontFace", XS_SDL__OpenGL_glFrontFace, file);
        newXS("SDL::OpenGL::glCullFace", XS_SDL__OpenGL_glCullFace, file);
        newXS("SDL::OpenGL::glPolygonStipple", XS_SDL__OpenGL_glPolygonStipple, file);
        newXS("SDL::OpenGL::glEdgeFlag", XS_SDL__OpenGL_glEdgeFlag, file);
        newXS("SDL::OpenGL::glNormal", XS_SDL__OpenGL_glNormal, file);
        newXS("SDL::OpenGL::glEnableClientState", XS_SDL__OpenGL_glEnableClientState, file);
        newXS("SDL::OpenGL::glDisableClientState", XS_SDL__OpenGL_glDisableClientState, file);
        newXS("SDL::OpenGL::glVertexPointer", XS_SDL__OpenGL_glVertexPointer, file);
        newXS("SDL::OpenGL::glColorPointer", XS_SDL__OpenGL_glColorPointer, file);
        newXS("SDL::OpenGL::glNormalPointer", XS_SDL__OpenGL_glNormalPointer, file);
        newXS("SDL::OpenGL::glTexCoordPointer", XS_SDL__OpenGL_glTexCoordPointer, file);
        newXS("SDL::OpenGL::glEdgeFlagPointer", XS_SDL__OpenGL_glEdgeFlagPointer, file);
        newXS("SDL::OpenGL::glArrayElement", XS_SDL__OpenGL_glArrayElement, file);
        newXS("SDL::OpenGL::glDrawElements", XS_SDL__OpenGL_glDrawElements, file);
#if XSubPPtmpAAAB
        newXS("SDL::OpenGL::glDrawRangeElements", XS_SDL__OpenGL_glDrawRangeElements, file);
#endif
        newXS("SDL::OpenGL::glDrawArrays", XS_SDL__OpenGL_glDrawArrays, file);
        newXS("SDL::OpenGL::glInterleavedArrays", XS_SDL__OpenGL_glInterleavedArrays, file);
        newXS("SDL::OpenGL::glPushAttrib", XS_SDL__OpenGL_glPushAttrib, file);
        newXS("SDL::OpenGL::glPopAttrib", XS_SDL__OpenGL_glPopAttrib, file);
        newXS("SDL::OpenGL::glPushClientAttrib", XS_SDL__OpenGL_glPushClientAttrib, file);
        newXS("SDL::OpenGL::glPopClientAttrib", XS_SDL__OpenGL_glPopClientAttrib, file);
        newXS("SDL::OpenGL::glMatrixMode", XS_SDL__OpenGL_glMatrixMode, file);
        newXS("SDL::OpenGL::glLoadIdentity", XS_SDL__OpenGL_glLoadIdentity, file);
        newXS("SDL::OpenGL::glLoadMatrix", XS_SDL__OpenGL_glLoadMatrix, file);
        newXS("SDL::OpenGL::glMultMatrix", XS_SDL__OpenGL_glMultMatrix, file);
        newXS("SDL::OpenGL::glTranslate", XS_SDL__OpenGL_glTranslate, file);
        newXS("SDL::OpenGL::glRotate", XS_SDL__OpenGL_glRotate, file);
        newXS("SDL::OpenGL::glScale", XS_SDL__OpenGL_glScale, file);
        newXS("SDL::OpenGL::glFrustum", XS_SDL__OpenGL_glFrustum, file);
        newXS("SDL::OpenGL::glOrtho", XS_SDL__OpenGL_glOrtho, file);
        newXS("SDL::OpenGL::glViewport", XS_SDL__OpenGL_glViewport, file);
        newXS("SDL::OpenGL::glDepthRange", XS_SDL__OpenGL_glDepthRange, file);
        newXS("SDL::OpenGL::glPushMatrix", XS_SDL__OpenGL_glPushMatrix, file);
        newXS("SDL::OpenGL::glPopMatrix", XS_SDL__OpenGL_glPopMatrix, file);
        newXS("SDL::OpenGL::glClipPlane", XS_SDL__OpenGL_glClipPlane, file);
        newXS("SDL::OpenGL::glColor", XS_SDL__OpenGL_glColor, file);
        newXS("SDL::OpenGL::glIndex", XS_SDL__OpenGL_glIndex, file);
        newXS("SDL::OpenGL::glShadeModel", XS_SDL__OpenGL_glShadeModel, file);
        newXS("SDL::OpenGL::glLight", XS_SDL__OpenGL_glLight, file);
        newXS("SDL::OpenGL::glLightModel", XS_SDL__OpenGL_glLightModel, file);
        newXS("SDL::OpenGL::glMaterial", XS_SDL__OpenGL_glMaterial, file);
        newXS("SDL::OpenGL::glColorMaterial", XS_SDL__OpenGL_glColorMaterial, file);
        newXS("SDL::OpenGL::glBlendFunc", XS_SDL__OpenGL_glBlendFunc, file);
        newXS("SDL::OpenGL::glHint", XS_SDL__OpenGL_glHint, file);
        newXS("SDL::OpenGL::glFog", XS_SDL__OpenGL_glFog, file);
        newXS("SDL::OpenGL::glPolygonOffset", XS_SDL__OpenGL_glPolygonOffset, file);
        newXS("SDL::OpenGL::glGenLists", XS_SDL__OpenGL_glGenLists, file);
        newXS("SDL::OpenGL::glNewList", XS_SDL__OpenGL_glNewList, file);
        newXS("SDL::OpenGL::glEndList", XS_SDL__OpenGL_glEndList, file);
        newXS("SDL::OpenGL::glDeleteLists", XS_SDL__OpenGL_glDeleteLists, file);
        newXS("SDL::OpenGL::glCallList", XS_SDL__OpenGL_glCallList, file);
        newXS("SDL::OpenGL::glIsList", XS_SDL__OpenGL_glIsList, file);
        newXS("SDL::OpenGL::glListBase", XS_SDL__OpenGL_glListBase, file);
        newXS("SDL::OpenGL::glCallLists", XS_SDL__OpenGL_glCallLists, file);
        newXS("SDL::OpenGL::glCallListsString", XS_SDL__OpenGL_glCallListsString, file);
        newXS("SDL::OpenGL::glRasterPos", XS_SDL__OpenGL_glRasterPos, file);
        newXS("SDL::OpenGL::glBitmap", XS_SDL__OpenGL_glBitmap, file);
        newXS("SDL::OpenGL::glDrawPixels", XS_SDL__OpenGL_glDrawPixels, file);
        newXS("SDL::OpenGL::glReadPixels", XS_SDL__OpenGL_glReadPixels, file);
        newXS("SDL::OpenGL::glReadPixel", XS_SDL__OpenGL_glReadPixel, file);
        newXS("SDL::OpenGL::glCopyPixels", XS_SDL__OpenGL_glCopyPixels, file);
        newXS("SDL::OpenGL::glPixelStore", XS_SDL__OpenGL_glPixelStore, file);
        newXS("SDL::OpenGL::glPixelTransfer", XS_SDL__OpenGL_glPixelTransfer, file);
        newXS("SDL::OpenGL::glPixelMap", XS_SDL__OpenGL_glPixelMap, file);
        newXS("SDL::OpenGL::glPixelZoom", XS_SDL__OpenGL_glPixelZoom, file);
#if XSubPPtmpAAAC
        newXS("SDL::OpenGL::glColorTable", XS_SDL__OpenGL_glColorTable, file);
        newXS("SDL::OpenGL::glColorTableParameter", XS_SDL__OpenGL_glColorTableParameter, file);
        newXS("SDL::OpenGL::glCopyColorTable", XS_SDL__OpenGL_glCopyColorTable, file);
        newXS("SDL::OpenGL::glColorSubTable", XS_SDL__OpenGL_glColorSubTable, file);
        newXS("SDL::OpenGL::glCopyColorSubTable", XS_SDL__OpenGL_glCopyColorSubTable, file);
        newXS("SDL::OpenGL::glConvolutionFilter2D", XS_SDL__OpenGL_glConvolutionFilter2D, file);
        newXS("SDL::OpenGL::glCopyConvolutionFilter2D", XS_SDL__OpenGL_glCopyConvolutionFilter2D, file);
        newXS("SDL::OpenGL::glSeparableFilter2D", XS_SDL__OpenGL_glSeparableFilter2D, file);
        newXS("SDL::OpenGL::glConvolutionFilter1D", XS_SDL__OpenGL_glConvolutionFilter1D, file);
        newXS("SDL::OpenGL::glCopyConvolutionFilter1D", XS_SDL__OpenGL_glCopyConvolutionFilter1D, file);
        newXS("SDL::OpenGL::glConvolutionParameter", XS_SDL__OpenGL_glConvolutionParameter, file);
        newXS("SDL::OpenGL::glHistogram", XS_SDL__OpenGL_glHistogram, file);
        newXS("SDL::OpenGL::glGetHistogram", XS_SDL__OpenGL_glGetHistogram, file);
        newXS("SDL::OpenGL::glResetHistogram", XS_SDL__OpenGL_glResetHistogram, file);
        newXS("SDL::OpenGL::glMinmax", XS_SDL__OpenGL_glMinmax, file);
        newXS("SDL::OpenGL::glGetMinmax", XS_SDL__OpenGL_glGetMinmax, file);
        newXS("SDL::OpenGL::glResetMinmax", XS_SDL__OpenGL_glResetMinmax, file);
        newXS("SDL::OpenGL::glBlendEquation", XS_SDL__OpenGL_glBlendEquation, file);
#endif
        newXS("SDL::OpenGL::glTexImage2D", XS_SDL__OpenGL_glTexImage2D, file);
        newXS("SDL::OpenGL::glCopyTexImage2D", XS_SDL__OpenGL_glCopyTexImage2D, file);
        newXS("SDL::OpenGL::glTexSubImage2D", XS_SDL__OpenGL_glTexSubImage2D, file);
        newXS("SDL::OpenGL::glCopyTexSubImage2D", XS_SDL__OpenGL_glCopyTexSubImage2D, file);
        newXS("SDL::OpenGL::glTexImage1D", XS_SDL__OpenGL_glTexImage1D, file);
        newXS("SDL::OpenGL::glTexSubImage1D", XS_SDL__OpenGL_glTexSubImage1D, file);
        newXS("SDL::OpenGL::glCopyTexImage1D", XS_SDL__OpenGL_glCopyTexImage1D, file);
        newXS("SDL::OpenGL::glCopyTexSubImage1D", XS_SDL__OpenGL_glCopyTexSubImage1D, file);
#if XSubPPtmpAAAD
        newXS("SDL::OpenGL::glTexImage3D", XS_SDL__OpenGL_glTexImage3D, file);
        newXS("SDL::OpenGL::glTexSubImage3D", XS_SDL__OpenGL_glTexSubImage3D, file);
        newXS("SDL::OpenGL::glCopyTexSubImage3D", XS_SDL__OpenGL_glCopyTexSubImage3D, file);
#endif
        newXS("SDL::OpenGL::glGenTextures", XS_SDL__OpenGL_glGenTextures, file);
        newXS("SDL::OpenGL::glIsTexture", XS_SDL__OpenGL_glIsTexture, file);
        newXS("SDL::OpenGL::glBindTexture", XS_SDL__OpenGL_glBindTexture, file);
        newXS("SDL::OpenGL::glDeleteTextures", XS_SDL__OpenGL_glDeleteTextures, file);
        newXS("SDL::OpenGL::glAreTexturesResident", XS_SDL__OpenGL_glAreTexturesResident, file);
        newXS("SDL::OpenGL::glPrioritizeTextures", XS_SDL__OpenGL_glPrioritizeTextures, file);
        newXS("SDL::OpenGL::glTexEnv", XS_SDL__OpenGL_glTexEnv, file);
        newXS("SDL::OpenGL::glTexCoord", XS_SDL__OpenGL_glTexCoord, file);
        newXS("SDL::OpenGL::glTexParameter", XS_SDL__OpenGL_glTexParameter, file);
        newXS("SDL::OpenGL::glTexGen", XS_SDL__OpenGL_glTexGen, file);
#if XSubPPtmpAAAE
        newXS("SDL::OpenGL::glActiveTextureARB", XS_SDL__OpenGL_glActiveTextureARB, file);
        newXS("SDL::OpenGL::glMultiTexCoord", XS_SDL__OpenGL_glMultiTexCoord, file);
#endif
        newXS("SDL::OpenGL::glDrawBuffer", XS_SDL__OpenGL_glDrawBuffer, file);
        newXS("SDL::OpenGL::glReadBuffer", XS_SDL__OpenGL_glReadBuffer, file);
        newXS("SDL::OpenGL::glIndexMask", XS_SDL__OpenGL_glIndexMask, file);
        newXS("SDL::OpenGL::glColorMask", XS_SDL__OpenGL_glColorMask, file);
        newXS("SDL::OpenGL::glDepthMask", XS_SDL__OpenGL_glDepthMask, file);
        newXS("SDL::OpenGL::glStencilMask", XS_SDL__OpenGL_glStencilMask, file);
        newXS("SDL::OpenGL::glScissor", XS_SDL__OpenGL_glScissor, file);
        newXS("SDL::OpenGL::glAlphaFunc", XS_SDL__OpenGL_glAlphaFunc, file);
        newXS("SDL::OpenGL::glStencilFunc", XS_SDL__OpenGL_glStencilFunc, file);
        newXS("SDL::OpenGL::glStencilOp", XS_SDL__OpenGL_glStencilOp, file);
        newXS("SDL::OpenGL::glDepthFunc", XS_SDL__OpenGL_glDepthFunc, file);
        newXS("SDL::OpenGL::glLogicOp", XS_SDL__OpenGL_glLogicOp, file);
        newXS("SDL::OpenGL::glAccum", XS_SDL__OpenGL_glAccum, file);
        newXS("SDL::OpenGL::glMap1", XS_SDL__OpenGL_glMap1, file);
        newXS("SDL::OpenGL::glEvalCoord1", XS_SDL__OpenGL_glEvalCoord1, file);
        newXS("SDL::OpenGL::glMapGrid1", XS_SDL__OpenGL_glMapGrid1, file);
        newXS("SDL::OpenGL::glEvalMesh1", XS_SDL__OpenGL_glEvalMesh1, file);
        newXS("SDL::OpenGL::glMap2", XS_SDL__OpenGL_glMap2, file);
        newXS("SDL::OpenGL::glEvalCoord2", XS_SDL__OpenGL_glEvalCoord2, file);
        newXS("SDL::OpenGL::glMapGrid2", XS_SDL__OpenGL_glMapGrid2, file);
        newXS("SDL::OpenGL::glEvalMesh2", XS_SDL__OpenGL_glEvalMesh2, file);
        newXS("SDL::OpenGL::glGetError", XS_SDL__OpenGL_glGetError, file);
        newXS("SDL::OpenGL::glRenderMode", XS_SDL__OpenGL_glRenderMode, file);
        newXS("SDL::OpenGL::glInitNames", XS_SDL__OpenGL_glInitNames, file);
        newXS("SDL::OpenGL::glPushName", XS_SDL__OpenGL_glPushName, file);
        newXS("SDL::OpenGL::glPopName", XS_SDL__OpenGL_glPopName, file);
        newXS("SDL::OpenGL::glLoadName", XS_SDL__OpenGL_glLoadName, file);
        newXS("SDL::OpenGL::glFeedbackBuffer", XS_SDL__OpenGL_glFeedbackBuffer, file);
        newXS("SDL::OpenGL::glPassThrough", XS_SDL__OpenGL_glPassThrough, file);
#endif
#if XSubPPtmpAAAF
        newXS("SDL::OpenGL::gluLookAt", XS_SDL__OpenGL_gluLookAt, file);
        newXS("SDL::OpenGL::gluPerspective", XS_SDL__OpenGL_gluPerspective, file);
        newXS("SDL::OpenGL::gluPickMatrix", XS_SDL__OpenGL_gluPickMatrix, file);
        newXS("SDL::OpenGL::gluOrtho2D", XS_SDL__OpenGL_gluOrtho2D, file);
        newXS("SDL::OpenGL::gluScaleImage", XS_SDL__OpenGL_gluScaleImage, file);
        newXS("SDL::OpenGL::gluBuild1DMipmaps", XS_SDL__OpenGL_gluBuild1DMipmaps, file);
        newXS("SDL::OpenGL::gluBuild2DMipmaps", XS_SDL__OpenGL_gluBuild2DMipmaps, file);
#if XSubPPtmpAAAG
        newXS("SDL::OpenGL::gluBuild3DMipmaps", XS_SDL__OpenGL_gluBuild3DMipmaps, file);
#endif
#if XSubPPtmpAAAH
        newXS("SDL::OpenGL::gluBuild3DMipmaps", XS_SDL__OpenGL_gluBuild3DMipmaps, file);
#endif
#if XSubPPtmpAAAI
        newXS("SDL::OpenGL::gluBuild1DMipmapLevels", XS_SDL__OpenGL_gluBuild1DMipmapLevels, file);
#endif
#if XSubPPtmpAAAJ
        newXS("SDL::OpenGL::gluBuild1DMipmapLevels", XS_SDL__OpenGL_gluBuild1DMipmapLevels, file);
#endif
#if XSubPPtmpAAAK
        newXS("SDL::OpenGL::gluBuild2DMipmapLevels", XS_SDL__OpenGL_gluBuild2DMipmapLevels, file);
#endif
#if XSubPPtmpAAAL
        newXS("SDL::OpenGL::gluBuild2DMipmapLevels", XS_SDL__OpenGL_gluBuild2DMipmapLevels, file);
#endif
#if XSubPPtmpAAAM
        newXS("SDL::OpenGL::gluBuild3DMipmapLevels", XS_SDL__OpenGL_gluBuild3DMipmapLevels, file);
#endif
#if XSubPPtmpAAAN
        newXS("SDL::OpenGL::gluBuild3DMipmapLevels", XS_SDL__OpenGL_gluBuild3DMipmapLevels, file);
#endif
        newXS("SDL::OpenGL::gluErrorString", XS_SDL__OpenGL_gluErrorString, file);
        newXS("SDL::OpenGL::gluNewNurbsRenderer", XS_SDL__OpenGL_gluNewNurbsRenderer, file);
        newXS("SDL::OpenGL::gluDeleteNurbsRenderer", XS_SDL__OpenGL_gluDeleteNurbsRenderer, file);
        newXS("SDL::OpenGL::gluNurbsProperty", XS_SDL__OpenGL_gluNurbsProperty, file);
        newXS("SDL::OpenGL::gluLoadSamplingMatrices", XS_SDL__OpenGL_gluLoadSamplingMatrices, file);
        newXS("SDL::OpenGL::gluGetNurbsProperty", XS_SDL__OpenGL_gluGetNurbsProperty, file);
        newXS("SDL::OpenGL::gluNurbsCallback", XS_SDL__OpenGL_gluNurbsCallback, file);
#if XSubPPtmpAAAO
        newXS("SDL::OpenGL::gluNurbsCallbackData", XS_SDL__OpenGL_gluNurbsCallbackData, file);
#endif
        newXS("SDL::OpenGL::gluBeginSurface", XS_SDL__OpenGL_gluBeginSurface, file);
        newXS("SDL::OpenGL::gluEndSurface", XS_SDL__OpenGL_gluEndSurface, file);
        newXS("SDL::OpenGL::gluNurbsSurface", XS_SDL__OpenGL_gluNurbsSurface, file);
        newXS("SDL::OpenGL::gluBeginCurve", XS_SDL__OpenGL_gluBeginCurve, file);
        newXS("SDL::OpenGL::gluEndCurve", XS_SDL__OpenGL_gluEndCurve, file);
        newXS("SDL::OpenGL::gluNurbsCurve", XS_SDL__OpenGL_gluNurbsCurve, file);
        newXS("SDL::OpenGL::gluBeginTrim", XS_SDL__OpenGL_gluBeginTrim, file);
        newXS("SDL::OpenGL::gluEndTrim", XS_SDL__OpenGL_gluEndTrim, file);
        newXS("SDL::OpenGL::gluPwlCurve", XS_SDL__OpenGL_gluPwlCurve, file);
        newXS("SDL::OpenGL::gluUnProject", XS_SDL__OpenGL_gluUnProject, file);
#if XSubPPtmpAAAP
        newXS("SDL::OpenGL::gluUnProject4", XS_SDL__OpenGL_gluUnProject4, file);
#endif
        newXS("SDL::OpenGL::gluProject", XS_SDL__OpenGL_gluProject, file);
#if XSubPPtmpAAAQ
        newXS("SDL::OpenGL::gluNewTess", XS_SDL__OpenGL_gluNewTess, file);
        newXS("SDL::OpenGL::gluTessCallback", XS_SDL__OpenGL_gluTessCallback, file);
        newXS("SDL::OpenGL::gluTessProperty", XS_SDL__OpenGL_gluTessProperty, file);
        newXS("SDL::OpenGL::gluGetTessProperty", XS_SDL__OpenGL_gluGetTessProperty, file);
        newXS("SDL::OpenGL::gluTessNormal", XS_SDL__OpenGL_gluTessNormal, file);
        newXS("SDL::OpenGL::gluTessBeginPolygon", XS_SDL__OpenGL_gluTessBeginPolygon, file);
        newXS("SDL::OpenGL::gluTessEndPolygon", XS_SDL__OpenGL_gluTessEndPolygon, file);
        newXS("SDL::OpenGL::gluTessBeginContour", XS_SDL__OpenGL_gluTessBeginContour, file);
        newXS("SDL::OpenGL::gluTessEndContour", XS_SDL__OpenGL_gluTessEndContour, file);
        newXS("SDL::OpenGL::gluDeleteTess", XS_SDL__OpenGL_gluDeleteTess, file);
        newXS("SDL::OpenGL::gluTessVertex", XS_SDL__OpenGL_gluTessVertex, file);
#endif
        newXS("SDL::OpenGL::gluNewQuadric", XS_SDL__OpenGL_gluNewQuadric, file);
        newXS("SDL::OpenGL::gluDeleteQuadric", XS_SDL__OpenGL_gluDeleteQuadric, file);
        newXS("SDL::OpenGL::gluQuadricNormals", XS_SDL__OpenGL_gluQuadricNormals, file);
        newXS("SDL::OpenGL::gluQuadricTexture", XS_SDL__OpenGL_gluQuadricTexture, file);
        newXS("SDL::OpenGL::gluCylinder", XS_SDL__OpenGL_gluCylinder, file);
        newXS("SDL::OpenGL::gluDisk", XS_SDL__OpenGL_gluDisk, file);
        newXS("SDL::OpenGL::gluPartialDisk", XS_SDL__OpenGL_gluPartialDisk, file);
        newXS("SDL::OpenGL::gluSphere", XS_SDL__OpenGL_gluSphere, file);
#endif

    /* Initialisation Section */

#if XSubPPtmpAAAA
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#endif
#if XSubPPtmpAAAF
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#if XSubPPtmpAAAK
#endif
#if XSubPPtmpAAAL
#endif
#if XSubPPtmpAAAM
#endif
#if XSubPPtmpAAAN
#endif
#if XSubPPtmpAAAO
#endif
#if XSubPPtmpAAAP
#endif
#if XSubPPtmpAAAQ
#endif
#endif
#line 6138 "lib/SDL/OpenGL.c"

    /* End of Initialisation Section */

    if (PL_unitcheckav)
         call_list(PL_scopestack_ix, PL_unitcheckav);
    XSRETURN_YES;
}

