#!/usr/bin/perl -w

# Copyright 2015 Kevin Ryde
#
# This file is part of Graph-Graph6.
#
# Graph-Graph6 is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# Graph-Graph6 is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along
# with Graph-Graph6.  If not, see <http://www.gnu.org/licenses/>.

use 5.005;
use strict;
use FindBin;
use List::Util 'min','max','sum';
use MyGraphs;

# uncomment this to run the ### lines
# use Smart::Comments;

{
  # J(5,2) complement of Petersen
  require Graph::Maker::Johnson;
  my @graphs;
  my $graph = Graph::Maker->new('johnson',
                                N => 5, K => 2,
                                undirected => 1,
                               );
  print $graph->get_graph_attribute ('name'),"\n";
  my $num_vertices = $graph->vertices;
  my $num_edges    = $graph->edges;
  print "  num vertices $num_vertices  num edges $num_edges\n";
   Graph_view($graph);
  push @graphs, $graph;
  $graph = $graph->complement;
  push @graphs, $graph;
  Graph_view($graph);

  hog_searches_html(@graphs);
  exit 0;
}

{
  # Johnson
  #
  # J(4,2) = https://hog.grinvin.org/ViewGraphInfo.action?id=226
  # J(5,2) = not
  # J(6,3) = not

  require Graph::Maker::Johnson;
  my @graphs;
  my $K = 3;
  foreach my $N (3 .. 7) {
    my $graph = Graph::Maker->new('johnson',
                                  N => $N, K => $K,
                                  undirected => 1,
                                 );
    print $graph->get_graph_attribute ('name'),"\n";
    my $num_vertices = $graph->vertices;
    my $num_edges    = $graph->edges;
    print "  num vertices $num_vertices  num edges $num_edges\n";
    # Graph_view($graph);
    push @graphs, $graph;
  }
  hog_searches_html(@graphs);
  exit 0;
}


