#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Precedence__stab_sum = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Precedence__basic(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int,int)
int32_t SPPRECOMPILE__TestCase__Precedence__stab_sum(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Precedence__basic(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_INT
  int_vars[3] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L4: // ADD_INT
  int_vars[1] = int_vars[3] + int_vars[4];
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L6: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[3]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], string);
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x30", 1));
L9: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Precedence";
    const char* sub_name = "basic";
    const char* file = "TestCase/Precedence.spvm";
    int32_t line = 6;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L15: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[3];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[4];
L23: // GOTO
  goto L26;
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L25: // BOOL_INT
  int_vars[0] = int_vars[5];
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L57;
L30: // GOTO
  goto L31;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L36: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L37: // CALL_SUB_INT
  // TestCase::Precedence->stab_sum
  {
    if (SUB_ID_TestCase__Precedence__stab_sum < 0) {
      SUB_ID_TestCase__Precedence__stab_sum = env->get_sub_id(env, "TestCase::Precedence", "stab_sum", "int(int,int)");
      if (SUB_ID_TestCase__Precedence__stab_sum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Precedence stab_sum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Precedence__stab_sum;
    exception_flag = SPPRECOMPILE__TestCase__Precedence__stab_sum(env, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Precedence";
    const char* sub_name = "basic";
    const char* file = "TestCase/Precedence.spvm";
    int32_t line = 12;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L40: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[6]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], string);
  }
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L42: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x34", 1));
L43: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Precedence";
    const char* sub_name = "basic";
    const char* file = "TestCase/Precedence.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L57;
  }
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L57;
L50: // GOTO
  goto L51;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L57;
L55: // INIT_INT
  int_vars[6] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L57;
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Precedence__stab_sum(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L2: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L5;
L3: // INIT_INT
  int_vars[5] = 0;
L4: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


