#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__LongList__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__LongList__length = -1;
static int32_t FIELD_ID_SPVM__LongList__capacity = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__LongList__capacity = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT64_MAX = - 1;
static int32_t SUB_ID_SPVM__LongList__newa = - 1;
static int32_t SUB_ID_SPVM__LongList__get = - 1;
static int32_t SUB_ID_SPVM__LongList__length = - 1;
static int32_t SUB_ID_SPVM__LongList__insert = - 1;
static int32_t SUB_ID_SPVM__LongList__to_array = - 1;
static int32_t SUB_ID_SPVM__Util__equals_larray = - 1;
static int32_t SUB_ID_SPVM__LongList__capacity = - 1;
static int32_t SUB_ID_SPVM__LongList__new = - 1;
static int32_t SUB_ID_SPVM__LongList__unshift = - 1;
static int32_t SUB_ID_SPVM__LongList__new_capacity = - 1;
static int32_t SUB_ID_SPVM__LongList__push = - 1;
static int32_t SUB_ID_SPVM__LongList__pop = - 1;
static int32_t SUB_ID_SPVM__LongList__remove = - 1;
static int32_t SUB_ID_SPVM__LongList__set = - 1;
static int32_t SUB_ID_SPVM__LongList__shift = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_long = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__get(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__insert(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__length(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__new_capacity(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__newa(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__pop(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__push(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__remove(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__set(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__shift(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__to_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__unshift(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__get(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L27: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L28: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L31: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L32: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[4];
L40: // MOVE_INT
  int_vars[0] = int_vars[0];
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L48: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L49: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L52: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L53: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L58: // GOTO
  goto L59;
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L60: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L61: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L62: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L64: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L66: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L71: // GOTO
  goto L72;
L72: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L75: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L80: // GOTO
  goto L81;
L81: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L82: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L84: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L85: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L86: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 219;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L88: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L89: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L97: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L98: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L99: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L100: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 226;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L102;
  }
L102: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L103: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L104: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L105: // IF_NE_ZERO
  if (int_vars[0]) { goto L110; }
L106: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L107: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L108: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L109: // GOTO
  goto L110;
L110: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L111: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L112: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L115: // INIT_INT
  int_vars[4] = 0;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L117;
L117: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L118: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__insert(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int64_t long_vars[4];
  int32_t int_vars[13];
  int32_t exception_flag = 0;
  int32_t mortal_stack[21];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L16: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L27: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L30: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L31: // CALL_SUB_VOID
  // SPVM::LongList->insert
  {
    if (SUB_ID_SPVM__LongList__insert < 0) {
      SUB_ID_SPVM__LongList__insert = env->get_sub_id(env, "SPVM::LongList", "insert", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L35: // CALL_SUB_OBJECT
  // SPVM::LongList->to_array
  {
    if (SUB_ID_SPVM__LongList__to_array < 0) {
      SUB_ID_SPVM__LongList__to_array = env->get_sub_id(env, "SPVM::LongList", "to_array", "long[](self)");
      if (SUB_ID_SPVM__LongList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L39: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L42: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L47: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L48: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L49: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L52: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[7];
L53: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L54: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L57: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[9];
L58: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L59: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L62: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L63: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[11];
L66: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L76: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L79: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L80: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L81: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L84: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L85: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L86: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L89: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L90: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L91: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L95: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L97: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L98: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L100: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L102: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L103: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L104: // CALL_SUB_VOID
  // SPVM::LongList->insert
  {
    if (SUB_ID_SPVM__LongList__insert < 0) {
      SUB_ID_SPVM__LongList__insert = env->get_sub_id(env, "SPVM::LongList", "insert", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L107: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L108: // CALL_SUB_OBJECT
  // SPVM::LongList->to_array
  {
    if (SUB_ID_SPVM__LongList__to_array < 0) {
      SUB_ID_SPVM__LongList__to_array = env->get_sub_id(env, "SPVM::LongList", "to_array", "long[](self)");
      if (SUB_ID_SPVM__LongList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L111: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L112: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L115: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L116: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L117: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L120: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L121: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L122: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L124: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L125: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[7];
L126: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L127: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L129: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L130: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[9];
L131: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L132: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L134: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L135: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L136: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L137: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L138: // BOOL_INT
  int_vars[0] = int_vars[11];
L139: // IF_NE_ZERO
  if (int_vars[0]) { goto L145; }
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L141: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L142: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L144: // GOTO
  goto L145;
L145: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L146: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L147: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L149: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L151: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L152: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L153: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L154: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L156: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L157: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L158: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L159: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L162: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L163: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L164: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L166: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L167: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L168: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L170: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L171: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L172: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L173: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L174: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L175: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L176: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L177: // CALL_SUB_VOID
  // SPVM::LongList->insert
  {
    if (SUB_ID_SPVM__LongList__insert < 0) {
      SUB_ID_SPVM__LongList__insert = env->get_sub_id(env, "SPVM::LongList", "insert", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L179: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L180: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L181: // CALL_SUB_OBJECT
  // SPVM::LongList->to_array
  {
    if (SUB_ID_SPVM__LongList__to_array < 0) {
      SUB_ID_SPVM__LongList__to_array = env->get_sub_id(env, "SPVM::LongList", "to_array", "long[](self)");
      if (SUB_ID_SPVM__LongList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L183: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L184: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L185: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L186: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L187: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L188: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L189: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L190: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L192: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L193: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L194: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L195: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L198: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[7];
L199: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L200: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L201: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L202: // MOVE_CONSTANT_INT
  int_vars[9] = 4;
L203: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[9];
L204: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L205: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L207: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L208: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L209: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L210: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L211: // BOOL_INT
  int_vars[0] = int_vars[11];
L212: // IF_NE_ZERO
  if (int_vars[0]) { goto L218; }
L213: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L214: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L215: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L216: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L217: // GOTO
  goto L218;
L218: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L219: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L220: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L221: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L222: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L223: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L224: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L225: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L226: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L227: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L228: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L229: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L230: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L231: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L232: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L233: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L234: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L235: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L236: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L237: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L238: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L239: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L240: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L241: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L242: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L243: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L244: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L245: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L246: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L247: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L248: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L249: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L250: // CALL_SUB_VOID
  // SPVM::LongList->insert
  {
    if (SUB_ID_SPVM__LongList__insert < 0) {
      SUB_ID_SPVM__LongList__insert = env->get_sub_id(env, "SPVM::LongList", "insert", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L251: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L252: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__capacity < 0, 0)) {
      FIELD_ID_SPVM__LongList__capacity = env->get_field_id(env, "SPVM::LongList", "capacity", "int");
      if (FIELD_ID_SPVM__LongList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__LongList__capacity);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__capacity);
    }
  }
L253: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L354;
  }
L254: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L255: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L256: // BOOL_INT
  int_vars[0] = int_vars[0];
L257: // IF_NE_ZERO
  if (int_vars[0]) { goto L261; }
L258: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L259: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L260: // GOTO
  goto L261;
L261: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L262: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L263: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L264: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L265: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L266: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L267: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L268: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L269: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L270: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L271: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L272: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L273: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L274: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L275: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L276: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L277: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L278: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L279: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L280: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L281: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L282: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L283: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L284: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L285: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L286: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L287: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L288: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L289: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L290: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L291: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L292: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L293: // CALL_SUB_VOID
  // SPVM::LongList->insert
  {
    if (SUB_ID_SPVM__LongList__insert < 0) {
      SUB_ID_SPVM__LongList__insert = env->get_sub_id(env, "SPVM::LongList", "insert", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L294: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 87;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L295;
  }
L295: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L296: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L297: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L298: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L299: // IF_NE_ZERO
  if (int_vars[0]) { goto L304; }
L300: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L301: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L302: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L303: // GOTO
  goto L304;
L304: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L305: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L306: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L307: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L308: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L309: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L310: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L311: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L312: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L313: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L314: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L315: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L316: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L317: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L318: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L319: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L320: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L321: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L322: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[7];
L323: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L324: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L325: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L326: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L327: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L328: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L329: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L330: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L331: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L332: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L333: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L334: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L335: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L336: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L337: // CALL_SUB_VOID
  // SPVM::LongList->insert
  {
    if (SUB_ID_SPVM__LongList__insert < 0) {
      SUB_ID_SPVM__LongList__insert = env->get_sub_id(env, "SPVM::LongList", "insert", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L338: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 97;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L339;
  }
L339: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L340: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L341: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L342: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L343: // IF_NE_ZERO
  if (int_vars[0]) { goto L348; }
L344: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L345: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L346: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L347: // GOTO
  goto L348;
L348: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L349: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L350: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L351: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L354;
L352: // INIT_INT
  int_vars[4] = 0;
L353: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L354;
L354: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L355: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__length(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::LongList->new
  {
    if (SUB_ID_SPVM__LongList__new < 0) {
      SUB_ID_SPVM__LongList__new = env->get_sub_id(env, "SPVM::LongList", "new", "SPVM::LongList()");
      if (SUB_ID_SPVM__LongList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 453;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L16: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L22: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 457;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L36;
L30: // GOTO
  goto L31;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__new_capacity(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::LongList->new_capacity
  {
    if (SUB_ID_SPVM__LongList__new_capacity < 0) {
      SUB_ID_SPVM__LongList__new_capacity = env->get_sub_id(env, "SPVM::LongList", "new_capacity", "SPVM::LongList(int)");
      if (SUB_ID_SPVM__LongList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L6: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L9: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L14: // GOTO
  goto L15;
L15: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__capacity < 0, 0)) {
      FIELD_ID_SPVM__LongList__capacity = env->get_field_id(env, "SPVM::LongList", "capacity", "int");
      if (FIELD_ID_SPVM__LongList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__LongList__capacity);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__capacity);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 32;
L18: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L23: // GOTO
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__newa(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L27: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L28: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 10;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L31: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L32: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L40: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L41: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L44: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L45: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L50: // GOTO
  goto L51;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L53: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L54: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L56: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L58: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L63: // GOTO
  goto L64;
L64: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L67: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_NE_ZERO
  if (int_vars[0]) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L72: // GOTO
  goto L73;
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L78;
L76: // INIT_INT
  int_vars[6] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__pop(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::LongList->new
  {
    if (SUB_ID_SPVM__LongList__new < 0) {
      SUB_ID_SPVM__LongList__new = env->get_sub_id(env, "SPVM::LongList", "new", "SPVM::LongList()");
      if (SUB_ID_SPVM__LongList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::LongList->push
  {
    if (SUB_ID_SPVM__LongList__push < 0) {
      SUB_ID_SPVM__LongList__push = env->get_sub_id(env, "SPVM::LongList", "push", "void(self,long)");
      if (SUB_ID_SPVM__LongList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::LongList->push
  {
    if (SUB_ID_SPVM__LongList__push < 0) {
      SUB_ID_SPVM__LongList__push = env->get_sub_id(env, "SPVM::LongList", "push", "void(self,long)");
      if (SUB_ID_SPVM__LongList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L16: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::LongList->push
  {
    if (SUB_ID_SPVM__LongList__push < 0) {
      SUB_ID_SPVM__LongList__push = env->get_sub_id(env, "SPVM::LongList", "push", "void(self,long)");
      if (SUB_ID_SPVM__LongList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L23: // CALL_SUB_LONG
  // SPVM::LongList->pop
  {
    if (SUB_ID_SPVM__LongList__pop < 0) {
      SUB_ID_SPVM__LongList__pop = env->get_sub_id(env, "SPVM::LongList", "pop", "long(self)");
      if (SUB_ID_SPVM__LongList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L25: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 336;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L27: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L34: // BOOL_INT
  int_vars[0] = int_vars[4];
L35: // MOVE_INT
  int_vars[0] = int_vars[0];
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L40: // GOTO
  goto L41;
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L42: // CALL_SUB_LONG
  // SPVM::LongList->pop
  {
    if (SUB_ID_SPVM__LongList__pop < 0) {
      SUB_ID_SPVM__LongList__pop = env->get_sub_id(env, "SPVM::LongList", "pop", "long(self)");
      if (SUB_ID_SPVM__LongList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L45: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L46: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L52; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L51: // GOTO
  goto L52;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L53: // CALL_SUB_LONG
  // SPVM::LongList->pop
  {
    if (SUB_ID_SPVM__LongList__pop < 0) {
      SUB_ID_SPVM__LongList__pop = env->get_sub_id(env, "SPVM::LongList", "pop", "long(self)");
      if (SUB_ID_SPVM__LongList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L56: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L57: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L62: // GOTO
  goto L63;
L63: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L71: // GOTO
  goto L72;
L72: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L73: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L74: // CALL_SUB_LONG
  // SPVM::LongList->pop
  {
    if (SUB_ID_SPVM__LongList__pop < 0) {
      SUB_ID_SPVM__LongList__pop = env->get_sub_id(env, "SPVM::LongList", "pop", "long(self)");
      if (SUB_ID_SPVM__LongList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L75: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 357;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L76;
  }
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L77: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L78: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L79: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L80: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L89: // INIT_INT
  int_vars[4] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L91;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__push(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::LongList->new
  {
    if (SUB_ID_SPVM__LongList__new < 0) {
      SUB_ID_SPVM__LongList__new = env->get_sub_id(env, "SPVM::LongList", "new", "SPVM::LongList()");
      if (SUB_ID_SPVM__LongList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::LongList->push
  {
    if (SUB_ID_SPVM__LongList__push < 0) {
      SUB_ID_SPVM__LongList__push = env->get_sub_id(env, "SPVM::LongList", "push", "void(self,long)");
      if (SUB_ID_SPVM__LongList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::LongList->push
  {
    if (SUB_ID_SPVM__LongList__push < 0) {
      SUB_ID_SPVM__LongList__push = env->get_sub_id(env, "SPVM::LongList", "push", "void(self,long)");
      if (SUB_ID_SPVM__LongList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L16: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::LongList->push
  {
    if (SUB_ID_SPVM__LongList__push < 0) {
      SUB_ID_SPVM__LongList__push = env->get_sub_id(env, "SPVM::LongList", "push", "void(self,long)");
      if (SUB_ID_SPVM__LongList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L22: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L34: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L37: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[6];
L38: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L43: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L44: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L47: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L48: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[3];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[4];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[5];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L62: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L63: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L64: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L66: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L68: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L72: // BOOL_INT
  int_vars[0] = int_vars[3];
L73: // GOTO
  goto L76;
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[4];
L76: // GOTO
  goto L79;
L77: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L78: // BOOL_INT
  int_vars[0] = int_vars[5];
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L86: // CALL_SUB_OBJECT
  // SPVM::LongList->new
  {
    if (SUB_ID_SPVM__LongList__new < 0) {
      SUB_ID_SPVM__LongList__new = env->get_sub_id(env, "SPVM::LongList", "new", "SPVM::LongList()");
      if (SUB_ID_SPVM__LongList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // GOTO
  goto L99;
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L91: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L92: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L93: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L94: // CALL_SUB_VOID
  // SPVM::LongList->push
  {
    if (SUB_ID_SPVM__LongList__push < 0) {
      SUB_ID_SPVM__LongList__push = env->get_sub_id(env, "SPVM::LongList", "push", "void(self,long)");
      if (SUB_ID_SPVM__LongList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L96: // MOVE_INT
  int_vars[3] = int_vars[2];
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L98: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L100: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L103: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 310;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L106: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L109: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L111: // GOTO
  goto L112;
L112: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L113: // GOTO
  goto L129;
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L115: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L116: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 316;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L119: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L120: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_NE_ZERO
  if (int_vars[0]) { goto L126; }
L123: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L125: // GOTO
  goto L126;
L126: // MOVE_INT
  int_vars[6] = int_vars[5];
L127: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L128: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L129: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L130: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[3]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L133: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L134: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L135: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L138;
L136: // INIT_INT
  int_vars[5] = 0;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L138;
L138: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L139: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__remove(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int64_t long_vars[4];
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[19];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L16: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L21: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[8];
L22: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L23: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L27: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L32: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L33: // CALL_SUB_LONG
  // SPVM::LongList->remove
  {
    if (SUB_ID_SPVM__LongList__remove < 0) {
      SUB_ID_SPVM__LongList__remove = env->get_sub_id(env, "SPVM::LongList", "remove", "long(self,int)");
      if (SUB_ID_SPVM__LongList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // CALL_SUB_OBJECT
  // SPVM::LongList->to_array
  {
    if (SUB_ID_SPVM__LongList__to_array < 0) {
      SUB_ID_SPVM__LongList__to_array = env->get_sub_id(env, "SPVM::LongList", "to_array", "long[](self)");
      if (SUB_ID_SPVM__LongList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L41: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L46: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L49: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[5];
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L51: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L54: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[7];
L55: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L56: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L60: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[9] = *(int32_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L62: // BOOL_INT
  int_vars[0] = int_vars[9];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L65: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L68: // GOTO
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L71: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L72: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L81: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L84: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L85: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L86: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L89: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L90: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L91: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L94: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L95: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L96: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L99: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L100: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L105: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L106: // CALL_SUB_LONG
  // SPVM::LongList->remove
  {
    if (SUB_ID_SPVM__LongList__remove < 0) {
      SUB_ID_SPVM__LongList__remove = env->get_sub_id(env, "SPVM::LongList", "remove", "long(self,int)");
      if (SUB_ID_SPVM__LongList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L110: // CALL_SUB_OBJECT
  // SPVM::LongList->to_array
  {
    if (SUB_ID_SPVM__LongList__to_array < 0) {
      SUB_ID_SPVM__LongList__to_array = env->get_sub_id(env, "SPVM::LongList", "to_array", "long[](self)");
      if (SUB_ID_SPVM__LongList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L113: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L114: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L117: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L119: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L121: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L122: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L123: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L124: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L126: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L127: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L128: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L130: // BOOL_INT
  int_vars[0] = int_vars[7];
L131: // IF_NE_ZERO
  if (int_vars[0]) { goto L137; }
L132: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L133: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L134: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L135: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L136: // GOTO
  goto L137;
L137: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L138: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L140: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L141: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L144: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L145: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L146: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L149: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L150: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L151: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L153: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L154: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L155: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L156: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L157: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L158: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L159: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L160: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L162: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L163: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L164: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L165: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L166: // CALL_SUB_LONG
  // SPVM::LongList->remove
  {
    if (SUB_ID_SPVM__LongList__remove < 0) {
      SUB_ID_SPVM__LongList__remove = env->get_sub_id(env, "SPVM::LongList", "remove", "long(self,int)");
      if (SUB_ID_SPVM__LongList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L168: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L169: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L170: // CALL_SUB_OBJECT
  // SPVM::LongList->to_array
  {
    if (SUB_ID_SPVM__LongList__to_array < 0) {
      SUB_ID_SPVM__LongList__to_array = env->get_sub_id(env, "SPVM::LongList", "to_array", "long[](self)");
      if (SUB_ID_SPVM__LongList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L171: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L172: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L173: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L174: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L175: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L176: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L177: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L178: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L179: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L181: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L182: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L183: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L184: // ARRAY_STORE_LONG
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L186: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L187: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L188: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L285;
  }
L190: // BOOL_INT
  int_vars[0] = int_vars[7];
L191: // IF_NE_ZERO
  if (int_vars[0]) { goto L197; }
L192: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L193: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L194: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L195: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L196: // GOTO
  goto L197;
L197: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L198: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L199: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L200: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L201: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L202: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L203: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L204: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L205: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L206: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L207: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L208: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L209: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L210: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L211: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L212: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L213: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L214: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L215: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L216: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L217: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L218: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L219: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L220: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L221: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L222: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L223: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L224: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L225: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L226: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L227: // CALL_SUB_LONG
  // SPVM::LongList->remove
  {
    if (SUB_ID_SPVM__LongList__remove < 0) {
      SUB_ID_SPVM__LongList__remove = env->get_sub_id(env, "SPVM::LongList", "remove", "long(self,int)");
      if (SUB_ID_SPVM__LongList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L228: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 141;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L229;
  }
L229: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L230: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L231: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L232: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L233: // IF_NE_ZERO
  if (int_vars[0]) { goto L238; }
L234: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L235: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L236: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L237: // GOTO
  goto L238;
L238: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L239: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L240: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L241: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L242: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L243: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L244: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L245: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L246: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L247: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L248: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L249: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L250: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L251: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L252: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L253: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L254: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L255: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L256: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[7];
L257: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L258: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L259: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L260: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L261: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L262: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L263: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L264: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L265: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L266: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L267: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L268: // CALL_SUB_LONG
  // SPVM::LongList->remove
  {
    if (SUB_ID_SPVM__LongList__remove < 0) {
      SUB_ID_SPVM__LongList__remove = env->get_sub_id(env, "SPVM::LongList", "remove", "long(self,int)");
      if (SUB_ID_SPVM__LongList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L269: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 151;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L270;
  }
L270: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L271: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L272: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L273: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L274: // IF_NE_ZERO
  if (int_vars[0]) { goto L279; }
L275: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L276: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L277: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L278: // GOTO
  goto L279;
L279: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L280: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L281: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L282: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L285;
L283: // INIT_INT
  int_vars[4] = 0;
L284: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L285;
L285: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L286: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__set(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L16: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[6];
L17: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L27: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L30: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L31: // CALL_SUB_VOID
  // SPVM::LongList->set
  {
    if (SUB_ID_SPVM__LongList__set < 0) {
      SUB_ID_SPVM__LongList__set = env->get_sub_id(env, "SPVM::LongList", "set", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L35: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L38: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L39: // CALL_SUB_VOID
  // SPVM::LongList->set
  {
    if (SUB_ID_SPVM__LongList__set < 0) {
      SUB_ID_SPVM__LongList__set = env->get_sub_id(env, "SPVM::LongList", "set", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 244;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L45: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L46: // PUSH_ARG_LONG
  *(int64_t*)&stack[2] = long_vars[0];
L47: // CALL_SUB_VOID
  // SPVM::LongList->set
  {
    if (SUB_ID_SPVM__LongList__set < 0) {
      SUB_ID_SPVM__LongList__set = env->get_sub_id(env, "SPVM::LongList", "set", "void(self,int,long)");
      if (SUB_ID_SPVM__LongList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 244;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L51: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L52: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L55: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L56: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L133;
L61: // GOTO
  goto L62;
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L63: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L64: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L65: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L68: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L69: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L133;
L74: // GOTO
  goto L75;
L75: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L77: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L78: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L80: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L82: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_NE_ZERO
  if (int_vars[0]) { goto L88; }
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L133;
L87: // GOTO
  goto L88;
L88: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 258;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L133;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L91: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L92: // BOOL_INT
  int_vars[0] = int_vars[0];
L93: // IF_NE_ZERO
  if (int_vars[0]) { goto L97; }
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L133;
L96: // GOTO
  goto L97;
L97: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L98: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L99: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L100: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L101: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L102: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 264;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L103: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L104: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L105: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L106: // IF_NE_ZERO
  if (int_vars[0]) { goto L111; }
L107: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L133;
L110: // GOTO
  goto L111;
L111: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L112: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L113: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L115: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L116: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 271;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L118;
  }
L118: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L119: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L120: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L121: // IF_NE_ZERO
  if (int_vars[0]) { goto L126; }
L122: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L123: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L133;
L125: // GOTO
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L128: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L129: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L133;
L131: // INIT_INT
  int_vars[4] = 0;
L132: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L133;
L133: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L134: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__shift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[2];
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::LongList->new
  {
    if (SUB_ID_SPVM__LongList__new < 0) {
      SUB_ID_SPVM__LongList__new = env->get_sub_id(env, "SPVM::LongList", "new", "SPVM::LongList()");
      if (SUB_ID_SPVM__LongList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L16: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 417;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L23: // CALL_SUB_LONG
  // SPVM::LongList->shift
  {
    if (SUB_ID_SPVM__LongList__shift < 0) {
      SUB_ID_SPVM__LongList__shift = env->get_sub_id(env, "SPVM::LongList", "shift", "long(self)");
      if (SUB_ID_SPVM__LongList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L25: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L27: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L32: // GOTO
  goto L33;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L34: // CALL_SUB_LONG
  // SPVM::LongList->shift
  {
    if (SUB_ID_SPVM__LongList__shift < 0) {
      SUB_ID_SPVM__LongList__shift = env->get_sub_id(env, "SPVM::LongList", "shift", "long(self)");
      if (SUB_ID_SPVM__LongList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L37: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L38: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L43: // GOTO
  goto L44;
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L45: // CALL_SUB_LONG
  // SPVM::LongList->shift
  {
    if (SUB_ID_SPVM__LongList__shift < 0) {
      SUB_ID_SPVM__LongList__shift = env->get_sub_id(env, "SPVM::LongList", "shift", "long(self)");
      if (SUB_ID_SPVM__LongList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L48: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L49: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L54: // GOTO
  goto L55;
L55: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 431;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L63: // GOTO
  goto L64;
L64: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L66: // CALL_SUB_LONG
  // SPVM::LongList->shift
  {
    if (SUB_ID_SPVM__LongList__shift < 0) {
      SUB_ID_SPVM__LongList__shift = env->get_sub_id(env, "SPVM::LongList", "shift", "long(self)");
      if (SUB_ID_SPVM__LongList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L67: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 437;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L69: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L70: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L76; }
L72: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L75: // GOTO
  goto L76;
L76: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L77: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L81: // INIT_INT
  int_vars[4] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__to_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L22: // CALL_SUB_OBJECT
  // SPVM::LongList->newa
  {
    if (SUB_ID_SPVM__LongList__newa < 0) {
      SUB_ID_SPVM__LongList__newa = env->get_sub_id(env, "SPVM::LongList", "newa", "SPVM::LongList(long[])");
      if (SUB_ID_SPVM__LongList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L27: // CALL_SUB_OBJECT
  // SPVM::LongList->to_array
  {
    if (SUB_ID_SPVM__LongList__to_array < 0) {
      SUB_ID_SPVM__LongList__to_array = env->get_sub_id(env, "SPVM::LongList", "to_array", "long[](self)");
      if (SUB_ID_SPVM__LongList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L29: // IS_TYPE
  {
    if (BASIC_TYPE_ID_long < 0) {
      BASIC_TYPE_ID_long = env->get_basic_type_id(env, "long");
      if (BASIC_TYPE_ID_long < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_long;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L82;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L39: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L40: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L82;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L47: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L50: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L51: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L82;
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L58: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 180;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L60: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 180;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L62: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L82;
L67: // GOTO
  goto L68;
L68: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L82;
  }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L71: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L77; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L82;
L76: // GOTO
  goto L77;
L77: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L82;
L80: // INIT_INT
  int_vars[6] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L82;
L82: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L83: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__LongList__unshift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::LongList->new
  {
    if (SUB_ID_SPVM__LongList__new < 0) {
      SUB_ID_SPVM__LongList__new = env->get_sub_id(env, "SPVM::LongList", "new", "SPVM::LongList()");
      if (SUB_ID_SPVM__LongList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L8: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L11: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L13: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L14: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L16: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 375;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L20: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 375;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L22: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 377;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L34: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L36: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L38: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L43: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L44: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L47: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L48: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[3];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[4];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[5];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L61: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L62: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L63: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L64: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L67: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L68: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L72: // BOOL_INT
  int_vars[0] = int_vars[3];
L73: // GOTO
  goto L76;
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[4];
L76: // GOTO
  goto L79;
L77: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L78: // BOOL_INT
  int_vars[0] = int_vars[5];
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L86: // CALL_SUB_OBJECT
  // SPVM::LongList->new
  {
    if (SUB_ID_SPVM__LongList__new < 0) {
      SUB_ID_SPVM__LongList__new = env->get_sub_id(env, "SPVM::LongList", "new", "SPVM::LongList()");
      if (SUB_ID_SPVM__LongList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // GOTO
  goto L99;
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L91: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L92: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L93: // PUSH_ARG_LONG
  *(int64_t*)&stack[1] = long_vars[0];
L94: // CALL_SUB_VOID
  // SPVM::LongList->unshift
  {
    if (SUB_ID_SPVM__LongList__unshift < 0) {
      SUB_ID_SPVM__LongList__unshift = env->get_sub_id(env, "SPVM::LongList", "unshift", "void(self,long)");
      if (SUB_ID_SPVM__LongList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L96: // MOVE_INT
  int_vars[3] = int_vars[2];
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L98: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L100: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L103: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__LongList__length < 0, 0)) {
      FIELD_ID_SPVM__LongList__length = env->get_field_id(env, "SPVM::LongList", "length", "int");
      if (FIELD_ID_SPVM__LongList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::LongList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__LongList__length = env->get_field_offset(env, FIELD_ID_SPVM__LongList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__LongList__length);
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 395;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L106: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L109: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L111: // GOTO
  goto L112;
L112: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L113: // GOTO
  goto L129;
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L115: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L116: // CALL_SUB_LONG
  // SPVM::LongList->get
  {
    if (SUB_ID_SPVM__LongList__get < 0) {
      SUB_ID_SPVM__LongList__get = env->get_sub_id(env, "SPVM::LongList", "get", "long(self,int)");
      if (SUB_ID_SPVM__LongList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::LongList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__LongList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::LongList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/LongList.spvm";
    int32_t line = 401;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L138;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L119: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L120: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_NE_ZERO
  if (int_vars[0]) { goto L126; }
L123: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L138;
L125: // GOTO
  goto L126;
L126: // MOVE_INT
  int_vars[6] = int_vars[5];
L127: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L128: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L129: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L130: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[3]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L133: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L134: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L135: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L138;
L136: // INIT_INT
  int_vars[5] = 0;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L138;
L138: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L139: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


