#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__IntList__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__IntList__length = -1;
static int32_t FIELD_ID_SPVM__IntList__capacity = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__IntList__capacity = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT32_MAX = - 1;
static int32_t SUB_ID_SPVM__IntList__newa = - 1;
static int32_t SUB_ID_SPVM__IntList__get = - 1;
static int32_t SUB_ID_SPVM__IntList__length = - 1;
static int32_t SUB_ID_SPVM__IntList__insert = - 1;
static int32_t SUB_ID_SPVM__IntList__to_array = - 1;
static int32_t SUB_ID_SPVM__Util__equals_iarray = - 1;
static int32_t SUB_ID_SPVM__IntList__capacity = - 1;
static int32_t SUB_ID_SPVM__IntList__new = - 1;
static int32_t SUB_ID_SPVM__IntList__unshift = - 1;
static int32_t SUB_ID_SPVM__IntList__new_capacity = - 1;
static int32_t SUB_ID_SPVM__IntList__push = - 1;
static int32_t SUB_ID_SPVM__IntList__pop = - 1;
static int32_t SUB_ID_SPVM__IntList__remove = - 1;
static int32_t SUB_ID_SPVM__IntList__set = - 1;
static int32_t SUB_ID_SPVM__IntList__shift = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_int = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__get(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__insert(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__length(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__new_capacity(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__newa(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__pop(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__push(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__remove(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__set(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__shift(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__to_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__unshift(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__get(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L16: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L26: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L38: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 201;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L46: // GOTO
  goto L47;
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L49: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L50: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L52: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L54: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L59: // GOTO
  goto L60;
L60: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L63: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L68: // GOTO
  goto L69;
L69: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L70: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L72: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L73: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L74: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 215;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L76: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L77: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L78: // IF_NE_ZERO
  if (int_vars[0]) { goto L83; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L82: // GOTO
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L85: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L87: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L88: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L89: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "get";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 222;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L91: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L92: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L93: // IF_NE_ZERO
  if (int_vars[0]) { goto L98; }
L94: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L97: // GOTO
  goto L98;
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L100: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L103: // INIT_INT
  int_vars[4] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__insert(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[14];
  int32_t exception_flag = 0;
  int32_t mortal_stack[21];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L15: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L16: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L26: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L27: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L28: // CALL_SUB_VOID
  // SPVM::IntList->insert
  {
    if (SUB_ID_SPVM__IntList__insert < 0) {
      SUB_ID_SPVM__IntList__insert = env->get_sub_id(env, "SPVM::IntList", "insert", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 51;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L32: // CALL_SUB_OBJECT
  // SPVM::IntList->to_array
  {
    if (SUB_ID_SPVM__IntList__to_array < 0) {
      SUB_ID_SPVM__IntList__to_array = env->get_sub_id(env, "SPVM::IntList", "to_array", "int[](self)");
      if (SUB_ID_SPVM__IntList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L36: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L39: // MOVE_INT
  int_vars[4] = int_vars[3];
L40: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L41: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L44: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L45: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L48: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L49: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L52: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L53: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L56: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L57: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[12] = *(int32_t*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L59: // BOOL_INT
  int_vars[0] = int_vars[12];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L327;
L65: // GOTO
  goto L66;
L66: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L67: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L70: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L73: // MOVE_INT
  int_vars[6] = int_vars[5];
L74: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L75: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L78: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L79: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L82: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L83: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L87: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L89: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L90: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L92: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L93: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L94: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L95: // CALL_SUB_VOID
  // SPVM::IntList->insert
  {
    if (SUB_ID_SPVM__IntList__insert < 0) {
      SUB_ID_SPVM__IntList__insert = env->get_sub_id(env, "SPVM::IntList", "insert", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L97: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L98: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L99: // CALL_SUB_OBJECT
  // SPVM::IntList->to_array
  {
    if (SUB_ID_SPVM__IntList__to_array < 0) {
      SUB_ID_SPVM__IntList__to_array = env->get_sub_id(env, "SPVM::IntList", "to_array", "int[](self)");
      if (SUB_ID_SPVM__IntList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L102: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L103: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L106: // MOVE_INT
  int_vars[4] = int_vars[3];
L107: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L108: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L110: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L111: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L112: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L115: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L116: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L119: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L120: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L122: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L123: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L124: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[12] = *(int32_t*)&stack[0];
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L126: // BOOL_INT
  int_vars[0] = int_vars[12];
L127: // IF_NE_ZERO
  if (int_vars[0]) { goto L133; }
L128: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L129: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L130: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L131: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L327;
L132: // GOTO
  goto L133;
L133: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L134: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L135: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L136: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L137: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L140: // MOVE_INT
  int_vars[6] = int_vars[5];
L141: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L142: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L144: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L145: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L146: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L149: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L150: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L151: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L152: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L153: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L154: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L156: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L157: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L158: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L159: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L160: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L161: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L162: // CALL_SUB_VOID
  // SPVM::IntList->insert
  {
    if (SUB_ID_SPVM__IntList__insert < 0) {
      SUB_ID_SPVM__IntList__insert = env->get_sub_id(env, "SPVM::IntList", "insert", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L163: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L164: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L165: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L166: // CALL_SUB_OBJECT
  // SPVM::IntList->to_array
  {
    if (SUB_ID_SPVM__IntList__to_array < 0) {
      SUB_ID_SPVM__IntList__to_array = env->get_sub_id(env, "SPVM::IntList", "to_array", "int[](self)");
      if (SUB_ID_SPVM__IntList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L168: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L169: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L170: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L171: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L172: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L173: // MOVE_INT
  int_vars[4] = int_vars[3];
L174: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L175: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L176: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L177: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L178: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L179: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L181: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L182: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L183: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L185: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L186: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L187: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L188: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L189: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L190: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L191: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[12] = *(int32_t*)&stack[0];
    }
  }
L192: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L193: // BOOL_INT
  int_vars[0] = int_vars[12];
L194: // IF_NE_ZERO
  if (int_vars[0]) { goto L200; }
L195: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L196: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L327;
L199: // GOTO
  goto L200;
L200: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L201: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L202: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L203: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L204: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L205: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L206: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L207: // MOVE_INT
  int_vars[6] = int_vars[5];
L208: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L209: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L210: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L211: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L212: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L213: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L214: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L215: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L216: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L217: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L218: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L219: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L220: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L221: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L222: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L223: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L224: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L225: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L226: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L227: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L228: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L229: // CALL_SUB_VOID
  // SPVM::IntList->insert
  {
    if (SUB_ID_SPVM__IntList__insert < 0) {
      SUB_ID_SPVM__IntList__insert = env->get_sub_id(env, "SPVM::IntList", "insert", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L230: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L231: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__capacity < 0, 0)) {
      FIELD_ID_SPVM__IntList__capacity = env->get_field_id(env, "SPVM::IntList", "capacity", "int");
      if (FIELD_ID_SPVM__IntList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__IntList__capacity);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__capacity);
    }
  }
L232: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L327;
  }
L233: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L234: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L235: // BOOL_INT
  int_vars[0] = int_vars[0];
L236: // IF_NE_ZERO
  if (int_vars[0]) { goto L240; }
L237: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L238: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L327;
L239: // GOTO
  goto L240;
L240: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L241: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L242: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L243: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L244: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L245: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L271;
  }
L246: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L247: // MOVE_INT
  int_vars[6] = int_vars[5];
L248: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L249: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L250: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L271;
  }
L251: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L252: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L253: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L254: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L271;
  }
L255: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L256: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L257: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L258: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L271;
  }
L259: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L260: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L261: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L262: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 86;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L271;
  }
L263: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L264: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L265: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L266: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L267: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L268: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L269: // CALL_SUB_VOID
  // SPVM::IntList->insert
  {
    if (SUB_ID_SPVM__IntList__insert < 0) {
      SUB_ID_SPVM__IntList__insert = env->get_sub_id(env, "SPVM::IntList", "insert", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L270: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 87;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L271;
  }
L271: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L272: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L273: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L274: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L275: // IF_NE_ZERO
  if (int_vars[0]) { goto L280; }
L276: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L277: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L278: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L327;
L279: // GOTO
  goto L280;
L280: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L281: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L282: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L283: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L284: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L285: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L286: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L312;
  }
L287: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L288: // MOVE_INT
  int_vars[4] = int_vars[3];
L289: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L290: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L291: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L312;
  }
L292: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L293: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L294: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L295: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L312;
  }
L296: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L297: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L298: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L299: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L312;
  }
L300: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L301: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L302: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L303: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 96;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L312;
  }
L304: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L305: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L306: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L307: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L308: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L309: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L310: // CALL_SUB_VOID
  // SPVM::IntList->insert
  {
    if (SUB_ID_SPVM__IntList__insert < 0) {
      SUB_ID_SPVM__IntList__insert = env->get_sub_id(env, "SPVM::IntList", "insert", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L311: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 97;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L312;
  }
L312: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L313: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L314: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L315: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L316: // IF_NE_ZERO
  if (int_vars[0]) { goto L321; }
L317: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L318: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L319: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L327;
L320: // GOTO
  goto L321;
L321: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L322: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L323: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L324: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L327;
L325: // INIT_INT
  int_vars[4] = 0;
L326: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L327;
L327: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L328: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__length(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::IntList->new
  {
    if (SUB_ID_SPVM__IntList__new < 0) {
      SUB_ID_SPVM__IntList__new = env->get_sub_id(env, "SPVM::IntList", "new", "SPVM::IntList()");
      if (SUB_ID_SPVM__IntList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 443;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L7: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 445;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L11: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L12: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 446;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L16: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L17: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L18: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L20: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "length";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L23: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L34;
L28: // GOTO
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__new_capacity(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 32;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::IntList->new_capacity
  {
    if (SUB_ID_SPVM__IntList__new_capacity < 0) {
      SUB_ID_SPVM__IntList__new_capacity = env->get_sub_id(env, "SPVM::IntList", "new_capacity", "SPVM::IntList(int)");
      if (SUB_ID_SPVM__IntList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L6: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L9: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L14: // GOTO
  goto L15;
L15: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__capacity < 0, 0)) {
      FIELD_ID_SPVM__IntList__capacity = env->get_field_id(env, "SPVM::IntList", "capacity", "int");
      if (FIELD_ID_SPVM__IntList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__IntList__capacity);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__capacity);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "new_capacity";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[5] = 32;
L18: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L29;
L23: // GOTO
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L29;
L27: // INIT_INT
  int_vars[6] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L29;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__newa(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L16: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L26: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 10;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L38: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L46: // GOTO
  goto L47;
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L49: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L50: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L52: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L54: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L59: // GOTO
  goto L60;
L60: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "newa";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L74;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L63: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L74;
L68: // GOTO
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L74;
L72: // INIT_INT
  int_vars[6] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L74;
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__pop(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::IntList->new
  {
    if (SUB_ID_SPVM__IntList__new < 0) {
      SUB_ID_SPVM__IntList__new = env->get_sub_id(env, "SPVM::IntList", "new", "SPVM::IntList()");
      if (SUB_ID_SPVM__IntList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 325;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L7: // CALL_SUB_VOID
  // SPVM::IntList->push
  {
    if (SUB_ID_SPVM__IntList__push < 0) {
      SUB_ID_SPVM__IntList__push = env->get_sub_id(env, "SPVM::IntList", "push", "void(self,int)");
      if (SUB_ID_SPVM__IntList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 327;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L11: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L12: // CALL_SUB_VOID
  // SPVM::IntList->push
  {
    if (SUB_ID_SPVM__IntList__push < 0) {
      SUB_ID_SPVM__IntList__push = env->get_sub_id(env, "SPVM::IntList", "push", "void(self,int)");
      if (SUB_ID_SPVM__IntList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 328;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L16: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L17: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L18: // CALL_SUB_VOID
  // SPVM::IntList->push
  {
    if (SUB_ID_SPVM__IntList__push < 0) {
      SUB_ID_SPVM__IntList__push = env->get_sub_id(env, "SPVM::IntList", "push", "void(self,int)");
      if (SUB_ID_SPVM__IntList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // CALL_SUB_INT
  // SPVM::IntList->pop
  {
    if (SUB_ID_SPVM__IntList__pop < 0) {
      SUB_ID_SPVM__IntList__pop = env->get_sub_id(env, "SPVM::IntList", "pop", "int(self)");
      if (SUB_ID_SPVM__IntList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L23: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L30: // GOTO
  goto L31;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L32: // CALL_SUB_INT
  // SPVM::IntList->pop
  {
    if (SUB_ID_SPVM__IntList__pop < 0) {
      SUB_ID_SPVM__IntList__pop = env->get_sub_id(env, "SPVM::IntList", "pop", "int(self)");
      if (SUB_ID_SPVM__IntList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L35: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L40: // GOTO
  goto L41;
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L42: // CALL_SUB_INT
  // SPVM::IntList->pop
  {
    if (SUB_ID_SPVM__IntList__pop < 0) {
      SUB_ID_SPVM__IntList__pop = env->get_sub_id(env, "SPVM::IntList", "pop", "int(self)");
      if (SUB_ID_SPVM__IntList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 339;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L45: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L50: // GOTO
  goto L51;
L51: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L59: // GOTO
  goto L60;
L60: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L62: // CALL_SUB_INT
  // SPVM::IntList->pop
  {
    if (SUB_ID_SPVM__IntList__pop < 0) {
      SUB_ID_SPVM__IntList__pop = env->get_sub_id(env, "SPVM::IntList", "pop", "int(self)");
      if (SUB_ID_SPVM__IntList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "pop";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 349;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L65: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L66: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L77: // INIT_INT
  int_vars[4] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__push(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::IntList->new
  {
    if (SUB_ID_SPVM__IntList__new < 0) {
      SUB_ID_SPVM__IntList__new = env->get_sub_id(env, "SPVM::IntList", "new", "SPVM::IntList()");
      if (SUB_ID_SPVM__IntList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 282;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L7: // CALL_SUB_VOID
  // SPVM::IntList->push
  {
    if (SUB_ID_SPVM__IntList__push < 0) {
      SUB_ID_SPVM__IntList__push = env->get_sub_id(env, "SPVM::IntList", "push", "void(self,int)");
      if (SUB_ID_SPVM__IntList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 284;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L11: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L12: // CALL_SUB_VOID
  // SPVM::IntList->push
  {
    if (SUB_ID_SPVM__IntList__push < 0) {
      SUB_ID_SPVM__IntList__push = env->get_sub_id(env, "SPVM::IntList", "push", "void(self,int)");
      if (SUB_ID_SPVM__IntList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L16: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L17: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L18: // CALL_SUB_VOID
  // SPVM::IntList->push
  {
    if (SUB_ID_SPVM__IntList__push < 0) {
      SUB_ID_SPVM__IntList__push = env->get_sub_id(env, "SPVM::IntList", "push", "void(self,int)");
      if (SUB_ID_SPVM__IntList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L20: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L23: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L31: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L32: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L35: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L39: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L40: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L41: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L44: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L48: // BOOL_INT
  int_vars[0] = int_vars[3];
L49: // GOTO
  goto L52;
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L51: // BOOL_INT
  int_vars[0] = int_vars[4];
L52: // GOTO
  goto L55;
L53: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L54: // BOOL_INT
  int_vars[0] = int_vars[5];
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L59: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L60: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L62: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L68: // BOOL_INT
  int_vars[0] = int_vars[3];
L69: // GOTO
  goto L72;
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L71: // BOOL_INT
  int_vars[0] = int_vars[4];
L72: // GOTO
  goto L75;
L73: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L74: // BOOL_INT
  int_vars[0] = int_vars[5];
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L80; }
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L79: // GOTO
  goto L80;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L82: // CALL_SUB_OBJECT
  // SPVM::IntList->new
  {
    if (SUB_ID_SPVM__IntList__new < 0) {
      SUB_ID_SPVM__IntList__new = env->get_sub_id(env, "SPVM::IntList", "new", "SPVM::IntList()");
      if (SUB_ID_SPVM__IntList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L85: // GOTO
  goto L94;
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L88: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L89: // CALL_SUB_VOID
  // SPVM::IntList->push
  {
    if (SUB_ID_SPVM__IntList__push < 0) {
      SUB_ID_SPVM__IntList__push = env->get_sub_id(env, "SPVM::IntList", "push", "void(self,int)");
      if (SUB_ID_SPVM__IntList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L91: // MOVE_INT
  int_vars[3] = int_vars[2];
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L93: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L94: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L95: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L98: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L101: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_NE_ZERO
  if (int_vars[0]) { goto L107; }
L104: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L106: // GOTO
  goto L107;
L107: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L108: // GOTO
  goto L123;
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L110: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L111: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "push";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L114: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_NE_ZERO
  if (int_vars[0]) { goto L120; }
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L119: // GOTO
  goto L120;
L120: // MOVE_INT
  int_vars[6] = int_vars[5];
L121: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L122: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L123: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L124: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[3]);
L125: // BOOL_INT
  int_vars[0] = int_vars[0];
L126: // IF_NE_ZERO
  if (int_vars[0]) { goto L109; }
L127: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L128: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L129: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L132;
L130: // INIT_INT
  int_vars[5] = 0;
L131: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L132;
L132: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L133: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__remove(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[13];
  int32_t exception_flag = 0;
  int32_t mortal_stack[19];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L15: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L16: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[9] = 4;
L19: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L20: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[9];
      } 
    } 
  } 
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L24: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L30: // CALL_SUB_INT
  // SPVM::IntList->remove
  {
    if (SUB_ID_SPVM__IntList__remove < 0) {
      SUB_ID_SPVM__IntList__remove = env->get_sub_id(env, "SPVM::IntList", "remove", "int(self,int)");
      if (SUB_ID_SPVM__IntList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L34: // CALL_SUB_OBJECT
  // SPVM::IntList->to_array
  {
    if (SUB_ID_SPVM__IntList__to_array < 0) {
      SUB_ID_SPVM__IntList__to_array = env->get_sub_id(env, "SPVM::IntList", "to_array", "int[](self)");
      if (SUB_ID_SPVM__IntList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L38: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L41: // MOVE_INT
  int_vars[5] = int_vars[4];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L43: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L46: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L47: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[9] = 4;
L50: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L51: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[9];
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L54: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L55: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L57: // BOOL_INT
  int_vars[0] = int_vars[11];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L60: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L269;
L63: // GOTO
  goto L64;
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L66: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L269;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L75: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L78: // MOVE_INT
  int_vars[6] = int_vars[5];
L79: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L80: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L83: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L84: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L87: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L88: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L91: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L92: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L94: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L97: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L98: // CALL_SUB_INT
  // SPVM::IntList->remove
  {
    if (SUB_ID_SPVM__IntList__remove < 0) {
      SUB_ID_SPVM__IntList__remove = env->get_sub_id(env, "SPVM::IntList", "remove", "int(self,int)");
      if (SUB_ID_SPVM__IntList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L100: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L102: // CALL_SUB_OBJECT
  // SPVM::IntList->to_array
  {
    if (SUB_ID_SPVM__IntList__to_array < 0) {
      SUB_ID_SPVM__IntList__to_array = env->get_sub_id(env, "SPVM::IntList", "to_array", "int[](self)");
      if (SUB_ID_SPVM__IntList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L105: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L106: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L109: // MOVE_INT
  int_vars[4] = int_vars[3];
L110: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L111: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L114: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L115: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L117: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L118: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L119: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L121: // BOOL_INT
  int_vars[0] = int_vars[8];
L122: // IF_NE_ZERO
  if (int_vars[0]) { goto L128; }
L123: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L269;
L127: // GOTO
  goto L128;
L128: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L129: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L130: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L131: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L132: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L134: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L135: // MOVE_INT
  int_vars[6] = int_vars[5];
L136: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L137: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L140: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L141: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L143: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L144: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L145: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L146: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L147: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L148: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L149: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L151: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L152: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L153: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L154: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L155: // CALL_SUB_INT
  // SPVM::IntList->remove
  {
    if (SUB_ID_SPVM__IntList__remove < 0) {
      SUB_ID_SPVM__IntList__remove = env->get_sub_id(env, "SPVM::IntList", "remove", "int(self,int)");
      if (SUB_ID_SPVM__IntList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L157: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L158: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L159: // CALL_SUB_OBJECT
  // SPVM::IntList->to_array
  {
    if (SUB_ID_SPVM__IntList__to_array < 0) {
      SUB_ID_SPVM__IntList__to_array = env->get_sub_id(env, "SPVM::IntList", "to_array", "int[](self)");
      if (SUB_ID_SPVM__IntList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L162: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L163: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L164: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L166: // MOVE_INT
  int_vars[4] = int_vars[3];
L167: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L168: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L171: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L172: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L174: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L175: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L176: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L177: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L269;
  }
L178: // BOOL_INT
  int_vars[0] = int_vars[8];
L179: // IF_NE_ZERO
  if (int_vars[0]) { goto L185; }
L180: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L181: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L182: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L183: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L269;
L184: // GOTO
  goto L185;
L185: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L186: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L187: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L188: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L189: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L190: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L191: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L215;
  }
L192: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L193: // MOVE_INT
  int_vars[6] = int_vars[5];
L194: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L195: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L196: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L215;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L198: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L199: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L200: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L215;
  }
L201: // MOVE_CONSTANT_INT
  int_vars[10] = 3;
L202: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L203: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L204: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L215;
  }
L205: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L206: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L207: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L208: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 140;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L215;
  }
L209: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L210: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L211: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L212: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L213: // CALL_SUB_INT
  // SPVM::IntList->remove
  {
    if (SUB_ID_SPVM__IntList__remove < 0) {
      SUB_ID_SPVM__IntList__remove = env->get_sub_id(env, "SPVM::IntList", "remove", "int(self,int)");
      if (SUB_ID_SPVM__IntList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L214: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 141;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L215;
  }
L215: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L216: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L217: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L218: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L219: // IF_NE_ZERO
  if (int_vars[0]) { goto L224; }
L220: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L221: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L222: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L269;
L223: // GOTO
  goto L224;
L224: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L225: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L226: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L227: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L228: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L229: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L230: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L231: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L232: // MOVE_INT
  int_vars[4] = int_vars[3];
L233: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L234: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L235: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L236: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L237: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L238: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L239: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L240: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L241: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L242: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L243: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L244: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L245: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L246: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L247: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 150;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L248: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L249: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L250: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L251: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L252: // CALL_SUB_INT
  // SPVM::IntList->remove
  {
    if (SUB_ID_SPVM__IntList__remove < 0) {
      SUB_ID_SPVM__IntList__remove = env->get_sub_id(env, "SPVM::IntList", "remove", "int(self,int)");
      if (SUB_ID_SPVM__IntList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L253: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 151;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L254: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L255: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L256: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L257: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L258: // IF_NE_ZERO
  if (int_vars[0]) { goto L263; }
L259: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L260: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L261: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L269;
L262: // GOTO
  goto L263;
L263: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L264: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L265: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L266: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L269;
L267: // INIT_INT
  int_vars[4] = 0;
L268: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L269;
L269: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L270: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__set(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L14: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L15: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L26: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L27: // CALL_SUB_VOID
  // SPVM::IntList->set
  {
    if (SUB_ID_SPVM__IntList__set < 0) {
      SUB_ID_SPVM__IntList__set = env->get_sub_id(env, "SPVM::IntList", "set", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L32: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L34: // CALL_SUB_VOID
  // SPVM::IntList->set
  {
    if (SUB_ID_SPVM__IntList__set < 0) {
      SUB_ID_SPVM__IntList__set = env->get_sub_id(env, "SPVM::IntList", "set", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L39: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L40: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L41: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L42: // CALL_SUB_VOID
  // SPVM::IntList->set
  {
    if (SUB_ID_SPVM__IntList__set < 0) {
      SUB_ID_SPVM__IntList__set = env->get_sub_id(env, "SPVM::IntList", "set", "void(self,int,int)");
      if (SUB_ID_SPVM__IntList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L46: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L47: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L50: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L57: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L58: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L59: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 246;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L62: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L67: // GOTO
  goto L68;
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L69: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L70: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L71: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L73: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L75: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L80: // GOTO
  goto L81;
L81: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L84: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L89: // GOTO
  goto L90;
L90: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L91: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L92: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L93: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L94: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L95: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 260;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L96;
  }
L96: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L97: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L98: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L99: // IF_NE_ZERO
  if (int_vars[0]) { goto L104; }
L100: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L103: // GOTO
  goto L104;
L104: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L105: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L106: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L107: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L108: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L109: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L110: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "set";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 267;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L111: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L112: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L113: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L114: // IF_NE_ZERO
  if (int_vars[0]) { goto L119; }
L115: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L118: // GOTO
  goto L119;
L119: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L120: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L121: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L123: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L124: // INIT_INT
  int_vars[4] = 0;
L125: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__shift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::IntList->new
  {
    if (SUB_ID_SPVM__IntList__new < 0) {
      SUB_ID_SPVM__IntList__new = env->get_sub_id(env, "SPVM::IntList", "new", "SPVM::IntList()");
      if (SUB_ID_SPVM__IntList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L7: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 407;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L11: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L12: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 408;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L16: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L17: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L18: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // CALL_SUB_INT
  // SPVM::IntList->shift
  {
    if (SUB_ID_SPVM__IntList__shift < 0) {
      SUB_ID_SPVM__IntList__shift = env->get_sub_id(env, "SPVM::IntList", "shift", "int(self)");
      if (SUB_ID_SPVM__IntList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L23: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L25: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L30: // GOTO
  goto L31;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L32: // CALL_SUB_INT
  // SPVM::IntList->shift
  {
    if (SUB_ID_SPVM__IntList__shift < 0) {
      SUB_ID_SPVM__IntList__shift = env->get_sub_id(env, "SPVM::IntList", "shift", "int(self)");
      if (SUB_ID_SPVM__IntList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 415;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L35: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L40: // GOTO
  goto L41;
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L42: // CALL_SUB_INT
  // SPVM::IntList->shift
  {
    if (SUB_ID_SPVM__IntList__shift < 0) {
      SUB_ID_SPVM__IntList__shift = env->get_sub_id(env, "SPVM::IntList", "shift", "int(self)");
      if (SUB_ID_SPVM__IntList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L45: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L50: // GOTO
  goto L51;
L51: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L79;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L59: // GOTO
  goto L60;
L60: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L62: // CALL_SUB_INT
  // SPVM::IntList->shift
  {
    if (SUB_ID_SPVM__IntList__shift < 0) {
      SUB_ID_SPVM__IntList__shift = env->get_sub_id(env, "SPVM::IntList", "shift", "int(self)");
      if (SUB_ID_SPVM__IntList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "shift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 429;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L64;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L65: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L66: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L74: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L79;
L77: // INIT_INT
  int_vars[4] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__to_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L13: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L16: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // CALL_SUB_OBJECT
  // SPVM::IntList->newa
  {
    if (SUB_ID_SPVM__IntList__newa < 0) {
      SUB_ID_SPVM__IntList__newa = env->get_sub_id(env, "SPVM::IntList", "newa", "SPVM::IntList(int[])");
      if (SUB_ID_SPVM__IntList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 164;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // CALL_SUB_OBJECT
  // SPVM::IntList->to_array
  {
    if (SUB_ID_SPVM__IntList__to_array < 0) {
      SUB_ID_SPVM__IntList__to_array = env->get_sub_id(env, "SPVM::IntList", "to_array", "int[](self)");
      if (SUB_ID_SPVM__IntList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L27: // IS_TYPE
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_int;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L37: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L44: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L47: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L52: // GOTO
  goto L53;
L53: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L54: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 180;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L56: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 180;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L58: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L63: // GOTO
  goto L64;
L64: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "to_array";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L67: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_NE_ZERO
  if (int_vars[0]) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L72: // GOTO
  goto L73;
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L78;
L76: // INIT_INT
  int_vars[6] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IntList__unshift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::IntList->new
  {
    if (SUB_ID_SPVM__IntList__new < 0) {
      SUB_ID_SPVM__IntList__new = env->get_sub_id(env, "SPVM::IntList", "new", "SPVM::IntList()");
      if (SUB_ID_SPVM__IntList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L7: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L11: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L12: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 367;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L16: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L17: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L18: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 367;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L20: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L23: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L31: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L32: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L34: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L36: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L41: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L42: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L45: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[3];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[4];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[5];
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L60: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L61: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 374;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L68: // BOOL_INT
  int_vars[0] = int_vars[3];
L69: // GOTO
  goto L72;
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L71: // BOOL_INT
  int_vars[0] = int_vars[4];
L72: // GOTO
  goto L75;
L73: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L74: // BOOL_INT
  int_vars[0] = int_vars[5];
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L80; }
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L79: // GOTO
  goto L80;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L82: // CALL_SUB_OBJECT
  // SPVM::IntList->new
  {
    if (SUB_ID_SPVM__IntList__new < 0) {
      SUB_ID_SPVM__IntList__new = env->get_sub_id(env, "SPVM::IntList", "new", "SPVM::IntList()");
      if (SUB_ID_SPVM__IntList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L85: // GOTO
  goto L94;
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L88: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L89: // CALL_SUB_VOID
  // SPVM::IntList->unshift
  {
    if (SUB_ID_SPVM__IntList__unshift < 0) {
      SUB_ID_SPVM__IntList__unshift = env->get_sub_id(env, "SPVM::IntList", "unshift", "void(self,int)");
      if (SUB_ID_SPVM__IntList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 384;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L91: // MOVE_INT
  int_vars[3] = int_vars[2];
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L93: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L94: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L95: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L98: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__IntList__length < 0, 0)) {
      FIELD_ID_SPVM__IntList__length = env->get_field_id(env, "SPVM::IntList", "length", "int");
      if (FIELD_ID_SPVM__IntList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IntList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IntList__length = env->get_field_offset(env, FIELD_ID_SPVM__IntList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IntList__length);
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 387;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L101: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_NE_ZERO
  if (int_vars[0]) { goto L107; }
L104: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L106: // GOTO
  goto L107;
L107: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L108: // GOTO
  goto L123;
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L110: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[5];
L111: // CALL_SUB_INT
  // SPVM::IntList->get
  {
    if (SUB_ID_SPVM__IntList__get < 0) {
      SUB_ID_SPVM__IntList__get = env->get_sub_id(env, "SPVM::IntList", "get", "int(self,int)");
      if (SUB_ID_SPVM__IntList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IntList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IntList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IntList";
    const char* sub_name = "unshift";
    const char* file = "TestCase/Lib/SPVM/IntList.spvm";
    int32_t line = 393;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L132;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L114: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_NE_ZERO
  if (int_vars[0]) { goto L120; }
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L132;
L119: // GOTO
  goto L120;
L120: // MOVE_INT
  int_vars[6] = int_vars[5];
L121: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L122: // ADD_INT
  int_vars[5] = int_vars[6] + int_vars[7];
L123: // MOVE_CONSTANT_INT
  int_vars[3] = 100;
L124: // LT_INT
  int_vars[0] = (int_vars[5] < int_vars[3]);
L125: // BOOL_INT
  int_vars[0] = int_vars[0];
L126: // IF_NE_ZERO
  if (int_vars[0]) { goto L109; }
L127: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L128: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L129: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L132;
L130: // INIT_INT
  int_vars[5] = 0;
L131: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L132;
L132: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L133: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


