#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__IO__File__auto_flush = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__IO__File__auto_flush = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__IO__File__open = - 1;
static int32_t SUB_ID_SPVM__IO__File__auto_flush = - 1;
static int32_t SUB_ID_SPVM__IO__File__set_auto_flush = - 1;
static int32_t SUB_ID_SPVM__IO__File__print = - 1;
static int32_t SUB_ID_SPVM__IO__File__flush = - 1;
static int32_t SUB_ID_SPVM__IO__File__read = - 1;
static int32_t SUB_ID_SPVM__Util__sliceb = - 1;
static int32_t SUB_ID_SPVM__IO__File__readline = - 1;
static int32_t SUB_ID_SPVM__Util__chomp_lf = - 1;
static int32_t SUB_ID_SPVM__StringList__new = - 1;
static int32_t SUB_ID_SPVM__StringList__push = - 1;
static int32_t SUB_ID_SPVM__StringList__to_array = - 1;
static int32_t SUB_ID_SPVM__Util__equals_strarray = - 1;
static int32_t SUB_ID_SPVM__IO__File__slurp = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
// Function Declarations
// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_auto_flush(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_flush(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_open(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_print(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_print_long_lines(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_print_newline(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_read(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf_eof(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf_long_line(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf_while(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_eof(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_long_line(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_while(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_slurp(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_auto_flush(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3E", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_auto_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L14: // GOTO
  goto L15;
L15: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__IO__File__auto_flush < 0, 0)) {
      FIELD_ID_SPVM__IO__File__auto_flush = env->get_field_id(env, "SPVM::IO::File", "auto_flush", "byte");
      if (FIELD_ID_SPVM__IO__File__auto_flush < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IO::File auto_flush");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IO__File__auto_flush = env->get_field_offset(env, FIELD_ID_SPVM__IO__File__auto_flush);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IO__File__auto_flush);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_auto_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L17: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L26: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L27: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__IO__File__auto_flush < 0, 0)) {
      FIELD_ID_SPVM__IO__File__auto_flush = env->get_field_id(env, "SPVM::IO::File", "auto_flush", "byte");
      if (FIELD_ID_SPVM__IO__File__auto_flush < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IO::File auto_flush");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IO__File__auto_flush = env->get_field_offset(env, FIELD_ID_SPVM__IO__File__auto_flush);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IO__File__auto_flush) = byte_vars[1];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_auto_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L29: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_SPVM__IO__File__auto_flush < 0, 0)) {
      FIELD_ID_SPVM__IO__File__auto_flush = env->get_field_id(env, "SPVM::IO::File", "auto_flush", "byte");
      if (FIELD_ID_SPVM__IO__File__auto_flush < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::IO::File auto_flush");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__IO__File__auto_flush = env->get_field_offset(env, FIELD_ID_SPVM__IO__File__auto_flush);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[1] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__IO__File__auto_flush);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_auto_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L31: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[1];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L38: // GOTO
  goto L39;
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x48\x65\x6C\x6C\x6F", 5));
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L42: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L43: // CALL_SUB_VOID
  // SPVM::IO::File->print
  {
    if (SUB_ID_SPVM__IO__File__print < 0) {
      SUB_ID_SPVM__IO__File__print = env->get_sub_id(env, "SPVM::IO::File", "print", "void(self,string)");
      if (SUB_ID_SPVM__IO__File__print < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File print");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__print;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_auto_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L50;
  }
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L50;
L48: // INIT_INT
  int_vars[4] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L50;
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_flush(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3E", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x48\x65", 2));
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L13: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L14: // CALL_SUB_VOID
  // SPVM::IO::File->print
  {
    if (SUB_ID_SPVM__IO__File__print < 0) {
      SUB_ID_SPVM__IO__File__print = env->get_sub_id(env, "SPVM::IO::File", "print", "void(self,string)");
      if (SUB_ID_SPVM__IO__File__print < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File print");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__print;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 10;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L18: // CALL_SUB_VOID
  // SPVM::IO::File->flush
  {
    if (SUB_ID_SPVM__IO__File__flush < 0) {
      SUB_ID_SPVM__IO__File__flush = env->get_sub_id(env, "SPVM::IO::File", "flush", "void(self)");
      if (SUB_ID_SPVM__IO__File__flush < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File flush");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__flush;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 11;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x6C\x6C\x6F", 3));
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L24: // CALL_SUB_VOID
  // SPVM::IO::File->print
  {
    if (SUB_ID_SPVM__IO__File__print < 0) {
      SUB_ID_SPVM__IO__File__print = env->get_sub_id(env, "SPVM::IO::File", "print", "void(self,string)");
      if (SUB_ID_SPVM__IO__File__print < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File print");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__print;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 12;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L28: // CALL_SUB_VOID
  // SPVM::IO::File->flush
  {
    if (SUB_ID_SPVM__IO__File__flush < 0) {
      SUB_ID_SPVM__IO__File__flush = env->get_sub_id(env, "SPVM::IO::File", "flush", "void(self)");
      if (SUB_ID_SPVM__IO__File__flush < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File flush");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__flush;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_flush";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L34;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L32: // INIT_INT
  int_vars[4] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L34: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L35: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_open(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_open";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L14: // GOTO
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x70\x70\x70", 3));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L22: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_open";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 84;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L29: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L34: // GOTO
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L37: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L40: // INIT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_print(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3E", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_print";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L14: // GOTO
  goto L15;
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x48\x65\x6C\x6C\x6F", 5));
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L19: // CALL_SUB_VOID
  // SPVM::IO::File->print
  {
    if (SUB_ID_SPVM__IO__File__print < 0) {
      SUB_ID_SPVM__IO__File__print = env->get_sub_id(env, "SPVM::IO::File", "print", "void(self,string)");
      if (SUB_ID_SPVM__IO__File__print < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File print");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__print;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_print";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 47;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L24: // INIT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_print_long_lines(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3E", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_print_long_lines";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L14: // GOTO
  goto L15;
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x41\x0A\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x42\x0A\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x43\x0A\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x44\x0A\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x45\x0A\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x46\x0A", 126));
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L19: // CALL_SUB_VOID
  // SPVM::IO::File->print
  {
    if (SUB_ID_SPVM__IO__File__print < 0) {
      SUB_ID_SPVM__IO__File__print = env->get_sub_id(env, "SPVM::IO::File", "print", "void(self,string)");
      if (SUB_ID_SPVM__IO__File__print < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File print");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__print;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_print_long_lines";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L24: // INIT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_print_newline(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3E", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_print_newline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L14: // GOTO
  goto L15;
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x0A", 1));
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L19: // CALL_SUB_VOID
  // SPVM::IO::File->print
  {
    if (SUB_ID_SPVM__IO__File__print < 0) {
      SUB_ID_SPVM__IO__File__print = env->get_sub_id(env, "SPVM::IO::File", "print", "void(self,string)");
      if (SUB_ID_SPVM__IO__File__print < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File print");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__print;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_print_newline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L24: // INIT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L26;
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_read(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 98;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L37: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L38: // CALL_SUB_INT
  // SPVM::IO::File->read
  {
    if (SUB_ID_SPVM__IO__File__read < 0) {
      SUB_ID_SPVM__IO__File__read = env->get_sub_id(env, "SPVM::IO::File", "read", "int(self,byte[])");
      if (SUB_ID_SPVM__IO__File__read < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File read");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__read;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L41: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64\x0A", 5));
L42: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_NE_ZERO
  if (int_vars[0]) { goto L50; }
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L119;
L49: // GOTO
  goto L50;
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L52: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_NE_ZERO
  if (int_vars[0]) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L119;
L57: // GOTO
  goto L58;
L58: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L60: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L61: // CALL_SUB_INT
  // SPVM::IO::File->read
  {
    if (SUB_ID_SPVM__IO__File__read < 0) {
      SUB_ID_SPVM__IO__File__read = env->get_sub_id(env, "SPVM::IO::File", "read", "int(self,byte[])");
      if (SUB_ID_SPVM__IO__File__read < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File read");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__read;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L64: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x66\x67\x68\x69\x0A", 5));
L65: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_NE_ZERO
  if (int_vars[0]) { goto L73; }
L69: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L119;
L72: // GOTO
  goto L73;
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L75: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L119;
L80: // GOTO
  goto L81;
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L84: // CALL_SUB_INT
  // SPVM::IO::File->read
  {
    if (SUB_ID_SPVM__IO__File__read < 0) {
      SUB_ID_SPVM__IO__File__read = env->get_sub_id(env, "SPVM::IO::File", "read", "int(self,byte[])");
      if (SUB_ID_SPVM__IO__File__read < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File read");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__read;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L87: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L88: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L90: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L91: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[4];
L92: // CALL_SUB_OBJECT
  // SPVM::Util->sliceb
  {
    if (SUB_ID_SPVM__Util__sliceb < 0) {
      SUB_ID_SPVM__Util__sliceb = env->get_sub_id(env, "SPVM::Util", "sliceb", "byte[](byte[],int,int)");
      if (SUB_ID_SPVM__Util__sliceb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util sliceb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__sliceb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L95: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x6B\x6C\x6D\x0A", 4));
L96: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_read";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_NE_ZERO
  if (int_vars[0]) { goto L105; }
L100: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L101: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L102: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L103: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L119;
L104: // GOTO
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L107: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L119;
L112: // GOTO
  goto L113;
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L117: // INIT_INT
  int_vars[6] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L119;
L119: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L120: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 140;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 140;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 140;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L34: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L37: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64\x0A", 5));
L38: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 145;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L50: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 151;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x66\x67\x68\x69\x0A", 5));
L54: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L61: // GOTO
  goto L62;
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L66: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L69: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x6B\x6C\x6D\x0A", 4));
L70: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L82: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L84: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L89: // GOTO
  goto L90;
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L95;
L93: // INIT_INT
  int_vars[6] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L34: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L40: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L41: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 280;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L48: // GOTO
  goto L49;
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L53: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L56: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L59: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x66\x67\x68\x69", 4));
L60: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L67: // GOTO
  goto L68;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L72: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L75: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L78: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x6B\x6C\x6D", 3));
L79: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L87; }
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L86: // GOTO
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L90: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L91: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L94: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L96: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_NE_ZERO
  if (int_vars[0]) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L101: // GOTO
  goto L102;
L102: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf_eof(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[17];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L34: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 338;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 339;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L40: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L41: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 340;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L48: // GOTO
  goto L49;
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L53: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 346;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L56: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L59: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x66\x67\x68\x69", 4));
L60: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 348;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L67: // GOTO
  goto L68;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L72: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 354;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L75: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L78: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "", 0));
L79: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 356;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L87; }
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L86: // GOTO
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L90: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L91: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L94: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L96: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L97: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x6B\x6C\x6D", 3));
L98: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 364;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L100: // BOOL_INT
  int_vars[0] = int_vars[0];
L101: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L105: // GOTO
  goto L106;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L110: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 370;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L112: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L113: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L115: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L116: // BOOL_INT
  int_vars[0] = int_vars[0];
L117: // IF_NE_ZERO
  if (int_vars[0]) { goto L121; }
L118: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L120: // GOTO
  goto L121;
L121: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L123: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L126;
L124: // INIT_INT
  int_vars[6] = 0;
L125: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf_long_line(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 380;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L34: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 386;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 387;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L40: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61", 170));
L41: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L48: // GOTO
  goto L49;
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L53: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 394;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L56: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 395;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L59: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x66\x67\x68\x69", 4));
L60: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 396;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L67: // GOTO
  goto L68;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L72: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L75: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 403;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L78: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x6B\x6C\x6D", 3));
L79: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 404;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L87; }
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L86: // GOTO
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L90: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L91: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 410;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L94: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L96: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_NE_ZERO
  if (int_vars[0]) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L101: // GOTO
  goto L102;
L102: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_chomp_lf_while(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // CALL_SUB_OBJECT
  // SPVM::StringList->new
  {
    if (SUB_ID_SPVM__StringList__new < 0) {
      SUB_ID_SPVM__StringList__new = env->get_sub_id(env, "SPVM::StringList", "new", "SPVM::StringList()");
      if (SUB_ID_SPVM__StringList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L35: // GOTO
  goto L43;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L37: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 319;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L39: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L41: // CALL_SUB_VOID
  // SPVM::StringList->push
  {
    if (SUB_ID_SPVM__StringList__push < 0) {
      SUB_ID_SPVM__StringList__push = env->get_sub_id(env, "SPVM::StringList", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 320;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L45: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 318;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L47: // BOOL_OBJECT
  int_vars[0] = !!object_vars[3];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L51: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L52: // CALL_SUB_OBJECT
  // SPVM::StringList->to_array
  {
    if (SUB_ID_SPVM__StringList__to_array < 0) {
      SUB_ID_SPVM__StringList__to_array = env->get_sub_id(env, "SPVM::StringList", "to_array", "string[](self)");
      if (SUB_ID_SPVM__StringList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L56: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L59: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L60: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L61: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L64: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x66\x67\x68\x69", 4));
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L69: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], env->new_string_len_raw(env, "\x6B\x6C\x6D", 3));
L70: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L71: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L73: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L74: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L75: // CALL_SUB_INT
  // SPVM::Util->equals_strarray
  {
    if (SUB_ID_SPVM__Util__equals_strarray < 0) {
      SUB_ID_SPVM__Util__equals_strarray = env->get_sub_id(env, "SPVM::Util", "equals_strarray", "int(string[],string[])");
      if (SUB_ID_SPVM__Util__equals_strarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_strarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_strarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_chomp_lf_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L91;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[6];
L78: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L80: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L81: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L82: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L91;
L85: // GOTO
  goto L86;
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L91;
L89: // INIT_INT
  int_vars[6] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L91;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_eof(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[17];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L34: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 199;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L37: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64\x0A", 5));
L38: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 200;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L50: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 206;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x66\x67\x68\x69\x0A", 5));
L54: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 207;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L61: // GOTO
  goto L62;
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L66: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L69: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x0A", 1));
L70: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L82: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L84: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L85: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x6B\x6C\x6D", 3));
L86: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L94; }
L90: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L93: // GOTO
  goto L94;
L94: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L98: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_eof";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L111;
  }
L100: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L111;
L105: // GOTO
  goto L106;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L108: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L111;
L109: // INIT_INT
  int_vars[6] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L111;
L111: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L112: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_long_line(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L34: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L37: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x0A", 171));
L38: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L50: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L53: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x66\x67\x68\x69\x0A", 5));
L54: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L61: // GOTO
  goto L62;
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L66: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 256;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L69: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x6B\x6C\x6D\x0A", 4));
L70: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 257;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L82: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_long_line";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L84: // IS_UNDEF
  int_vars[0] = object_vars[1] == NULL;
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L89: // GOTO
  goto L90;
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L95;
L93: // INIT_INT
  int_vars[6] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_readline_while(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // BOOL_OBJECT
  int_vars[0] = !!object_vars[2];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L13: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x43\x61\x6E\x27\x74\x20\x6F\x70\x65\x6E\x20\x66\x69\x6C\x65\x20", 16));
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[0];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "", 0));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L22: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[5]);
L23: // SET_CROAK_FLAG_TRUE
  exception_flag = 1;
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L29: // GOTO
  goto L31;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // CALL_SUB_OBJECT
  // SPVM::StringList->new
  {
    if (SUB_ID_SPVM__StringList__new < 0) {
      SUB_ID_SPVM__StringList__new = env->get_sub_id(env, "SPVM::StringList", "new", "SPVM::StringList()");
      if (SUB_ID_SPVM__StringList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L35: // GOTO
  goto L40;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L37: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L38: // CALL_SUB_VOID
  // SPVM::StringList->push
  {
    if (SUB_ID_SPVM__StringList__push < 0) {
      SUB_ID_SPVM__StringList__push = env->get_sub_id(env, "SPVM::StringList", "push", "void(self,string)");
      if (SUB_ID_SPVM__StringList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L42: // CALL_SUB_OBJECT
  // SPVM::IO::File->readline
  {
    if (SUB_ID_SPVM__IO__File__readline < 0) {
      SUB_ID_SPVM__IO__File__readline = env->get_sub_id(env, "SPVM::IO::File", "readline", "string(self)");
      if (SUB_ID_SPVM__IO__File__readline < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File readline");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__readline;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 180;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L44: // BOOL_OBJECT
  int_vars[0] = !!object_vars[3];
L45: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L49: // CALL_SUB_OBJECT
  // SPVM::StringList->to_array
  {
    if (SUB_ID_SPVM__StringList__to_array < 0) {
      SUB_ID_SPVM__StringList__to_array = env->get_sub_id(env, "SPVM::StringList", "to_array", "string[](self)");
      if (SUB_ID_SPVM__StringList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::StringList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__StringList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L53: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L56: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x62\x63\x64\x0A", 5));
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L61: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x66\x67\x68\x69\x0A", 5));
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L63: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L66: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], env->new_string_len_raw(env, "\x6B\x6C\x6D\x0A", 4));
L67: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L68: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L70: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L72: // CALL_SUB_INT
  // SPVM::Util->equals_strarray
  {
    if (SUB_ID_SPVM__Util__equals_strarray < 0) {
      SUB_ID_SPVM__Util__equals_strarray = env->get_sub_id(env, "SPVM::Util", "equals_strarray", "int(string[],string[])");
      if (SUB_ID_SPVM__Util__equals_strarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_strarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_strarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_readline_while";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L88;
  }
L74: // BOOL_INT
  int_vars[0] = int_vars[6];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L83; }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L78: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L88;
L82: // GOTO
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L85: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L88;
L86: // INIT_INT
  int_vars[6] = 0;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L88;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__IO__File__test_slurp(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x3C", 1));
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_OBJECT
  // SPVM::IO::File->open
  {
    if (SUB_ID_SPVM__IO__File__open < 0) {
      SUB_ID_SPVM__IO__File__open = env->get_sub_id(env, "SPVM::IO::File", "open", "SPVM::IO::File(string,string)");
      if (SUB_ID_SPVM__IO__File__open < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File open");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__open;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_slurp";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L13: // CALL_SUB_OBJECT
  // SPVM::IO::File->slurp
  {
    if (SUB_ID_SPVM__IO__File__slurp < 0) {
      SUB_ID_SPVM__IO__File__slurp = env->get_sub_id(env, "SPVM::IO::File", "slurp", "string(self,string)");
      if (SUB_ID_SPVM__IO__File__slurp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::IO::File slurp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__IO__File__slurp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_slurp";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64\x0A\x66\x67\x68\x69\x0A\x6B\x6C\x6D\x0A", 14));
L17: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::IO::File";
    const char* sub_name = "test_slurp";
    const char* file = "TestCase/Lib/SPVM/IO/File.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L31;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L31;
L24: // GOTO
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L31;
L29: // INIT_INT
  int_vars[6] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L31;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


