#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__If__condition_my(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__If__else_match(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__If__elsif_match(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__If__if_bool(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__If__if_false(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__If__if_true(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__If__condition_my(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L4: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L5: // BOOL_INT
  int_vars[0] = int_vars[5];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L7: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L8: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L11: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L12: // GOTO
  goto L13;
L13: // GOTO
  goto L18;
L14: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L15: // BOOL_INT
  int_vars[0] = int_vars[6];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L23: // GOTO
  goto L24;
L24: // BOOL_INT
  int_vars[0] = int_vars[1];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L29: // BOOL_INT
  int_vars[0] = int_vars[5];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L32: // BOOL_INT
  int_vars[0] = int_vars[6];
L33: // GOTO
  goto L36;
L34: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[7];
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L97;
L40: // GOTO
  goto L41;
L41: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[5];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L47: // GOTO
  goto L58;
L48: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L49: // BOOL_INT
  int_vars[0] = int_vars[6];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L51: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L52: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[7]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L55: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L56: // GOTO
  goto L57;
L57: // GOTO
  goto L58;
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L59: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L63: // GOTO
  goto L64;
L64: // BOOL_INT
  int_vars[0] = int_vars[1];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L66: // BOOL_INT
  int_vars[0] = int_vars[3];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // BOOL_INT
  int_vars[0] = int_vars[5];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L72: // BOOL_INT
  int_vars[0] = int_vars[6];
L73: // GOTO
  goto L76;
L74: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[7];
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L97;
L80: // GOTO
  goto L81;
L81: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L83: // BOOL_INT
  int_vars[0] = int_vars[3];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L86: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_NE_ZERO
  if (int_vars[0]) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L97;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L97;
L95: // INIT_INT
  int_vars[6] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L97;
L97: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__If__else_match(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L29;
L8: // GOTO
  goto L25;
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L10: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L29;
L15: // GOTO
  goto L25;
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L17: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[5]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L29;
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L29;
L25: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L29;
L27: // INIT_INT
  int_vars[9] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L29;
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__If__elsif_match(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L29;
L8: // GOTO
  goto L25;
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L10: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L29;
L15: // GOTO
  goto L25;
L16: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L17: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[5]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L29;
L22: // GOTO
  goto L25;
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L29;
L25: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L29;
L27: // INIT_INT
  int_vars[9] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L29;
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__If__if_bool(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  float float_vars[1];
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L4: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L5: // BOOL_INT
  int_vars[0] = int_vars[4];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L7: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L8: // GOTO
  goto L10;
L9: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L10: // BOOL_INT
  int_vars[0] = int_vars[1];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L14: // GOTO
  goto L15;
L15: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L17: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L18: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L19: // BOOL_INT
  int_vars[0] = int_vars[4];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L21: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L25: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L26: // BOOL_INT
  int_vars[0] = int_vars[4];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L28: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L29: // GOTO
  goto L30;
L30: // BOOL_INT
  int_vars[0] = int_vars[1];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L39: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L40: // GOTO
  goto L41;
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[3];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L44: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L45: // GOTO
  goto L46;
L46: // BOOL_INT
  int_vars[0] = int_vars[1];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L50: // GOTO
  goto L51;
L51: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L52: // MOVE_CONSTANT_LONG
  long_vars[0] = 1LL;
L53: // BOOL_LONG
  int_vars[0] = !!long_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L55: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_LONG
  long_vars[0] = 0LL;
L58: // BOOL_LONG
  int_vars[0] = !!long_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L62; }
L60: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L61: // GOTO
  goto L62;
L62: // BOOL_INT
  int_vars[0] = int_vars[1];
L63: // IF_NE_ZERO
  if (int_vars[0]) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L68: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.5;
L69: // BOOL_FLOAT
  int_vars[0] = !!float_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L71: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L72: // GOTO
  goto L73;
L73: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L74: // BOOL_FLOAT
  int_vars[0] = !!float_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L76: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L77: // GOTO
  goto L78;
L78: // BOOL_INT
  int_vars[0] = int_vars[1];
L79: // IF_NE_ZERO
  if (int_vars[0]) { goto L83; }
L80: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L82: // GOTO
  goto L83;
L83: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L84: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.5;
L85: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[0];
L86: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L89; }
L87: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L88: // GOTO
  goto L89;
L89: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L90: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L92: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L93: // GOTO
  goto L94;
L94: // BOOL_INT
  int_vars[0] = int_vars[1];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L103;
L98: // GOTO
  goto L99;
L99: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L103;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__If__if_false(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__If__if_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


