#!/usr/bin/env perl

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/../lib";

use SMS::API::VoIP::MS;

die "Usage: $0 <login> <api_key> <from_did> <to_did> <message>\n"
    if !@ARGV || @ARGV < 5;

my ( $username, $key, $from, $to ) = @ARGV;
my $message                        = join q{ }, splice( @ARGV, 4 );

my $obj = SMS::API::VoIP::MS->new(
    username => $username,
    api_key  => $key,
    did      => $from,
    convert_long_sms_to_mms => 1,
);

print 'From: ' . $obj->did . "\n";;
print "To: $to\n\n";
print "$message\n";

$obj->send_sms(
    to => $to,

    $message,
);
