package APR::Request::FunctionTable;

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# ! WARNING: generated by My::ParseSource/
# !          Fri Jul  8 12:29:54 2005
# !          do NOT edit, any changes will be lost !
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

$APR::Request::FunctionTable = [
  {
    'return_type' => 'return',
    'name' => 'INT2PTR',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'arg0'
      },
      {
        'type' => 'iv',
        'name' => 'arg1'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'Perl_grok_number',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'const char *',
        'name' => 'pv'
      },
      {
        'type' => 'STRLEN',
        'name' => 'len'
      },
      {
        'type' => 'UV *',
        'name' => 'valuep'
      }
    ]
  },
  {
    'return_type' => 'bool',
    'name' => 'Perl_grok_numeric_radix',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'const char * *',
        'name' => 'sp'
      },
      {
        'type' => 'const char *',
        'name' => 'send'
      }
    ]
  },
  {
    'return_type' => 'return',
    'name' => 'SvPV_nolen',
    'args' => [
      {
        'type' => 'sv',
        'name' => 'arg0'
      }
    ]
  },
  {
    'return_type' => 'return',
    'name' => 'SvRV',
    'args' => [
      {
        'type' => 'sv',
        'name' => 'arg0'
      }
    ]
  },
  {
    'return_type' => 'else',
    'name' => 'XSRETURN',
    'args' => [
      {
        'type' => '0',
        'name' => 'arg0'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'XS_APR__Request__Cookie_nil',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'XS_APR__Request__Error_nil',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'XS_APR__Request__Param_nil',
    'args' => []
  },
  {
    'return_type' => 'UV',
    'name' => '_grok_bin',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'string'
      },
      {
        'type' => 'STRLEN *',
        'name' => 'len'
      },
      {
        'type' => 'I32 *',
        'name' => 'flags'
      },
      {
        'type' => 'NV *',
        'name' => 'result'
      }
    ]
  },
  {
    'return_type' => 'UV',
    'name' => '_grok_hex',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'string'
      },
      {
        'type' => 'STRLEN *',
        'name' => 'len'
      },
      {
        'type' => 'I32 *',
        'name' => 'flags'
      },
      {
        'type' => 'NV *',
        'name' => 'result'
      }
    ]
  },
  {
    'return_type' => 'UV',
    'name' => '_grok_oct',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'string'
      },
      {
        'type' => 'STRLEN *',
        'name' => 'len'
      },
      {
        'type' => 'I32 *',
        'name' => 'flags'
      },
      {
        'type' => 'NV *',
        'name' => 'result'
      }
    ]
  },
  {
    'return_type' => 'return',
    'name' => 'apr_pstrmemdup',
    'args' => [
      {
        'type' => 'p',
        'name' => 'arg0'
      },
      {
        'type' => 'v',
        'name' => 'arg1'
      },
      {
        'type' => 'vlen',
        'name' => 'arg2'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_args',
    'comment' => '*
 * Expose the parsed "query string" associated to this handle. 
 *
 * @param req The request handle
 * @param t   The resulting table, which will either be NULL or a 
 *            valid table object on return.
 *
 * @return    APR_SUCCESS or a module-specific error status code.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const apr_table_t * *',
        'name' => 't'
      }
    ]
  },
  {
    'return_type' => 'apreq_param_t *',
    'name' => 'apreq_args_get',
    'comment' => '*
 * Fetch the first query string param with the given name. 
 *
 * @param req  The request handle
 * @param name Case-insensitive param name.
 *
 * @return     First matching param, or NULL if none match.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      }
    ]
  },
  {
    'return_type' => 'apr_int64_t',
    'name' => 'apreq_atoi64f',
    'comment' => '*
 * Converts file sizes (KMG) to bytes
 *
 * @param s  file size matching m/^\\\\d+[KMG]b?$/i
 *
 * @return 64-bit integer representation of s.
 *
 * @todo What happens when s is malformed?  Should this return
 *       an unsigned value instead?',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 's'
      }
    ]
  },
  {
    'return_type' => 'apr_int64_t',
    'name' => 'apreq_atoi64t',
    'comment' => '*
 * Converts time strings (YMDhms) to seconds
 *
 * @param s time string matching m/^\\\\+?\\\\d+[YMDhms]$/
 *
 * @return 64-bit integer representation of s as seconds.
 *
 * @todo What happens when s is malformed?  Should this return
 *       an unsigned value instead?',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 's'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_body',
    'comment' => '*
 * Expose the parsed "request body" associated to this handle. 
 *
 * @param req The request handle
 * @param t   The resulting table, which will either be NULL or a 
 *            valid table object on return.
 *
 * @return    APR_SUCCESS or a module-specific error status code.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const apr_table_t * *',
        'name' => 't'
      }
    ]
  },
  {
    'return_type' => 'apreq_param_t *',
    'name' => 'apreq_body_get',
    'comment' => '*
 * Fetch the first body param with the given name. 
 *
 * @param req  The request handle
 * @param name Case-insensitive cookie name.
 *
 * @return     First matching param, or NULL if none match.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_brigade_concat',
    'comment' => '*
 * Concatenates the brigades, spooling large brigades into
 * a tempfile (APREQ_SPOOL) bucket.
 *
 * @param pool           Pool for creating a tempfile bucket.
 * @param temp_dir       Directory for tempfile creation.
 * @param brigade_limit  If out\'s length would exceed this value, 
 *                       the appended buckets get written to a tempfile.  
 * @param out            Resulting brigade.
 * @param in             Brigade to append.
 *
 * @return APR_SUCCESS.
 * @return Error status code resulting from either apr_brigade_length(),
 *         apreq_file_mktemp(), apreq_brigade_fwrite(), or apr_file_seek().
 *
 * @todo Flesh out these error codes, making them as explicit as possible.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'const char *',
        'name' => 'temp_dir'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'brigade_limit'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'out'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'in'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_brigade_copy',
    'comment' => '*
 * Copy a brigade.
 *
 * @param d (destination) Copied buckets are appended to this brigade.
 * @param s (source) Brigade to copy from.
 *
 * @return APR_SUCCESS.
 * @return Error status code from an unsuccessful apr_bucket_copy().
 *
 * @remarks s == d produces Undefined Behavior.',
    'args' => [
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'd'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 's'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_brigade_fwrite',
    'comment' => '*
 * Writes brigade to a file.
 *
 * @param f       File that gets the brigade.
 * @param wlen    On a successful return, wlen holds the length of
 *                the brigade, which is the amount of data written to 
 *                the file.
 * @param bb      Bucket brigade.
 *
 * @return APR_SUCCESS.
 * @return Error status code from either an unsuccessful apr_bucket_read(),
 *         or a failed apr_file_writev().
 *
 * @remarks       In the future, this function may do something 
 *                intelligent with file buckets.',
    'args' => [
      {
        'type' => 'apr_file_t *',
        'name' => 'f'
      },
      {
        'type' => 'apr_off_t *',
        'name' => 'wlen'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'bb'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_brigade_limit_get',
    'comment' => '*
 * Get the active brigade limit.
 *
 * @param req   The handle.
 * @param bytes Pointer to resulting (current) limit.
 *
 * @return APR_SUCCESS or a module-specific error, 
 *         which may leave bytes undefined.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apr_size_t *',
        'name' => 'bytes'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_brigade_limit_set',
    'comment' => '*
 * Set the active brigade limit.
 *
 * @param req   The handle.
 * @param bytes New limit to use.
 *
 * @return APR_SUCCESS or module-specific error.
 *',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'bytes'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_brigade_move',
    'comment' => '*
 * Move the front of a brigade.
 *
 * @param d (destination) Append buckets to this brigade.
 * @param s (source) Brigade to take buckets from.
 * @param e First bucket of s after the move.  All buckets
 *          before e are appended to d.
 *
 * @remarks This moves all buckets when e == APR_BRIGADE_SENTINEL(s).',
    'args' => [
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'd'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 's'
      },
      {
        'type' => 'apr_bucket *',
        'name' => 'e'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_brigade_setaside',
    'comment' => '*
 * Set aside all buckets in the brigade.
 *
 * @param bb Brigade.
 * @param p  Setaside buckets into this pool.
 * @return APR_SUCCESS.
 * @return Error status code from an unsuccessful apr_bucket_setaside().',
    'args' => [
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'bb'
      },
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'apr_file_t *',
    'name' => 'apreq_brigade_spoolfile',
    'comment' => '*
 * Determines the spool file used by the brigade. Returns NULL if the
 * brigade is not spooled in a file (does not use an APREQ_SPOOL
 * bucket).
 *
 * @param bb the bucket brigade
 * @return the spool file, or NULL.',
    'args' => [
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'bb'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'apreq_cookie_as_string',
    'comment' => '*
 * Returns a string that represents the cookie as it would appear 
 * in a valid "Set-Cookie*" header.
 *
 * @param c cookie.
 * @param p pool which allocates the returned string.
 *
 * @return header string.',
    'args' => [
      {
        'type' => 'const apreq_cookie_t *',
        'name' => 'c'
      },
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_cookie_expires',
    'comment' => '*
 * Set the Cookie\'s expiration date.
 * 
 * @param c The cookie.
 * @param time_str If NULL, the Cookie\'s expiration date is unset,
 * making it a session cookie.  This means no "expires" or "max-age" 
 * attribute will appear in the cookie\'s serialized form. If time_str
 * is not NULL, the expiration date will be reset to the offset (from now)
 * represented by time_str.  The time_str should be in a format that 
 * apreq_atoi64t() can understand, namely /[+-]?\\\\d+\\\\s*[YMDhms]/.
 *
 * @remarks Now time_str may also be a fixed date; see apr_date_parse_rfc()
 * for admissible formats.',
    'args' => [
      {
        'type' => 'apreq_cookie_t *',
        'name' => 'c'
      },
      {
        'type' => 'const char *',
        'name' => 'time_str'
      }
    ]
  },
  {
    'return_type' => 'unsigned',
    'name' => 'apreq_cookie_is_secure',
    'comment' => '* @return 1 if the secure flag is set, 0 otherwise.',
    'args' => [
      {
        'type' => 'const apreq_cookie_t *',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'unsigned',
    'name' => 'apreq_cookie_is_tainted',
    'comment' => '* @return 1 if the taint flag is set, 0 otherwise.',
    'args' => [
      {
        'type' => 'const apreq_cookie_t *',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'apreq_cookie_t *',
    'name' => 'apreq_cookie_make',
    'comment' => '*
 * Returns a new cookie, made from the argument list.
 *
 * @param pool  Pool which allocates the cookie.
 * @param name  The cookie\'s name.
 * @param nlen  Length of name.
 * @param value The cookie\'s value.
 * @param vlen  Length of value.
 *
 * @return the new cookie',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'nlen'
      },
      {
        'type' => 'const char *',
        'name' => 'value'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'vlen'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_cookie_secure_off',
    'comment' => '* Turns off the cookie\'s secure flag.',
    'args' => [
      {
        'type' => 'apreq_cookie_t *',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_cookie_secure_on',
    'comment' => '* Sets the cookie\'s secure flag, meaning it only
 *  comes back over an SSL-encrypted connction.',
    'args' => [
      {
        'type' => 'apreq_cookie_t *',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_cookie_serialize',
    'comment' => '*
 * Same functionality as apreq_cookie_as_string.  Stores the string
 * representation in buf, using up to len bytes in buf as storage.
 * The return value has the same semantics as that of apr_snprintf,
 * including the special behavior for a "len = 0" argument.
 *
 * @param c   cookie.
 * @param buf storage location for the result.
 * @param len size of buf\'s storage area. 
 *
 * @return size of resulting header string.',
    'args' => [
      {
        'type' => 'const apreq_cookie_t *',
        'name' => 'c'
      },
      {
        'type' => 'char *',
        'name' => 'buf'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'len'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_cookie_tainted_off',
    'comment' => '* Turns off the cookie\'s tainted flag.',
    'args' => [
      {
        'type' => 'apreq_cookie_t *',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_cookie_tainted_on',
    'comment' => '* Sets the cookie\'s tainted flag.',
    'args' => [
      {
        'type' => 'apreq_cookie_t *',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'unsigned',
    'name' => 'apreq_cookie_version',
    'comment' => '*@return 1 if this is an RFC cookie, 0 if its a Netscape cookie.',
    'args' => [
      {
        'type' => 'const apreq_cookie_t *',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_cookie_version_set',
    'comment' => '* Sets the cookie\'s protocol version.',
    'args' => [
      {
        'type' => 'apreq_cookie_t *',
        'name' => 'c'
      },
      {
        'type' => 'unsigned',
        'name' => 'v'
      }
    ]
  },
  {
    'return_type' => 'apr_table_t *',
    'name' => 'apreq_cookies',
    'comment' => '*
 * Returns a table containing all request cookies.
 *
 * @param req the apreq request handle
 * @param p Allocates the returned table.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'apr_size_t',
    'name' => 'apreq_cp1252_to_utf8',
    'comment' => '*
 * Convert a string from cp1252 to utf8.  Caller must ensure it is large enough
 * to hold the encoded string and trailing \'\\\\0\'.
 *
 * @param dest Location of utf8-encoded result string. Caller must ensure it
 *             is large enough to hold the encoded string and trailing \'\\\\0\'.
 * @param src  Original string.
 * @param slen Length of original string.
 *
 * @return length of utf8-encoded string in dest; does not exceed 3 * slen.',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'dest'
      },
      {
        'type' => 'const char *',
        'name' => 'src'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'slen'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_decode',
    'comment' => '*
 * Url-decodes a string.
 *
 * @param dest Location of url-encoded result string. Caller must ensure dest is
 *             large enough to hold the encoded string and trailing null character.
 * @param dlen points to resultant length of url-decoded string in dest
 * @param src  Original string.
 * @param slen Length of original string.
 *
 * @return APR_SUCCESS + apreq_charset_t (<=APREQ_CHARSET_UTF8) on success.
 * @return APR_INCOMPLETE + apreq_charset_t (<=APREQ_CHARSET_UTF8) if the string
 *         ends in the middle of an escape sequence.
 * @return ::APREQ_ERROR_BADSEQ or ::APREQ_ERROR_BADCHAR on malformed input.
 *
 * @remarks In the non-success case, dlen will be set to include
 *          the last succesfully decoded value.  This function decodes 
 *          \\%uXXXX into a utf8 (wide) character, following ECMA-262 
 *          (the Javascript spec) Section B.2.1.',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'dest'
      },
      {
        'type' => 'apr_size_t *',
        'name' => 'dlen'
      },
      {
        'type' => 'const char *',
        'name' => 'src'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'slen'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_decodev',
    'comment' => '*
 * Url-decodes an iovec array.
 *
 * @param dest  Location of url-encoded result string. Caller must ensure dest is
 *              large enough to hold the encoded string and trailing null character.
 * @param dlen  Resultant length of dest.
 * @param v     Array of iovecs that represent the source string
 * @param nelts Number of iovecs in the array.
 *
 * @return APR_SUCCESS + apreq_charset_t (<=APREQ_CHARSET_UTF8) on success.
 * @return APR_INCOMPLETE + apreq_charset_t (<=APREQ_CHARSET_UTF8) if the iovec
 *         ends in the middle of an escape sequence.
 * @return ::APREQ_ERROR_BADSEQ or ::APREQ_ERROR_BADCHAR on malformed input.
 *
 * @remarks In the non-APR_SUCCESS case, dlen will be set to include
 *          the last succesfully decoded value.  This function decodes
 *          \\%uXXXX into a utf8 (wide) character, following ECMA-262 
 *          (the Javascript spec) Section B.2.1.',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'dest'
      },
      {
        'type' => 'apr_size_t *',
        'name' => 'dlen'
      },
      {
        'type' => 'struct iovec *',
        'name' => 'v'
      },
      {
        'type' => 'int',
        'name' => 'nelts'
      }
    ]
  },
  {
    'return_type' => 'apr_size_t',
    'name' => 'apreq_encode',
    'comment' => '*
 * Url-encodes a string.
 *
 * @param dest Location of url-encoded result string. Caller must ensure it
 *             is large enough to hold the encoded string and trailing \'\\\\0\'.
 * @param src  Original string.
 * @param slen Length of original string.
 *
 * @return length of url-encoded string in dest; does not exceed 3 * slen.',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'dest'
      },
      {
        'type' => 'const char *',
        'name' => 'src'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'slen'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'apreq_escape',
    'comment' => '*
 * Returns an url-encoded copy of a string.
 *
 * @param p    Pool used to allocate the return value.
 * @param src  Original string.
 * @param slen Length of original string.
 *
 * @return The url-encoded string.
 *
 * @remarks Use this function insead of apreq_encode if its
 *          caller might otherwise overflow dest.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      },
      {
        'type' => 'const char *',
        'name' => 'src'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'slen'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_file_mktemp',
    'comment' => '*
 * Makes a temporary file.
 *
 * @param fp    Points to the temporary apr_file_t on success.
 * @param pool  Pool to associate with the temp file.  When the
 *              pool is destroyed, the temp file will be closed
 *              and deleted.
 * @param path  The base directory which will contain the temp file.
 *              If param == NULL, the directory will be selected via
 *              tempnam().  See the tempnam manpage for details.
 *
 * @return APR_SUCCESS.
 * @return Error status code from unsuccessful apr_filepath_merge(),
 *         or a failed apr_file_mktemp().',
    'args' => [
      {
        'type' => 'apr_file_t * *',
        'name' => 'fp'
      },
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'const char *',
        'name' => 'path'
      }
    ]
  },
  {
    'return_type' => 'apreq_handle_t *',
    'name' => 'apreq_handle_apache2',
    'comment' => '*
 * @defgroup mod_apreq2 Apache 2.X Filter Module
 * @ingroup apreq_module
 * @brief mod_apreq2 - DSO that ties libapreq2 to Apache HTTPD 2.X.
 *
 * mod_apreq2 provides the "APREQ2" input filter for using libapreq2
 * (and allow its parsed data structures to be shared) within
 * the Apache 2.X webserver.  Using it, libapreq2 works properly
 * in every phase of the HTTP request, from translation handlers 
 * to output filters, and even for subrequests / internal redirects.
 *
 * <hr>
 *
 * <h2>Activating mod_apreq2 in Apache 2.X</h2>
 *
 * The installation process triggered by
 * <code>% make install</code>
 * <em>will not modify your webserver\'s config file</em>. Hence,
 * be sure you activate it on startup by adding a LoadModule directive
 * to your webserver config; e.g.
 *
 * @code
 *
 *     LoadModule    modules/mod_apreq2.so
 *
 * @endcode
 *
 * The mod_apreq2 filter is named "APREQ2", and may be used in Apache\'s
 * input filter directives, e.g.
 * @code
 *
 *     AddInputFilter APREQ2         # or
 *     SetInputFilter APREQ2
 *
 * @endcode
 *
 * However, this is not required because libapreq2 will add the filter (only)
 * if it\'s necessary.  You just need to ensure that your module invokes
 * apreq_handle_apache2() <em>before the content handler ultimately reads 
 * from the input filter chain</em>.  It is important to realize that no
 * matter how the input filters are initially arranged, the APREQ2 filter 
 * will attempt to reposition itself to be the last input filter to read the
 * data.
 *
 * If you want to use other input filters to transform the incoming HTTP
 * request data, is important to register those filters with Apache
 * as having type AP_FTYPE_CONTENT_SET or AP_FTYPE_RESOURCE.  Due to the 
 * limitations of Apache\'s current input filter design, types higher than 
 * AP_FTYPE_CONTENT_SET may not work properly whenever the apreq filter is
 * active.
 *
 * This is especially true when a content handler uses libapreq2 to parse 
 * some of the post data before doing an internal redirect.  Any input
 * filter subsequently added to the redirected request will bypass the
 * original apreq filter (and therefore lose access to some of the original
 * post data), unless its type is less than the type of the apreq filter
 * (currently AP_FTYPE_PROTOCOL-1). 
 *
 *
 * <H2>Server Configuration Directives</H2>
 *
 * <TABLE class="qref">
 *   <CAPTION>Per-directory commands for mod_apreq2</CAPTION>
 *   <TR>
 *     <TH>Directive</TH>
 *     <TH>Context</TH>
 *     <TH>Default</TH><TH>Description</TH>
 *   </TR>
 *   <TR class="odd">
 *     <TD>APREQ2_ReadLimit</TD>
 *     <TD>directory</TD>
 *     <TD> #APREQ_DEFAULT_READ_LIMIT </TD>
 *     <TD> Maximum number of bytes mod_apreq2 will send off to libapreq2
 *          for parsing. mod_apreq2 will log this event and subsequently
 *          remove itself from the filter chain. 
 *     </TD>
 *   </TR>
 *   <TR>
 *     <TD>APREQ2_BrigadeLimit</TD>
 *     <TD>directory</TD>
 *     <TD>#APREQ_DEFAULT_BRIGADE_LIMIT</TD>
 *     <TD> Maximum number of bytes mod_apreq2 will let accumulate
 *          within the heap-buckets in a brigade.  Excess data will be 
 *          spooled to an appended file bucket.
 *     </TD>
 *   </TR>
 *   <TR class="odd">
 *     <TD>APREQ2_TempDir</TD>
 *     <TD>directory</TD>
 *     <TD>NULL</TD>
 *     <TD> Sets the location of the temporary directory apreq will use to spool
 *          overflow brigade data (based on the APREQ2_BrigadeLimit setting).
 *          If left unset, libapreq2 will select a platform-specific location
 *          via apr_temp_dir_get(). 
 *     </TD>
 *  </TR>
 * </TABLE>
 *
 * <H2>Implementation Details</H2>
 * <PRE>
 *   XXX apreq as a normal input filter
 *   XXX apreq as a "virtual" content handler.
 *   XXX apreq as a transparent "tee".
 *   XXX apreq parser registration in post_config
 * </PRE>
 *
 * @{ *
 * Create an apreq handle which communicates with an Apache 2.X
 * request_rec.',
    'args' => [
      {
        'type' => 'request_rec *',
        'name' => 'r'
      }
    ]
  },
  {
    'return_type' => 'apreq_handle_t *',
    'name' => 'apreq_handle_cgi',
    'comment' => '*
 * Create an apreq handle which is suitable for a CGI program. It
 * reads input from stdin and writes output to stdout.
 *
 * @param pool Pool associated to this handle.
 *
 * @return New handle; can only be NULL if the pool allocation failed.
 *
 * @remarks The handle gets cached in the pool\'s userdata, so subsequent
 *          calls will retrieve the original cached handle.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      }
    ]
  },
  {
    'return_type' => 'apreq_handle_t *',
    'name' => 'apreq_handle_custom',
    'comment' => '*
 * Create a custom apreq handle which knows only some 
 * values. Useful if you want to test the parser code or if you have
 * got data from a custom source (neither Apache 2 nor CGI).
 *
 * @param pool         allocates the parse data,
 * @param query_string parsed into args table
 * @param cookie       value of the request "Cookie" header
 * @param parser       parses the request body
 * @param read_limit   maximum bytes to read from the body
 * @param in           brigade containing the request body
 *
 * @return new handle; can only be NULL if the pool allocation failed.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'const char *',
        'name' => 'query_string'
      },
      {
        'type' => 'const char *',
        'name' => 'cookie'
      },
      {
        'type' => 'apreq_parser_t *',
        'name' => 'parser'
      },
      {
        'type' => 'apr_uint64_t',
        'name' => 'read_limit'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'in'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_header_attribute',
    'comment' => '*
 * Search a header string for the value of a particular named attribute.
 *
 * @param hdr Header string to scan.
 * @param name Name of attribute to search for.
 * @param nlen Length of name.
 * @param val Location of (first) matching value.
 * @param vlen Length of matching value.
 *
 * @return APR_SUCCESS.
 * @return ::APREQ_ERROR_NOATTR if the attribute is not found.
 * @return ::APREQ_ERROR_BADSEQ if an unpaired quote mark was detected.',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 'hdr'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'nlen'
      },
      {
        'type' => 'const char * *',
        'name' => 'val'
      },
      {
        'type' => 'apr_size_t *',
        'name' => 'vlen'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_hook_add',
    'comment' => '*
 * Add a parser hook for this request.
 *
 * @param req  The request handle
 * @param hook Hook to add.
 *
 * @return     APR_SUCCESS or module-specific error.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apreq_hook_t *',
        'name' => 'hook'
      }
    ]
  },
  {
    'return_type' => 'apreq_hook_t *',
    'name' => 'apreq_hook_make',
    'comment' => '*
 * Construct a hook.
 *
 * @param pool used to allocate the hook.
 * @param hook The hook function.
 * @param next List of other hooks for this hook to call on.
 * @param ctx Hook\'s internal scratch pad.
 * @return New hook.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'apreq_hook_function_t',
        'name' => 'hook'
      },
      {
        'type' => 'apreq_hook_t *',
        'name' => 'next'
      },
      {
        'type' => 'void *',
        'name' => 'ctx'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_hook_run',
    'comment' => '*
 * Run the hook with the current parameter and the incoming 
 * bucket brigade.  The hook may modify the brigade if necessary.
 * Once all hooks have completed, the contents of the brigade will 
 * be added to the parameter\'s bb attribute.
 * @return APR_SUCCESS on success. All other values represent errors.',
    'args' => [
      {
        'type' => 'struct apreq_hook_t *',
        'name' => 'h'
      },
      {
        'type' => 'apreq_param_t *',
        'name' => 'param'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'bb'
      }
    ]
  },
  {
    'return_type' => 'apr_ssize_t',
    'name' => 'apreq_index',
    'comment' => '*
 * Returns offset of match string\'s location, or -1 if no match is found.
 *
 * @param hay  Location of bytes to scan.
 * @param hlen Number of bytes available for scanning.
 * @param ndl  Search string
 * @param nlen Length of search string.
 * @param type Match type.
 *
 * @return Offset of match string, or -1 if no match is found.
 *',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 'hay'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'hlen'
      },
      {
        'type' => 'const char *',
        'name' => 'ndl'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'nlen'
      },
      {
        'type' => 'const apreq_match_t',
        'name' => 'type'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_initialize',
    'comment' => '*
 * Initialize libapreq2. Applications (except apache modules using
 * mod_apreq) should call this exactly once before they use any
 * libapreq2 modules.  If you want to modify the list of default parsers
 * with apreq_register_parser(), please use apreq_pre_initialize()
 * and apreq_post_initialize() instead.
 *
 * @param pool a base pool persisting while libapreq2 is used
 * @remarks after you detroy the pool, you have to call this function again
 *    with a new pool if you still plan to use libapreq2',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_jar',
    'comment' => '*
 * Expose the parsed "cookie" header associated to this handle. 
 *
 * @param req The request handle
 * @param t   The resulting table, which will either be NULL or a 
 *            valid table object on return.
 *
 * @return    APR_SUCCESS or a module-specific error status code.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const apr_table_t * *',
        'name' => 't'
      }
    ]
  },
  {
    'return_type' => 'apreq_cookie_t *',
    'name' => 'apreq_jar_get',
    'comment' => '*
 * Fetch the first cookie with the given name. 
 *
 * @param req  The request handle
 * @param name Case-insensitive cookie name.
 *
 * @return     First matching cookie, or NULL if none match.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'apreq_join',
    'comment' => '*
 * This header contains useful functions for creating new 
 * parsers, hooks or modules.  It includes
 *
 *    - string <-> array converters
 *    - substring search functions
 *    - simple encoders & decoders for urlencoded strings
 *    - simple time, date, & file-size converters
 * @file apreq_util.h
 * @brief Utility functions for apreq.
 * @ingroup libapreq2 *
 * Join an array of values. The result is an empty string if there are
 * no values.
 *
 * @param p    Pool to allocate return value.
 * @param sep  String that is inserted between the joined values.
 * @param arr  Array of apreq_value_t entries.
 * @param mode Join type- see apreq_join_t.
 *
 * @return Joined string, or NULL on error',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      },
      {
        'type' => 'const char *',
        'name' => 'sep'
      },
      {
        'type' => 'const apr_array_header_t *',
        'name' => 'arr'
      },
      {
        'type' => 'apreq_join_t',
        'name' => 'mode'
      }
    ]
  },
  {
    'return_type' => 'unsigned',
    'name' => 'apreq_module_status_is_error',
    'comment' => '*
 * Defines the module-specific status codes which
 * are commonly considered to be non-fatal.
 *
 * @param s status code returned by an apreq_module_t method.
 *
 * @return 1 if s is fatal, 0 otherwise.',
    'args' => [
      {
        'type' => 'apr_status_t',
        'name' => 's'
      }
    ]
  },
  {
    'return_type' => 'apreq_param_t *',
    'name' => 'apreq_param',
    'comment' => '*
 * Find the first query string parameter or body parameter with the
 * specified name.  The match is case-insensitive.
 *
 * @param req request handle.
 * @param key desired parameter name
 *
 * @return The first matching parameter (with args searched first) or NULL.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      }
    ]
  },
  {
    'return_type' => 'apreq_charset_t',
    'name' => 'apreq_param_charset_get',
    'comment' => '* Gets the character encoding for this parameter.',
    'args' => [
      {
        'type' => 'apreq_param_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'apreq_charset_t',
    'name' => 'apreq_param_charset_set',
    'comment' => '* Sets the character encoding for this parameter.',
    'args' => [
      {
        'type' => 'apreq_param_t *',
        'name' => 'p'
      },
      {
        'type' => 'unsigned char',
        'name' => 'c'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_param_decode',
    'comment' => '*
 * Url-decodes a name=value pair into a param.
 *
 * @param param points to the decoded parameter on success
 * @param pool  Pool from which the param is allocated.
 * @param word  Start of the name=value pair.
 * @param nlen  Length of urlencoded name.
 * @param vlen  Length of urlencoded value.
 *
 * @return APR_SUCCESS + apreq_charset_t (<=APREQ_CHARSET_UTF8) on success.
 * @return ::APREQ_ERROR_BADSEQ or ::APREQ_ERROR_BADCHAR on malformed input.
 *
 * @remarks     Unless vlen == 0, this function assumes there is
 *              exactly one character (\'=\') which separates the pair.
 *',
    'args' => [
      {
        'type' => 'apreq_param_t * *',
        'name' => 'param'
      },
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'const char *',
        'name' => 'word'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'nlen'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'vlen'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'apreq_param_encode',
    'comment' => '*
 * Url-encodes the param into a name-value pair.
 * @param pool Pool which allocates the returned string.
 * @param param Param to encode.
 * @return name-value pair representing the param.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'const apreq_param_t *',
        'name' => 'param'
      }
    ]
  },
  {
    'return_type' => 'unsigned',
    'name' => 'apreq_param_is_tainted',
    'comment' => '* @return 1 if the taint flag is set, 0 otherwise.',
    'args' => [
      {
        'type' => 'const apreq_param_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'apreq_param_t *',
    'name' => 'apreq_param_make',
    'comment' => '* creates a param from name/value information',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'nlen'
      },
      {
        'type' => 'const char *',
        'name' => 'val'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'vlen'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_param_tainted_off',
    'comment' => '* Turns off the taint flag.',
    'args' => [
      {
        'type' => 'apreq_param_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_param_tainted_on',
    'comment' => '* Sets the tainted flag.',
    'args' => [
      {
        'type' => 'apreq_param_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'apr_table_t *',
    'name' => 'apreq_params',
    'comment' => '*
 * Returns a table containing key-value pairs for the full request
 * (args + body).
 *
 * @param req request handle
 * @param p   allocates the returned table.
 *
 * @return table representing all available params; is never NULL.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      }
    ]
  },
  {
    'return_type' => 'apr_array_header_t *',
    'name' => 'apreq_params_as_array',
    'comment' => '*
 * Returns an array of parameters (apreq_param_t *) matching the given key.
 * The key is case-insensitive.
 * @param p Allocates the returned array.
 * @param t the parameter table returned by apreq_args(), apreq_body()
 *    or apreq_params()
 * @param key Null-terminated search key, case insensitive.
 *    key==NULL fetches all parameters.
 * @return an array of apreq_param_t* (pointers)
 * @remark Also parses the request if necessary.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      },
      {
        'type' => 'const apr_table_t *',
        'name' => 't'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      }
    ]
  },
  {
    'return_type' => 'const char *',
    'name' => 'apreq_params_as_string',
    'comment' => '*
 * Returns a ", " -joined string containing all parameters
 * for the requested key, an empty string if none are found.
 * The key is case-insensitive.
 *
 * @param p Allocates the return string.
 * @param t the parameter table returned by apreq_args(), apreq_body()
 *    or apreq_params()
 * @param key Null-terminated parameter name, case insensitive.
 *    key==NULL fetches all values.
 * @param mode Join type- see apreq_join().
 * @return the joined string or NULL on error
 * @remark Also parses the request if necessary.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'p'
      },
      {
        'type' => 'const apr_table_t *',
        'name' => 't'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      },
      {
        'type' => 'apreq_join_t',
        'name' => 'mode'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_parse_cookie_header',
    'comment' => '*
 * Parse a cookie header and store the cookies in an apr_table_t.
 *
 * @param pool pool which allocates the cookies
 * @param jar table where parsed cookies are stored
 * @param header the header value
 *
 * @return APR_SUCCESS.
 * @return ::APREQ_ERROR_BADSEQ if an unparseable character sequence appears.
 * @return ::APREQ_ERROR_MISMATCH if an rfc-cookie attribute appears in a
 *         netscape cookie header.
 * @return ::APR_ENOTIMPL if an unrecognized rfc-cookie attribute appears.
 * @return ::APREQ_ERROR_NOTOKEN if a required token was not present.
 * @return ::APREQ_ERROR_BADCHAR if an unexpected token was present.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'apr_table_t *',
        'name' => 'jar'
      },
      {
        'type' => 'const char *',
        'name' => 'header'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_parse_query_string',
    'comment' => '*
 * Parse a url-encoded string into a param table.
 * @param pool    pool used to allocate the param data.
 * @param t       table to which the params are added.
 * @param qs      Query string to url-decode.
 * @return        APR_SUCCESS if successful, error otherwise.
 * @remark        This function uses [&;] as the set of tokens
 *                to delineate words, and will treat a word w/o \'=\'
 *                as a name-value pair with value-length = 0.
 *',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'apr_table_t *',
        'name' => 't'
      },
      {
        'type' => 'const char *',
        'name' => 'qs'
      }
    ]
  },
  {
    'return_type' => 'apreq_parser_function_t',
    'name' => 'apreq_parser',
    'comment' => '*
 * Fetch the default parser function associated with the given MIME type.
 * @param enctype The desired enctype (can also be a full "Content-Type"
 *        header).
 * @return The parser function, or NULL if the enctype is unrecognized.',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 'enctype'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_parser_add_hook',
    'comment' => '*
 * Add a new hook to the end of the parser\'s hook list.
 *
 * @param p Parser.
 * @param h Hook to append.',
    'args' => [
      {
        'type' => 'apreq_parser_t *',
        'name' => 'p'
      },
      {
        'type' => 'apreq_hook_t *',
        'name' => 'h'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_parser_get',
    'comment' => '*
 * Fetch the active body parser.
 *
 * @param req    The request handle
 * @param parser Points to the active parser on return.
 *
 * @return       APR_SUCCESS or module-specific error.
 *',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const apreq_parser_t * *',
        'name' => 'parser'
      }
    ]
  },
  {
    'return_type' => 'apreq_parser_t *',
    'name' => 'apreq_parser_make',
    'comment' => '*
 * Construct a parser.
 *
 * @param pool Pool used to allocate the parser.
 * @param ba bucket allocator used to create bucket brigades
 * @param content_type Content-type that this parser can deal with.
 * @param pfn The parser function.
 * @param brigade_limit the maximum in-memory bytes a brigade may use
 * @param temp_dir the directory used by the parser for temporary files
 * @param hook Hooks to associate this parser with.
 * @param ctx Parser\'s internal scratch pad.
 * @return New parser.',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      },
      {
        'type' => 'apr_bucket_alloc_t *',
        'name' => 'ba'
      },
      {
        'type' => 'const char *',
        'name' => 'content_type'
      },
      {
        'type' => 'apreq_parser_function_t',
        'name' => 'pfn'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'brigade_limit'
      },
      {
        'type' => 'const char *',
        'name' => 'temp_dir'
      },
      {
        'type' => 'apreq_hook_t *',
        'name' => 'hook'
      },
      {
        'type' => 'void *',
        'name' => 'ctx'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_parser_run',
    'comment' => '*
 * Parse the incoming brigade into a table.  Parsers normally
 * consume all the buckets of the brigade during parsing. However
 * parsers may leave "rejected" data in the brigade, even during a
 * successful parse, so callers may need to clean up the brigade
 * themselves (in particular, rejected buckets should not be 
 * passed back to the parser again).
 * @remark  bb == NULL is valid: the parser should return its 
 * public status: APR_INCOMPLETE, APR_SUCCESS, or an error code.',
    'args' => [
      {
        'type' => 'struct apreq_parser_t *',
        'name' => 'psr'
      },
      {
        'type' => 'apr_table_t *',
        'name' => 't'
      },
      {
        'type' => 'apr_bucket_brigade *',
        'name' => 'bb'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_parser_set',
    'comment' => '*
 * Set the body parser for this request.
 *
 * @param req    The request handle
 * @param parser New parser to use.
 *
 * @return       APR_SUCCESS or module-specific error.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apreq_parser_t *',
        'name' => 'parser'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_post_initialize',
    'comment' => '*
 * Post-initialize libapreq2. Applications (except apache modules using
 * mod_apreq2) should this exactly once before they use any
 * libapreq2 modules for parsing.
 *
 * @param pool the same pool that was used in apreq_pre_initialize().',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_pre_initialize',
    'comment' => '*
 * Pre-initialize libapreq2. Applications (except apache modules using
 * mod_apreq2) should call this exactly once before they register custom
 * parsers with libapreq2. mod_apreq2 does this automatically during the
 * post-config phase, so modules that need call apreq_register_parser should
 * create a post-config hook using APR_HOOK_MIDDLE.
 *
 * @param pool a base pool persisting while libapreq2 is used
 * @remarks after you detroyed the pool, you have to call this function again
 *    with a new pool if you still plan to use libapreq2',
    'args' => [
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      }
    ]
  },
  {
    'return_type' => 'apr_size_t',
    'name' => 'apreq_quote',
    'comment' => '*
 * Places a quoted copy of src into dest.  Embedded quotes are escaped with a
 * backslash (\'\\\').
 *
 * @param dest Location of quoted copy.  Must be large enough to hold the copy
 *             and trailing null byte.
 * @param src  Original string.
 * @param slen Length of original string.
 * @param dest Destination string.
 *
 * @return length of quoted copy in dest.',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'dest'
      },
      {
        'type' => 'const char *',
        'name' => 'src'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'slen'
      }
    ]
  },
  {
    'return_type' => 'apr_size_t',
    'name' => 'apreq_quote_once',
    'comment' => '*
 *
 * Same as apreq_quote() except when src begins and ends in quote marks. In
 * that case it assumes src is quoted correctly, and just copies src to dest.
 *
 * @param dest Location of quoted copy.  Must be large enough to hold the copy
 *             and trailing null byte.
 * @param src  Original string.
 * @param slen Length of original string.
 * @param dest Destination string.
 *
 * @return length of quoted copy in dest.',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'dest'
      },
      {
        'type' => 'const char *',
        'name' => 'src'
      },
      {
        'type' => 'const apr_size_t',
        'name' => 'slen'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_read_limit_get',
    'comment' => '*
 * Get the active read limit.
 *
 * @param req   The request handle.
 * @param bytes Pointer to resulting (current) limit.
 *
 * @return APR_SUCCESS or a module-specific error,
 *         which may leave bytes undefined.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apr_uint64_t *',
        'name' => 'bytes'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_read_limit_set',
    'comment' => '*
 * Set the active read limit.
 *
 * @param req   The handle.
 * @param bytes New limit to use.
 *
 * @return APR_SUCCESS or a module-specific error.
 *',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'apr_uint64_t',
        'name' => 'bytes'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_register_parser',
    'comment' => '*
 * Register a new parsing function with a MIME enctype.
 * Registered parsers are added to apreq_parser()\'s
 * internal lookup table.
 *
 * @param enctype The MIME type.
 * @param pfn     The function to use during parsing. Setting
 *                parser == NULL will remove an existing parser.
 *
 * @return APR_SUCCESS or error.',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 'enctype'
      },
      {
        'type' => 'apreq_parser_function_t',
        'name' => 'pfn'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'apreq_strerror',
    'comment' => '* 
 * apreq\'s wrapper around apr_strerror();
 * recognizes APREQ_ERROR_* status codes.',
    'args' => [
      {
        'type' => 'apr_status_t',
        'name' => 's'
      },
      {
        'type' => 'char *',
        'name' => 'buf'
      },
      {
        'type' => 'apr_size_t',
        'name' => 'bufsize'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_temp_dir_get',
    'comment' => '*
 * Get the active temp directory.
 *
 * @param req   The handle.
 * @param path  Resulting path to temp dir.
 *
 * @return APR_SUCCESS implies path is valid, but may also be NULL.
 *         Any other return value is module-specific, and may leave
 *         path undefined.',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const char * *',
        'name' => 'path'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_temp_dir_set',
    'comment' => '*
 * Set the active temp directory.
 *
 * @param req  The handle.
 * @param path New path to use; may be NULL.
 *
 * @return APR_SUCCESS or a module-specific error .',
    'args' => [
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const char *',
        'name' => 'path'
      }
    ]
  },
  {
    'return_type' => 'apr_ssize_t',
    'name' => 'apreq_unescape',
    'comment' => '*
 * An \\e in-situ url-decoder.
 *
 * @param str  The string to decode
 *
 * @return  Length of decoded string, or < 0 on error.',
    'args' => [
      {
        'type' => 'char *',
        'name' => 'str'
      }
    ]
  },
  {
    'return_type' => 'const apreq_param_t *',
    'name' => 'apreq_upload',
    'comment' => '*
 * Returns the first param in req->body which has both param->v.name 
 * matching key (case insensitive) and param->upload != NULL.
 * @param body parameter table returned by apreq_body() or apreq_params()
 * @param name Parameter name. key == NULL returns first upload.
 * @return Corresponding upload, NULL if none found.
 * @remark Will parse the request as necessary.',
    'args' => [
      {
        'type' => 'const apr_table_t *',
        'name' => 'body'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      }
    ]
  },
  {
    'return_type' => 'const apr_table_t *',
    'name' => 'apreq_uploads',
    'comment' => '*
 * Returns a table of all params in req->body with non-NULL upload brigades.
 * @param body parameter table returned by apreq_body() or apreq_params()
 * @param pool Pool which allocates the table struct.
 * @return Upload table.
 * @remark Will parse the request if necessary.',
    'args' => [
      {
        'type' => 'const apr_table_t *',
        'name' => 'body'
      },
      {
        'type' => 'apr_pool_t *',
        'name' => 'pool'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_value_table_add',
    'args' => [
      {
        'type' => 'const apreq_value_t *',
        'name' => 'v'
      },
      {
        'type' => 'apr_table_t *',
        'name' => 't'
      }
    ]
  },
  {
    'return_type' => 'apreq_cookie_t *',
    'name' => 'apreq_value_to_cookie',
    'comment' => '* Upgrades a jar\'s table values to apreq_cookie_t structs.',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'apreq_param_t *',
    'name' => 'apreq_value_to_param',
    'comment' => '* Upgrades args and body table values to apreq_param_t structs.',
    'args' => [
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_version',
    'comment' => '*
 * Return libapreq\'s version information information in a numeric form.
 *
 *  @param pvsn Pointer to a version structure for returning the version
 *              information.',
    'args' => [
      {
        'type' => 'apr_version_t *',
        'name' => 'pvsn'
      }
    ]
  },
  {
    'return_type' => 'const char *',
    'name' => 'apreq_version_string',
    'comment' => '* Return libapreq\'s version information as a string.',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_args',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_body',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_brigade_copy',
    'comment' => ' XXX these Apache::Upload::Brigade funcs need a makeover as vanilla XS.',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_brigade_read',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_brigade_readline',
    'args' => []
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_cookie2sv',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'apreq_cookie_t *',
        'name' => 'c'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      },
      {
        'type' => 'SV *',
        'name' => 'parent'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'apreq_xs_cookie_pool_copy',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'obj'
      },
      {
        'type' => 'SV *',
        'name' => 'value'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_cookie_table2sv',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'const apr_table_t *',
        'name' => 't'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      },
      {
        'type' => 'SV *',
        'name' => 'parent'
      },
      {
        'type' => 'const char *',
        'name' => 'value_class'
      },
      {
        'type' => 'I32',
        'name' => 'vclen'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_cookie_table_FETCH',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_cookie_table_NEXTKEY',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_cookie_table_do',
    'args' => []
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_cookie_table_do_sub',
    'args' => [
      {
        'type' => 'void *',
        'name' => 'data'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      },
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_cookie_table_keys',
    'args' => [
      {
        'type' => 'void *',
        'name' => 'data'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      },
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_cookie_table_magic_copy',
    'comment' => ' Requires perl 5.8 or better. 
 * A custom MGVTBL with its "copy" slot filled allows
 * us to FETCH a table entry immediately during iteration.
 * For multivalued keys this is essential in order to get
 * the value corresponding to the current key, otherwise
 * values() will always report the first value repeatedly.
 * With this MGVTBL the keys() list always matches up with
 * the values() list, even in the multivalued case.
 * We only prefetch the value during iteration, because the
 * prefetch adds overhead to EXISTS and STORE operations.
 * They are only "penalized" when the perl program is iterating
 * via each(), which seems to be a reasonable tradeoff.',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      },
      {
        'type' => 'MAGIC *',
        'name' => 'mg'
      },
      {
        'type' => 'SV *',
        'name' => 'nsv'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      },
      {
        'type' => 'int',
        'name' => 'namelen'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_cookie_table_values',
    'args' => [
      {
        'type' => 'void *',
        'name' => 'data'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      },
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_croak',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'HV *',
        'name' => 'data'
      },
      {
        'type' => 'SV *',
        'name' => 'obj'
      },
      {
        'type' => 'apr_status_t',
        'name' => 'rc'
      },
      {
        'type' => 'const char *',
        'name' => 'func'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_error2sv',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'apr_status_t',
        'name' => 's'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_find_bb_obj',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'in'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_find_obj',
    'comment' => '*
 * @file apreq_xs_postperl.h
 * @brief XS include file for making Cookie.so and Request.so
 * *
 * @defgroup XS Perl
 * @ingroup GLUE
 * @{ * 
 * Trace through magic objects & hashrefs looking for original object.
 * @param in  The starting SV *.
 * @param key The first letter of key is used to search a hashref for 
 *            the desired object.
 * @return    Reference to the object.',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'in'
      },
      {
        'type' => 'const char',
        'name' => 'key'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_handle2sv',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'apreq_handle_t *',
        'name' => 'req'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      },
      {
        'type' => 'SV *',
        'name' => 'parent'
      }
    ]
  },
  {
    'return_type' => 'const char *',
    'name' => 'apreq_xs_helper_class',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV * *',
        'name' => 'SP'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      },
      {
        'type' => 'const char *',
        'name' => 'method'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_jar',
    'args' => []
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_object2sv',
    'comment' => ' conversion function templates based on modperl-2\'s sv2request_rec',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'void *',
        'name' => 'ptr'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      },
      {
        'type' => 'SV *',
        'name' => 'parent'
      },
      {
        'type' => 'const char *',
        'name' => 'base'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_param',
    'args' => []
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_param2sv',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'apreq_param_t *',
        'name' => 'p'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      },
      {
        'type' => 'SV *',
        'name' => 'parent'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_param_table2sv',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'const apr_table_t *',
        'name' => 't'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      },
      {
        'type' => 'SV *',
        'name' => 'parent'
      },
      {
        'type' => 'const char *',
        'name' => 'value_class'
      },
      {
        'type' => 'I32',
        'name' => 'vclen'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_param_table_FETCH',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_param_table_NEXTKEY',
    'args' => []
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_param_table_do',
    'args' => []
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_param_table_do_sub',
    'args' => [
      {
        'type' => 'void *',
        'name' => 'data'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      },
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_param_table_keys',
    'args' => [
      {
        'type' => 'void *',
        'name' => 'data'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      },
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_param_table_magic_copy',
    'comment' => ' Requires perl 5.8 or better. 
 * A custom MGVTBL with its "copy" slot filled allows
 * us to FETCH a table entry immediately during iteration.
 * For multivalued keys this is essential in order to get
 * the value corresponding to the current key, otherwise
 * values() will always report the first value repeatedly.
 * With this MGVTBL the keys() list always matches up with
 * the values() list, even in the multivalued case.
 * We only prefetch the value during iteration, because the
 * prefetch adds overhead to EXISTS and STORE operations.
 * They are only "penalized" when the perl program is iterating
 * via each(), which seems to be a reasonable tradeoff.',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      },
      {
        'type' => 'MAGIC *',
        'name' => 'mg'
      },
      {
        'type' => 'SV *',
        'name' => 'nsv'
      },
      {
        'type' => 'const char *',
        'name' => 'name'
      },
      {
        'type' => 'int',
        'name' => 'namelen'
      }
    ]
  },
  {
    'return_type' => 'int',
    'name' => 'apreq_xs_param_table_values',
    'args' => [
      {
        'type' => 'void *',
        'name' => 'data'
      },
      {
        'type' => 'const char *',
        'name' => 'key'
      },
      {
        'type' => 'const char *',
        'name' => 'val'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'apreq_xs_parse',
    'args' => []
  },
  {
    'return_type' => 'apreq_cookie_t *',
    'name' => 'apreq_xs_sv2cookie',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      }
    ]
  },
  {
    'return_type' => 'apreq_handle_t *',
    'name' => 'apreq_xs_sv2handle',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'apreq_xs_sv2object',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      },
      {
        'type' => 'const char *',
        'name' => 'class'
      },
      {
        'type' => 'const char',
        'name' => 'attr'
      }
    ]
  },
  {
    'return_type' => 'apreq_param_t *',
    'name' => 'apreq_xs_sv2param',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'apreq_xs_upload_hook',
    'args' => [
      {
        'type' => 'APREQ_HOOK_ARGS',
        'name' => 'arg0'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'eval_upload_hook',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'apreq_param_t *',
        'name' => 'upload'
      },
      {
        'type' => 'struct hook_ctx *',
        'name' => 'ctx'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'my_sv_2pvbyte',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'register SV *',
        'name' => 'sv'
      },
      {
        'type' => 'STRLEN *',
        'name' => 'lp'
      }
    ]
  },
  {
    'return_type' => 'void',
    'name' => 'newCONSTSUB',
    'args' => [
      {
        'type' => 'HV *',
        'name' => 'stash'
      },
      {
        'type' => 'char *',
        'name' => 'name'
      },
      {
        'type' => 'SV *',
        'name' => 'sv'
      }
    ]
  },
  {
    'return_type' => 'SV *',
    'name' => 'newRV_noinc',
    'args' => [
      {
        'type' => 'SV *',
        'name' => 'sv'
      }
    ]
  },
  {
    'return_type' => 'char *',
    'name' => 'sv_2pv_nolen',
    'args' => [
      {
        'type' => 'pTHX',
        'name' => 'aTHX'
      },
      {
        'type' => 'register SV *',
        'name' => 'sv'
      }
    ]
  },
  {
    'return_type' => 'apr_status_t',
    'name' => 'upload_hook_cleanup',
    'args' => [
      {
        'type' => 'void *',
        'name' => 'ctx_'
      }
    ]
  }
];


1;
