<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title></title>
    <filename>index</filename>
  </compound>
  <compound kind="file">
    <name>apreq.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq_8h</filename>
    <class kind="struct">apreq_value_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_NONSTD</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist>(d)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_DATA</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_READ_BLOCK_SIZE</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_READ_LIMIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_BRIGADE_LIMIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DEFAULT_NELTS</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_OFF</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_ON</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a8</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_GET</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a9</anchor>
      <arglist>(f, name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FLAGS_SET</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a10</anchor>
      <arglist>(f, name, value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_CHARSET_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a11</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_CHARSET_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a12</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_TAINTED_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a13</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_TAINTED_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a14</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_VERSION_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a15</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_VERSION_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a16</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_SECURE_BIT</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a17</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_SECURE_MASK</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a18</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>apreq_attr_to_type</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a19</anchor>
      <arglist>(T, A, P)</arglist>
    </member>
    <member kind="typedef">
      <type>apreq_value_t</type>
      <name>apreq_value_t</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_charset_t</name>
      <anchor>a37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_join_t</name>
      <anchor>a38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_AS_IS</name>
      <anchor>a38a25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_ENCODE</name>
      <anchor>a38a26</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_DECODE</name>
      <anchor>a38a27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_JOIN_QUOTE</name>
      <anchor>a38a28</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_match_t</name>
      <anchor>a39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_MATCH_FULL</name>
      <anchor>a39a29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_MATCH_PARTIAL</name>
      <anchor>a39a30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>apreq_expires_t</name>
      <anchor>a40</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_EXPIRES_HTTP</name>
      <anchor>a40a31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APREQ_EXPIRES_NSCOOKIE</name>
      <anchor>a40a32</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_value_table_add</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a33</anchor>
      <arglist>(const apreq_value_t *v, apr_table_t *t)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a34</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_pre_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a35</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_post_initialize</name>
      <anchorfile>apreq_8h.html</anchorfile>
      <anchor>a36</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_cookie.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__cookie_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <class kind="struct">apreq_cookie_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_COOKIE_MAX_LENGTH</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>apreq_cookie_t</type>
      <name>apreq_cookie_t</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_cookie_t *</type>
      <name>apreq_value_to_cookie</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist>(const char *val)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_version</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_version_set</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist>(apreq_cookie_t *c, unsigned v)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_is_secure</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_secure_on</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_secure_off</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_cookie_is_tainted</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a8</anchor>
      <arglist>(const apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_tainted_on</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a9</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_cookie_tainted_off</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a10</anchor>
      <arglist>(apreq_cookie_t *c)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parse_cookie_header</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a11</anchor>
      <arglist>(apr_pool_t *pool, apr_table_t *jar, const char *header)</arglist>
    </member>
    <member kind="function">
      <type>apreq_cookie_t *</type>
      <name>apreq_cookie_make</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a12</anchor>
      <arglist>(apr_pool_t *pool, const char *name, const apr_size_t nlen, const char *value, const apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_cookie_as_string</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a13</anchor>
      <arglist>(const apreq_cookie_t *c, apr_pool_t *p)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>apreq_cookie_serialize</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a14</anchor>
      <arglist>(const apreq_cookie_t *c, char *buf, apr_size_t len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apreq_cookie_expires</name>
      <anchorfile>apreq__cookie_8h.html</anchorfile>
      <anchor>a15</anchor>
      <arglist>(apreq_cookie_t *c, const char *time_str)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_error.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__error_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="define">
      <type>#define</type>
      <name>APR_EBADARG</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_GENERAL</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_TAINTED</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_INTERRUPT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADDATA</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADCHAR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADSEQ</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADATTR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADHEADER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_BADUTF8</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NODATA</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a10</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOTOKEN</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a11</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOATTR</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a12</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOHEADER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a13</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOPARSER</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a14</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_MISMATCH</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a15</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_OVERLIMIT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a16</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_UNDERLIMIT</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a17</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_ERROR_NOTEMPTY</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a18</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_strerror</name>
      <anchorfile>apreq__error_8h.html</anchorfile>
      <anchor>a19</anchor>
      <arglist>(apr_status_t s, char *buf, apr_size_t bufsize)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_module.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__module_8h</filename>
    <includes id="apreq__cookie_8h" name="apreq_cookie.h" local="yes" imported="no">apreq_cookie.h</includes>
    <includes id="apreq__parser_8h" name="apreq_parser.h" local="yes" imported="no">apreq_parser.h</includes>
    <includes id="apreq__error_8h" name="apreq_error.h" local="yes" imported="no">apreq_error.h</includes>
    <class kind="struct">apreq_handle_t</class>
    <class kind="struct">apreq_module_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MODULE</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist>(pre, mmn)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>apreq_cookie</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist>(req, name)</arglist>
    </member>
    <member kind="typedef">
      <type>apreq_handle_t</type>
      <name>apreq_handle_t</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>apreq_module_t</type>
      <name>apreq_module_t</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_module_status_is_error</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist>(apr_status_t s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_jar</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_args</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_body</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist>(apreq_handle_t *req, const apr_table_t **t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_cookie_t *</type>
      <name>apreq_jar_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a8</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_args_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a9</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_body_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a10</anchor>
      <arglist>(apreq_handle_t *req, const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a11</anchor>
      <arglist>(apreq_handle_t *req, const apreq_parser_t **parser)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a12</anchor>
      <arglist>(apreq_handle_t *req, apreq_parser_t *parser)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_hook_add</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a13</anchor>
      <arglist>(apreq_handle_t *req, apreq_hook_t *hook)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_limit_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a14</anchor>
      <arglist>(apreq_handle_t *req, apr_size_t bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_limit_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a15</anchor>
      <arglist>(apreq_handle_t *req, apr_size_t *bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_read_limit_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a16</anchor>
      <arglist>(apreq_handle_t *req, apr_uint64_t bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_read_limit_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a17</anchor>
      <arglist>(apreq_handle_t *req, apr_uint64_t *bytes)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_temp_dir_set</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a18</anchor>
      <arglist>(apreq_handle_t *req, const char *path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_temp_dir_get</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a19</anchor>
      <arglist>(apreq_handle_t *req, const char **path)</arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_cgi</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a20</anchor>
      <arglist>(apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_custom</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a21</anchor>
      <arglist>(apr_pool_t *pool, const char *query_string, const char *cookie, apreq_parser_t *parser, apr_uint64_t read_limit, apr_bucket_brigade *in)</arglist>
    </member>
    <member kind="function">
      <type>apreq_param_t *</type>
      <name>apreq_param</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a22</anchor>
      <arglist>(apreq_handle_t *req, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>apr_table_t *</type>
      <name>apreq_params</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a23</anchor>
      <arglist>(apreq_handle_t *req, apr_pool_t *p)</arglist>
    </member>
    <member kind="function">
      <type>apr_table_t *</type>
      <name>apreq_cookies</name>
      <anchorfile>apreq__module_8h.html</anchorfile>
      <anchor>a24</anchor>
      <arglist>(apreq_handle_t *req, apr_pool_t *p)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_param.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__param_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <class kind="struct">apreq_param_t</class>
    <member kind="typedef">
      <type>apreq_param_t</type>
      <name>apreq_param_t</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE unsigned</type>
      <name>apreq_param_is_tainted</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist>(const apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_param_tainted_on</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_param_tainted_off</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_charset_t</type>
      <name>apreq_param_charset_set</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist>(apreq_param_t *p, unsigned char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_charset_t</type>
      <name>apreq_param_charset_get</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist>(apreq_param_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apreq_param_t *</type>
      <name>apreq_value_to_param</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist>(const char *val)</arglist>
    </member>
    <member kind="function">
      <type>apreq_param_t *</type>
      <name>apreq_param_make</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist>(apr_pool_t *p, const char *name, const apr_size_t nlen, const char *val, const apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_param_decode</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a8</anchor>
      <arglist>(apreq_param_t **param, apr_pool_t *pool, const char *word, apr_size_t nlen, apr_size_t vlen)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>apreq_param_encode</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a9</anchor>
      <arglist>(apr_pool_t *pool, const apreq_param_t *param)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parse_query_string</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a10</anchor>
      <arglist>(apr_pool_t *pool, apr_table_t *t, const char *qs)</arglist>
    </member>
    <member kind="function">
      <type>apr_array_header_t *</type>
      <name>apreq_params_as_array</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a11</anchor>
      <arglist>(apr_pool_t *p, const apr_table_t *t, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>apreq_params_as_string</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a12</anchor>
      <arglist>(apr_pool_t *p, const apr_table_t *t, const char *key, apreq_join_t mode)</arglist>
    </member>
    <member kind="function">
      <type>const apr_table_t *</type>
      <name>apreq_uploads</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a13</anchor>
      <arglist>(const apr_table_t *body, apr_pool_t *pool)</arglist>
    </member>
    <member kind="function">
      <type>const apreq_param_t *</type>
      <name>apreq_upload</name>
      <anchorfile>apreq__param_8h.html</anchorfile>
      <anchor>a14</anchor>
      <arglist>(const apr_table_t *body, const char *name)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_parser.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__parser_8h</filename>
    <includes id="apreq__param_8h" name="apreq_param.h" local="yes" imported="no">apreq_param.h</includes>
    <class kind="struct">apreq_hook_t</class>
    <class kind="struct">apreq_parser_t</class>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_PARSER_ARGS</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_HOOK_ARGS</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist>(f)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist>(f)</arglist>
    </member>
    <member kind="typedef">
      <type>apreq_hook_t</type>
      <name>apreq_hook_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>apreq_parser_t</type>
      <name>apreq_parser_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>apr_status_t(*</type>
      <name>apreq_parser_function_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist>)(APREQ_PARSER_ARGS)</arglist>
    </member>
    <member kind="typedef">
      <type>apr_status_t(*</type>
      <name>apreq_hook_function_t</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist>)(APREQ_HOOK_ARGS)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_parser_run</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a8</anchor>
      <arglist>(struct apreq_parser_t *psr, apr_table_t *t, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_hook_run</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a9</anchor>
      <arglist>(struct apreq_hook_t *h, apreq_param_t *param, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a10</anchor>
      <arglist>(apreq_parse_headers)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a11</anchor>
      <arglist>(apreq_parse_urlencoded)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a12</anchor>
      <arglist>(apreq_parse_multipart)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_PARSER</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a13</anchor>
      <arglist>(apreq_parse_generic)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a14</anchor>
      <arglist>(apreq_hook_apr_xml_parser)</arglist>
    </member>
    <member kind="function">
      <type>apreq_parser_t *</type>
      <name>apreq_parser_make</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a15</anchor>
      <arglist>(apr_pool_t *pool, apr_bucket_alloc_t *ba, const char *content_type, apreq_parser_function_t pfn, apr_size_t brigade_limit, const char *temp_dir, apreq_hook_t *hook, void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>apreq_hook_t *</type>
      <name>apreq_hook_make</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a16</anchor>
      <arglist>(apr_pool_t *pool, apreq_hook_function_t hook, apreq_hook_t *next, void *ctx)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_parser_add_hook</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a17</anchor>
      <arglist>(apreq_parser_t *p, apreq_hook_t *h)</arglist>
    </member>
    <member kind="function">
      <type>apreq_parser_function_t</type>
      <name>apreq_parser</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a18</anchor>
      <arglist>(const char *enctype)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_register_parser</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a19</anchor>
      <arglist>(const char *enctype, apreq_parser_function_t pfn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a20</anchor>
      <arglist>(apreq_hook_disable_uploads)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a21</anchor>
      <arglist>(apreq_hook_discard_brigade)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>APREQ_DECLARE_HOOK</name>
      <anchorfile>apreq__parser_8h.html</anchorfile>
      <anchor>a22</anchor>
      <arglist>(apreq_hook_find_param)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_util.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__util_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="function">
      <type>char *</type>
      <name>apreq_join</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist>(apr_pool_t *p, const char *sep, const apr_array_header_t *arr, apreq_join_t mode)</arglist>
    </member>
    <member kind="function">
      <type>apr_ssize_t</type>
      <name>apreq_index</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist>(const char *hay, apr_size_t hlen, const char *ndl, apr_size_t nlen, const apreq_match_t type)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_quote</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_quote_once</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_encode</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist>(char *dest, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_size_t</type>
      <name>apreq_cp1252_to_utf8</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist>(char *dest, const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_decode</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist>(char *dest, apr_size_t *dlen, const char *src, apr_size_t slen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_decodev</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist>(char *dest, apr_size_t *dlen, struct iovec *v, int nelts)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE char *</type>
      <name>apreq_escape</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a8</anchor>
      <arglist>(apr_pool_t *p, const char *src, const apr_size_t slen)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_ssize_t</type>
      <name>apreq_unescape</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a9</anchor>
      <arglist>(char *str)</arglist>
    </member>
    <member kind="function">
      <type>apr_int64_t</type>
      <name>apreq_atoi64f</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a10</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>apr_int64_t</type>
      <name>apreq_atoi64t</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a11</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_brigade_fwrite</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a12</anchor>
      <arglist>(apr_file_t *f, apr_off_t *wlen, apr_bucket_brigade *bb)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_file_mktemp</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a13</anchor>
      <arglist>(apr_file_t **fp, apr_pool_t *pool, const char *path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_setaside</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a14</anchor>
      <arglist>(apr_bucket_brigade *bb, apr_pool_t *p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE apr_status_t</type>
      <name>apreq_brigade_copy</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a15</anchor>
      <arglist>(apr_bucket_brigade *d, apr_bucket_brigade *s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static APR_INLINE void</type>
      <name>apreq_brigade_move</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a16</anchor>
      <arglist>(apr_bucket_brigade *d, apr_bucket_brigade *s, apr_bucket *e)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_header_attribute</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a17</anchor>
      <arglist>(const char *hdr, const char *name, const apr_size_t nlen, const char **val, apr_size_t *vlen)</arglist>
    </member>
    <member kind="function">
      <type>apr_status_t</type>
      <name>apreq_brigade_concat</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a18</anchor>
      <arglist>(apr_pool_t *pool, const char *temp_dir, apr_size_t brigade_limit, apr_bucket_brigade *out, apr_bucket_brigade *in)</arglist>
    </member>
    <member kind="function">
      <type>apr_file_t *</type>
      <name>apreq_brigade_spoolfile</name>
      <anchorfile>apreq__util_8h.html</anchorfile>
      <anchor>a19</anchor>
      <arglist>(apr_bucket_brigade *bb)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>apreq_version.h</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>apreq__version_8h</filename>
    <includes id="apreq_8h" name="apreq.h" local="yes" imported="no">apreq.h</includes>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MAJOR_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_MINOR_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_PATCH_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_IS_DEV_VERSION</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_VERSION_STRING</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_IS_DEV_STRING</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apreq_version</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a6</anchor>
      <arglist>(apr_version_t *pvsn)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>apreq_version_string</name>
      <anchorfile>apreq__version_8h.html</anchorfile>
      <anchor>a7</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_cookie_t</name>
    <filename>structapreq__cookie__t.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>path</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>domain</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>port</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>comment</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>commentURL</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_time_t</type>
      <name>max_age</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>flags</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const apreq_value_t</type>
      <name>v</name>
      <anchorfile>structapreq__cookie__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_handle_t</name>
    <filename>structapreq__handle__t.html</filename>
    <member kind="variable">
      <type>const struct apreq_module_t *</type>
      <name>module</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_alloc_t *</type>
      <name>bucket_alloc</name>
      <anchorfile>structapreq__handle__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_hook_t</name>
    <filename>structapreq__hook__t.html</filename>
    <member kind="variable">
      <type>apreq_hook_function_t</type>
      <name>hook</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apreq_hook_t *</type>
      <name>next</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>ctx</name>
      <anchorfile>structapreq__hook__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_module_t</name>
    <filename>structapreq__module__t.html</filename>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_uint32_t</type>
      <name>magic_number</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>jar</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>args</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>body</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist>)(apreq_handle_t *, const apr_table_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_cookie_t *(*</type>
      <name>jar_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_param_t *(*</type>
      <name>args_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apreq_param_t *(*</type>
      <name>body_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>parser_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o8</anchor>
      <arglist>)(apreq_handle_t *, const apreq_parser_t **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>parser_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o9</anchor>
      <arglist>)(apreq_handle_t *, apreq_parser_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>hook_add</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o10</anchor>
      <arglist>)(apreq_handle_t *, apreq_hook_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>brigade_limit_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o11</anchor>
      <arglist>)(apreq_handle_t *, apr_size_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>brigade_limit_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o12</anchor>
      <arglist>)(apreq_handle_t *, apr_size_t)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>read_limit_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o13</anchor>
      <arglist>)(apreq_handle_t *, apr_uint64_t *)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>read_limit_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o14</anchor>
      <arglist>)(apreq_handle_t *, apr_uint64_t)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>temp_dir_get</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o15</anchor>
      <arglist>)(apreq_handle_t *, const char **)</arglist>
    </member>
    <member kind="variable">
      <type>apr_status_t(*</type>
      <name>temp_dir_set</name>
      <anchorfile>structapreq__module__t.html</anchorfile>
      <anchor>o16</anchor>
      <arglist>)(apreq_handle_t *, const char *)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_param_t</name>
    <filename>structapreq__param__t.html</filename>
    <member kind="variable">
      <type>apr_table_t *</type>
      <name>info</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_brigade *</type>
      <name>upload</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>flags</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const apreq_value_t</type>
      <name>v</name>
      <anchorfile>structapreq__param__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_parser_t</name>
    <filename>structapreq__parser__t.html</filename>
    <member kind="variable">
      <type>apreq_parser_function_t</type>
      <name>parser</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>content_type</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_pool_t *</type>
      <name>pool</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_bucket_alloc_t *</type>
      <name>bucket_alloc</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>brigade_limit</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>temp_dir</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apreq_hook_t *</type>
      <name>hook</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>ctx</name>
      <anchorfile>structapreq__parser__t.html</anchorfile>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>apreq_value_t</name>
    <filename>structapreq__value__t.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>name</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>nlen</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>apr_size_t</type>
      <name>dlen</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>data</name>
      <anchorfile>structapreq__value__t.html</anchorfile>
      <anchor>o3</anchor>
      <arglist>[1]</arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>apreq_changes</name>
    <title>CHANGES</title>
    <filename>apreq_changes</filename>
    <docanchor file="apreq_changes">v2_0_0</docanchor>
    <docanchor file="apreq_changes">v2_01_dev</docanchor>
    <docanchor file="apreq_changes">v2_02_dev</docanchor>
    <docanchor file="apreq_changes">v2_03_dev</docanchor>
    <docanchor file="apreq_changes">v2_04_dev</docanchor>
    <docanchor file="apreq_changes">v2_05_dev</docanchor>
    <docanchor file="apreq_changes">v2_06</docanchor>
  </compound>
  <compound kind="page">
    <name>apreq_status</name>
    <title>STATUS</title>
    <filename>apreq_status</filename>
  </compound>
  <compound kind="page">
    <name>apreq_license</name>
    <title>LICENSE</title>
    <filename>apreq_license</filename>
  </compound>
  <compound kind="page">
    <name>apreq_notice</name>
    <title>NOTICE</title>
    <filename>apreq_notice</filename>
  </compound>
  <compound kind="page">
    <name>apreq_install</name>
    <title>INSTALL</title>
    <filename>apreq_install</filename>
  </compound>
  <compound kind="page">
    <name>apreq_faq</name>
    <title>FAQ</title>
    <filename>apreq_faq</filename>
  </compound>
  <compound kind="group">
    <name>libapreq2</name>
    <title>Apache Request Library</title>
    <filename>group__libapreq2.html</filename>
    <file>apreq.h</file>
    <file>apreq_cookie.h</file>
    <file>apreq_error.h</file>
    <file>apreq_module.h</file>
    <file>apreq_param.h</file>
    <file>apreq_parser.h</file>
    <file>apreq_util.h</file>
    <file>apreq_version.h</file>
    <docanchor file="group__libapreq2">apreq2_config</docanchor>
  </compound>
  <compound kind="group">
    <name>apreq_module</name>
    <title>Modules</title>
    <filename>group__apreq__module.html</filename>
    <subgroup>mod_apreq2</subgroup>
  </compound>
  <compound kind="group">
    <name>apreq_lang</name>
    <title>Language Bindings</title>
    <filename>group__apreq__lang.html</filename>
    <subgroup>apreq_xs</subgroup>
  </compound>
  <compound kind="group">
    <name>apreq_xs</name>
    <title>Perl</title>
    <filename>group__apreq__xs.html</filename>
    <subgroup>apreq_xs_request</subgroup>
    <subgroup>apreq_xs_upload</subgroup>
    <subgroup>apreq_xs_cookie</subgroup>
    <subgroup>apreq_xs_apr_request</subgroup>
    <subgroup>apreq_xs_apr_request_cookie</subgroup>
    <subgroup>apreq_xs_apr_request_param</subgroup>
    <subgroup>apreq_xs_apr_request_error</subgroup>
    <subgroup>apreq_xs_apr_request_cgi</subgroup>
    <subgroup>apreq_xs_apr_request_apache2</subgroup>
  </compound>
  <compound kind="group">
    <name>apreq_xs_request</name>
    <title>Apache2::Request</title>
    <filename>group__apreq__xs__request.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_upload</name>
    <title>Apache2::Upload</title>
    <filename>group__apreq__xs__upload.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_cookie</name>
    <title>Apache2::Cookie</title>
    <filename>group__apreq__xs__cookie.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request</name>
    <title>APR::Request</title>
    <filename>group__apreq__xs__apr__request.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_cookie</name>
    <title>APR::Request::Cookie</title>
    <filename>group__apreq__xs__apr__request__cookie.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_param</name>
    <title>APR::Request::Param</title>
    <filename>group__apreq__xs__apr__request__param.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_error</name>
    <title>APR::Request::Error</title>
    <filename>group__apreq__xs__apr__request__error.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_cgi</name>
    <title>APR::Request::CGI</title>
    <filename>group__apreq__xs__apr__request__cgi.html</filename>
  </compound>
  <compound kind="group">
    <name>apreq_xs_apr_request_apache2</name>
    <title>APR::Request::Apache2</title>
    <filename>group__apreq__xs__apr__request__apache2.html</filename>
  </compound>
  <compound kind="group">
    <name>mod_apreq2</name>
    <title>Apache 2.X Filter Module</title>
    <filename>group__mod__apreq2.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_FILTER_NAME</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>ga1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>APREQ_APACHE2_MMN</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>ga2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>apreq_handle_t *</type>
      <name>apreq_handle_apache2</name>
      <anchorfile>group__mod__apreq2.html</anchorfile>
      <anchor>ga0</anchor>
      <arglist>(request_rec *r)</arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>module/apache/</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/module/apache/</path>
    <filename>dir_000002.html</filename>
    <file>apreq_module_apache.h</file>
  </compound>
  <compound kind="dir">
    <name>module/apache2/</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/module/apache2/</path>
    <filename>dir_000003.html</filename>
    <file>apreq_module_apache2.h</file>
  </compound>
  <compound kind="dir">
    <name>include/</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/include/</path>
    <filename>dir_000000.html</filename>
    <file>apreq.h</file>
    <file>apreq_cookie.h</file>
    <file>apreq_error.h</file>
    <file>apreq_module.h</file>
    <file>apreq_param.h</file>
    <file>apreq_parser.h</file>
    <file>apreq_util.h</file>
    <file>apreq_version.h</file>
  </compound>
  <compound kind="dir">
    <name>module/</name>
    <path>/home/joe/src/apache/httpd/apreq/trunk/module/</path>
    <filename>dir_000001.html</filename>
    <dir>module/apache/</dir>
    <dir>module/apache2/</dir>
  </compound>
</tagfile>
