#!/bin/bash - 
#===============================================================================
#
#          FILE: bychrmpil.sh
# 
#         USAGE: ./bychrmpil.sh 
# 
#   DESCRIPTION: Output commands for mpileup by chromosome in parallel
#               Adapted from a blog post here
#               http://www.research.janahang.com/efficient-way-to-generate-vcf-files-using-samtools/
#       OPTIONS: $1 fasta file
#  REQUIREMENTS: samtools, bcftools
#         NOTES: To run these commands you need samtools and bcftools
#        AUTHOR: Jillian Rowe, 
#  ORGANIZATION: WCMC-Q
#       CREATED: 21/01/15 14:33
#      REVISION:  ---
#===============================================================================

cd `pwd`

mkdir tmpbcf

find `pwd`/ |grep -e "bam$" > bamlist.txt

cat bamlist.txt | xargs -n 1 -I % bash -c "samtools view -H % " |  grep "\@SQ" | sed 's/^.*SN://g' | cut -f 1 >> tt

cat tt | sort | uniq > coord.txt

rm tt

cat coord.txt | xargs -I {} -n 1 bash -c 'echo -e "samtools mpileup -DguS -f $1 -r {} -b bamlist.txt | bcftools view -bvcg - > tmpbcf/tmp.{}.bcf && bcftools view tmpbcf/tmp.{}.bcf > tmpbcf/tmp.{}.vcf\n"'

#Wait for these to finish
echo -e "wait\n" 

# Got to cat the bcf files back together
# find `pwd`/tmpbcf | grep -e "bcf$" > bcflist.txt
# Didn't work with the -f option not sure why
echo "find `pwd`/tmpbcf/*bcf | xargs bcftools cat > merge.bcf && bcftools view merge.bcf > merge.vcf"

rm coord.txt
